/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class ScrollBar {
    private boolean vScroll;
    private boolean stopping;
    private boolean kScroll;
    private int pScroll;
    private int lY;
    private int wX;
    private int wY;
    private int wWidth;
    private int wHeight;
    private int value;
    private int mValue;
    private int sHeight;
    private int dir;
    private int bx;
    private int scrolling;
    private int[] scroll;
    private float sAspect;
    private float sSpeed;
    private float sTime;
    private float time;
    private float dist;
    private float dist_prev;
    private float mAspect;
    private long lTime;
    private long sTimePrev;

    public ScrollBar(int wX, int wY, int wWidth, int wHeight, int mValue, int extent, boolean kScroll) {
        this.wX = wX;
        this.wY = wY;
        this.wWidth = wWidth;
        this.wHeight = wHeight;
        this.mValue = mValue;
        this.kScroll = kScroll;
        this.sHeight = (int)((float)wHeight * ((float)wHeight / (float)extent));
        this.sAspect = (float)(wHeight - this.sHeight) / (float)mValue;
        this.scroll = new int[2 * this.sHeight];
        for (int i = 0; i < this.scroll.length; ++i) {
            this.scroll[i] = 0x3FFFFFFF;
        }
        this.mAspect = 5.0f;
        this.vScroll = true;
    }

    public void setMovingAspect(float f) {
        this.mAspect = f;
    }

    public void init() {
        this.value = 0;
        this.pScroll = 0;
    }

    public void setVisibleScroll(boolean flag) {
        this.vScroll = flag;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > this.mValue) {
            value = this.mValue;
        }
        this.value = value;
        this.pScroll = (int)((float)value * this.sAspect);
    }

    public boolean setScrollingValue(int value) {
        boolean flag = false;
        if (value < 0) {
            value = 0;
            flag = true;
        }
        if (value > this.mValue) {
            value = this.mValue;
            flag = true;
        }
        this.value = value;
        this.pScroll = (int)((float)value * this.sAspect);
        return flag;
    }

    public void pCheck(float fps_time, int dKey, int pX, int pY, int rX, int rY, int dX, int dY) {
        if (this.scrolling == 0) {
            if (Wand.region(pX, pY, this.wX, this.wY, this.wWidth, this.wHeight)) {
                this.lY = pY;
                this.dir = 0;
                this.bx = 0;
                this.sSpeed = this.sTime = (float)0;
                this.stopping = false;
                this.lTime = System.currentTimeMillis();
            }
            if (Wand.region(dX, dY, this.wX, this.wY, this.wWidth, this.wHeight)) {
                this.pScroll += this.lY - dY;
                if (this.pScroll < 0) {
                    this.pScroll = 0;
                }
                if (this.pScroll > this.wHeight - this.sHeight) {
                    this.pScroll = this.wHeight - this.sHeight;
                }
                this.value = (int)((float)this.pScroll / this.sAspect);
                float distance = (float)Math.sqrt((dY - this.lY) * (dY - this.lY));
                float time = (float)(System.currentTimeMillis() - this.lTime) / 1000.0f;
                this.lTime = System.currentTimeMillis();
                if (time != 0.0f) {
                    this.sSpeed = distance / time;
                }
                if (this.lY < dY) {
                    this.dir = 1;
                }
                if (this.lY > dY) {
                    this.dir = 2;
                }
                this.lY = dY;
            }
            if ((Wand.region(rX, rY, this.wX, this.wY, this.wWidth, this.wHeight) || this.stopping) && this.sSpeed != 0.0f) {
                int x = (int)(this.sSpeed * this.sTime - 1000.0f * (this.sTime * this.sTime) / 2.0f);
                if (x >= this.bx) {
                    this.sTime += fps_time;
                    if (this.dir == 1) {
                        this.pScroll -= x - this.bx;
                    }
                    if (this.dir == 2) {
                        this.pScroll += x - this.bx;
                    }
                    if (this.pScroll < 0) {
                        this.pScroll = 0;
                    }
                    if (this.pScroll > this.wHeight - this.sHeight) {
                        this.pScroll = this.wHeight - this.sHeight;
                    }
                    this.value = (int)((float)this.pScroll / this.sAspect);
                    this.bx = x;
                    this.stopping = true;
                } else {
                    this.stopping = false;
                }
            }
            if (this.kScroll && this.scrolling == 0) {
                if (dKey == -1 || dKey == 50 || dKey == 116) {
                    this.scrolling = 1;
                    this.sTimePrev = System.currentTimeMillis();
                }
                if (dKey == -2 || dKey == 56 || dKey == 98) {
                    this.scrolling = 2;
                    this.sTimePrev = System.currentTimeMillis();
                }
            }
        } else if (this.scrolling != 0) {
            this.time = (float)(System.currentTimeMillis() - this.sTimePrev) / 1000.0f;
            this.dist = (this.mAspect * this.time - 12.0f * (this.time * this.time) / 2.0f) * 100.0f;
            if (this.scrolling == 1 && (this.setScrollingValue(this.getValue() - (int)(this.dist - this.dist_prev)) || this.dist < this.dist_prev)) {
                this.scrolling = 0;
            }
            if (this.scrolling == 2 && (this.setScrollingValue(this.getValue() + (int)(this.dist - this.dist_prev)) || this.dist < this.dist_prev)) {
                this.scrolling = 0;
            }
            this.dist_prev = this.scrolling != 0 ? this.dist : 0.0f;
        }
    }

    public void paint(Graphics g) {
        if (this.vScroll) {
            g.drawRGB(this.scroll, 0, 2, this.wX + this.wWidth - 2, this.wY + this.pScroll, 2, this.sHeight, true);
        }
    }
}

