package gamepacker;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.HashMap;
import javax.swing.JPanel;
/**
 *
 * @author user
 */
public class MapCanvas extends JPanel {
    
    private boolean sMap, showCursor;
    private int cObject;
    private int[] cXY, wh;
    private int[][] tiles;
    private Image[] objects;
    
    public MapCanvas(Image[] objects) {
        this.objects = objects;
        cXY = new int[2];
        cObject = -1;
    }
    
    public void setCurrentObject(int n) {
        cObject = n;
    }
    
    public void setObject(boolean change) {
        if(sMap && cObject != -1) {
            int col = cXY[0]/40;
            int row = cXY[1]/30;
            if(col >= 0 && col < wh[0] && row >= 0 && row < wh[1]) {
                int tile = tiles[row][col];
                if(change) {
                    if(tile != cObject) {
                        if(cObject >= 9) {
                            if((cObject <= 10 && row < wh[1]-1) || cObject >= 11) {
                                for(int i=0; i<tiles.length; i++) {
                                    for(int j=0; j<tiles[i].length; j++) {
                                        if(tiles[i][j] == cObject) {
                                            if(tiles[i][j] <= 10) tiles[i+1][j] = 0;
                                            tiles[i][j] = 0;
                                        }
                                    }
                                }
                            }
                            if(cObject <= 10 && row < wh[1]-1) {
                                tile = cObject;
                                tiles[row+1][col] = 0;
                            }
                            if(cObject >= 11) tile = cObject;
                        } else {
                            tile = cObject;
                        }
                    } else {
                        if(cObject >= 2) tile = 0;
                    }
                } else {
                    if((cObject == 0 || cObject == 1) && tile != cObject) tile = cObject;
                }
                tiles[row][col] = tile;
            }
        }
    }
    
    public void setCursorXY(int cX, int cY) {
        cXY[0] = cX/40*40;
        cXY[1] = cY/30*30;
    }
    
    public void setShowCursor(boolean flag) {
        showCursor = flag;
    }
    
    public void setEmptyMap() {
        sMap = false;
    }
    
    public void setMap(HashMap<String, Object> map) {
        wh = (int[])map.get("wh");
        tiles = (int[][])map.get("tiles");
        setPreferredSize(new Dimension(wh[0]*40+1, wh[1]*30+1));
        sMap = true;
    }
    
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if(sMap) {
            g.setColor(Color.white);
        } else {
            g.setColor(Color.gray);
        }
        g.fillRect(0, 0, getWidth(), getHeight());
        if(sMap) {
            g.setColor(Color.black);
            for(int i=0; i<wh[0]; i++) {
                for(int j=0; j<wh[1]; j++) {
                    g.drawRect(i*40, j*30, 40, 30);
                }
            }
            g.drawRect(1, 1, wh[0]*40-2, wh[1]*30-2);
            for(int i=0; i<tiles.length; i++) {
                for(int j=0; j<tiles[i].length; j++) {
                    if(tiles[i][j] != 0) {
                        g.drawImage(objects[tiles[i][j]], j*40, i*30, null);
                    }
                }
            }
            if(cObject != -1 && showCursor && cXY[0] < wh[0]*40 && cXY[1] < wh[1]*30) {
                g.drawImage(objects[cObject], cXY[0], cXY[1], null);
            }
        }
    }
    
}
