import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
/**
 *
 * @author user
 */
public class RMS {
    
    private final static String[] diff = {"EASY", "NORMAL", "HARD"};
    
    public boolean beContinued() {
        String[] list = RecordStore.listRecordStores();
        if(list != null && list.length != 0) {
            return true;
        }
        return false;
    }
    
    /*
     * Возвращает уровень c учетом уровня сложности, принмает rms - массив rms_game из класса RB2
     */
    public int getGameLevel(int[] rms) {
        return rms[4] == 1 ? rms[0] : rms[4] == 2 ? rms[9] : rms[10];
    }
    
    /*
     * Изменяет текуюший уровень на уровегь l, с учетом уровня сложности, rms - массив rms_game из класса RB2
     */
    public void setGameLevel(int[] rms, int l) {
        setGameVar(l, (rms[4] == 1 ? 0 : rms[4] == 2 ? 9 : 10));
    }
    
    /*
     * Возвращает true - если игра пройдена на текущем уровне сложности, rms - массив rms_game из класса RB2
     */
    public boolean isPassed(int[] rms) {
        if(rms[rms[4] == 1 ? 2 : rms[4] == 2 ? 11 : 12] == 1) return true;
        return false;
    }
    
    /*
     * Записывает в RMS, что игра на текущем уровне сложности пройдена, rms - массив rms_game из класса RB2
     */
    public void setPassed(int[] rms) {
        setGameVar(1, rms[4] == 1 ? 2 : rms[4] == 2 ? 11 : 12);
    }
    
    /*
     * Возвращает массив rms_game из класса RB2
     */
    public int[] getGameData() {
        int[] rms = null;
        try {
            RecordStore rs = RecordStore.openRecordStore("GAME", true);
            if(rs.getNumRecords() == 0) {
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("2".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
            }
            rms = new int[rs.getNumRecords()];
            for(int i=0; i<rms.length; i++) {
                rms[i] = Integer.parseInt(new String(rs.getRecord(i+1)));
            }
            rs.closeRecordStore();
        } catch (RecordStoreException ex) {}
        return rms;
    }
    
    /*
     * Возвращает  массив rms_ball из класса RB2
     */
    public float[] getBallData() {
        float[] rms = null;
        try {
            RecordStore rs = RecordStore.openRecordStore("BALL", true);
            if(rs.getNumRecords() == 0) {
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("4".getBytes(), 0, 1);
                rs.addRecord("60".getBytes(), 0, 2);
            }
            rms = new float[rs.getNumRecords()];
            for(int i=0; i<rms.length; i++) {
                rms[i] = Float.parseFloat(new String(rs.getRecord(i+1)));
            }
            rs.closeRecordStore();
        } catch (RecordStoreException ex) {}
        return rms;
    }
    
    /*
     * Устанавливает значение var под index'ом для массива rms_game
     */
    public void setGameVar(int var, int index) {
        byte[] temp_var = (""+var).getBytes();
        try {
            RecordStore rs = RecordStore.openRecordStore("GAME", true);
            if(rs.getNumRecords() == 0) {
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("2".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
            }
            rs.setRecord(index+1, temp_var, 0, temp_var.length);
            rs.closeRecordStore();
        } catch (RecordStoreException ex) {}
    }
    
    public void setGameVars(int[][] iValues) {
        try {
            RecordStore rs = RecordStore.openRecordStore("GAME", true);
            if(rs.getNumRecords() == 0) {
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("2".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
            }
            for(int i=0; i<iValues.length; i++) {
                byte[] temp_var = (""+iValues[i][1]).getBytes();
                rs.setRecord(iValues[i][0]+1, temp_var, 0, temp_var.length);
            }
            rs.closeRecordStore();
        } catch (RecordStoreException ex) {}
    }
    
    /*
     * Устанавливает значение var под index'ом для массива rms_ball
     */
    public void setBallVar(float var, int index) {
        String temp_var = ""+(var+0.01);
        int p = temp_var.indexOf('.');
        if(temp_var.length()-p-1 > 1) {
            temp_var = temp_var.substring(0, p+2);
        }
        try {
            RecordStore rs = RecordStore.openRecordStore("BALL", true);
            if(rs.getNumRecords() == 0) {
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("4".getBytes(), 0, 1);
                rs.addRecord("60".getBytes(), 0, 2);
            }
            rs.setRecord(index+1, temp_var.getBytes(), 0, temp_var.length());
            rs.closeRecordStore();
        } catch (RecordStoreException ex) {}
    }
    
    /*
     * Возврашает массив |уровень|время|очки| для таблицы рекордов, принимает id - ид юзера
     */
    public int[][] getRecords(int d) {
        int[][] records = null;
        try {
            RecordStore rs = RecordStore.openRecordStore("RECORDS_"+diff[d], true);
            //if(rs.getNumRecords() == 0) {
            //    for(int i=0; i<20; i++) {
            //        rs.addRecord((""+(i+1)).getBytes(), 0, (""+(i+1)).length());
            //        rs.addRecord((""+(1000*i)).getBytes(), 0, (""+(1000*i)).length());
            //        rs.addRecord((""+(1000*i)).getBytes(), 0, (""+(1000*i)).length());
            //    }
            //}
            records = new int[rs.getNumRecords()/3][3];
            for(int i=0; i<records.length; i++) {
                for(int j=0; j<3; j++) {
                    records[i][j] = Integer.parseInt(new String(rs.getRecord(i*3+j+1)));
                }
            }
            rs.closeRecordStore();
        } catch (RecordStoreException ex) {}
        while(true) {
            boolean sort = false;
            for(int i=0; i<records.length-1; i++) {
                if(records[i][1] > records[i+1][1]) {
                    int[] record = records[i];
                    records[i] = records[i+1];
                    records[i+1] = record;
                    record = null;
                    sort = true;
                }
            }
            if(!sort) break;
        }
        return records;
    }
    
    /*
     * Обновляет/устанавливает рекорд уровня для таблицы рекордов, принмает id - ид юзера, level - уровень, time - время прохождения, points - полученные очки
     */
    public void upRecord(int d, int level, long time, int points) {
        try {
            RecordStore rs = RecordStore.openRecordStore("RECORDS_"+diff[d], true);
            boolean addRecord = false;
            for(int i=1; i<=rs.getNumRecords(); i+=3) {
                if(Integer.parseInt(new String(rs.getRecord(i))) == level) {
                    if(time < Integer.parseInt(new String(rs.getRecord(i+1)))) {
                        rs.setRecord(i+1, (""+time).getBytes(), 0, (""+time).length());
                    }
                    if(points > Integer.parseInt(new String(rs.getRecord(i+2)))) {
                        rs.setRecord(i+2, (""+points).getBytes(), 0, (""+points).length());
                    }
                    addRecord = true;
                    break;
                }
            }
            if(!addRecord) {
                rs.addRecord((""+level).getBytes(), 0, (""+level).length());
                rs.addRecord((""+time).getBytes(), 0, (""+time).length());
                rs.addRecord((""+points).getBytes(), 0, (""+points).length());
            }
            rs.closeRecordStore();
        } catch (RecordStoreException ex) {}
    }
    
    /*
     * Возвращает список созданных/редактированных уровней
     */
    public String[] getLevelList() {
        String[] list = null;
        try {
            RecordStore rs = RecordStore.openRecordStore("LEVELS", true);
            list = new String[rs.getNumRecords()/2];
            for(int i=0; i<list.length; i++) {
                list[i] = new String(rs.getRecord(i*2+1));
            }
            rs.closeRecordStore();
        } catch (RecordStoreException ex) {}
        return list;
    }
    
    /*
     * Возврашает массив байт созданного уровня с index'ом (из массива getLevelList())
     */
    public byte[] getLevel(int index) {
        byte[] level = null;
        try {
            RecordStore rs = RecordStore.openRecordStore("LEVELS", true);
            level = rs.getRecord(index*2+2);
            rs.closeRecordStore();
        } catch (RecordStoreException ex) {}
        return level;
    }
    
    /*
     * Записывает новый созданный уровень под именем name, где level - массив байт уровня
     */
    public void putLevel(String name, byte[] level) {
        try {
            RecordStore rs = RecordStore.openRecordStore("LEVELS", true);
            rs.addRecord(name.getBytes(), 0, name.length());
            rs.addRecord(level, 0, level.length);
            rs.closeRecordStore();
        } catch (RecordStoreException ex) {}
    }
    
    /*
     * Обновляет созданный уровень под index'ом (из массива getLevelList()), где level - массив байт уровня
     */
    public void updateLevel(int index, byte[] level) {
        try {
            RecordStore rs = RecordStore.openRecordStore("LEVELS", true);
            rs.setRecord(index*2+2, level, 0, level.length);
            rs.closeRecordStore();
        } catch (RecordStoreException ex) {}
    }
    
    /*
     * Удаляет уровень под index'ом (из массива getLevelList())
     */
    public void deleteLevel(int index) {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore("LEVELS", true);
            byte[][] name = new byte[rs.getNumRecords()/2][];
            byte[][] level = new byte[name.length][];
            for(int i=0; i<level.length; i++) {
                name[i] = rs.getRecord(i*2+1);
                level[i] = rs.getRecord(i*2+2);
            }
            rs.closeRecordStore();
            RecordStore.deleteRecordStore("LEVELS");
            rs = RecordStore.openRecordStore("LEVELS", true);
            for(int i=0; i<level.length; i++) {
                if(i != index) {
                    rs.addRecord(name[i], 0, name[i].length);
                    rs.addRecord(level[i], 0, level[i].length);
                }
            }
            level = null;
            name = null;
            rs.closeRecordStore();
        } catch (RecordStoreException ex) {}
    }
    
    /*
     * Чистит RMS для создания новой игры
     */
    public void flush() {
        int backShowHelp = getGameData()[3];
        try {
            RecordStore.deleteRecordStore("GAME");
            RecordStore.deleteRecordStore("BALL");
            RecordStore.deleteRecordStore("RECORDS");
        } catch (RecordStoreException ex) {}
        setGameVar(backShowHelp, 3);
    }
    
}
