import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

/**
 *
 * @author AlexeyW
 */
public class Sound implements PlayerListener {
    
    private boolean enable;
    private Vector vSound;
    
    /*
     * Конструктор класса, инициализирует вектор-набор Player'ов
     */
    public Sound() {
        vSound = new Vector();
    }
    
    /*
     * Возвращает Enable звука, true - если звук включен
     */
    public boolean isEnable() {
        return enable;
    }
    
    /*
     * Включает звук
     */
    public boolean soundOn() {
        if(!enable) {
            restoreAll(); enable = true;
            return true;
        }
        return false;
    }
    
    /*
     * Отключает звук
     */
    public void soundOff() {
        stopAll();
        enable = false;
    }
    
    /*
     * Запустить воспроизведение мелодии name, с типом mime и количеством повтором (-1 - бесконечное воспроизведение)
     */
    public Player play(String name, String mime, int loopCount) {
        Player player = null;
        if(enable) {
            InputStream is = getClass().getResourceAsStream("/resources/sound/"+name);
            try {
                player = Manager.createPlayer(is, mime);
                player.addPlayerListener(this);
                player.setLoopCount(loopCount);
                player.start();
            } catch (IOException ex) {} catch (MediaException ex) {}
            vSound.addElement(player);
        }
        return player;
    }
    
    /*
     * Останавливает все звуки приложения, и удаляет их из набора вектор-плеера
     */
    public void fullStop(Player player) {
        if(enable && vSound.contains(player)) {
            player.close(); vSound.removeElement(player);
        }
    }
    
    /*
     * Возобновляает воспроизведение всех звуков
     */
    public void restoreAll() {
        for(int i=0; i<vSound.size(); i++) {
            try {
                ((Player)vSound.elementAt(i)).start();
            } catch (MediaException ex) {}
        }
    }
    
    /*
     * Останавливает воспроизведение всех звуков
     */
    public void stopAll() {
        for(int i=0; i<vSound.size(); i++) {
            try {
                ((Player)vSound.elementAt(i)).stop();
            } catch (MediaException ex) {}
        }
    }
    
    public void fullStopAll() {
        for(int i=0; i<vSound.size(); i++) {
            ((Player)vSound.elementAt(i)).close();
        }
        vSound.removeAllElements();
    }

    /*
     * Абстрактный метод (если мелодия закончила свое воспроизведение, то она удаляется из набора вектор-плееров)
     */
    public void playerUpdate(Player player, String event, Object eventData) {
        if(event.equals(END_OF_MEDIA)) vSound.removeElement(player);
    }
    
}