import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

/**
 *
 * @author AlexeyW
 */
public class DrawFont {
    
    private char[] cnums, cbfont, csfont;
    private Image[] nums, bfont, sfont;
    
    /*
     * Конструктор класса, принимает картинки шрифта, цифры, большые буквы, маленькие буквы
     */
    public DrawFont(Image nums, Image bfont, Image sfont) {
        Object[] objs = loadFont(nums, "nfont.dat");
        cnums = (char[])objs[0]; this.nums =(Image[])objs[1];
        objs = loadFont(bfont, Localization.getLocaleAsString()+"_bfont.dat");
        cbfont = (char[])objs[0]; this.bfont = (Image[])objs[1];
        objs = loadFont(sfont, Localization.getLocaleAsString()+"_sfont.dat");
        csfont = (char[])objs[0]; this.sfont = (Image[])objs[1];
    }
    
    /*
     * Загружает шрфит, принмает картинку шрифта и путь к файлу с данными шрифта
     */
    private Object[] loadFont(Image font, String path) {
        DataInputStream dis = new DataInputStream(getClass().getResourceAsStream("/resources/"+path));
        String data = "";
        try {
            int ch;
            while((ch = dis.readUnsignedByte()) != -1) {
                data+=(char)ch;
            }
        } catch (IOException ex) {}
        dis = null;
        Vector vector = new Vector();
        int p1 = 0, p2;
        while((p2 = data.indexOf("\r\n", p1)) != -1) {
            vector.addElement(data.substring(p1, p2));
            p1 = p2+2;
        }
        data = null;
        char[] chars = new char[vector.size()];
        Image[] imgs = new Image[vector.size()];
        for(int i=0; i<vector.size(); i++) {
            String s = (String)vector.elementAt(i);
            chars[i] = s.charAt(0);
            imgs[i] = Image.createImage(font, Integer.parseInt(s.substring(s.indexOf('-')+1, s.indexOf('-', s.indexOf('-')+1))), 0, Integer.parseInt(s.substring(s.indexOf('-', s.indexOf('-')+1)+1)), font.getHeight(), Sprite.TRANS_NONE);
        }
        vector = null;
        return (new Object[] {chars, imgs});
    }
    
    /*
     * Возвращает высоту шрифта
     */
    public int getHeight() {
        return 33;
    }
    
    /*
     * Возвращает ширину строки
     */
    public int stringWidth(String s) {
        int width = 0;
        for(int i=0; i<s.length(); i++) {
            char ch = check(s.charAt(i));
            if(ch == ' ') {
                width+=7;
            } else {
                for(int j=0; j<nums.length; j++) {
                    if(ch == cnums[j]) {
                        width+=nums[j].getWidth()+3;
                    }
                }
                for(int j=0; j<bfont.length; j++) {
                    if(ch == cbfont[j]) {
                        width+=bfont[j].getWidth()+(j == 5 ? -3 : 2);
                    }
                }
                for(int j=0; j<sfont.length; j++) {
                    if(ch == csfont[j]) {
                        width+=sfont[j].getWidth()+2;
                    }
                }
            }
        }
        return width;
    }
    
    /*
     * Рисует строку s, по координатам x и y
     */
    public void drawString(Graphics g, int x, int y, String s) {
        for(int i=0; i<s.length(); i++) {
            char ch = check(s.charAt(i));
            if(ch == ' ') {
                x+=7;
            } else {
                for(int j=0; j<nums.length; j++) {
                    if(ch == cnums[j]) {
                        g.drawImage(nums[j], x, y, 20);
                        x+=nums[j].getWidth()+3;
                    }
                }
                for(int j=0; j<bfont.length; j++) {
                    if(ch == cbfont[j]) {
                        g.drawImage(bfont[j], x, y, 20);
                        x+=bfont[j].getWidth()+(j == 5 ? -3 : 2);
                    }
                }
                for(int j=0; j<sfont.length; j++) {
                    if(ch == csfont[j]) {
                        g.drawImage(sfont[j], x, y, 20);
                        x+=sfont[j].getWidth()+2;
                    }
                }
            }
        }
    }
    
    /*
     * Проверяет корректность символа для отрисовки
     */
    private char check(char charCode) {
        if(charCode >= 1040 && charCode <= 1103) charCode-=848;
        return charCode;
    }
    
}