import game.S;
import java.util.Timer;
import java.util.TimerTask;
/**
 *
 * @author user
 */
public class Fan extends TimerTask {
    
    private int direction, delay, bDist;
    private float time;
    private Timer timer;
    
    private S fan;
    
    /*
     * Конструктор класса, принимает спрайт вентилятора, направление вентилятора (d=1 - вверх, d=2 - вниз, d=3 - влево, d=4 - вправо), и задержку между кадрами анимации
     */
    public Fan(S fan, int direction, int delay) {
        this.fan = fan;
        this.direction = direction;
        this.delay = delay;
        timer = new Timer();
    }
    
    /*
     * Возвращает спрайт вентилятора
     */
    public S getFan() {
        return fan;
    }
    
    /*
     * Возвращает направление вентилятора
     */
    public int getDirection() {
        return direction;
    }
    
    /*
     * Возвращает время вентилятора
     */
    public float getTime() {
        return time;
    }
    
    /*
     * Устанавливает время вентилятора
     */
    public void setTime(float time) {
        this.time = time;
    }
    
    /*
     * Возвращает обратную дистанцию вентилятора
     */
    public int getBackDistance() {
        return bDist;
    }
    
    /*
     * Устанавливает обратную дистанцию вентилятора
     */
    public void setBackDistance(int backDistance) {
        bDist = backDistance;
    }
    
    /*
     * Запускает вентилятор
     */
    public void start() {
        timer.scheduleAtFixedRate(this, delay, delay);
    }
    
    /*
     * Цикл run, смена фреймов анимации
     */
    public void run() {
        fan.nextFrame();
    }
    
}
