/**
 *
 * @author AlexeyW
 */
public class HScrollBar {
    
    private boolean stopping;
    private int pScroll, lX, wX, wY, wWidth, wHeight, value, mValue, sHeight, dir, bx;
    private float sAspect, sSpeed, sTime;
    private long lTime;
    
    /*
     * Конструктор класса, инициализирует и принмает, wX и wY и wWidth и wHeight - положение горизонтального скролла на экране и его ширина с высотой, mValue - максимальное value скролла,
     * extent - диапазон (мат. высота) скролла
     */
    public HScrollBar(int wX, int wY, int wWidth, int wHeight, int mValue, int extent) {
        this.wX = wX;
        this.wY = wY;
        this.wWidth = wWidth;
        this.wHeight = wHeight;
        this.mValue = mValue;
        
        sHeight = (int)((float)wHeight*((float)wHeight/(float)extent));
        sAspect = (float)(wHeight-sHeight)/(float)mValue;
    }
    
    /*
     * Переводит скролл в начальное положение (на 0)
     */
    public void init() {
        value = 0;
        pScroll = 0;
    }
    
    /*
     * Возвращает value скролла
     */
    public int getValue() {
        return value;
    }
    
    /*
     * Устанавливает value скролла
     */
    public void setValue(int value) {
        if(value < 0) value = 0;
        if(value > mValue) value = mValue;
        this.value = value;
        pScroll = (int)((float)value*sAspect);
    }
    
    /*
     * Цикличная функция, принимает fps_time - 1/fps, проверяет нажатие кнопок и нажатия на экран, нажатия на экран типа presssed, released, dragged
     */
    public void pCheck(float fps_time, int pX, int pY, int rX, int rY, int dX, int dY) {
        if(Wand.region(pX, pY, wX, wY, wWidth, wHeight)) {
            lX = pX;
            sSpeed = sTime = bx = dir = 0;
            stopping = false;
            lTime = System.currentTimeMillis();
        }
        if(Wand.region(dX, dY, wX, wY, wWidth, wHeight)) {
            pScroll+=lX-dX;
            if(pScroll < 0) pScroll = 0;
            if(pScroll > wHeight-sHeight) pScroll = wHeight-sHeight;
            value = (int)((float)pScroll/sAspect);
            
            float distance = (float)Math.sqrt((dX-lX)*(dX-lX));
            float time = (float)(System.currentTimeMillis()-lTime)/1000f;
            lTime = System.currentTimeMillis();
            if(time != 0) sSpeed = distance/time;
            if(lX < dX) dir = 1;
            if(lX > dX) dir = 2;
            
            lX = dX;
        }
        if(Wand.region(rX, rY, wX, wY, wWidth, wHeight) || stopping) {
            if(sSpeed != 0) {
                int x = (int)(sSpeed*sTime-1000f*(sTime*sTime)/2f);
                if(x >= bx) {
                    sTime += fps_time;
                    if(dir == 1) pScroll -= (int)(x-bx);
                    if(dir == 2) pScroll += (int)(x-bx);
                    if(pScroll < 0) pScroll = 0;
                    if(pScroll > wHeight-sHeight) pScroll = wHeight-sHeight;
                    value = (int)((float)pScroll/sAspect);
                    bx = x;
                    stopping = true;
                } else {
                    stopping = false;
                }
            }
        }
    }
    
}