import javax.microedition.lcdui.*;
/**
 *
 * @author user
 */
public class MapParameters implements CommandListener {
    
    private int sWidth, sHeight, cInputBox, nLevel;
    private int[][] ibsXY;
    private String[] ibsTitle;
    private Image bg, board;
    private Image[] button_long1, button_long3;
    private Button p_create, p_cancel;
    private DrawText dt;
    private InputBox[] ibs;
    private Command ok, cancel;
    private TextBox textBox;
    
    private RB2 rb2;
    
    /*
     * Конструктор класса, инициализирует и принмает, sWidth и sHeight - высоту и ширину экрана, nLevel - уровень для создания/редактирования, картинку фона, картинки двух кнопок, класс DrawText и класс RB2
     */
    public MapParameters(int sWidth, int sHeight, int nLevel, Image bg, Image board, Image[] button_long1, Image[] button_long3, DrawText dt, RB2 rb2) {
        this.sWidth = sWidth;
        this.sHeight = sHeight;
        this.nLevel = nLevel;
        this.bg = bg;
        this.board = board;
        this.button_long1 = button_long1;
        this.button_long3 = button_long3;
        this.dt = dt;
        this.rb2 = rb2;
        ibs = new InputBox[2];
        ibs[0] = new InputBox(dt.stringWidth("40")+12, 14+10, "20", InputBox.NUMERIC, dt);
        ibs[0].setSelect(true); cInputBox = 0;
        ibs[1] = new InputBox(dt.stringWidth("40")+12, 14+10, "20", InputBox.NUMERIC, dt);
        
        ibsXY = new int[][] {
            {sWidth/4-ibs[0].getWidth()/2, sHeight/2+10},
            {sWidth/2+sWidth/4-ibs[1].getWidth()/2, sHeight/2+10}
        };
        ibsTitle = new String[] {
            Localization.getAloneText(8), Localization.getAloneText(9)
        };
        
        p_create = new Button();
        p_cancel = new Button();
    }
    
    public Button getCreateButton() {
        return p_create;
    }
    
    public Button getCancelButton() {
        return p_cancel;
    }
    
    /*
     * Возвращает имя уровня
     */
    public String getName() {
        return Localization.getAloneText(6)+nLevel;
    }
    
    /*
     * Возвращает ширину уровня (в блоках)
     */
    public int getWidth() {
        return Integer.parseInt(ibs[0].getValue());
    }
    
    /*
     * Возвращает высоту уровня (в блоках)
     */
    public int getHeight() {
        return Integer.parseInt(ibs[1].getValue());
    }
    
    /*
     * Делает TextBox из массива ibs под индексом newIndex текущим, убирает выделение с прошлого TextBox'а
     */
    private void reSelect(int newIndex) {
        ibs[cInputBox].setSelect(false);
        cInputBox = newIndex;
        ibs[cInputBox].setSelect(true);
    }
    
    /*
     * Возвращает true - если происходит ввод/редактирование в TextBox'е
     */
    public boolean isLockKeyboard() {
        return ibs[cInputBox].isLockKeyboard();
    }
    
    /*
     * Цикличная функция, проверяет нажатие кнопок и нажатия на экран, принимает кнопки pressed и repeated, и указатель pressed
     */
    public void check(int pKey, int rpKey, int pX, int pY) {
        if(!ibs[cInputBox].isLockKeyboard()) {
            if((pKey == -3 || pKey == Canvas.KEY_NUM4 || pKey == 102) && cInputBox > 0) reSelect(cInputBox-1);
            if((pKey == -4 || pKey == Canvas.KEY_NUM6 || pKey == 104) && cInputBox < ibs.length-1) reSelect(cInputBox+1);
            
            for(int i=0; i<ibs.length; i++) {
                if(Wand.region(pX, pY, ibsXY[i][0], ibsXY[i][1], ibs[i].getWidth(), ibs[i].getHeight())) {
                    if(cInputBox != i) {
                        ibs[cInputBox].setSelect(false); cInputBox = i; ibs[cInputBox].setSelect(true);
                    } else {
                        textBox = new TextBox(ibsTitle[i], ibs[i].getValue(), 2, TextField.ANY);
                        ok = new Command("OK", Command.OK, 0);
                        cancel = new Command("Cancel", Command.CANCEL, 0);
                        textBox.addCommand(ok);
                        textBox.addCommand(cancel);
                        textBox.setCommandListener(this);
                        rb2.rb2MIDlet.display.setCurrent(textBox);
                    }
                }
            }
        }
        if((pKey == -5 || pKey == Canvas.KEY_NUM5 || pKey == 103) && ibs[cInputBox].isLockKeyboard()) {
            if(Integer.parseInt(ibs[cInputBox].getValue()) < 10) {
                ibs[cInputBox].setValue("10");
            }
            if(Integer.parseInt(ibs[cInputBox].getValue()) > 40) {
                ibs[cInputBox].setValue("40");
            }
        }
        ibs[cInputBox].check(pKey, rpKey);
    }
    
    /*
     * Цикличная функция, принимает класс Graphics и отображает меню ввода параметров карты
     */
    public void paint(Graphics g) {
        g.drawImage(bg, 0, 0, 20);
        g.drawImage(board, sWidth/2-board.getWidth()/2, sHeight/2-board.getHeight()/2 - 6, 20);
        String string = Localization.getAloneText(6)+nLevel;
        dt.drawString(g, sWidth/2-dt.stringWidth(string)/2, sHeight/2-46, string);
        string = Localization.getAloneText(8);
        dt.drawString(g, sWidth/4-dt.stringWidth(string)/2, sHeight/2-9, string);
        string = null;
        ibs[0].paint(g, sWidth/4-ibs[0].getWidth()/2, sHeight/2+10);
        string = Localization.getAloneText(9);
        dt.drawString(g, sWidth/2+sWidth/4-dt.stringWidth(string)/2, sHeight/2-9, string);
        string = null;
        ibs[1].paint(g, sWidth/2+sWidth/4-ibs[1].getWidth()/2, sHeight/2+10);
        dt.setColor(0xdddddd);
        string = Localization.getAloneText(10);
        p_create.paint(g, 20+dt.stringWidth(string)/2-button_long3[0].getWidth()/2, sHeight-24+7-button_long3[0].getHeight()/2, button_long3);
        dt.drawString(g, 20, sHeight-24, string);
        string = null;
        string = Localization.getAloneText(11);
        p_cancel.paint(g, sWidth-dt.stringWidth(string)/2-button_long1[0].getWidth()/2-20, sHeight-24+7-button_long1[0].getHeight()/2, button_long1);
        dt.drawString(g, sWidth-dt.stringWidth(string)-20, sHeight-24, string);
        string = null;
    }
    
    public void commandAction(Command c, Displayable d) {
        if(c == ok || c == cancel) {
            if(c == ok) {
                ibs[cInputBox].setValue(textBox.getString());
                if(Integer.parseInt(ibs[cInputBox].getValue()) < 10) {
                    ibs[cInputBox].setValue("10");
                }
                if(Integer.parseInt(ibs[cInputBox].getValue()) > 40) {
                    ibs[cInputBox].setValue("40");
                }
            }
            rb2.rb2MIDlet.display.setCurrent(rb2.canvas);
        }
    }
    
}