import game.LM;
import game.S;
import game.TL;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

/**
 *
 * @author user
 */
public class NewMap {
    
    public int error;
    public long ptime;
    
    private boolean showHelp, wasMotionScroll, wasMotionMap, helpWithFlag;
    private int sWidth, sHeight, bWidth, bHeight, cX, cY, lX, lY, sbIndex, scroll, scroll2, sY = -29, pMode = 2, lIndex, mFlag;
    private int[] lXY;
    private long time;
    private String nFlag;
    private Image cBlock, board;
    private Image[] mblocks, addl, flag, button, button_long1, button_long2, button_open, button_close;
    private Button nm_save, nm_cancel, b_change;
    
    private S[] lifts;
    private TL newMap;
    private LM lm;
    private RMS rms;
    
    private ScrollBar scrollBar;
    private HScrollBar hScrollBar;
    
    private DrawText dt;
    
    public final static int DONT_SET_LIFT_UP = 0;
    public final static int DONT_SET_LIFT_DOWN = 1;
    public final static int DONT_SET_POINT_UP = 2;
    public final static int DONT_SET_POINT_DOWN = 3;
    public final static int NOT_AT_LINE = 4;
    public final static int WRONG_DIRECTION = 5;
    public final static int AT_LINE = 6;
    public final static int TOO_BESIDE_LIFT1 = 7;
    public final static int TOO_BESIDE_LIFT2 = 8;
    public final static int NOT_PUT_LIFT1 = 9;
    public final static int NOT_PUT_LIFT2 = 10;
    
    /*
     * Конструктор класса, главный класс создания карт, инициализирует и принмает, wSize и hSize - ширину и высоту экрана, blocks - картинку-набор блоков, ширину и высоту одного блока в этой картинке,
     * mblocks - миниатюрная картинка-набор блоков для каретки, board - рамка, подъемный лифт, спускной лифт, точка для подъема лифта, точка для спуска лифта, 
     * button и button_long1 и button_long2 - картинки кнопок, sWidth и sHeight - ширина и высота экрана, класс DrawText
     */
    public NewMap(int wSize, int hSize, Image blocks, int bW, int bH, Image mblocks, Image board, Image liftEnter, Image enterLift, Image liftExit, Image exitLift,
            Image[] button, Image[] button_long1, Image[] button_long2, Image[] button_open, Image[] button_close, Image[] addl, int sWidth, int sHeight, DrawText dt) {
        this.sWidth = sWidth;
        this.sHeight = sHeight;
        this.button = button;
        this.button_long1 = button_long1;
        this.button_long2 = button_long2;
        this.button_open = button_open;
        this.button_close = button_close;
        this.addl = addl;
        this.dt = dt;
        bWidth = bW;
        bHeight = bH;
        this.mblocks = new Image[8];
        for(int i=0; i<8; i++) {
            this.mblocks[i] = Image.createImage(mblocks, i*28, 0, 28, 21, Sprite.TRANS_NONE);
        }
        this.board = board;
        newMap = new TL(wSize, hSize, blocks, bWidth, bHeight, new int[hSize][wSize], sWidth, sHeight);
        lifts = new S[] {new S(enterLift), new S(liftEnter), new S(liftExit), new S(exitLift)};
        lm = new LM(sWidth, sHeight);
        lm.append(newMap, 0, 0);
        for(int i=0; i<lifts.length; i++) {
            lm.append(lifts[i]);
            removeLift(i);
        }
        
        int[] argb = new int[bWidth*bHeight];
        for(int i=0; i<argb.length; i++) {
            argb[i] = 0x40000000;
        }
        cBlock = Image.createRGBImage(argb, bWidth, bHeight, true);
        argb = null;
        
        hScrollBar = new HScrollBar(2, sHeight-52, sWidth-4, 30, (this.mblocks.length*38+5)-(sWidth-4), this.mblocks.length*38+5);
        
        nm_save = new Button();
        nm_cancel = new Button();
        b_change = new Button();
    }
    
    /*
     * Конструкт класса, главный класс создания карт, инициализирует и принмает, mLoader - лоудер карт, iLoader - лоудер картинок, sWidth и sHeight - ширину и высоту экрана, board - рамка,
     * button, button_long1, button_long2 - картинки кнопок, addl - дополнительные картинки, класс DrawText
     */
    public NewMap(MLoader mLoader, ILoader iLoader, int sWidth, int sHeight, Image board, Image[] button, Image[] button_long1, Image[] button_long2, Image[] button_open, Image[] button_close, Image[] addl, DrawText dt) {
        this.sWidth = sWidth;
        this.sHeight = sHeight;
        this.board = board;
        this.button = button;
        this.button_long1 = button_long1;
        this.button_long2 = button_long2;
        this.button_open = button_open;
        this.button_close = button_close;
        this.addl = addl;
        this.dt = dt;
        Image mini_blocks = iLoader.get("mblocks");
        mblocks = new Image[8];
        for(int i=0; i<8; i++) {
            mblocks[i] = Image.createImage(mini_blocks, i*28, 0, 28, 21, Sprite.TRANS_NONE);
        }
        mini_blocks = null;
        Image block = iLoader.get("block");
        bWidth = block.getWidth();
        bHeight = block.getHeight();
        block = null;
        int[] mWH = (int[])mLoader.get("wh");
        int[][] tiles = (int[][])mLoader.get("tiles");
        mLoader = null;
        lifts = new S[] {new S(iLoader.get("enter_lift")), new S(iLoader.get("lift_enter")), new S(iLoader.get("lift_exit")), new S(iLoader.get("exit_lift"))};
        lm = new LM(sWidth, sHeight);
        for(int i=0; i<mWH[1]; i++) {
            for(int j=0; j<mWH[0]; j++) {
                if(tiles[i][j] >= 9) {
                    int nLift = tiles[i][j] == 9 ? 1 : tiles[i][j] == 10 ? 2 : tiles[i][j] == 11 ? 0 : 3;
                    lifts[nLift].setPosition(j*bWidth, i*bHeight);
                    lm.append(lifts[nLift]);
                    tiles[i][j] = 0;
                }
            }
        }
        newMap = new TL(mWH[0], mWH[1], iLoader.get("blocks"), bWidth, bHeight, tiles, sWidth, sHeight);
        iLoader = null;
        lm.append(newMap, 0, 0);
        tiles = null;
        mWH = null;
        
        int[] argb = new int[bWidth*bHeight];
        for(int i=0; i<argb.length; i++) {
            argb[i] = 0x40000000;
        }
        cBlock = Image.createRGBImage(argb, bWidth, bHeight, true);
        argb = null;
        
        hScrollBar = new HScrollBar(2, sHeight-52, sWidth-4, 30, (mblocks.length*38+5)-(sWidth-4), mblocks.length*38+5);
        
        nm_save = new Button();
        nm_cancel = new Button();
        b_change = new Button();
    }
    
    public Button getSaveButton() {
        return nm_save;
    }
    
    public Button getCancelButton() {
        return nm_cancel;
    }
    
    /*
     * Включить отображение помощи, принмает help - массив с текстом помощи, flag - две картинки с флагом (вкл и выкл), и класс RMS
     */
    public void setHelp(String[] help, Image[] flag, RMS rms) {
        if(rms.getGameData()[14] == 0) {
            this.flag = flag;
            this.rms = rms;
            
            System.out.println(help.length);
            dt.setText(help[0], sWidth/2-board.getWidth()/2+10, sHeight/2-board.getHeight()/2+10, board.getWidth()-20, board.getHeight()-45);
            scrollBar = new ScrollBar(sWidth/2-board.getWidth()/2+10, sHeight/2-board.getHeight()/2+10, board.getWidth()-15, board.getHeight()-40, dt.getHText()-(board.getHeight()-45), dt.getHText(), true);

            nFlag = help[1];
            
            showHelp = helpWithFlag = true; mFlag = 0;
        }
    }
    
    /*
     * Упрщенное вклюение отображения помощи, help - массив с текстом помощи
     */
    public void setHelp(String[] help) {
        //switch(Localization.getLocale()) {
        //    case Localization.EN:
        dt.setText(help[0], sWidth/2-board.getWidth()/2+10, sHeight/2-board.getHeight()/2+10, board.getWidth()-20, board.getHeight()-20);
        scrollBar = new ScrollBar(sWidth/2-board.getWidth()/2+10, sHeight/2-board.getHeight()/2+10, board.getWidth()-15, board.getHeight()-20, dt.getHText()-(board.getHeight()-20), dt.getHText(), true);
        //        break;
        //    case Localization.RU:
        //        dt.setText(help[0], sWidth/8-2, sHeight/8+10, sWidth-sWidth/4+4, sHeight-sHeight/4-40);
        //        scrollBar = new ScrollBar(sWidth/8-2, sHeight/8+10, sWidth-sWidth/4+4+4, sHeight-sHeight/4-40, dt.getHText()-(sHeight-sHeight/4-40), dt.getHText());
        //        break;
        //}
        showHelp = true; helpWithFlag = false;
    }
    
    /*
     * Возвращает состояние справки на экране, false - если справка не отображается
     */
    public boolean isShowHelp() {
        return showHelp;
    }
    
    /*
     * Возвращает массив байт созданной карты
     */
    public byte[] getNewMap() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(0);
        int[] mWH = {newMap.getColumns(), newMap.getRows()};
        baos.write(mWH[0]);
        baos.write(mWH[1]);
        for(int i=0; i<mWH[1]; i++) {
            for(int j=0; j<mWH[0]; j++) {
                boolean isLift = false;
                for(int k=0; k<lifts.length; k++) {
                    if(lifts[k].getX() == j*bWidth && lifts[k].getY() == i*bHeight) {
                        baos.write(k == 0 ? 11 : k == 1 ? 9 : k == 2 ? 10 : 12);
                        isLift = true;
                        break;
                    }
                }
                if(!isLift) baos.write(newMap.getCell(j, i));
            }
        }
        for(int i=0; i<4; i++) baos.write(0);
        return baos.toByteArray();
    }
    
    /*
     * Передвигает лифт на текущую позицию (n=1 - лифт для подъема, n=2 - лифт для спуска)
     */
    private void moveLift(int n) {
        lifts[n].setPosition(cX, cY);
    }
    
    /*
     * Удаляет лифт с текущей позиции (n=1 - лифт для подъема, n=2 - лифт для спуска)
     */
    private void removeLift(int n) {
        lifts[n].setPosition(-(lifts[n].getWidth()*2), -(lifts[n].getHeight()*2));
    }
    
    /*
     * Возвращает true - если в текущей позиции есть лифт (n=1 - лифт для подъема, n=2 - лифт для спуска)
     */
    private boolean isLift(int n) {
        if(cX == lifts[n].getX() && cY == lifts[n].getY()) return true;
        return false;
    }
    
    
    /*
     * Возврашает true - если лифт вообще есть на карте (n=1 - лифт для подъема, n=2 - лифт для спуска)
     */
    public boolean isSetLift(int n) {
        if(lifts[n].getX() >= 0 && lifts[n].getY() >= 0) return true;
        return false;
    }
    
    /*
     * Устанавливает лифт в текущую позицию (n=1 - лифт для подъема, n=2 - лифт для спуска)
     */
    private void setLift(int n) {
        if(!isLift(n)) {
            int nOther = (n == 1 ? 2 : 1);
            if(cX != lifts[nOther].getX()) {
                if(cX < lifts[nOther].getX()-bWidth || cX > lifts[nOther].getX()+bWidth) {
                    moveLift(n);
                } else {
                    ptime = System.currentTimeMillis();
                    error = TOO_BESIDE_LIFT1;
                }
            } else {
                ptime = System.currentTimeMillis();
                error = AT_LINE;
            }
        } else {
            removeLift(n);
        }
    }
    
    /*
     * Устанавливает точку подъема/спуска в текущую позицию (n=1 - точка подъема, n=2 - точка спуска)
     */
    private void setLiftPoint(int n) {
        int point = (n == 1 ? 0 : 3);
        if(!isLift(point)) {
            if(lifts[n].getX() >= 0 && lifts[n].getY() >= 0) {
                if(cX == lifts[n].getX()) {
                    if(cY < lifts[n].getY()-bHeight || cY > lifts[n].getY()+bHeight*2) {
                        if(cY > lifts[n].getY()+bHeight*2) {
                            moveLift(point);
                        } else {
                            ptime = System.currentTimeMillis();
                            error = WRONG_DIRECTION;
                        }
                    } else {
                        ptime = System.currentTimeMillis();
                        error = TOO_BESIDE_LIFT2;
                    }
                } else {
                    ptime = System.currentTimeMillis();
                    error = NOT_AT_LINE;
                }
            } else {
                moveLift(point);
            }
        } else {
            removeLift(point);
        }
    }
    
    /*
     * Цикличная функция, проверяет нажатие кнопок и нажатия на экран, принмает fps_time - 1/fps, нажатие кнопок типа pressed, released и hold,нажатия на экран типа pressed, releasedи dragged
     */
    public boolean check(float fps_time, int pKey, int rKey, int hKey, int dKey, int pX, int pY, int rX, int rY, int dX, int dY) {
        if(!showHelp) {
            int sbX = -hScrollBar.getValue();
            if(scroll == 0 && scroll2 == 0) {
                boolean mScreen = false;
                if(pKey == -1 || hKey == -1 || pKey == Canvas.KEY_NUM2 || hKey == Canvas.KEY_NUM2 || pKey == 116 || hKey == 116) {
                    if(cY > 0) {
                        cY-=bHeight;
                        if(lY+cY/bHeight*bHeight < 0) {
                            lY+=-(lY+cY/bHeight*bHeight);
                        }
                        mScreen = true;
                    }
                }
                if(pKey == -2 || hKey == -2 || pKey == Canvas.KEY_NUM8 || hKey == Canvas.KEY_NUM8 || pKey == 98 || hKey == 198) {
                    if(cY < newMap.getHeight()-bHeight) {
                        cY+=bHeight;
                        if(lY+cY/bHeight*bHeight > (sHeight-52)-bHeight) {
                            lY-=(lY+cY/bHeight*bHeight)-((sHeight-52)-bHeight);
                        }
                        mScreen = true;
                    }
                }
                if(pKey == -3 || hKey == -3 || pKey == Canvas.KEY_NUM4 || hKey == Canvas.KEY_NUM4 || pKey == 102 || hKey == 102) {
                    if(cX > 0) {
                        cX-=bWidth;
                        if(lX+cX/bWidth*bWidth < 0) {
                            lX+=-(lX+cX/bWidth*bWidth);
                        }
                        mScreen = true;
                    }
                }
                if(pKey == -4 || hKey == -4 || pKey == Canvas.KEY_NUM6 || hKey == Canvas.KEY_NUM6 || pKey == 104 || hKey == 104) {
                    if(cX < newMap.getWidth()-bWidth) {
                        cX+=bWidth;
                        if(lX+cX/bWidth*bWidth > (sWidth-5)-bWidth) {
                            lX-=(lX+cX/bWidth*bWidth)-((sWidth-5)-bWidth);
                        }
                        mScreen = true;
                    }
                }
                if(mScreen) lm.check(cX+cBlock.getWidth()/2, cY+cBlock.getHeight()/2);

                if(pKey == Canvas.KEY_NUM1 || pKey == 114) {
                    if(pMode == 1 && sbIndex > 0) {
                        sbIndex--;
                        if(10+sbX+38*sbIndex < 0) scroll = sbX+38*sbIndex;
                    }
                    if(pMode == 2 && lIndex > 0) lIndex--;
                }
                if(pKey == Canvas.KEY_NUM3 || pKey == 121) {
                    if(pMode == 1 && sbIndex < 7) {
                        sbIndex++;
                        if(48+sbX+38*sbIndex >= sWidth) scroll = (48+sbX+38*sbIndex)-sWidth;
                    }
                    if(pMode == 2 && lIndex < 4) lIndex++;
                }

                if(pKey == -5 || pKey == Canvas.KEY_NUM5 || pKey == 103) {
                    if(newMap.getCell(cX/bWidth, cY/bHeight) == 0) {
                        if(pMode == 1) newMap.setCell(cX/bWidth, cY/bHeight, sbIndex+1);
                        if(pMode == 2) {
                            if(lIndex == 0) setLift(1);
                            if(lIndex == 3) setLift(2);
                            if(lIndex == 1) setLiftPoint(1);
                            if(lIndex == 2) setLiftPoint(2);
                            if(lIndex == 4) return true;
                        }
                    } else {
                        boolean setlift = false;
                        for(int i=0; i<4; i++) {
                            if(i == 1 || i == 2) {
                                if(isLift(i) || (cX == lifts[i].getX() && cY == lifts[i].getY()+bHeight)) {
                                    removeLift(i);
                                    setlift = true;
                                }
                            } else {
                                if(isLift(i)) {
                                    removeLift(i);
                                    setlift = true;
                                }
                            }
                        }
                        if(!setlift) newMap.setCell(cX/bWidth, cY/bHeight, 0);
                    }
                    
                    //newMap.setCell(cX/bWidth, cY/bHeight, sbIndex+1);
                }
                //if(rKey == Canvas.KEY_NUM0) {
                //    if(pMode == 1) {
                //        scroll2 = 30;
                //        pMode = 2;
                //    } else {
                //        if(pMode == 2) {
                //            scroll2 = -30;
                //            pMode = 1;
                //        }
                //    }
                    
                    //boolean setlift = false;
                    //for(int i=0; i<4; i++) {
                    //    if(i == 1 || i == 2) {
                    //        if(isLift(i) || (cX == lifts[i].getX() && cY == lifts[i].getY()+bHeight)) {
                    //            removeLift(i);
                    //            setlift = true;
                    //        }
                    //    } else {
                    //        if(isLift(i)) {
                    //            removeLift(i);
                    //            setlift = true;
                    //        }
                    //    }
                    //}
                    //if(!setlift) newMap.setCell(cX/bWidth, cY/bHeight, 0);
                //}
                //if(pKey == Canvas.KEY_NUM7 || pKey == 1084) setLift(1);
                //if(pKey == Canvas.KEY_NUM9 || pKey == 1090) setLift(2);
                
                //if(pKey == Canvas.KEY_STAR || pKey == 1075) setLiftPoint(1);
                //if(pKey == Canvas.KEY_POUND || pKey == 1086) setLiftPoint(2);
                
                if(lXY == null) lXY = new int[2];
                if(Wand.region(pX, pY, 2, 2, 2+(sWidth-5), 2+(sHeight-52))) {
                    lXY[0] = pX; lXY[1] = pY;
                }
                if(Wand.isAction(lXY[0], lXY[1]) && Wand.region(dX, dY, 2, 2, 2+(sWidth-5), 2+(sHeight-52))) {
                    lX += dX-lXY[0]; lY += dY-lXY[1];
                    lXY[0] = dX; lXY[1] = dY;
                    if(lX > 0) lX = 0;
                    if(lY > 0) lY = 0;
                    if(lX < (sWidth-5)-newMap.getWidth()) lX = (sWidth-5)-newMap.getWidth();
                    if(lY < (sHeight-52)-newMap.getHeight()) lY = (sHeight-52)-newMap.getHeight();
                }
                if(Wand.isAction(lXY[0], lXY[1]) && Wand.region(rX, rY, 2, 2, 2+(sWidth-5), 2+(sHeight-52))) {
                    lXY[0] = lXY[1] = -1;
                }
                
                if(Wand.region(rX, rY, 2, 2, 2+(sWidth-5), 2+(sHeight-52)) && !wasMotionMap) {
                    cX = (rX-2-lX)/bWidth*bWidth; cY = (rY-2-lY)/bHeight*bHeight;
                    if(newMap.getCell(cX/bWidth, cY/bHeight) == 0) {
                        if(pMode == 1) newMap.setCell(cX/bWidth, cY/bHeight, sbIndex+1);
                        if(pMode == 2) {
                            if(lIndex == 0) setLift(1);
                            if(lIndex == 3) setLift(2);
                            if(lIndex == 1) setLiftPoint(1);
                            if(lIndex == 2) setLiftPoint(2);
                        }
                    } else {
                        boolean setlift = false;
                        for(int i=0; i<4; i++) {
                            if(i == 1 || i == 2) {
                                if(isLift(i) || (cX == lifts[i].getX() && cY == lifts[i].getY()+bHeight)) {
                                    removeLift(i);
                                    setlift = true;
                                }
                            } else {
                                if(isLift(i)) {
                                    removeLift(i);
                                    setlift = true;
                                }
                            }
                        }
                        if(!setlift) newMap.setCell(cX/bWidth, cY/bHeight, 0);
                    }
                }
                if(!wasMotionMap) {
                    if(Wand.isAction(dX, dY)) wasMotionMap = true;
                } else {
                    if(Wand.isAction(rX, rY)) wasMotionMap = false;
                }
                
                if(pMode == 1) {
                    for(int i=0; i<8; i++) {
                        if(Wand.region(rX, rY, 8+sbX+38*i, sY+sHeight-50, 32, 25) && !wasMotionScroll) {
                            sbIndex = i;
                        }
                    }
                    if(!wasMotionScroll) {
                        if(Wand.isAction(dX, dY)) wasMotionScroll = true;
                    } else {
                        if(Wand.isAction(rX, rY)) wasMotionScroll = false;
                    }
                    hScrollBar.pCheck(fps_time, pX, pY, rX, rY, dX, dY);
                }
                if(pMode == 2) {
                    int mW = (sWidth-4-28*5)/6;
                    for(int i=0; i<5; i++) {
                        if(Wand.region(pX, pY, mW+(28+mW)*i, sY+30+sHeight-50, 32, 25)) {
                            int temp = lIndex;
                            lIndex = i;
                            if(temp == 4 && lIndex == 4) return true;
                        }
                    }
                }
                
                if(pKey == Canvas.KEY_NUM0 || Wand.region(pX, pY, (Localization.getLocale() == Localization.EN ? sWidth/2 : 133)-button_open[0].getWidth()/2-2, sHeight-18-2, button_open[0].getWidth()+4, button_open[0].getHeight()+4)) {
                    b_change.setState(true);
                }
                if(b_change.getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                    if(rKey == Canvas.KEY_NUM0 || Wand.region(rX, rY, (Localization.getLocale() == Localization.EN ? sWidth/2 : 133)-button_open[0].getWidth()/2-2, sHeight-18-2, button_open[0].getWidth()+4, button_open[0].getHeight()+4)) {
                        if(pMode == 1) {
                            scroll2 = 30;
                            pMode = 2;
                        } else {
                            if(pMode == 2) {
                                scroll2 = -30;
                                pMode = 1;
                            }
                        }
                    }
                    b_change.setState(false);
                }
            } else {
                if(scroll != 0) {
                    if(scroll > 0) {
                        sbX -= 3; scroll -= 3;
                    }
                    if(scroll < 0) {
                        sbX += 3; scroll += 3;
                    }
                }
                if(scroll2 != 0) {
                    if(scroll2 > 0) {
                        sY -= 3; scroll2 -= 3;
                    }
                    if(scroll2 < 0) {
                        sY += 3; scroll2 += 3;
                    }
                }
            }
        } else {
            if(!helpWithFlag) {
                if((pKey != 0 && pKey != -1 && pKey != -2 && pKey != Canvas.KEY_NUM2 && pKey != Canvas.KEY_NUM8 && pKey != 116 && pKey != 98) || (Wand.isAction(pX, pY) && !Wand.region(pX, pY, sWidth/8-10, sHeight/8-10, board.getWidth(), board.getHeight()))) {
                    wasMotionMap = true; showHelp = false;
                }
            } else {
                if((pKey != 0 && pKey != -1 && pKey != -2 && pKey != -5 && pKey != Canvas.KEY_NUM2 && pKey != Canvas.KEY_NUM8 && pKey != Canvas.KEY_NUM5 && pKey != 116 && pKey != 98 && pKey != 103 && pKey != 10) || (Wand.isAction(pX, pY) && !Wand.region(pX, pY, sWidth/8-10, sHeight/8-10, board.getWidth(), board.getHeight()))) {
                    wasMotionMap = true; showHelp = false;
                }
            }
            
            if(helpWithFlag && (pKey == -5 || pKey == Canvas.KEY_NUM5 || pKey == 103 || pKey == 10 || Wand.region(pX, pY, sWidth/2-board.getWidth()/2+10, sHeight/2+board.getHeight()/2-30, dt.stringWidth(nFlag)+28, 20))) {
                mFlag = (mFlag == 0 ? 1 : 0);
                rms.setGameVar(mFlag, 14);
            }
            
            scrollBar.pCheck(fps_time, dKey, pX, pY, rX, rY, dX, dY);
            dt.setY(-scrollBar.getValue());
        }
        return false;
    }
    
    /*
     * Цикличная функция, принмает класс Graphics и отображает редактируемую карту, вместе с остальным интерфейсом
     */
    public void paint(Graphics g) {
        g.setColor(0xffffff);
        g.fillRect(0, 0, sWidth, sHeight);
        
        g.setClip(2, 2, sWidth-4, sHeight-24);
        g.setColor(0x999999);
        g.fillRect(2, 2, sWidth-5, sHeight-24);
        
        g.setClip(2, 2, sWidth-4, sHeight-52);
        g.setColor(0x000000);
        g.drawRect(2, 2, sWidth-5, sHeight-52);
        for(int i=0; i<newMap.getColumns(); i++) {
            for(int j=0; j<newMap.getRows(); j++) {
                if(lX+i*bWidth > -bWidth && lX+i*bWidth < sWidth-5 && lY+j*bHeight > -bHeight && lY+j*bHeight < sHeight-52) g.drawRect(2+lX+i*bWidth, 2+lY+j*bHeight, bWidth, bHeight);
            }
        }
        lm.paint(g, 2+lX, 2+lY);
        g.drawImage(cBlock, 2+lX+cX, 2+lY+cY, 20);
        g.setClip(0, 0, sWidth, sHeight);
        g.setColor(0x858585);
        g.fillRect(0, sHeight-20, sWidth, 20);
        
        g.setClip(2, sHeight-52, sWidth-4, 30);
        g.fillRect(2, sHeight-52, sWidth-5, 29);
        
        g.setColor(0x000000);
        g.drawRect(2, sHeight-52, sWidth-5, 29);
        
        int sbX = -hScrollBar.getValue();
        for(int i=0; i<8; i++) {
            if(sbIndex == i) {
                g.setColor(0xffffff);
                g.fillRect(8+sbX+38*i, sY+sHeight-50, 32, 25);
            }
            g.drawImage(mblocks[i], 10+sbX+38*i, sY+sHeight-48, 20);
        }
        
        int mW = (sWidth-4-28*5)/6;
        for(int i=0; i<5; i++) {
            if(lIndex == i) {
                g.setColor(0xffffff);
                g.fillRect(mW+(28+mW)*i, sY+30+sHeight-50, 32, 25);
            }
            g.drawImage(addl[i], 2+mW+(28+mW)*i, sY+30+sHeight-48, 20);
        }
        
        g.setClip(0, 0, sWidth, sHeight);
        dt.setColor(0xeeeeee);
        String string = Localization.getAloneText(12)+(cX/bWidth)+":"+(cY/bHeight);
        dt.drawString(g, sWidth-dt.stringWidth(string)-10, 10, string);
        string = null;
        string = Localization.getAloneText(13);
        if(Localization.getLocale() == Localization.EN) nm_save.paint(g, 1, sHeight-17+7-button[0].getHeight()/2, button);
        if(Localization.getLocale() == Localization.RU) nm_save.paint(g, 1, sHeight-17+7-button_long2[0].getHeight()/2, button_long2);
        dt.drawString(g, 1+(Localization.getLocale() == Localization.EN ? button : button_long2)[0].getWidth()/2-dt.stringWidth(string)/2, sHeight-17, string);
        string = null;
        string = Localization.getAloneText(14);
        if(Localization.getLocale() == Localization.EN) nm_cancel.paint(g, sWidth-button[0].getWidth()-1, sHeight-17+7-button[0].getHeight()/2, button);
        if(Localization.getLocale() == Localization.RU) nm_cancel.paint(g, sWidth-button_long1[0].getWidth()-1, sHeight-17+7-button_long1[0].getHeight()/2, button_long1);
        dt.drawString(g, sWidth-(Localization.getLocale() == Localization.EN ? button : button_long1)[0].getWidth()/2-dt.stringWidth(string)/2, sHeight-17, string);
        string = null;
        
        b_change.paint(g, (Localization.getLocale() == Localization.EN ? sWidth/2 : 133)-button_open[0].getWidth()/2, sHeight-18, pMode == 1 ? button_close : button_open);
        
        if(error == TOO_BESIDE_LIFT1 || error == TOO_BESIDE_LIFT2) {
            time = System.currentTimeMillis()-ptime;
            if(time < 2000) {
                string = Localization.getAloneText(15)+(error == TOO_BESIDE_LIFT1 ? Localization.getAloneText(16) : " ")+Localization.getAloneText(17);
                dt.drawString(g, sWidth/2-dt.stringWidth(string)/2, sHeight/2-7, string);
                string = null;
            } else {
                error = 0;
            }
        }
        if(error == NOT_PUT_LIFT1 || error == NOT_PUT_LIFT2) {
            time = System.currentTimeMillis()-ptime;
            if(time < 2000) {
                string = Localization.getAloneText(18)+(error == NOT_PUT_LIFT1 ? Localization.getAloneText(19) : Localization.getAloneText(20))+Localization.getAloneText(21);
                dt.drawString(g, sWidth/2-dt.stringWidth(string)/2, sHeight/2-7, string);
                string = null;
            } else {
                error = 0;
            }
        }
        if(error == NOT_AT_LINE) {
            time = System.currentTimeMillis()-ptime;
            if(time < 2000) {
                string = Localization.getAloneText(22);
                dt.drawString(g, sWidth/2-dt.stringWidth(string)/2, sHeight/2-7, string);
                string = null;
            } else {
                error = 0;
            }
        }
        if(error == WRONG_DIRECTION) {
            time = System.currentTimeMillis()-ptime;
            if(time < 2000) {
                string = Localization.getAloneText(23);
                dt.drawString(g, sWidth/2-dt.stringWidth(string)/2, sHeight/2-7, string);
                string = null;
            } else {
                error = 0;
            }
        }
        if(error == AT_LINE) {
            time = System.currentTimeMillis()-ptime;
            if(time < 2000) {
                string = Localization.getAloneText(24);
                dt.drawString(g, sWidth/2-dt.stringWidth(string)/2, sHeight/2-7, string);
                string = null;
            } else {
                error = 0;
            }
        }
        if(error == DONT_SET_LIFT_UP) {
            time = System.currentTimeMillis()-ptime;
            if(time < 2000) {
                string = Localization.getAloneText(25);
                dt.drawString(g, sWidth/2-dt.stringWidth(string)/2, sHeight/2-7, string);
                string = null;
            } else {
                error = 0;
            }
        }
        if(error == DONT_SET_LIFT_DOWN) {
            time = System.currentTimeMillis()-ptime;
            if(time < 2000) {
                string = Localization.getAloneText(26);
                dt.drawString(g, sWidth/2-dt.stringWidth(string)/2, sHeight/2-7, string);
                string = null;
            } else {
                error = 0;
            }
        }
        if(error == DONT_SET_POINT_UP) {
            time = System.currentTimeMillis()-ptime;
            if(time < 2000) {
                string = Localization.getAloneText(27);
                dt.drawString(g, sWidth/2-dt.stringWidth(string)/2, sHeight/2-7, string);
                string = null;
            } else {
                error = 0;
            }
        }
        if(error == DONT_SET_POINT_DOWN) {
            time = System.currentTimeMillis()-ptime;
            if(time < 2000) {
                string = Localization.getAloneText(28);
                dt.drawString(g, sWidth/2-dt.stringWidth(string)/2, sHeight/2-7, string);
                string = null;
            } else {
                error = 0;
            }
        }
        if(showHelp) {
            g.drawImage(board, sWidth/8-10, sHeight/8-10, 20);
            dt.setColor(0xe0e0e0);
            dt.drawText(g, true);
            scrollBar.paint(g);
            if(helpWithFlag) {
                int X = sWidth/2-board.getWidth()/2+10, Y = sHeight/2+board.getHeight()/2-30;
                g.drawImage(flag[mFlag], X+2, Y+2, 20);
                dt.setColor(0xffffff);
                dt.drawString(g, X+22, Y+3, nFlag);
                g.setStrokeStyle(Graphics.DOTTED);
                g.setColor(0x000000);
                g.drawRect(X, Y, dt.stringWidth(nFlag)+28, 20);
                g.setStrokeStyle(Graphics.SOLID);
            }
        }
    }
    
}
