import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
/**
 *
 * @author user
 */
public class Signboard {
    
    private boolean showLevelBegin, showLevelEnd;
    private int sWidth, sHeight;
    private long firstTime, lastTime, overTime;
    private String[] sb_text;
    private Image[] images;
    private DrawFont df;
    
    /*
     * Конструктор класса, принимает sb_text - локализацию для отображения, набор картинок нужных для отображения, класса DrawFont, ширину и высоту экрана
     */
    public Signboard(String[] sb_text, Image[] images, DrawFont df, int sWidth, int sHeight) {
        this.sb_text = sb_text;
        this.images = images;
        this.df = df;
        this.sWidth = sWidth;
        this.sHeight = sHeight;
    }
    
    public DrawFont getDrawFont() {
        return df;
    }
    
    /*
     * Уводит в паузу оторажение всех Signboard'ов
     */
    public void pause() {
        overTime = System.currentTimeMillis();
    }
    
    /*
     * Возобновляет отображение всех Signboard'ов
     */
    public void play() {
        firstTime+=System.currentTimeMillis()-overTime;
    }
    
    /*
     * Запускает отображение Signboard'а - "Уровень 1 (или 2 или 3 и т.д.)"
     */
    public void startShowlevelBegin() {
        firstTime = System.currentTimeMillis();
        showLevelBegin = true;
    }
    
    /*
     * Принмает класс Graphics и отображает level (номер уровня)
     */
    public void showLevelBegin(Graphics g, int level) {
        if(showLevelBegin) {
            int x = 0;
            lastTime = System.currentTimeMillis()-firstTime;
            if(lastTime >= 1000 && lastTime < 5000) {
                df.drawString(g, (x = sWidth/2-(df.stringWidth(sb_text[5])+df.stringWidth(String.valueOf(level))+10)/2), sHeight/2-df.getHeight()/2, sb_text[5]);
            }
            if(lastTime >= 3000 && lastTime < 5000) {
                df.drawString(g, x+df.stringWidth(sb_text[5])+10, sHeight/2-df.getHeight()/2, String.valueOf(level));
            }
            if(lastTime >= 5000) {
                showLevelBegin = false;
            }
        }
    }
    
    /*
     * Возвращает состояние отображения Signboard'а - "Уровень 1 (или 2 или 3 и т.д.)", false - если отображение закончилось
     */
    public boolean isShowLevelBegin() {
        return showLevelBegin;
    }
    
    /*
     * Запускает отображение Signboard'а - "Уровень 6 (например) пройден... и т.д."
     */
    public void startShowLevelEnd() {
        firstTime = System.currentTimeMillis();
        showLevelEnd = true;
    }
    
    /*
     * Принимает класс Graphics и отображает Signboard'а - "Уровень 6 (например) пройден... и т.д."
     */
    public void showLevelEnd(Graphics g, int level, int points, boolean jLevel) {
        if(showLevelEnd) {
            lastTime = System.currentTimeMillis()-firstTime;
            int x = 0;
            if(lastTime >= 1000 && lastTime < 3000) {
                df.drawString(g, (x = sWidth/2-(df.stringWidth(sb_text[5])+df.stringWidth(String.valueOf(level))+10)/2), sHeight/2-df.getHeight(), sb_text[5]);
                df.drawString(g, x+df.stringWidth(sb_text[5])+10, sHeight/2-df.getHeight(), String.valueOf(level));
            }
            if(lastTime >= 2000 && lastTime < 3000) {
                df.drawString(g, sWidth/2-df.stringWidth(sb_text[9])/2, sHeight/2+5, sb_text[9]);
            }
            if(!jLevel) {
                if(lastTime >= 4000 && lastTime < 6000) {
                    df.drawString(g, sWidth/2-df.stringWidth(sb_text[7])/2, sHeight/2-df.getHeight()-df.getHeight()/2, sb_text[7]);
                    df.drawString(g, sWidth/2-df.stringWidth(String.valueOf(points))/2, sHeight/2-df.getHeight()/2, String.valueOf(points));
                    g.drawImage(images[13], sWidth/2-images[13].getWidth()/2, sHeight/2+df.getHeight()/2+5, 20);
                }
                if(lastTime >= 7000) {
                    showLevelEnd = false;
                }
            } else {
                if(lastTime >= 4000) {
                    showLevelEnd = false;
                }
            }
        }
    }
    
    /*
     * Возвращает состояние отображения Signboard'а - "Уровень 6 (например) пройден... и т.д.", false - если отображение закончилось
     */
    public boolean isShowLevelEnd() {
        return showLevelEnd;
    }
    
}
