/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.Game.Building;
import com.twistfuture.Game.GameManager;
import com.twistfuture.Game.MainCanvas;
import com.twistfuture.app.GeneralFunction;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Story {
    private static final Image[] IMG_BLOCKS = new Image[7];
    private static final Image[] IMG_GRILLS = new Image[7];
    public static int currentIndex;
    private int blockWidth;
    private final int storyNo;
    private Image block;
    private int blockX;
    private int blockY;
    private int blockEndX;
    private int movement = -1;
    private static int speed;

    public Story(int id, int Y, int storyNo) {
        int temp;
        speed = 5;
        this.block = IMG_BLOCKS[id];
        this.storyNo = storyNo;
        this.blockY = Y - this.block.getHeight();
        this.blockWidth = this.block.getWidth();
        this.blockX = !MainCanvas.headStartStatus ? ((temp = storyNo / 3 % 2) == 0 ? 240 - this.blockWidth : 0) : (240 - this.blockWidth) / 2;
        this.blockEndX = this.blockX + this.blockWidth;
    }

    protected void paint(Graphics g) {
        g.drawImage(this.block, this.blockX, this.blockY, 0);
    }

    protected void update() {
        if (this.blockEndX >= 240) {
            this.movement = -1;
        } else if (this.blockX <= 0) {
            this.movement = 1;
        }
        this.blockX += this.movement * speed;
        this.blockEndX = this.blockX + this.blockWidth;
    }

    protected int finalFix() {
        if (this.blockEndX < Building.currentFloorX + 20 || this.blockX > Building.currentFloorEndX - 20) {
            if (MainCanvas.noOflife > -1) {
                GameManager.manger.playSound("Tower_1");
                Building.currentFloorX = this.blockX;
                Building.currentFloorEndX = this.blockEndX;
                --MainCanvas.noOflife;
                return 0;
            }
            MainCanvas.threadStatus = false;
            return -1;
        }
        int diff = this.blockX - Building.currentFloorX;
        int indexDiff = Math.abs(diff) / 21;
        int scoreMultiplier = this.storyNo / 10 + 1;
        GameManager.manger.playSound("Tower_3");
        if ((currentIndex += indexDiff) > IMG_BLOCKS.length - 1) {
            MainCanvas.threadStatus = false;
            return -1;
        }
        this.block = this.storyNo % 2 == 1 ? IMG_BLOCKS[currentIndex] : IMG_GRILLS[currentIndex];
        this.blockWidth = this.block.getWidth();
        if (diff < 0) {
            this.blockX = Building.currentFloorX;
            Building.currentFloorEndX = this.blockX + this.block.getWidth();
        } else {
            Building.currentFloorX = this.blockX = Building.currentFloorEndX - this.blockWidth;
        }
        if (this.storyNo % 10 == 0) {
            ++speed;
        }
        if (indexDiff == 0) {
            GameManager.scoreIncresed = 10 * scoreMultiplier;
            return 1;
        }
        if (indexDiff == 1) {
            GameManager.scoreIncresed = 5 * scoreMultiplier;
            return 2;
        }
        GameManager.scoreIncresed = 1 * scoreMultiplier;
        return 0;
    }

    public int getBlockY() {
        return this.blockY;
    }

    public void setBlockY(int blockY) {
        this.blockY = blockY;
    }

    public void setBlockX(int blockX) {
        this.blockX = Building.currentFloorX;
        this.blockEndX = Building.currentFloorEndX;
    }

    static {
        for (int i = 0; i < IMG_BLOCKS.length; ++i) {
            Story.IMG_BLOCKS[i] = GeneralFunction.createImage("maincanvas/upper" + (i + 1) + ".png");
            Story.IMG_GRILLS[i] = GeneralFunction.createImage("maincanvas/down" + (i + 1) + ".png");
        }
    }
}

