/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.Game.Building;
import com.twistfuture.Game.MainCanvas;
import com.twistfuture.Game.Sky;
import com.twistfuture.app.GeneralFunction;
import com.twistfuture.utility.SaveRecord;
import com.twistfuture.utility.SoundManger;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameManager {
    private static final Image BG1 = GeneralFunction.createImage("maincanvas/bg1.png");
    private static final Image BG2 = GeneralFunction.createImage("maincanvas/bg2.png");
    private static final Image BG3 = GeneralFunction.createImage("maincanvas/bg3.png");
    private static final Image BG4 = GeneralFunction.createImage("maincanvas/bg4.png");
    public static int groundY;
    public static int scoreIncresed;
    private final Image[] bgArr = new Image[]{BG1, BG2, BG3, BG4};
    private final Sky sky1;
    private final Sky sky2;
    private final Sky sky3;
    private Image bg1;
    private Image bg2;
    private final Image ground;
    private final Building building;
    private final int bgX;
    private int bgY = 0;
    private int score;
    private String scoreString;
    private final Image scoreBg;
    private int currentBg;
    public static SoundManger manger;
    private Font font = Font.getFont((int)32, (int)0, (int)8);
    private boolean coinDoublerStatus;
    private String cross2str = "";
    private String increasedScoreStr = "";

    public GameManager() {
        this.sky1 = new Sky();
        this.sky2 = new Sky();
        this.sky3 = new Sky();
        this.bg1 = this.bgArr[this.currentBg];
        this.bg2 = this.bgArr[this.currentBg + 1];
        this.scoreBg = GeneralFunction.createImage("maincanvas/score.png");
        this.bgX = 0;
        this.ground = GeneralFunction.createImage("maincanvas/ground.png");
        groundY = this.bgY + this.bg1.getHeight() - this.ground.getHeight();
        this.score = this.getScoreFromRecordStore();
        this.scoreString = "" + this.score;
        this.building = new Building();
    }

    protected void paint(Graphics g) {
        g.drawImage(this.bg1, this.bgX, this.bgY, 0);
        g.drawImage(this.bg2, this.bgX, this.bgY - 400, 0);
        g.drawImage(this.scoreBg, 173, 10, 0);
        this.sky1.paint(g);
        this.sky2.paint(g);
        this.sky3.paint(g);
        g.drawImage(this.ground, this.bgX, groundY, 0);
        g.setFont(this.font);
        g.setColor(0xFFFFFF);
        g.drawString(this.scoreString, 180, 12, 0);
        g.drawString(this.increasedScoreStr, 184, 40, 0);
        this.building.paint(g);
    }

    protected void update() {
        this.sky1.update();
        this.sky2.update();
        this.sky3.update();
        if (!MainCanvas.headStartStatus) {
            this.building.update();
        }
    }

    protected void pointerPressed(int x, int y) {
        if (this.building.pointerPressed(x, y)) {
            this.setBackGround();
            int multipleir = 1;
            if (this.coinDoublerStatus) {
                multipleir = 2;
            }
            this.score += scoreIncresed * multipleir;
            this.increasedScoreStr = "" + scoreIncresed + this.cross2str;
            this.scoreString = "" + this.score;
        }
    }

    public boolean fallen() {
        return this.building.fallen();
    }

    public void headStart(int n) {
        this.building.headStart(n);
    }

    private void setBackGround() {
        this.bgY += 2;
        if (this.bgY > 400) {
            ++this.currentBg;
            if (this.currentBg + 1 < 4) {
                this.bgY = 0;
                this.bg2 = this.bgArr[this.currentBg];
                this.bg1 = this.bgArr[this.currentBg + 1];
            }
        }
    }

    public void coinDoubler() {
        this.coinDoublerStatus = true;
        this.cross2str = "X2";
    }

    public void saveScore() {
        SaveRecord.setRecord(this.score, 1);
    }

    public int getScoreFromRecordStore() {
        return SaveRecord.getRecord(1);
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    static {
        manger = new SoundManger();
    }
}

