/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public final class Core
extends MIDlet {
    private MainCanvas mainCanvas = new MainCanvas(this);
    private final Display display = Display.getDisplay((MIDlet)this);

    public Core() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"Snake", (boolean)true);
            byte[] data = recordStore.getRecord(1);
            recordStore.closeRecordStore();
            data = null;
            recordStore = null;
        }
        catch (RecordStoreException RSE) {
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)"Snake", (boolean)true);
                byte[] data = new byte[]{0};
                recordStore.addRecord(data, 0, 1);
                recordStore.closeRecordStore();
                data = null;
                recordStore = null;
            }
            catch (RecordStoreException RS) {
                System.out.println(RS.getMessage());
            }
        }
        Font.init();
        System.out.println("Core loaded");
    }

    public final void pauseApp() {
    }

    public final void destroyApp(boolean b) {
        this.mainCanvas = null;
        this.notifyDestroyed();
    }

    public final void startApp() {
        this.display.setCurrent((Displayable)this.mainCanvas);
    }

    public static final class Font {
        private static Image[] font = new Image[10];

        public static final void init() {
            try {
                for (int i = 0; i < font.length; i = (int)((byte)(i + 1))) {
                    Font.font[i] = Image.createImage((String)("/" + i + ".png"));
                }
            }
            catch (IOException IOE) {
                System.out.println(IOE.getMessage());
            }
            System.out.println("Core.Font loaded");
        }

        public static final void drawText(Graphics G, String TEXT, int POSX, int POSY) {
            for (int i = 0; i < TEXT.length(); ++i) {
                char num = TEXT.charAt(i);
                int n = 0;
                switch (num) {
                    case '0': {
                        n = 0;
                    }
                    case '1': {
                        n = 1;
                        break;
                    }
                    case '2': {
                        n = 2;
                        break;
                    }
                    case '3': {
                        n = 3;
                        break;
                    }
                    case '4': {
                        n = 4;
                        break;
                    }
                    case '5': {
                        n = 5;
                        break;
                    }
                    case '6': {
                        n = 6;
                        break;
                    }
                    case '7': {
                        n = 7;
                        break;
                    }
                    case '8': {
                        n = 8;
                        break;
                    }
                    case '9': {
                        n = 9;
                    }
                }
                G.drawImage(font[n], POSX + i * 7, POSY, 0);
            }
        }
    }

    private static final class Background {
        private static int scrx;
        private static int scry;
        private static Image background;

        private Background() {
        }

        public static final void init(int SCRX, int SCRY) {
            scrx = SCRX;
            scry = SCRY;
            try {
                Image bg = Image.createImage((String)"/menubackground.png");
                Image backg = Image.createImage((int)scrx, (int)scry);
                Graphics g = backg.getGraphics();
                int x = 0;
                int y = 0;
                while (y < scry) {
                    g.drawImage(bg, x, y, 0);
                    if ((x += 16) <= scrx) continue;
                    x = 0;
                    y += 16;
                }
                bg = Image.createImage((String)"/background.png");
                for (x = 0; x < scrx; x += 16) {
                    g.drawImage(bg, x, 0, 0);
                    g.drawImage(bg, x, scry - 16, 0);
                }
                bg = null;
                background = backg;
            }
            catch (IOException IOE) {
                System.out.println(IOE.getMessage());
            }
            System.out.println("Core.Background loaded");
        }

        public static final void paint(Graphics G) {
            G.drawImage(background, 0, 0, 0);
        }
    }

    private final class RImage {
        private final int POSX;
        private final int POSY;
        private final Image IMG;

        public RImage(Image IMG, int POSX, int POSY) {
            this.IMG = IMG;
            this.POSY = POSY;
            this.POSX = POSX;
            System.out.println("Core.RImage loaded");
        }

        public final Image getImage() {
            return this.IMG;
        }

        public final int getPosx() {
            return this.POSX;
        }

        public final int getPosy() {
            return this.POSY;
        }
    }

    private final class MainCanvas
    extends GameCanvas {
        private final Image BOOFER;
        private final Graphics GRAPHIC;
        private final int SCRX;
        private final int SCRY;
        private byte screenId = 0;
        private Screen[] screen = new Screen[5];

        public MainCanvas(Core CORE) {
            super(false);
            this.setFullScreenMode(true);
            this.SCRX = this.getWidth();
            this.SCRY = this.getHeight();
            this.BOOFER = Image.createImage((int)this.SCRX, (int)this.SCRY);
            this.GRAPHIC = this.BOOFER.getGraphics();
            this.screen[0] = new Splash(this.SCRX, this.SCRY, this);
            this.screen[1] = new Menu(this.SCRX, this.SCRY, this, CORE);
            this.screen[2] = new Game(this.SCRX, this.SCRY, this);
            this.screen[3] = new GameOver(this.SCRX, this.SCRY, this);
            this.screen[4] = new HeightScore(this.SCRX, this.SCRY, this);
            Background.init(this.SCRX, this.SCRY);
            System.out.println("Core.MainCanvas loaded");
        }

        public final void setScreenId(byte SCREEN_ID) {
            switch (this.screenId) {
                case 0: {
                    this.screen[0] = null;
                }
            }
            switch (SCREEN_ID) {
                case 2: {
                    Game game = (Game)this.screen[2];
                    game.newGame();
                    this.screen[2] = game;
                    game = null;
                    break;
                }
                case 4: {
                    HeightScore heightScore = (HeightScore)this.screen[4];
                    heightScore.openHeightScore();
                    this.screen[4] = heightScore;
                    Object var3_3 = null;
                }
            }
            this.screenId = SCREEN_ID;
            System.gc();
        }

        public final void paint(Graphics G) {
            this.screen[this.screenId].paint(this.GRAPHIC);
            G.drawImage(this.BOOFER, 0, 0, 0);
            this.repaint();
        }

        public final void keyPressed(int KEY_CODE) {
            this.screen[this.screenId].keyPressed(this.getGameAction(KEY_CODE));
        }

        public final void keyReleased(int KEY_CODE) {
            this.screen[this.screenId].keyReleased(this.getGameAction(KEY_CODE));
        }

        public final class Game
        extends Screen {
            private final int SCRX;
            private final int SCRY;
            private final MainCanvas LINK;
            private final Heart HEART;
            private final Background BACKGROUND;
            private final Gamer GAMER;

            public Game(int SCRX, int SCRY, MainCanvas LINK) {
                this.SCRX = SCRX;
                this.SCRY = SCRY;
                this.LINK = LINK;
                this.HEART = new Heart(this.SCRX, this.SCRY);
                this.GAMER = new Gamer(this.SCRX, this.SCRY, this.HEART);
                this.BACKGROUND = new Background(this.SCRX, this.SCRY);
                System.out.println("Core.MainCanvas.Game loaded");
            }

            public final void newGame() {
                this.HEART.newHeart();
                this.GAMER.newGame();
                System.out.println("New game");
            }

            public final void paint(Graphics G) {
                this.BACKGROUND.paint(G);
                this.HEART.paint(G);
                this.GAMER.paint(G);
            }

            public final void keyPressed(int KEY_CODE) {
                this.GAMER.setKeyCode(KEY_CODE);
            }

            public final void keyReleased(int KEY_CODE) {
            }

            private final class Background {
                private final int SCRX;
                private final int SCRY;
                private Image background;

                public Background(int SCRX, int SCRY) {
                    this.SCRX = SCRX;
                    this.SCRY = SCRY;
                    Image bg = Image.createImage((int)this.SCRX, (int)this.SCRY);
                    Image block = null;
                    try {
                        block = Image.createImage((String)"/background.png");
                    }
                    catch (IOException IOE) {
                        System.out.println(IOE.getMessage());
                    }
                    Graphics g = bg.getGraphics();
                    int x = 0;
                    int y = 0;
                    while (y < this.SCRY) {
                        g.drawImage(block, x, y, 0);
                        if ((x += 16) <= this.SCRX) continue;
                        x = 0;
                        y += 16;
                    }
                    this.background = Image.createImage((int)this.SCRX, (int)(this.SCRY - 16));
                    g = this.background.getGraphics();
                    g.drawImage(bg, 0, 0, 0);
                    block = null;
                    bg = null;
                    g = null;
                    System.out.println("Core.MainCanvas.Game.Background loaded");
                }

                public void paint(Graphics G) {
                    G.drawImage(this.background, 0, 16, 0);
                }
            }

            private final class Heart {
                private final int SCRX;
                private final int SCRY;
                private final Random RND = new Random();
                private int posy;
                private int posx;
                private Image life;

                public Heart(int SCRX, int SCRY) {
                    this.SCRX = SCRX;
                    this.SCRY = SCRY;
                    try {
                        this.life = Image.createImage((String)"/life.png");
                    }
                    catch (IOException IOE) {
                        System.out.println(IOE.getMessage());
                    }
                    System.out.println("Core.MainCanvas.Game.Heart loaded");
                }

                public final void paint(Graphics G) {
                    G.setColor(0);
                    G.drawImage(this.life, this.posx, this.posy, 0);
                }

                public final void newHeart() {
                    this.posx = Math.abs(this.RND.nextInt(this.SCRX / 16)) * 16;
                    this.posy = Math.abs(this.RND.nextInt((this.SCRY - 16) / 16)) * 16 + 16;
                }

                public final int getPosx() {
                    return this.posx;
                }

                public final int getPosy() {
                    return this.posy;
                }
            }

            public final class Gamer
            implements Runnable {
                private final byte UP;
                private final byte DOWN;
                private final byte LEFT = (byte)2;
                private final byte RIGHT = (byte)3;
                private final Vector VECTOR = new Vector();
                private final int SCRX;
                private final int SCRY;
                private byte move;
                private byte score;
                private int posx;
                private int posy;
                private int time;
                private int keyCode;
                private boolean gameOverFlag;
                private long lastTime;
                private RSnake rSnake;
                private Thread MOVE;
                private Heart HEART;
                private Image snake;

                public Gamer(int SCRX, int SCRY, Heart HEART) {
                    this.UP = 0;
                    this.DOWN = 1;
                    this.HEART = HEART;
                    this.SCRX = SCRX;
                    this.SCRY = SCRY;
                    try {
                        this.snake = Image.createImage((String)"/snake.png");
                    }
                    catch (IOException IOE) {
                        System.out.println(IOE.getMessage());
                    }
                    System.out.println("Core.MainCanvas.Game.Gamer loaded");
                }

                public final void newGame() {
                    this.move = (byte)3;
                    this.posx = 32;
                    this.posy = 16;
                    this.VECTOR.removeAllElements();
                    this.VECTOR.addElement(new RSnake(this.posx, this.posy, 3));
                    this.VECTOR.addElement(new RSnake(16, 16, 3));
                    this.VECTOR.addElement(new RSnake(0, 16, 3));
                    this.time = 500;
                    this.lastTime = System.currentTimeMillis();
                    this.score = 0;
                    this.gameOverFlag = false;
                    this.MOVE = new Thread(this);
                    this.MOVE.start();
                }

                public final void gameOver() {
                    try {
                        RecordStore recordStore = RecordStore.openRecordStore((String)"Snake", (boolean)true);
                        byte[] data = new byte[]{this.score};
                        byte[] data2 = recordStore.getRecord(1);
                        if (data[0] > data2[0]) {
                            recordStore.setRecord(1, data, 0, 1);
                        }
                        recordStore.closeRecordStore();
                        data2 = null;
                        data = null;
                        recordStore = null;
                    }
                    catch (RecordStoreException RSE) {
                        System.out.println(RSE.getMessage());
                    }
                }

                public final void paint(Graphics G) {
                    G.setColor(6399342);
                    G.fillRect(0, 0, this.SCRX, 16);
                    Font.drawText(G, "" + this.score, 2, 2);
                    for (int i = 0; i < this.VECTOR.size(); i = (int)((byte)(i + 1))) {
                        this.rSnake = (RSnake)this.VECTOR.elementAt(i);
                        G.drawImage(this.snake, this.rSnake.getPosx(), this.rSnake.getPosy(), 0);
                    }
                }

                public final void run() {
                    while (!this.gameOverFlag) {
                        switch (this.move) {
                            case 0: {
                                this.posy -= 16;
                                break;
                            }
                            case 1: {
                                this.posy += 16;
                                break;
                            }
                            case 2: {
                                this.posx -= 16;
                                break;
                            }
                            case 3: {
                                this.posx += 16;
                            }
                        }
                        this.VECTOR.insertElementAt(new RSnake(this.posx, this.posy, this.move), 0);
                        this.VECTOR.removeElementAt(this.VECTOR.size() - 1);
                        this.collision();
                        try {
                            Thread.sleep(this.time);
                        }
                        catch (InterruptedException IE) {
                            System.out.println(IE.getMessage());
                        }
                    }
                }

                public final void setKeyCode(int KEY_CODE) {
                    this.keyCode = KEY_CODE;
                    if (System.currentTimeMillis() - this.lastTime > (long)this.time) {
                        this.lastTime = System.currentTimeMillis();
                        switch (this.keyCode) {
                            case 6: {
                                if (this.move == 0) break;
                                this.move = 1;
                                break;
                            }
                            case 1: {
                                if (this.move == 1) break;
                                this.move = 0;
                                break;
                            }
                            case 5: {
                                if (this.move == 2) break;
                                this.move = (byte)3;
                                break;
                            }
                            case 2: {
                                if (this.move == 3) break;
                                this.move = (byte)2;
                            }
                        }
                    }
                }

                private final void collision() {
                    if (this.posx == this.HEART.getPosx() & this.posy == this.HEART.getPosy()) {
                        this.HEART.newHeart();
                        this.rSnake = (RSnake)this.VECTOR.lastElement();
                        this.time -= 10;
                        this.score = (byte)(this.score + 1);
                        switch (this.move) {
                            case 0: {
                                this.VECTOR.addElement(new RSnake(this.rSnake.getPosx(), this.rSnake.getPosy() + 16, this.move));
                                break;
                            }
                            case 1: {
                                this.VECTOR.addElement(new RSnake(this.rSnake.getPosx(), this.rSnake.getPosy() - 16, this.move));
                                break;
                            }
                            case 2: {
                                this.VECTOR.addElement(new RSnake(this.rSnake.getPosx() + 16, this.rSnake.getPosy(), this.move));
                                break;
                            }
                            case 3: {
                                this.VECTOR.addElement(new RSnake(this.rSnake.getPosx() - 16, this.rSnake.getPosy(), this.move));
                            }
                        }
                    }
                    if (this.posx < 0 | this.posx + 16 > this.SCRX | this.posy < 16 | this.posy + 16 > this.SCRY) {
                        this.gameOverFlag = true;
                    }
                    for (int i = 4; i < this.VECTOR.size(); i = (int)((byte)(i + 1))) {
                        this.rSnake = (RSnake)this.VECTOR.elementAt(i);
                        if (!(this.posx == this.rSnake.getPosx() & this.posy == this.rSnake.getPosy())) continue;
                        this.gameOverFlag = true;
                        break;
                    }
                    if (this.gameOverFlag) {
                        this.gameOver();
                        Game.this.LINK.setScreenId((byte)3);
                    }
                }

                private final class RSnake {
                    private final int POSX;
                    private final int POSY;
                    private final byte MOVE;

                    public RSnake(int POSX, int POSY, byte MOVE) {
                        this.POSX = POSX;
                        this.POSY = POSY;
                        this.MOVE = MOVE;
                        System.out.println("Core.MainCanvas.Game.Gamer.RSnake loaded");
                    }

                    public final int getPosx() {
                        return this.POSX;
                    }

                    public final int getPosy() {
                        return this.POSY;
                    }

                    public final byte getMove() {
                        return this.MOVE;
                    }
                }
            }
        }

        public final class HeightScore
        extends Screen {
            private final int SCRX;
            private final int SCRY;
            private final MainCanvas LINK;
            private RImage logo;
            private String heightScore;

            public HeightScore(int SCRX, int SCRY, MainCanvas LINK) {
                this.SCRX = SCRX;
                this.SCRY = SCRY;
                this.LINK = LINK;
                try {
                    this.logo = new RImage(Image.createImage((String)"/heightscore.png"), (this.SCRX - 124) / 2, 22);
                }
                catch (IOException IOE) {
                    System.out.println(IOE.getMessage());
                }
            }

            public final void openHeightScore() {
                try {
                    RecordStore recordStore = RecordStore.openRecordStore((String)"Snake", (boolean)true);
                    byte[] data = recordStore.getRecord(1);
                    this.heightScore = "" + data[0];
                    data = null;
                    recordStore.closeRecordStore();
                    recordStore = null;
                }
                catch (RecordStoreException RSE) {
                    System.out.println(RSE.getMessage());
                }
            }

            public final void paint(Graphics G) {
                Background.paint(G);
                G.drawImage(this.logo.getImage(), this.logo.getPosx(), this.logo.getPosy(), 0);
                Font.drawText(G, this.heightScore, 5, 96);
            }

            public final void keyPressed(int KEY_CODE) {
                switch (KEY_CODE) {
                    case 8: {
                        this.LINK.setScreenId((byte)1);
                    }
                }
            }

            public final void keyReleased(int KEY_CODE) {
            }
        }

        public final class GameOver
        extends Screen {
            private final int SCRX;
            private final int SCRY;
            private final MainCanvas LINK;
            private RImage logo;

            public GameOver(int SCRX, int SCRY, MainCanvas LINK) {
                this.LINK = LINK;
                this.SCRX = SCRX;
                this.SCRY = SCRY;
                try {
                    this.logo = new RImage(Image.createImage((String)"/gameover.png"), (this.SCRX - 115) / 2, 22);
                }
                catch (IOException IOE) {
                    System.out.println(IOE.getMessage());
                }
                System.out.println("Core.MainCanvas.GameOver loaded");
            }

            public final void paint(Graphics G) {
                Background.paint(G);
                G.drawImage(this.logo.getImage(), this.logo.getPosx(), this.logo.getPosy(), 0);
            }

            public final void keyPressed(int KEY_CODE) {
                switch (KEY_CODE) {
                    case 8: {
                        this.LINK.setScreenId((byte)1);
                    }
                }
            }

            public void keyReleased(int KEY_CODE) {
            }
        }

        public final class Menu
        extends Screen {
            private final int SCRX;
            private final int SCRY;
            private final MainCanvas LINK;
            private final Core CORE;
            private byte pos = 0;
            private RImage[] choise = new RImage[3];
            private RImage logo;
            private Image noPos;
            private Image yesPos;

            public Menu(int SCRX, int SCRY, MainCanvas LINK, Core CORE) {
                this.CORE = CORE;
                this.LINK = LINK;
                this.SCRX = SCRX;
                this.SCRY = SCRY;
                try {
                    this.logo = new RImage(Image.createImage((String)"/logo.png"), (this.SCRX - 116) / 2, 22);
                    for (int i = 0; i < this.choise.length; ++i) {
                        this.choise[i] = new RImage(Image.createImage((String)("/choise" + i + ".png")), (this.SCRX - 116) / 2, i * 16 + 60);
                    }
                    this.noPos = Image.createImage((String)"/item.png");
                    int width = this.noPos.getWidth();
                    int height = this.noPos.getHeight();
                    int[] argb = new int[width * height];
                    this.noPos.getRGB(argb, 0, width, 0, 0, width, height);
                    int i = 0;
                    while (i < argb.length) {
                        int n = i++;
                        argb[n] = argb[n] + 0x101010;
                    }
                    this.yesPos = Image.createRGBImage((int[])argb, (int)width, (int)height, (boolean)true);
                }
                catch (IOException IOE) {
                    System.out.println(IOE.getMessage());
                }
                System.out.println("Core.MainCanvas.Menu loaded");
            }

            public final void paint(Graphics G) {
                Background.paint(G);
                G.drawImage(this.logo.getImage(), this.logo.getPosx(), this.logo.getPosy(), 0);
                for (int i = 0; i < this.choise.length; ++i) {
                    G.drawImage(this.choise[i].getImage(), this.choise[i].getPosx(), this.choise[i].getPosy(), 0);
                    if (i == this.pos) {
                        G.drawImage(this.yesPos, this.choise[i].getPosx() + 2, this.choise[i].getPosy() + 2, 0);
                        continue;
                    }
                    G.drawImage(this.noPos, this.choise[i].getPosx() + 2, this.choise[i].getPosy() + 2, 0);
                }
            }

            public final void keyPressed(int keyCode) {
                block0 : switch (keyCode) {
                    case 1: {
                        if (this.pos <= 0) break;
                        this.pos = (byte)(this.pos - 1);
                        break;
                    }
                    case 6: {
                        if (this.pos >= 2) break;
                        this.pos = (byte)(this.pos + 1);
                        break;
                    }
                    case 8: {
                        switch (this.pos) {
                            case 0: {
                                this.LINK.setScreenId((byte)2);
                                break block0;
                            }
                            case 1: {
                                this.LINK.setScreenId((byte)4);
                                break block0;
                            }
                            case 2: {
                                this.CORE.destroyApp(true);
                            }
                        }
                    }
                }
            }

            public final void keyReleased(int keyCode) {
            }
        }

        private final class Splash
        extends Screen {
            private final int SCRX;
            private final int SCRY;
            private final long LAST_TIME = System.currentTimeMillis();
            private final MainCanvas LINK;
            private RImage splash;

            public Splash(int SCRX, int SCRY, MainCanvas LINK) {
                this.LINK = LINK;
                this.SCRX = SCRX;
                this.SCRY = SCRY;
                try {
                    this.splash = new RImage(Image.createImage((String)"/splash.png"), (SCRX - 138) / 2, (SCRY - 48) / 2);
                }
                catch (IOException IOE) {
                    System.out.println(IOE.getMessage());
                }
                System.out.println("Core.MainCanvas.Splash loaded");
            }

            public final void paint(Graphics G) {
                G.setColor(0);
                G.fillRect(0, 0, this.SCRX, this.SCRY);
                G.drawImage(this.splash.getImage(), this.splash.getPosx(), this.splash.getPosy(), 0);
                if (System.currentTimeMillis() - this.LAST_TIME > 5000L) {
                    this.LINK.setScreenId((byte)1);
                }
            }

            public final void keyPressed(int KEY_CODE) {
            }

            public final void keyReleased(int KEY_CODE) {
            }
        }

        public abstract class Screen {
            public abstract void paint(Graphics var1);

            public abstract void keyPressed(int var1);

            public abstract void keyReleased(int var1);
        }
    }
}

