/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.constants.Constants;
import com.manthanstudio.game.GameCanvas;
import com.manthanstudio.game.GameWorld;
import com.manthanstudio.game.TextArea;
import com.manthanstudio.interfaces.GameObject;
import com.manthanstudio.locale.Locale;
import com.manthanstudio.midlet.GameMIDlet;
import com.manthanstudio.resource.ResManager;
import com.manthanstudio.tools.Bounds;
import com.manthanstudio.tools.ImageSet;
import com.manthanstudio.tools.Sprite;
import com.manthanstudio.tools.Tools;
import com.manthanstudio.tools.UIFont;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class GameMenu
implements GameObject {
    GameCanvas gameCanvas;
    public static final int STYLE_VERTICAL = 1000;
    public static final int STYLE_HORIZONTAL = 1001;
    public static final int STYLE_CIRCULAR = 1002;
    public static final int STYLE_SEMI_CIRCULAR = 1003;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_RIGHT = 3;
    public static final int STATE_MAIN_MENU = 0;
    public static final int STATE_HELP = 1;
    public static final int STATE_HIGH_SCORE = 2;
    public static final int STATE_SETTINGS = 3;
    public static final int STATE_ABOUT = 4;
    public static final int STATE_EXIT = 6;
    public static final int STATE_PAUSE = 7;
    public static final int STATE_RESET_SCORE = 8;
    public static final int STATE_QUIT_TO_MENU = 9;
    public static final int STATE_ENTER_USER_NAME = 10;
    public static final int STATE_HIGH_SCORE_MSG = 11;
    public static final int STATE_AFTER_EXIT = 12;
    public static final int STATE_TIPS = 13;
    public static final int ITEM_MAIN_MENU_NEW_GAME = 0;
    public static final int ITEM_MAIN_MENU_HELP = 1;
    public static final int ITEM_MAIN_MENU_HIGH_SCORE = 2;
    public static final int ITEM_MAIN_MENU_SETTINGS = 3;
    public static final int ITEM_MAIN_MENU_ABOUT = 4;
    public static final int ITEM_MAIN_MENU_CREDIT = 5;
    public static final int ITEM_MAIN_MENU_EXIT = 6;
    public static final int ITEM_PAUSE_MENU_RESUME = 0;
    public static final int ITEM_PAUSE_MENU_SOUND = 1;
    public static final int ITEM_PAUSE_MENU_VIBRATION = 2;
    public static final int ITEM_PAUSE_MENU_QUIT_TO_MENU = 3;
    public static final int ITEM_SETTING_MENU_SOUND = 0;
    public static final int ITEM_SETTING_MENU_VIBRATION = 1;
    public static final int ITEM_SETTING_MENU_RESET = 2;
    public static final int MAX_MENU_ITEMS = 7;
    public static final int MAX_SETTING_MENU_ITEM = 3;
    public static final int MAX_PAUSE_MENU_ITEM = 4;
    public static final int UMBRELLA_STOP = 0;
    public static final int UMBRELLA_ROTATE = 1;
    public static final int NONE = -1;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int BACK = 2;
    public static final int PAUSE = 3;
    String[] strMainMenu = null;
    String[] strSettingMenu = null;
    String[] strPauseMenu = null;
    Image imgMenuBg = null;
    Image imgOtherBg = null;
    Image imgMenuTitle = null;
    Image imgHighlighter = null;
    private Image imgSmallArrowUp;
    private Image imgSmallArrowDown;
    private Image menuImageLeft;
    private Image menuImageRight;
    private Sprite spriteUmbrella;
    private Image imgYes;
    private Image imgNo;
    private Image imgBack;
    public static String soundOnOff;
    public static String vibrationOnOff;
    private String screenTitle = "";
    private String strLsk;
    private String strRsk;
    private int lskId;
    private int rskId;
    TextArea textArea;
    public Locale locale;
    public int screenState = -1;
    int prevState = -1;
    int menuXPos;
    int menuYPos;
    int itemYPadding = 2;
    int selectedInde = 0;
    int mainMenuIndex = 0;
    int numOfItems;
    int scrBottomItem;
    int menuStyle = 1000;
    int itemYPos;
    int numOfVisibleItems;
    int scrTopItem = 0;
    Bounds bounds;
    Bounds textAreaBounds;
    public static String playerName;
    int selectedItemX;
    int selectedItemY;
    int selectedItemW;
    int selectedItemH;
    String strScore = "";
    private int scoreYPadding;
    Image imgMutable;
    int prevIndex = 0;
    int nextIndex = 0;
    int alignX = 0;
    StringBuffer bufferEditBox;
    int cursorIndex;
    StringBuffer alphabets = new StringBuffer("_ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    int[] charIndexes = new int[6];
    public static final char DEFAULT_USER_NAME_CHAR = '_';
    public static final String DEFAULT_USER_NAME_TEXT = "______";
    TextArea msgBox_1;
    TextArea msgBox_2;
    int textBoxX;
    int textBoxY;
    public static final int RECORD_SIZE = 5;
    public String[] playersName = Constants.PLAYERS_NAME;
    public int[] playersScores = Constants.PLAYERS_SCORE;

    public GameMenu(GameCanvas gameCanvas) {
        this.gameCanvas = gameCanvas;
        this.locale = Locale.getInstance();
        soundOnOff = this.locale.getMessage(40);
        vibrationOnOff = this.locale.getMessage(41);
        this.init();
        this.setScreenState(0);
    }

    public void init() {
        this.imgMenuBg = ResManager.getImage(ResManager.IMAGE_BG_MENU);
        this.imgOtherBg = ResManager.getImage(ResManager.IMAGE_MENU_OTHER_BG);
        this.imgSmallArrowDown = ResManager.getImage(ResManager.IMAGE_ARROW_UP);
        this.imgSmallArrowUp = ResManager.getImage(ResManager.IMAGE_ARROW_DOWN);
        this.imgHighlighter = !GameCanvas.hasPointerEvent ? ResManager.getImage(ResManager.IMAGE_MENU_HIGHLIGHTER) : ResManager.getImage(ResManager.IMAGE_MENU_TOUCH_IMAGE);
        this.strMainMenu = new String[7];
        this.strMainMenu[0] = this.locale.getMessage(9);
        this.strMainMenu[1] = this.locale.getMessage(10);
        this.strMainMenu[2] = this.locale.getMessage(11);
        this.strMainMenu[3] = this.locale.getMessage(12);
        this.strMainMenu[4] = this.locale.getMessage(14);
        this.strMainMenu[5] = this.locale.getMessage(13);
        this.strMainMenu[6] = this.locale.getMessage(15);
        this.strSettingMenu = new String[3];
        soundOnOff = GameCanvas.isSound ? this.locale.getMessage(40) : this.locale.getMessage(41);
        GameCanvas.isVibrate = true;
        vibrationOnOff = this.locale.getMessage(42);
        this.strSettingMenu[0] = soundOnOff;
        this.strSettingMenu[1] = vibrationOnOff;
        this.strSettingMenu[2] = this.locale.getMessage(18);
        this.strPauseMenu = new String[4];
        this.strPauseMenu[0] = this.locale.getMessage(19);
        this.strPauseMenu[1] = soundOnOff;
        this.strPauseMenu[2] = vibrationOnOff;
        this.strPauseMenu[3] = this.locale.getMessage(20);
        this.bounds = Constants.mainMenuBounds;
        this.menuImageLeft = ResManager.getImage(ResManager.IMAGE_MENU_UMBERELLA_LEFT_SPRITE);
        this.menuImageRight = ResManager.getImage(ResManager.IMAGE_MENU_UMBERELLA_RIGHT_SPRITE);
        Image menuUmberalla = ResManager.getImage(ResManager.IMAGE_MENU_UMBRELLA);
        int frameWidth = menuUmberalla.getWidth() / 2;
        int frameHeight = menuUmberalla.getHeight();
        ImageSet imageSet = new ImageSet(1);
        imageSet.addState(menuUmberalla, new int[]{100, 100}, new int[]{frameWidth, frameWidth}, new int[]{frameHeight, frameHeight}, new int[]{1});
        imageSet.addState(menuUmberalla, new int[]{100, 100}, new int[]{frameWidth, frameWidth}, new int[]{frameHeight, frameHeight}, new int[]{1, 0, 1});
        this.spriteUmbrella = new Sprite(imageSet, 0, 0);
        this.spriteUmbrella.setState(0, true);
        this.imgYes = ResManager.getImage(ResManager.IMAGE_GAME_YES);
        this.imgNo = ResManager.getImage(ResManager.IMAGE_GAME_NO);
        this.imgBack = ResManager.getImage(ResManager.IMAGE_GAME_BACK);
    }

    public void reInit() {
    }

    public void cycle(long deltaMS) {
        switch (this.screenState) {
            case 0: {
                this.cycleMainMenu(deltaMS);
                break;
            }
            case 1: {
                this.cycleHelp(deltaMS);
                break;
            }
            case 2: {
                this.cycleHighScore(deltaMS);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.cycleAbout(deltaMS);
                break;
            }
            case 6: {
                break;
            }
            case 10: {
                break;
            }
            case 7: {
                this.cyclePauseMenu(deltaMS);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.cycleQuitToMenu(deltaMS);
                break;
            }
            case 11: {
                this.cycleHighScoreMsg(deltaMS);
                break;
            }
            case 12: {
                this.cycleAfterExit(deltaMS);
                break;
            }
            case 13: {
                this.cycleTips(deltaMS);
            }
        }
    }

    public void processKeys() {
        switch (this.screenState) {
            case 0: {
                this.processKeyMainMenu();
                GameCanvas.resetKeys();
                break;
            }
            case 1: {
                this.processKeyHelp();
                break;
            }
            case 2: {
                this.processKeyHighScore();
                GameCanvas.resetKeys();
                break;
            }
            case 3: {
                this.processKeySetting();
                GameCanvas.resetKeys();
                break;
            }
            case 4: {
                this.processKeyAbout();
                break;
            }
            case 6: {
                this.processKeyExit();
                GameCanvas.resetKeys();
                break;
            }
            case 10: {
                this.processKeysEnterUserName();
                GameCanvas.resetKeys();
                break;
            }
            case 7: {
                this.processKeyPauseMenu();
                break;
            }
            case 8: {
                this.processKeyResetScore();
                break;
            }
            case 9: {
                this.processKeyQuitToMenu();
                break;
            }
            case 11: {
                this.processKeyHighScoreMsg();
                break;
            }
            case 12: {
                this.processKeyAfterExit();
                break;
            }
            case 13: {
                this.processKeyTips();
            }
        }
    }

    public void renderer(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 220, 176);
        switch (this.screenState) {
            case 0: {
                this.paintMainMenu(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 1: {
                this.paintHelp(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 2: {
                this.paintHighScore(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 3: {
                this.paintSettingMenu(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 4: {
                this.paintAbout(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 6: {
                this.paintExit(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 10: {
                this.renderEnterUserName(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 7: {
                this.paintPauseMenu(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 8: {
                this.paintResetScore(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 9: {
                this.paintQuitToMenu(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 11: {
                this.paintHighScoreMsg(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 12: {
                this.paintAfterExit(g);
                this.paintLSK(g);
                this.paintRSK(g);
                break;
            }
            case 13: {
                this.paintTips(g);
                this.paintLSK(g);
                this.paintRSK(g);
            }
        }
    }

    public void paintMainMenu(Graphics g) {
        g.drawImage(ResManager.getImage(ResManager.IMAGE_BG_MENU), 0, 0, 0);
        this.spriteUmbrella.draw(g, 110 - this.spriteUmbrella.getCurrentFrameWidth() / 2, 0);
        this.renderList(g, this.strMainMenu, this.menuStyle, 2, this.bounds);
    }

    public void cycleMainMenu(long deltaMS) {
        this.spriteUmbrella.cycle(deltaMS);
        if (this.spriteUmbrella.getTotalCycles() > 0) {
            this.spriteUmbrella.setState(0, true);
        }
    }

    public void processKeyMainMenu() {
        if (this.menuStyle == 1003) {
            if (GameCanvas.keyWasPressed(8) || GameCanvas.keyWasPressed(512)) {
                this.spriteUmbrella.setState(1, true);
                if (this.mainMenuIndex > 0) {
                    --this.mainMenuIndex;
                    this.traverse();
                } else {
                    this.mainMenuIndex = this.numOfItems - 1;
                    this.traverse();
                }
            } else if (GameCanvas.keyWasPressed(4) || GameCanvas.keyWasPressed(2048)) {
                this.spriteUmbrella.setState(1, true);
                if (this.mainMenuIndex < this.numOfItems - 1) {
                    ++this.mainMenuIndex;
                    this.traverse();
                } else {
                    this.mainMenuIndex = 0;
                    this.traverse();
                }
            } else if (GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(1024)) {
                switch (this.mainMenuIndex) {
                    case 0: {
                        this.setScreenState(13);
                        this.bounds = Constants.helpBounds;
                        this.textArea = new TextArea(this.locale.getMessage(59), 2, this.bounds.x + 10, this.bounds.y + 10, this.bounds.width, this.bounds.height);
                        this.textArea.align = 0;
                        this.screenTitle = this.locale.getMessage(60);
                        this.rskId = -1;
                        this.lskId = 0;
                        break;
                    }
                    case 1: {
                        this.setScreenState(1);
                        this.bounds = Constants.helpBounds;
                        this.textArea = new TextArea(this.locale.getMessage(31), 2, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                        this.screenTitle = this.locale.getMessage(10);
                        this.rskId = 2;
                        this.lskId = -1;
                        break;
                    }
                    case 3: {
                        this.setScreenState(3);
                        this.menuStyle = 1000;
                        this.bounds = Constants.settingMenuBounds;
                        this.setList(this.strSettingMenu, this.bounds);
                        this.selectedInde = 0;
                        this.numOfItems = this.strSettingMenu.length;
                        this.lskId = 0;
                        this.rskId = 2;
                        this.screenTitle = this.locale.getMessage(12);
                        break;
                    }
                    case 2: {
                        this.setScreenState(2);
                        this.lskId = -1;
                        this.rskId = 2;
                        this.screenTitle = this.locale.getMessage(11);
                        this.loadScore();
                        break;
                    }
                    case 4: {
                        this.setScreenState(4);
                        this.bounds = Constants.helpBounds;
                        String titleString = "" + this.locale.getMessage(0);
                        String versionString = GameMIDlet.midlet.getAppProperty("MIDlet-Version");
                        String abtText = titleString + " |" + "v" + versionString + this.locale.getMessage(32);
                        this.textArea = new TextArea(abtText, 2, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                        this.textArea.setSpecialLineFont((byte)0);
                        this.screenTitle = this.locale.getMessage(14);
                        this.lskId = -1;
                        this.rskId = 2;
                        break;
                    }
                    case 5: {
                        this.webBrowser();
                        this.lskId = 0;
                        break;
                    }
                    case 6: {
                        this.setScreenState(6);
                        this.textArea = new TextArea(this.locale.getMessage(38), 3, 220);
                        this.textArea.setPostion((220 - this.textArea.getWidth()) / 2, (176 - this.textArea.getHeight()) / 2);
                        this.lskId = 0;
                        this.rskId = 1;
                    }
                }
            }
        }
        GameCanvas.resetKeys();
    }

    public void paintTips(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.textArea.renderer(g);
        UIFont.drawString(g, this.screenTitle, (220 - UIFont.stringWidth(this.screenTitle, (byte)1)) / 2, 10, 1);
    }

    public void cycleTips(long deltaMS) {
        if (this.textArea != null) {
            this.textArea.cycle(deltaMS);
        }
    }

    public void processKeyTips() {
        if (GameCanvas.keyIsHeld(2) || GameCanvas.keyIsHeld(8192)) {
            this.textArea.moveDown();
        }
        if (GameCanvas.keyIsHeld(1) || GameCanvas.keyIsHeld(128)) {
            this.textArea.moveUp();
        }
        if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
            this.gameCanvas.loadGame();
            GameCanvas.resetKeys();
        }
    }

    public void paintHelp(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.textArea.renderer(g);
        UIFont.drawString(g, this.screenTitle, (220 - UIFont.stringWidth(this.screenTitle, (byte)1)) / 2, 10, 1);
    }

    public void cycleHelp(long deltaMS) {
        if (this.textArea != null) {
            this.textArea.cycle(deltaMS);
        }
    }

    public void processKeyHelp() {
        if (GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(0);
            this.textArea.destroy();
            GameCanvas.resetKey(262144);
        }
        if (GameCanvas.keyIsHeld(2) || GameCanvas.keyIsHeld(8192)) {
            this.textArea.moveDown();
        }
        if (GameCanvas.keyIsHeld(1) || GameCanvas.keyIsHeld(128)) {
            this.textArea.moveUp();
        }
    }

    public void paintHighScore(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        UIFont.drawString(g, this.screenTitle, (220 - UIFont.stringWidth(this.screenTitle, (byte)1)) / 2, 10, 1);
        this.scoreYPadding = 50;
        for (int i = 0; i < 5; ++i) {
            UIFont.drawString(g, this.playersName[i], 30, this.scoreYPadding, 3);
            this.strScore = "";
            this.strScore = this.strScore + this.playersScores[i];
            UIFont.drawString(g, this.strScore, 190 - UIFont.stringWidth(this.strScore, (byte)3), this.scoreYPadding, 3);
            this.scoreYPadding += UIFont.getHeight(3) + 10;
        }
    }

    public void cycleHighScore(long deltaMS) {
    }

    public void processKeyHighScore() {
        if (this.lskId != -1 && (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024))) {
            this.setScreenState(0);
        }
        if (this.rskId != -1 && GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(0);
        }
    }

    public void paintSettingMenu(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        UIFont.drawString(g, this.screenTitle, (220 - UIFont.stringWidth(this.screenTitle, (byte)1)) / 2, 10, 1);
        this.renderList(g, this.strSettingMenu, this.menuStyle, 2, this.bounds);
    }

    public void cycleSetting(long deltaMS) {
    }

    public void processKeySetting() {
        if (GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(0);
        } else if (this.menuStyle == 1000) {
            if (GameCanvas.keyWasPressed(1) || GameCanvas.keyWasPressed(128)) {
                if (this.selectedInde > 0) {
                    --this.selectedInde;
                    this.traverse();
                } else {
                    this.selectedInde = this.numOfItems - 1;
                    this.traverse();
                }
            } else if (GameCanvas.keyWasPressed(2) || GameCanvas.keyWasPressed(8192)) {
                if (this.selectedInde < this.numOfItems - 1) {
                    ++this.selectedInde;
                    this.traverse();
                } else {
                    this.selectedInde = 0;
                    this.traverse();
                }
            } else if (GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(1024)) {
                switch (this.selectedInde) {
                    case 0: {
                        if (GameCanvas.isSound) {
                            GameCanvas.isSound = false;
                            this.strSettingMenu[0] = soundOnOff = this.locale.getMessage(41);
                            break;
                        }
                        GameCanvas.isSound = true;
                        this.strSettingMenu[0] = soundOnOff = this.locale.getMessage(40);
                        this.gameCanvas.soundUtils.stopSound((byte)1);
                        this.gameCanvas.soundUtils.playSound((byte)1, 1);
                        break;
                    }
                    case 1: {
                        if (GameCanvas.isVibrate) {
                            GameCanvas.isVibrate = false;
                            this.strSettingMenu[1] = vibrationOnOff = this.locale.getMessage(43);
                            break;
                        }
                        GameCanvas.isVibrate = true;
                        this.strSettingMenu[1] = vibrationOnOff = this.locale.getMessage(42);
                        Tools.vibrate(300, 100);
                        break;
                    }
                    case 2: {
                        this.textArea = new TextArea(this.locale.getMessage(39), 3, 0, 30, 220, 44);
                        this.textArea.setPostion((220 - this.textArea.getWidth()) / 2, (176 - this.textArea.getHeight()) / 2);
                        this.lskId = 0;
                        this.rskId = 1;
                        this.setScreenState(8);
                    }
                }
            }
        }
        GameCanvas.resetKeys();
    }

    public void paintResetScore(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 220, 176);
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.textArea.renderer(g);
    }

    public void cycleResetScore(long deltaMS) {
    }

    public void processKeyResetScore() {
        if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
            this.resetScoreRMS();
            this.setScreenState(2);
        }
        if (GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(3);
            this.lskId = 0;
            this.rskId = 2;
        }
        GameCanvas.resetKeys();
    }

    public void paintPauseMenu(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        UIFont.drawString(g, this.screenTitle, (220 - UIFont.stringWidth(this.screenTitle, (byte)1)) / 2, 10, 1);
        this.renderList(g, this.strPauseMenu, this.menuStyle, 2, this.bounds);
    }

    public void cyclePauseMenu(long deltaMS) {
    }

    public void processKeyPauseMenu() {
        if (!GameCanvas.keyWasPressed(262144) && this.menuStyle == 1000) {
            if (GameCanvas.keyWasPressed(1) || GameCanvas.keyWasPressed(128)) {
                if (this.selectedInde > 0) {
                    --this.selectedInde;
                    this.traverse();
                } else {
                    this.selectedInde = this.numOfItems - 1;
                    this.traverse();
                }
            } else if (GameCanvas.keyWasPressed(2) || GameCanvas.keyWasPressed(8192)) {
                if (this.selectedInde < this.numOfItems - 1) {
                    ++this.selectedInde;
                    this.traverse();
                } else {
                    this.selectedInde = 0;
                    this.traverse();
                }
            } else if (GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(1024)) {
                switch (this.selectedInde) {
                    case 0: {
                        this.gameCanvas.resumeGame();
                        break;
                    }
                    case 1: {
                        if (GameCanvas.isSound) {
                            GameCanvas.isSound = false;
                            this.strPauseMenu[1] = soundOnOff = this.locale.getMessage(41);
                            break;
                        }
                        GameCanvas.isSound = true;
                        this.strPauseMenu[1] = soundOnOff = this.locale.getMessage(40);
                        this.gameCanvas.soundUtils.stopSound((byte)1);
                        this.gameCanvas.soundUtils.playSound((byte)1, 1);
                        break;
                    }
                    case 2: {
                        if (GameCanvas.isVibrate) {
                            GameCanvas.isVibrate = false;
                            this.strPauseMenu[2] = vibrationOnOff = this.locale.getMessage(43);
                            break;
                        }
                        GameCanvas.isVibrate = true;
                        this.strPauseMenu[2] = vibrationOnOff = this.locale.getMessage(42);
                        Tools.vibrate(300, 100);
                        break;
                    }
                    case 3: {
                        this.textArea = new TextArea(this.locale.getMessage(49), 3, 220);
                        this.textArea.setPostion((220 - this.textArea.getWidth()) / 2, (176 - this.textArea.getHeight()) / 2);
                        this.lskId = 0;
                        this.rskId = 1;
                        this.setScreenState(9);
                    }
                }
            }
        }
        GameCanvas.resetKeys();
    }

    public void paintQuitToMenu(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 220, 176);
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.textArea.renderer(g);
    }

    public void cycleQuitToMenu(long deltaMS) {
    }

    public void processKeyQuitToMenu() {
        if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
            this.strSettingMenu[0] = soundOnOff;
            this.strSettingMenu[1] = vibrationOnOff;
            this.setScreenState(0);
            this.gameCanvas.unloadGame();
        }
        if (GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(7);
        }
        GameCanvas.resetKeys();
    }

    public void paintAbout(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        try {
            this.textArea.renderer(g);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UIFont.drawString(g, this.screenTitle, (220 - UIFont.stringWidth(this.screenTitle, (byte)1)) / 2, 10, 1);
    }

    public void cycleAbout(long deltaMS) {
        if (this.textArea != null) {
            this.textArea.cycle(deltaMS);
        }
    }

    public void processKeyAbout() {
        if (GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(0);
            this.textArea.destroy();
            GameCanvas.resetKey(262144);
        }
        if (GameCanvas.keyIsHeld(2) || GameCanvas.keyIsHeld(8192)) {
            this.textArea.moveDown();
        }
        if (GameCanvas.keyIsHeld(1) || GameCanvas.keyIsHeld(128)) {
            this.textArea.moveUp();
        }
    }

    public void paintHighScoreMsg(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 220, 176);
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.textArea.renderer(g);
    }

    public void cycleHighScoreMsg(long deltaMS) {
    }

    public void processKeyHighScoreMsg() {
        if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
            this.setScreenState(0);
        }
        GameCanvas.resetKeys();
    }

    public void paintExit(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 220, 176);
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.textArea.renderer(g);
    }

    public void cycleExit(long deltaMS) {
    }

    public void processKeyExit() {
        if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
            this.imgMutable = this.makeTransparent(ResManager.getImage(ResManager.IMAGE_BG_MENU), 128);
            String text = this.locale.getMessage(51);
            text = text + "|v";
            text = text + GameMIDlet.midlet.getAppProperty("MIDlet-Version");
            text = text + this.locale.getMessage(52);
            this.textArea = new TextArea(text, 1, 0, 5, 220, 141);
            this.lskId = 0;
            this.rskId = -1;
            this.setScreenState(12);
        }
        if (GameCanvas.keyWasPressed(262144)) {
            this.setScreenState(0);
        }
    }

    Image makeTransparent(Image img, int opacity) {
        int[] rgbdata = new int[img.getWidth() * img.getHeight()];
        img.getRGB(rgbdata, 0, img.getWidth(), 0, 0, img.getWidth(), img.getHeight());
        for (int i = 0; i < rgbdata.length; ++i) {
            int pixel = rgbdata[i];
            int r = (pixel & 0xFF0000) >> 16;
            int g = (pixel & 0xFF00) >> 8;
            int b = (pixel & 0xFF) >> 0;
            rgbdata[i] = (opacity << 24) + (r << 16) + (g << 8) + b;
        }
        return Image.createRGBImage((int[])rgbdata, (int)img.getWidth(), (int)img.getHeight(), (boolean)true);
    }

    private void cycleAfterExit(long deltaMS) {
        this.textArea.cycle(deltaMS);
    }

    private void paintAfterExit(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 220, 176);
        g.drawImage(this.imgMutable, 0, 0, 0);
        this.textArea.renderer(g);
    }

    private void processKeyAfterExit() {
        if (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024)) {
            GameMIDlet.midlet.close();
        }
        if (GameCanvas.keyIsHeld(2) || GameCanvas.keyIsHeld(8192)) {
            this.textArea.moveDown();
        }
        if (GameCanvas.keyIsHeld(1) || GameCanvas.keyIsHeld(128)) {
            this.textArea.moveUp();
        }
    }

    public void traverse() {
        if (this.scrBottomItem < this.numOfItems - 1 && (GameCanvas.keyWasPressed(2) || GameCanvas.keyWasPressed(8192))) {
            if (this.selectedInde == this.scrBottomItem + 1) {
                ++this.scrTopItem;
                ++this.scrBottomItem;
            }
        } else if (this.scrTopItem > 0 && (GameCanvas.keyWasPressed(1) || GameCanvas.keyWasPressed(128)) && this.selectedInde == this.scrTopItem - 1) {
            --this.scrTopItem;
            --this.scrBottomItem;
        }
        if (this.selectedInde == 0 && (GameCanvas.keyWasPressed(2) || GameCanvas.keyWasPressed(8192))) {
            this.scrTopItem = 0;
            this.scrBottomItem = this.numOfVisibleItems;
        } else if (this.selectedInde == this.numOfItems - 1 && (GameCanvas.keyWasPressed(1) || GameCanvas.keyWasPressed(128))) {
            this.scrBottomItem = this.numOfItems - 1;
            this.scrTopItem = this.scrBottomItem - this.numOfVisibleItems;
        }
    }

    public void renderList(Graphics g, String[] items, int style, int align, Bounds bounds) {
        if (items != null) {
            try {
                int itemX = 0;
                int itemY = 0;
                this.itemYPos = bounds.y;
                if (style == 1000) {
                    for (int currentIndex = this.scrTopItem; currentIndex <= this.scrTopItem + this.numOfVisibleItems; ++currentIndex) {
                        this.alignX = 0;
                        if (align == 2) {
                            this.alignX = bounds.width - UIFont.stringWidth(items[currentIndex], (byte)3);
                            this.alignX /= 2;
                        } else if (align == 3) {
                            this.alignX = bounds.width - UIFont.stringWidth(items[currentIndex], (byte)3);
                        }
                        if (currentIndex == this.selectedInde && this.imgHighlighter != null && !GameCanvas.hasPointerEvent) {
                            g.drawImage(this.imgHighlighter, bounds.x + this.alignX - this.imgHighlighter.getWidth(), this.itemYPos + (UIFont.getHeight(3) - this.imgHighlighter.getHeight()) / 2, 0);
                        }
                        if (this.imgHighlighter != null) {
                            this.itemYPos += Math.max(this.imgHighlighter.getHeight(), 18) + this.itemYPadding;
                            itemX = bounds.x + this.alignX;
                            itemY = this.itemYPos - (Math.max(this.imgHighlighter.getHeight(), 18) + this.itemYPadding);
                            UIFont.drawString(g, items[currentIndex], itemX, itemY, 3);
                            continue;
                        }
                        this.itemYPos += this.itemYPadding;
                        itemX = bounds.x + this.alignX;
                        itemY = this.itemYPos;
                        UIFont.drawString(g, items[currentIndex], itemX, itemY, 3);
                    }
                } else if (style == 1001) {
                    UIFont.drawString(g, items[this.selectedInde], bounds.x + (bounds.width - UIFont.stringWidth(items[this.selectedInde], (byte)3)) / 2, bounds.y + (bounds.height - UIFont.getHeight(3)) / 2, 3);
                } else if (style == 1003) {
                    this.prevIndex = this.mainMenuIndex - 1;
                    this.nextIndex = this.mainMenuIndex + 1;
                    if (this.prevIndex < 0) {
                        this.prevIndex = items.length - 1;
                    }
                    if (this.nextIndex > items.length - 1) {
                        this.nextIndex = 0;
                    }
                    itemX = bounds.x + (bounds.width / 2 - UIFont.stringWidth(items[this.mainMenuIndex], (byte)3) / 2);
                    itemY = bounds.y + (bounds.height - UIFont.getHeight(3)) + 1;
                    UIFont.drawString(g, items[this.mainMenuIndex], itemX, itemY, 3);
                    if (this.spriteUmbrella.getCurrentState() == 0) {
                        this.drawFrame(g, this.menuImageLeft, this.mainMenuIndex, bounds.x, bounds.y, this.menuImageLeft.getWidth() / 7, this.menuImageLeft.getHeight());
                        this.drawFrame(g, this.menuImageRight, this.mainMenuIndex, bounds.x + (bounds.width - this.menuImageRight.getWidth() / 7), bounds.y, this.menuImageRight.getWidth() / 7, this.menuImageRight.getHeight());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setList(String[] items, Bounds bounds) {
        int totalHeight = 0;
        this.scrTopItem = 0;
        for (int currentIndex = 0; currentIndex < items.length; ++currentIndex) {
            totalHeight = this.imgHighlighter != null ? (totalHeight += Math.max(this.imgHighlighter.getHeight(), UIFont.getHeight(3)) + this.itemYPadding) : (totalHeight += UIFont.getHeight(3) + this.itemYPadding);
            if (totalHeight > bounds.height) continue;
            this.scrBottomItem = currentIndex;
            this.numOfVisibleItems = currentIndex;
        }
    }

    public void setScreenState(int state) {
        this.screenState = state;
        switch (this.screenState) {
            case 0: {
                this.menuStyle = 1003;
                this.bounds = Constants.mainMenuBounds;
                this.setList(this.strMainMenu, this.bounds);
                this.numOfItems = this.strMainMenu.length;
                this.lskId = 0;
                this.rskId = -1;
                this.screenTitle = "";
                break;
            }
            case 2: {
                this.lskId = 0;
                this.rskId = -1;
                this.screenTitle = this.locale.getMessage(11);
                break;
            }
            case 10: {
                this.initEnterUserName();
                this.lskId = 0;
                this.rskId = -1;
                break;
            }
            case 7: {
                this.menuStyle = 1000;
                this.bounds = Constants.pauseMenuBounds;
                this.setList(this.strPauseMenu, this.bounds);
                this.strPauseMenu[1] = soundOnOff;
                this.strPauseMenu[2] = vibrationOnOff;
                this.selectedInde = 0;
                this.numOfItems = this.strPauseMenu.length;
                this.lskId = 0;
                this.rskId = -1;
                this.screenTitle = "";
                break;
            }
            case 11: {
                this.textArea = new TextArea(this.locale.getMessage(57), 3, 220);
                this.textArea.setPostion((220 - this.textArea.getWidth()) / 2, (176 - this.textArea.getHeight()) / 2);
                this.lskId = 0;
                this.rskId = -1;
            }
        }
    }

    public void paintLSK(Graphics g) {
        if (GameCanvas.gameMode == 1) {
            switch (this.lskId) {
                case -1: {
                    return;
                }
                case 0: {
                    g.drawImage(this.imgYes, 220 - this.imgYes.getWidth() - 2, 176 - this.imgYes.getHeight() - 2, 0);
                    break;
                }
                case 1: {
                    g.drawImage(this.imgNo, 220 - this.imgNo.getWidth() - 2, 176 - this.imgNo.getHeight() - 2, 0);
                    break;
                }
                case 2: {
                    g.drawImage(this.imgBack, 220 - this.imgBack.getWidth() - 2, 176 - this.imgBack.getHeight() - 2, 0);
                }
            }
        } else {
            switch (this.lskId) {
                case -1: {
                    return;
                }
                case 0: {
                    g.drawImage(this.imgYes, 2, 176 - this.imgYes.getHeight() - 2, 0);
                    break;
                }
                case 1: {
                    g.drawImage(this.imgNo, 2, 176 - this.imgNo.getHeight() - 2, 0);
                    break;
                }
                case 2: {
                    g.drawImage(this.imgBack, 2, 176 - this.imgBack.getHeight() - 2, 0);
                }
            }
        }
    }

    public void paintRSK(Graphics g) {
        if (GameCanvas.gameMode == 1) {
            switch (this.rskId) {
                case -1: {
                    return;
                }
                case 0: {
                    g.drawImage(this.imgYes, 220 - this.imgYes.getWidth() - 2, 2, 0);
                    break;
                }
                case 1: {
                    g.drawImage(this.imgNo, 220 - this.imgNo.getWidth() - 2, 2, 0);
                    break;
                }
                case 2: {
                    g.drawImage(this.imgBack, 220 - this.imgBack.getWidth() - 2, 2, 0);
                }
            }
        } else {
            switch (this.rskId) {
                case -1: {
                    return;
                }
                case 0: {
                    g.drawImage(this.imgYes, 220 - this.imgYes.getWidth() - 2, 176 - this.imgYes.getHeight() - 2, 0);
                    break;
                }
                case 1: {
                    g.drawImage(this.imgNo, 220 - this.imgNo.getWidth() - 2, 176 - this.imgNo.getHeight() - 2, 0);
                    break;
                }
                case 2: {
                    g.drawImage(this.imgBack, 220 - this.imgBack.getWidth() - 2, 176 - this.imgBack.getHeight() - 2, 0);
                }
            }
        }
    }

    public void initEnterUserName() {
        this.alphabets = new StringBuffer("_ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        this.charIndexes = new int[6];
        this.msgBox_1 = new TextArea(this.locale.getMessage(44), 3, 240);
        this.msgBox_1.setPostion(110 - this.msgBox_1.getWidth() / 2, 10);
        this.msgBox_2 = new TextArea(this.locale.getMessage(45), 3, 240);
        this.msgBox_2.setPostion(110 - this.msgBox_1.getWidth() / 2, 118);
        this.bufferEditBox = new StringBuffer(6);
        this.bufferEditBox.append(DEFAULT_USER_NAME_TEXT);
        this.cursorIndex = 0;
    }

    public void renderEnterUserName(Graphics g) {
        g.drawImage(this.imgOtherBg, 0, 0, 0);
        this.msgBox_1.renderer(g);
        this.textBoxX = (220 - this.imgSmallArrowDown.getWidth() * 6) / 2;
        this.textBoxY = 88 - this.imgSmallArrowDown.getHeight();
        g.drawImage(this.imgSmallArrowDown, this.textBoxX + this.cursorIndex * this.imgSmallArrowDown.getWidth(), this.textBoxY - 3, 0);
        g.drawImage(this.imgSmallArrowUp, this.textBoxX + this.cursorIndex * this.imgSmallArrowUp.getWidth(), 88 + UIFont.getHeight(3) + 3, 0);
        g.setColor(0xFFFFFF);
        g.fillRect(this.textBoxX, 88, this.imgSmallArrowDown.getWidth() * 6, UIFont.getHeight(3));
        for (int i = 0; i < this.bufferEditBox.length(); ++i) {
            UIFont.drawFontCode(this.bufferEditBox.charAt(i), (byte)3, this.textBoxX + (this.imgSmallArrowDown.getWidth() - UIFont.charWidth(this.bufferEditBox.charAt(i), (byte)3)) / 2 + i * this.imgSmallArrowDown.getWidth(), 88);
        }
        this.msgBox_2.renderer(g);
    }

    public void processKeysEnterUserName() {
        if (GameCanvas.keyIsHeld(129)) {
            if (this.bufferEditBox.charAt(this.cursorIndex) == ' ') {
                this.charIndexes[this.cursorIndex] = this.alphabets.length() - 1;
                this.bufferEditBox.setCharAt(this.cursorIndex, this.alphabets.charAt(this.charIndexes[this.cursorIndex]));
            } else {
                int n = this.cursorIndex;
                this.charIndexes[n] = this.charIndexes[n] - 1;
                if (this.charIndexes[this.cursorIndex] < 0) {
                    this.charIndexes[this.cursorIndex] = this.alphabets.length() - 1;
                }
                this.bufferEditBox.setCharAt(this.cursorIndex, this.alphabets.charAt(this.charIndexes[this.cursorIndex]));
            }
        } else if (GameCanvas.keyIsHeld(8194)) {
            if (this.bufferEditBox.charAt(this.cursorIndex) == ' ') {
                this.charIndexes[this.cursorIndex] = 0;
                this.bufferEditBox.setCharAt(this.cursorIndex, this.alphabets.charAt(this.charIndexes[this.cursorIndex]));
            } else {
                int n = this.cursorIndex;
                this.charIndexes[n] = this.charIndexes[n] + 1;
                if (this.charIndexes[this.cursorIndex] >= this.alphabets.length()) {
                    this.charIndexes[this.cursorIndex] = 0;
                }
                this.bufferEditBox.setCharAt(this.cursorIndex, this.alphabets.charAt(this.charIndexes[this.cursorIndex]));
            }
        } else if (GameCanvas.keyWasPressed(520)) {
            --this.cursorIndex;
            if (this.cursorIndex < 0) {
                this.cursorIndex = 0;
            }
        } else if (GameCanvas.keyWasPressed(2052)) {
            if (this.bufferEditBox.charAt(this.cursorIndex) != ' ') {
                ++this.cursorIndex;
                if (this.cursorIndex >= 6) {
                    this.cursorIndex = 5;
                }
            }
        } else if (GameCanvas.keyWasPressed(32768)) {
            this.bufferEditBox.setCharAt(this.cursorIndex, '_');
            --this.cursorIndex;
            if (this.cursorIndex < 0) {
                this.cursorIndex = 0;
            }
        } else if (!GameCanvas.keyWasPressed(262144) && (GameCanvas.keyWasPressed(131072) || GameCanvas.keyWasPressed(16) || GameCanvas.keyWasPressed(1024))) {
            if (this.bufferEditBox != null && this.bufferEditBox.capacity() > 0) {
                for (int i = 0; i < 6; ++i) {
                    if (this.bufferEditBox.charAt(i) != '_') continue;
                    this.bufferEditBox.deleteCharAt(i);
                    this.bufferEditBox.insert(i, ' ');
                }
                playerName = this.bufferEditBox.toString().trim();
            }
            if (playerName == null || playerName.equals("") || playerName.equals(" ")) {
                playerName = "ANONYMOUS";
            }
            this.addScore(playerName, GameWorld.score);
            this.setScreenState(2);
        }
        GameCanvas.resetKeys();
    }

    public void free() {
    }

    public void destroy() {
        this.free();
    }

    public void enable() {
    }

    public void disable() {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void addScore(String playerName, int score) {
        this.loadScore();
        this.sortScore();
        try {
            for (int i = 0; i < 5; ++i) {
                if (this.playersScores[i] >= GameWorld.score) continue;
                for (int j = 3; j >= i; --j) {
                    this.playersScores[j + 1] = this.playersScores[j];
                    this.playersName[j + 1] = this.playersName[j];
                }
                this.playersScores[i] = GameWorld.score;
                this.playersName[i] = playerName;
                break;
            }
            this.saveScore(this.playersName, this.playersScores);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        playerName = "";
        GameWorld.score = 0;
    }

    public void resetScoreRMS() {
        this.playersName = new String[]{"Brian", "Lisa", "Brinda", "Yoshiaki", "Andrew"};
        this.playersScores = new int[]{10250, 8400, 6550, 3000, 1500};
        try {
            this.saveScore(this.playersName, this.playersScores);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sortScore() {
        for (int i = 3; i >= 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (this.playersScores[i] >= this.playersScores[i + 1]) continue;
                int temp = this.playersScores[i];
                this.playersScores[i] = this.playersScores[i + 1];
                this.playersScores[i + 1] = temp;
                String strTemp = this.playersName[i];
                this.playersName[i] = this.playersName[i + 1];
                this.playersName[i + 1] = strTemp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveScore(String[] playerName, int[] score) throws Exception {
        RecordStore scoreRms = null;
        try {
            scoreRms = RecordStore.openRecordStore((String)"score_rms", (boolean)true);
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteOutputStream);
            for (int i = 0; i < playerName.length; ++i) {
                dataOutputStream.writeUTF(playerName[i]);
                dataOutputStream.writeInt(score[i]);
            }
            dataOutputStream.flush();
            byte[] recordOut = byteOutputStream.toByteArray();
            try {
                scoreRms.setRecord(1, recordOut, 0, recordOut.length);
            }
            catch (InvalidRecordIDException ir) {
                scoreRms.addRecord(recordOut, 0, recordOut.length);
            }
            dataOutputStream.close();
            byteOutputStream.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException io) {
            System.out.println("IOException: " + io);
            boolean bl = false;
            return bl;
        }
        catch (RecordStoreException rse) {
            System.out.println("RecordStoreException: " + (Object)((Object)rse));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (scoreRms != null) {
                    scoreRms.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
                System.out.println("RecordStoreNotOpenException : " + (Object)((Object)e));
            }
            catch (RecordStoreException e) {
                System.out.println("RecordStoreException : " + (Object)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadScore() {
        RecordStore scoreRms = null;
        try {
            boolean i;
            scoreRms = RecordStore.openRecordStore((String)"score_rms", (boolean)true);
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(scoreRms.getRecord(1));
            DataInputStream dataInputStream = new DataInputStream(byteInputStream);
            for (i = false; i < this.playersName.length; i += 1) {
                this.playersName[i] = dataInputStream.readUTF();
                this.playersScores[i] = dataInputStream.readInt();
            }
            dataInputStream.close();
            byteInputStream.close();
            scoreRms = null;
            i = true;
            return i;
        }
        catch (IOException io) {
            System.out.println("IOException: " + io);
            boolean bl = false;
            return bl;
        }
        catch (RecordStoreException rse) {
            System.out.println("RecordStoreException: " + (Object)((Object)rse));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (scoreRms != null) {
                    scoreRms.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
                System.out.println("RecordStoreNotOpenException : " + (Object)((Object)e));
            }
            catch (RecordStoreException e) {
                System.out.println("RecordStoreException : " + (Object)((Object)e));
            }
        }
    }

    public void drawFrame(Graphics g, Image imgSource, int frameNo, int targetX, int targetY, int frameWidth, int frameHeight) {
        int row = imgSource.getHeight() / frameHeight;
        int col = imgSource.getWidth() / frameWidth;
        g.setClip(targetX, targetY, frameWidth, frameHeight);
        g.drawImage(imgSource, targetX - frameNo % col * frameWidth, targetY - frameNo / col % row * frameHeight, 0);
        g.setClip(0, 0, 220, 176);
    }

    public void webBrowser() {
        try {
            GameMIDlet.midlet.platformRequest("http://facebook.manthanstudio.com/games/");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

