/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.tools;

public class Bounds {
    public int x;
    public int y;
    public int width;
    public int height;

    public Bounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean contains(int rX, int rY, int rWidth, int rHeight) {
        return this.x <= rX && this.y <= rY && this.x + this.width >= rX + rWidth && this.y + this.height >= rY + rHeight;
    }

    public boolean contains(int rX, int rY) {
        return this.x <= rX && this.y <= rY && this.x + this.width >= rX && this.y + this.height >= rY;
    }

    public Bounds intersection(int rX, int rY, int rW, int rH) {
        int tx1 = this.x;
        int ty1 = this.y;
        int rx1 = rX;
        int ry1 = rY;
        long tx2 = tx1;
        tx2 += (long)this.width;
        long ty2 = ty1;
        ty2 += (long)this.height;
        long rx2 = rx1;
        rx2 += (long)rW;
        long ry2 = ry1;
        ry2 += (long)rH;
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        ty2 -= (long)ty1;
        if ((tx2 -= (long)tx1) < Integer.MIN_VALUE) {
            tx2 = Integer.MIN_VALUE;
        }
        if (ty2 < Integer.MIN_VALUE) {
            ty2 = Integer.MIN_VALUE;
        }
        return new Bounds(tx1, ty1, (int)tx2, (int)ty2);
    }

    public static boolean intersects(int tx, int ty, int tw, int th, int x, int y, int width, int height) {
        int rw = width;
        int rh = height;
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int rx = x;
        int ry = y;
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }

    public String toString() {
        return "x = " + this.x + " y = " + this.y + " width = " + this.width + " height = " + this.height;
    }
}

