/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.constants.Constants;
import com.manthanstudio.game.Actor;
import com.manthanstudio.game.ActorPool;
import com.manthanstudio.game.GameCanvas;
import com.manthanstudio.game.Hero;
import com.manthanstudio.game.Power;
import com.manthanstudio.game.TiledLayer;
import com.manthanstudio.game.Vehicles;
import com.manthanstudio.interfaces.GameObject;
import com.manthanstudio.locale.Locale;
import com.manthanstudio.resource.ResManager;
import com.manthanstudio.tools.ImageSet;
import com.manthanstudio.tools.Sprite;
import com.manthanstudio.tools.StringUtils;
import com.manthanstudio.tools.Tools;
import com.manthanstudio.tools.UIFont;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameWorld
implements GameObject {
    public final int POWER_FRUIT_INDEX;
    public final int POWER_BIRD_INDEX;
    public static final int MODE_DAY = 0;
    public static final int MODE_NIGHT = 1;
    public static final int MODE_TUNNEL = 2;
    private static int t = 0;
    public static final int NOT_STARTED = t++;
    public static final int STARTING_UP = t++;
    public static final int PLAYING = t++;
    public static final int LEVEL_FULL_IMAGE = t++;
    public static final int PAUSED = t++;
    public static final int GAME_OVER = t++;
    public static final int GAME_DONE = t++;
    public static final int GAME_RESET = t++;
    public static final String BLANK_STRING = "";
    public static final String SPACE_STRING = " ";
    public static final String PLUSH_STRING = "+";
    public static final String CROSS_STRING = " X ";
    public static final String MULTIPLICATION_STRING = " X 2";
    public static int gameState;
    private int statePriorToPause;
    private long timeStateChanged;
    private long timeSinceStateChange;
    public int currentViewX;
    public int currentViewY;
    GameCanvas gameCanvas;
    TiledLayer tiledLayer;
    Hero hero;
    ActorPool vehiclePool;
    Vehicles[] vehicals;
    Vehicles mileStoneVehicles;
    Power[] powerArray;
    private Sprite powerSprite;
    Locale locale;
    Image[][] cloud;
    private Image[] imgBuilding;
    private Image offlineImage;
    private Graphics offlineGraphics;
    private Image imgPause;
    private String gameMsg;
    private String rskKey;
    public static int score;
    public String strScore;
    public int currentGlidScores;
    public String strCurrGlidScores;
    public String strLandingType;
    private int landingMsgY = 0;
    private long landingMsgTicks;
    private long landingMsgFluff;
    public int actorLife = 3;
    public String strActorLife;
    public long cloudTicks;
    public long cloudFluff;
    int[] cloudCoord1;
    int[] cloudCoord2;
    public int mileStonePosX;
    public int mileStonePosY;
    public int mileStoneVehicle;
    public int maxGlideHeight;
    public int lowestGlideHeight;
    Vehicles vehiclesToBeRemoved;
    private int incrementFactor = 30;
    public static final int INCREMENT_FACTOR = 10;
    private int nextCarBonusTarget = 30;
    private int carCrossedBonusPoints = 1000;
    private String carBonusMsg;
    private static final int CAR_CROSSED_BONUS_MSG_Y = 30;
    private static final int TARGET_CAR_MSG_Y = 45;
    private String strCarCrossedBonusMsg = "";
    private String strTargetCarCrossedMsg = "";
    long fluffBlink;
    boolean isBlink;
    private long timeToStartBlink = 0L;
    public static final int BLINK_TIMING = 3000;
    public static final int BLINKING_DELAY = 400;
    private int totalVehiCrossed;
    private int prevTotalVehiCrossed = 0;
    private int countVehiForDifficulty;
    private int countVehiclesForAmbulance;
    private int differanceBetweenCar;
    boolean isAchiveTargetBlink;
    public boolean isModeChange = true;
    public long timeSinceGamePause;
    public long timeGamePause;
    Random random = new Random();
    int totalFree = 0;
    public int bgEnvirnmentIndex = 1;
    private int buildingX = 0;
    private int buildingY = 0;
    private int clipX = 0;
    private int clipY = 0;
    private int clipW = 0;
    private int clipH = 0;
    private int cloudSpeed = 1;
    public static final int TRANS_NONE = 0;
    private int oldX;
    private int oldY;
    private int oldWidth;
    private int oldHeight;
    private int srcX;
    private int srcY;
    private int srcWidth;
    private int srcHeight;
    private int targetX;
    private int targetY;
    private int transitionSpeed;
    private boolean isResetTransition = false;

    public GameWorld(GameCanvas gameCanvas) {
        this.POWER_FRUIT_INDEX = 0;
        this.POWER_BIRD_INDEX = 1;
        this.gameCanvas = gameCanvas;
        this.currentViewX = 0;
        this.currentViewY = 0;
        score = 0;
        if (GameCanvas.isSound) {
            gameCanvas.soundUtils.stopSound((byte)2);
            gameCanvas.soundUtils.loadSound((byte)2);
        }
    }

    public void loadGame() {
        this.setState(NOT_STARTED);
        this.startNewGame();
    }

    public void startNewGame() {
        this.init();
        if (GameCanvas.isSound) {
            this.gameCanvas.soundUtils.playSound((byte)2, -1);
        }
        System.gc();
        this.setState(STARTING_UP);
    }

    public void restart() {
        this.reInit();
        this.resetPanPixel();
        if (GameCanvas.isSound && !this.gameCanvas.soundUtils.isPlaying()) {
            this.gameCanvas.soundUtils.playSound((byte)2, -1);
        }
        System.gc();
        this.setState(STARTING_UP);
    }

    public void init() {
        int i;
        GameCanvas.resetKeys();
        this.locale = Locale.getInstance();
        this.countVehiclesForAmbulance = 0;
        this.totalVehiCrossed = this.prevTotalVehiCrossed = 0;
        this.countVehiForDifficulty = 0;
        this.currentViewX = 0;
        this.currentViewY = 0;
        this.strScore = BLANK_STRING;
        this.strScore = this.strScore + score;
        this.currentGlidScores = 0;
        this.strCurrGlidScores = BLANK_STRING;
        this.strLandingType = BLANK_STRING;
        this.strActorLife = CROSS_STRING;
        this.actorLife = 3;
        this.strActorLife = this.strActorLife + this.actorLife;
        this.isAchiveTargetBlink = false;
        this.carBonusMsg = this.locale.getMessage(58);
        this.vehicals = new Vehicles[8];
        this.differanceBetweenCar = 50;
        int tempX = -(this.currentViewX + this.differanceBetweenCar);
        this.vehicals[0] = this.mileStoneVehicles = new Vehicles(0, 10);
        this.vehicals[0].init();
        this.vehicals[0].setX(tempX -= this.vehicals[0].getWidth());
        tempX -= this.differanceBetweenCar;
        this.vehicals[0].setY(172 - this.vehicals[0].getHeight() - 9);
        this.vehicals[0].setWorld(this);
        this.vehicals[0].speedUpFP = Vehicles.FP_PLUS_0_02;
        for (i = 1; i < 8; ++i) {
            int vehiclesId = i % 8;
            if (vehiclesId == 0) {
                vehiclesId = Tools.getRand(1, 7);
            }
            this.vehicals[i] = new Vehicles(vehiclesId, 10);
            this.vehicals[i].init();
            this.vehicals[i].setX(tempX -= this.vehicals[i].getWidth());
            tempX -= this.differanceBetweenCar;
            this.vehicals[i].setY(172 - this.vehicals[i].getHeight() - 9);
            this.vehicals[i].setWorld(this);
            this.vehicals[i].speedUpFP = i % 2 == 0 ? Vehicles.FP_PLUS_0_02 : Vehicles.FP_MINUS_0_02;
        }
        this.vehiclePool = new ActorPool(this.vehicals);
        this.hero = new Hero(this.vehicals[0].getX(), 0);
        this.hero.init();
        this.hero.setY(this.vehicals[0].getY() - this.hero.getHeight());
        this.hero.setOwner(this.vehicals[0]);
        this.hero.setWorld(this);
        this.getVehiclesFromPool();
        for (i = 0; i < 4; ++i) {
            this.setNewVehiclesOnUsedList(this.getVehiclesFromPool());
        }
        this.tiledLayer = new TiledLayer(this, 220, 176);
        this.tiledLayer.setWorldX(this.currentViewX);
        this.tiledLayer.setWorldY(0);
        byte[][] tileMap = new byte[4][14];
        tileMap = this.createTileMapArray(90);
        this.bgEnvirnmentIndex = 0;
        this.tiledLayer.setTileMapArray(tileMap);
        this.tiledLayer.setTileImage(ResManager.getImage(ResManager.IMAGE_GAME_TUNNEL));
        this.tiledLayer.initResources();
        this.maxGlideHeight = this.bgEnvirnmentIndex == 2 ? 30 : 10;
        this.powerArray = new Power[2];
        this.powerArray[0] = new Power(9);
        this.powerArray[0].setWorld(this);
        this.powerArray[0].init();
        this.powerArray[0].setX(440);
        this.powerArray[0].setY(this.maxGlideHeight);
        this.powerArray[0].isInUse = true;
        this.powerArray[1] = new Power(10);
        this.powerArray[1].setWorld(this);
        this.powerArray[1].init();
        this.powerArray[1].setX(440);
        this.powerArray[1].setY(this.maxGlideHeight);
        this.powerArray[1].isInUse = true;
        this.imgBuilding = new Image[3];
        this.imgBuilding[0] = ResManager.getImage(ResManager.IMAGE_GAME_DAY_BUILDING_BG);
        this.imgBuilding[1] = ResManager.getImage(ResManager.IMAGE_GAME_NIGHT_BUILDING_BG);
        this.cloud = new Image[3][2];
        this.cloud[0][0] = ResManager.getImage(ResManager.IMAGE_GAME_DAY_CLOUD_1);
        this.cloud[0][1] = ResManager.getImage(ResManager.IMAGE_GAME_DAY_CLOUD_2);
        this.cloud[1][0] = ResManager.getImage(ResManager.IMAGE_GAME_NIGHT_CLOUD_1);
        this.cloud[1][1] = ResManager.getImage(ResManager.IMAGE_GAME_NIGHT_CLOUD_2);
        this.cloudCoord1 = new int[]{55, 5};
        this.cloudCoord2 = new int[]{220, 25};
        this.offlineImage = Image.createImage((int)220, (int)88);
        this.offlineGraphics = this.offlineImage.getGraphics();
        this.resetTransitionEffect("YOU LOST YOUR ONE LIFE", false);
        this.isResetTransition = false;
        this.imgPause = ResManager.getImage(ResManager.IMAGE_GAME_PAUSE);
        Image imgSprite = ResManager.getImage(ResManager.IMAGE_GAME_POWER_HEART);
        ImageSet imageSet = new ImageSet(1);
        imageSet.addState(imgSprite, new int[]{150, 150, 150}, new int[]{imgSprite.getWidth() / 3, imgSprite.getWidth() / 3, imgSprite.getWidth() / 3}, new int[]{imgSprite.getHeight(), imgSprite.getHeight(), imgSprite.getHeight()}, new int[]{0, 1, 2});
        this.powerSprite = new Sprite(imageSet, 0, 0);
        this.powerSprite.setState(0, true);
    }

    public byte[][] createTileMapArray(int size) {
        byte[][] day = new byte[][]{{12, 12, 12, 12, 12, 12, 12}, {12, 12, 12, 12, 12, 12, 12}, {12, 12, 12, 12, 12, 12, 12}, {19, 14, 19, 14, 19, 14, 19}};
        byte[][] tunnelDayToNight = new byte[][]{{1, 2, 1, 2, 1, 2}, {6, 7, 6, 7, 6, 7}, {11, 11, 11, 11, 11, 11}, {16, 17, 16, 17, 16, 17}};
        byte[][] night = new byte[][]{{12, 12, 12, 12, 12, 12, 12}, {12, 12, 12, 12, 12, 12, 12}, {12, 12, 12, 12, 12, 12, 12}, {4, 9, 4, 9, 4, 9, 4}};
        byte[][] tunnelNightToDay = new byte[][]{{1, 2, 1, 2, 1, 2}, {6, 7, 6, 7, 6, 7}, {11, 11, 11, 11, 11, 11}, {16, 17, 16, 17, 16, 17}};
        byte[][] tileMap = new byte[day.length][size * 4 + 4];
        int index = 0;
        for (int i = 0; i < tileMap.length; ++i) {
            int j;
            index = 0;
            for (j = 0; j < size; ++j) {
                tileMap[i][index] = day[i][j % day[0].length];
                ++index;
            }
            if (i == 0) {
                tileMap[i][index] = 0;
                ++index;
            } else if (i == 1 || i == 2) {
                tileMap[i][index] = 5;
                ++index;
            } else if (i == 3) {
                tileMap[i][index] = 15;
                ++index;
            }
            for (j = 0; j < size; ++j) {
                tileMap[i][index] = tunnelDayToNight[i][j % tunnelDayToNight[0].length];
                ++index;
            }
            if (i == 0) {
                tileMap[i][index] = 3;
                ++index;
            } else if (i == 1 || i == 2) {
                tileMap[i][index] = 8;
                ++index;
            } else if (i == 3) {
                tileMap[i][index] = 18;
                ++index;
            }
            for (j = 0; j < size; ++j) {
                tileMap[i][index] = night[i][j % night[0].length];
                ++index;
            }
            if (i == 0) {
                tileMap[i][index] = 0;
                ++index;
            } else if (i == 1 || i == 2) {
                tileMap[i][index] = 5;
                ++index;
            } else if (i == 3) {
                tileMap[i][index] = 10;
                ++index;
            }
            for (j = 0; j < size; ++j) {
                tileMap[i][index] = tunnelNightToDay[i][j % tunnelNightToDay[0].length];
                ++index;
            }
            if (i == 0) {
                tileMap[i][index] = 3;
                ++index;
                continue;
            }
            if (i == 1 || i == 2) {
                tileMap[i][index] = 8;
                ++index;
                continue;
            }
            if (i != 3) continue;
            tileMap[i][index] = 13;
            ++index;
        }
        return tileMap;
    }

    public void reInit() {
        int i;
        GameCanvas.resetKeys();
        this.countVehiclesForAmbulance = 0;
        this.totalVehiCrossed = this.prevTotalVehiCrossed;
        this.strScore = BLANK_STRING;
        this.strScore = this.strScore + score;
        this.currentGlidScores = 0;
        this.strCurrGlidScores = BLANK_STRING;
        this.strLandingType = BLANK_STRING;
        this.strActorLife = CROSS_STRING;
        this.strActorLife = this.strActorLife + this.actorLife;
        this.isAchiveTargetBlink = false;
        int tempX = this.currentViewX;
        tempX -= this.differanceBetweenCar;
        this.mileStoneVehicles.setX(tempX -= this.mileStoneVehicles.getWidth());
        tempX -= this.differanceBetweenCar;
        this.mileStoneVehicles.setY(172 - this.mileStoneVehicles.getHeight() - 9);
        this.mileStoneVehicles.setWorld(this);
        this.mileStoneVehicles.speedUpFP = Vehicles.FP_PLUS_0_02;
        for (i = 1; i < 8; ++i) {
            this.vehicals[i].setX(tempX -= this.vehicals[i].getWidth());
            tempX -= this.differanceBetweenCar;
            this.vehicals[i].setY(172 - this.vehicals[i].getHeight() - 9);
            this.vehicals[i].setWorld(this);
            this.vehicals[i].speedUpFP = i % 2 == 0 ? Vehicles.FP_PLUS_0_02 : Vehicles.FP_MINUS_0_02;
            this.vehicals[i].isInUse = false;
            this.vehicals[i].isCrossHero = false;
        }
        if (this.vehiclePool != null) {
            this.vehiclePool.free();
            this.vehiclePool = null;
        }
        this.vehiclePool = new ActorPool(this.vehicals);
        this.hero.setX(this.mileStoneVehicles.getX() + 3);
        this.hero.setY(this.mileStoneVehicles.getY() - this.hero.getHeight());
        this.hero.setOwner(this.mileStoneVehicles);
        this.hero.setWorld(this);
        Hero.isHeroOnVehicale = false;
        Hero.isHeroOnRoad = false;
        this.getVehiclesFromPool();
        for (i = 0; i < 4; ++i) {
            this.setNewVehiclesOnUsedList(this.getVehiclesFromPool());
        }
        this.maxGlideHeight = this.bgEnvirnmentIndex == 2 ? 30 : 10;
        this.powerArray[0].setWorld(this);
        this.powerArray[0].setX(440);
        this.powerArray[0].setY(this.maxGlideHeight);
        this.powerArray[0].isInUse = true;
        this.powerArray[1].setWorld(this);
        this.powerArray[1].setX(440);
        this.powerArray[1].setY(this.maxGlideHeight);
        this.powerArray[1].isInUse = true;
        this.isResetTransition = false;
    }

    public void cycle(long deltaMS) {
        if (gameState == STARTING_UP) {
            Vehicles a2;
            this.gameMsg = this.locale.getMessage(34);
            for (a2 = (Vehicles)this.vehiclePool.getFirstUsed(); a2 != null; a2 = (Vehicles)a2.getNextLinked()) {
                if (!this.hero.isCollidingWidhtRoof(a2) || Hero.isHeroOnVehicale) continue;
                if (!Hero.isHeroOnVehicale) {
                    this.hero.setSpeedFP(Constants.SPEED_ACTOR_WALK_PIXEL_PER_MS_FP);
                    this.hero.setOwner(a2);
                }
                Hero.isHeroOnVehicale = true;
            }
            for (a2 = (Vehicles)this.vehiclePool.getFirstUsed(); a2 != null; a2 = (Vehicles)a2.getNextLinked()) {
                a2.cycle((int)deltaMS);
            }
            this.hero.cycle(deltaMS);
            this.tiledLayer.setView(this.currentViewX, this.currentViewY);
            this.timeSinceStateChange = System.currentTimeMillis() - this.timeStateChanged;
            if (this.timeSinceStateChange > 1000L) {
                this.setState(PLAYING);
                this.gameMsg = this.locale.getMessage(53);
            }
        } else if (gameState == PLAYING) {
            if (this.bgEnvirnmentIndex != 2) {
                this.cycleMovingBuilding(deltaMS);
            }
            this.timeSinceStateChange = System.currentTimeMillis() - this.timeStateChanged;
            if (this.timeSinceStateChange > 1000L) {
                this.gameMsg = BLANK_STRING;
            }
            if (this.bgEnvirnmentIndex != 2) {
                this.cycleMovingBuilding(deltaMS);
            }
            this.rskKey = this.locale.getMessage(29);
            int count = 0;
            for (Vehicles v = (Vehicles)this.vehiclePool.getFirstUsed(); v != null; v = (Vehicles)v.getNextLinked()) {
                v.seqNo = count++;
                if (this.hero.state != 5 && this.hero.isCollidingWidhtRoof(v) && !Hero.isHeroOnVehicale) {
                    this.hero.setSpeedFP(Constants.SPEED_ACTOR_WALK_PIXEL_PER_MS_FP);
                    this.hero.setOwner(v);
                    if (this.hero.getX() < v.getX() + v.collisionX) {
                        this.hero.setX(v.getX() + v.collisionX);
                    }
                    Hero.isHeroOnVehicale = true;
                    if (this.hero.preState == 6) {
                        this.strLandingType = this.locale.getMessage(55);
                        score += 2 * v.getBonusPoints();
                        this.currentGlidScores += v.getBonusPoints();
                        this.strCurrGlidScores = PLUSH_STRING;
                        this.strCurrGlidScores = this.strCurrGlidScores + this.currentGlidScores;
                        this.strCurrGlidScores = this.strCurrGlidScores + MULTIPLICATION_STRING;
                    } else {
                        this.strLandingType = this.locale.getMessage(56);
                        score += v.getBonusPoints();
                        this.currentGlidScores += v.getBonusPoints();
                        this.strCurrGlidScores = PLUSH_STRING;
                        this.strCurrGlidScores = this.strCurrGlidScores + this.currentGlidScores;
                    }
                    this.landingMsgY = 0;
                    this.strScore = BLANK_STRING;
                    this.strScore = this.strScore + score;
                    this.hero.setState(4);
                    this.resetPanPixel();
                }
                if (v.isCrossHero || v.getX() <= this.hero.getX() + 10) continue;
                v.isCrossHero = true;
                this.strScore = BLANK_STRING;
                this.strScore = this.strScore + (score += 10);
                ++this.countVehiclesForAmbulance;
                if (v.getActorID() == 0) {
                    this.countVehiclesForAmbulance = 0;
                }
                ++this.countVehiForDifficulty;
                if (this.countVehiForDifficulty >= 50) {
                    this.countVehiForDifficulty = 0;
                    this.differanceBetweenCar += 20;
                    if (this.differanceBetweenCar > 200) {
                        this.differanceBetweenCar = 200;
                    }
                }
                ++this.totalVehiCrossed;
                if (this.totalVehiCrossed < this.nextCarBonusTarget) continue;
                this.prevTotalVehiCrossed = this.totalVehiCrossed;
                score += this.carCrossedBonusPoints;
                this.strCarCrossedBonusMsg = BLANK_STRING;
                this.strCarCrossedBonusMsg = this.strCarCrossedBonusMsg + PLUSH_STRING;
                this.strCarCrossedBonusMsg = this.strCarCrossedBonusMsg + this.carCrossedBonusPoints;
                this.strTargetCarCrossedMsg = BLANK_STRING;
                this.strTargetCarCrossedMsg = this.strTargetCarCrossedMsg + this.totalVehiCrossed;
                this.strTargetCarCrossedMsg = this.strTargetCarCrossedMsg + SPACE_STRING;
                this.strTargetCarCrossedMsg = this.strTargetCarCrossedMsg + this.carBonusMsg;
                this.nextCarBonusTarget += this.incrementFactor;
                this.incrementFactor += 10;
                this.carCrossedBonusPoints *= 2;
                this.timeToStartBlink = System.currentTimeMillis();
                this.fluffBlink = 0L;
                this.isAchiveTargetBlink = true;
            }
            for (Actor vehi = (Vehicles)this.vehiclePool.getFirstUsed(); vehi != null; vehi = vehi.getNextLinked()) {
                ((Actor)vehi).cycle(deltaMS);
            }
            if (this.vehiclesToBeRemoved != null) {
                this.setNewVehiclesOnUsedList(this.vehiclesToBeRemoved);
                this.vehiclesToBeRemoved = null;
            }
            this.hero.cycle(deltaMS);
            this.tiledLayer.setView(this.currentViewX, this.currentViewY);
            this.tiledLayer.cycle(deltaMS);
            for (int i = 0; i < this.powerArray.length; ++i) {
                if (this.powerArray[i].isInUse) {
                    this.powerArray[i].cycle(deltaMS);
                    if (!this.powerArray[i].isCollidingWith(this.hero) || this.powerArray[i].isPowerCollide) continue;
                    this.powerArray[i].isPowerCollide = true;
                    if (this.powerArray[i].getActorID() == 9) {
                        if (this.actorLife < 5) {
                            ++this.actorLife;
                        }
                        this.strActorLife = CROSS_STRING;
                        this.strActorLife = this.strActorLife + this.actorLife;
                        this.powerArray[i].setVisible(false);
                        continue;
                    }
                    if (this.powerArray[i].getActorID() != 10) continue;
                    Tools.vibrate(300, 100);
                    if (Hero.isHeroOnVehicale) continue;
                    this.hero.setState(8);
                    continue;
                }
                this.powerArray[i].monitor(deltaMS);
            }
            this.landingMsgTicks = (deltaMS + this.landingMsgFluff) / 10L;
            this.landingMsgFluff += deltaMS - this.landingMsgTicks * 10L;
            if (this.landingMsgTicks > 0L && this.landingMsgY < 176) {
                this.landingMsgY += 2;
                if (this.landingMsgY > 44) {
                    this.landingMsgY = 176;
                }
            }
            if (this.isAchiveTargetBlink && this.timeToStartBlink < System.currentTimeMillis() - 3000L) {
                this.isAchiveTargetBlink = false;
            }
            if (this.isAchiveTargetBlink) {
                int ticks2 = (int)(deltaMS + this.fluffBlink) / 400;
                this.fluffBlink += deltaMS - (long)(ticks2 * 400);
                if (ticks2 > 0) {
                    this.isBlink = !this.isBlink;
                }
            }
            if (this.actorLife > 0) {
                this.powerSprite.cycle(deltaMS);
            }
        } else if (gameState != PAUSED) {
            if (gameState == GAME_DONE) {
                if (this.actorLife > 0) {
                    this.gameMsg = BLANK_STRING;
                    this.gameMsg = this.gameMsg + this.actorLife;
                    this.gameMsg = this.gameMsg + SPACE_STRING;
                    this.gameMsg = this.actorLife == 1 ? this.gameMsg + this.locale.getMessage(50) : this.gameMsg + this.locale.getMessage(36);
                    if (!this.isResetTransition && gameState != GAME_OVER) {
                        this.resetTransitionEffect(this.gameMsg, false);
                    }
                } else {
                    this.setState(GAME_OVER);
                    this.isResetTransition = false;
                }
                this.timeSinceStateChange = System.currentTimeMillis() - this.timeStateChanged;
                if (this.timeSinceStateChange > 200L && gameState != GAME_OVER) {
                    this.cycleTransitionEffect(deltaMS, this.offlineImage, this.clipX);
                }
                for (int i = 0; i < this.powerArray.length; ++i) {
                    if (!this.powerArray[i].isInUse) continue;
                    this.powerArray[i].cycle(deltaMS);
                }
                for (Vehicles a3 = (Vehicles)this.vehiclePool.getFirstUsed(); a3 != null; a3 = (Vehicles)a3.getNextLinked()) {
                    a3.cycle((int)deltaMS);
                }
                if (this.vehiclesToBeRemoved != null) {
                    this.setNewVehiclesOnUsedList(this.vehiclesToBeRemoved);
                    this.vehiclesToBeRemoved = null;
                }
                if (this.timeSinceStateChange > 1000L) {
                    if (this.actorLife < 1) {
                        this.setState(GAME_OVER);
                        this.isResetTransition = false;
                    } else {
                        this.restart();
                        this.isResetTransition = false;
                    }
                }
            } else if (gameState == GAME_OVER) {
                this.gameMsg = this.locale.getMessage(35);
                this.gameMsg = this.gameMsg + this.locale.getMessage(46);
                this.gameMsg = this.gameMsg + score;
                if (!this.isResetTransition) {
                    this.resetTransitionEffect(this.gameMsg, true);
                }
                this.timeSinceStateChange = System.currentTimeMillis() - this.timeStateChanged;
                if (this.timeSinceStateChange > 200L) {
                    this.cycleTransitionEffect(deltaMS, this.offlineImage, this.clipX);
                }
                for (int i = 0; i < this.powerArray.length; ++i) {
                    if (!this.powerArray[i].isInUse) continue;
                    this.powerArray[i].cycle(deltaMS);
                }
                for (Vehicles a4 = (Vehicles)this.vehiclePool.getFirstUsed(); a4 != null; a4 = (Vehicles)a4.getNextLinked()) {
                    a4.cycle((int)deltaMS);
                }
                if (this.vehiclesToBeRemoved != null) {
                    this.setNewVehiclesOnUsedList(this.vehiclesToBeRemoved);
                    this.vehiclesToBeRemoved = null;
                }
                if (this.timeSinceStateChange > 2000L) {
                    this.isResetTransition = false;
                    this.gameCanvas.gameOver();
                }
            }
        }
    }

    public void renderer(Graphics g) {
        if (gameState != NOT_STARTED) {
            if (this.bgEnvirnmentIndex != 2) {
                this.drawMovingBuilding(g, this.buildingX, this.buildingY);
            }
            if (this.tiledLayer != null) {
                this.tiledLayer.renderer(g);
            }
            for (Actor a2 = this.vehiclePool.getLastUsed(); a2 != null; a2 = a2.getPrevLinked()) {
                a2.renderer(g, this.currentViewX, this.currentViewY);
            }
            if (this.hero != null) {
                this.hero.renderer(g, this.currentViewX, this.currentViewY);
                if (Hero.isHeroOnVehicale) {
                    UIFont.drawString(g, this.strCurrGlidScores, 110 - UIFont.stringWidth(this.strCurrGlidScores, (byte)4) / 2, 88 - UIFont.getHeight(4) / 2 - UIFont.getHeight(4) - this.landingMsgY, 4);
                    UIFont.drawString(g, this.strLandingType, 110 - UIFont.stringWidth(this.strLandingType, (byte)4) / 2, 88 - UIFont.getHeight(4) / 2 - this.landingMsgY, 4);
                }
            }
            for (int i = 0; i < this.powerArray.length; ++i) {
                if (!this.powerArray[i].isInUse) continue;
                this.powerArray[i].renderer(g, this.currentViewX, this.currentViewY);
            }
            if (this.actorLife > 0) {
                this.powerSprite.draw(g, 5, 4);
                UIFont.drawString(g, this.strActorLife, 5 + this.powerSprite.getCurrentFrameWidth(), 5, 4);
            }
            UIFont.drawString(g, this.strScore, 220 - UIFont.stringWidth(this.strScore, (byte)4) - 5, 5, 4);
        }
        if (gameState == STARTING_UP) {
            UIFont.drawString(g, this.gameMsg, 110 - UIFont.stringWidth(this.gameMsg, (byte)4) / 2, 88 - UIFont.getHeight(4) / 2, 4);
        } else if (gameState == PLAYING) {
            if (!this.gameMsg.equals(BLANK_STRING)) {
                UIFont.drawString(g, this.gameMsg, 110 - UIFont.stringWidth(this.gameMsg, (byte)4) / 2, 88 - UIFont.getHeight(4) / 2, 4);
            }
            if (this.isAchiveTargetBlink && this.isBlink) {
                UIFont.drawString(g, this.strTargetCarCrossedMsg, 110 - UIFont.stringWidth(this.strTargetCarCrossedMsg, (byte)5) / 2, 30, 5);
                UIFont.drawString(g, this.strCarCrossedBonusMsg, 110 - UIFont.stringWidth(this.strCarCrossedBonusMsg, (byte)5) / 2, 45, 5);
            }
            this.paintLSK(g);
        } else if (gameState == PAUSED) {
            UIFont.drawString(g, this.rskKey, 220 - UIFont.stringWidth(this.rskKey, (byte)4) - 2, 176 - UIFont.getHeight(4) - 2, 4);
        } else if (gameState == GAME_OVER) {
            if (this.isResetTransition) {
                this.drawTransitionEffect(g, this.offlineImage);
            }
        } else if (gameState == GAME_DONE && this.isResetTransition) {
            this.drawTransitionEffect(g, this.offlineImage);
        }
    }

    public void processKeys() {
        if (gameState == PLAYING) {
            if (GameCanvas.keyWasPressed(1) || GameCanvas.keyWasPressed(2) || GameCanvas.keyWasPressed(8) || GameCanvas.keyWasPressed(4)) {
                GameCanvas.resetKey(1);
                GameCanvas.resetKey(2);
                GameCanvas.resetKey(8);
                GameCanvas.resetKey(4);
                return;
            }
            if (GameCanvas.keyWasPressed(128) || GameCanvas.keyWasPressed(8192) || GameCanvas.keyWasPressed(512) || GameCanvas.keyWasPressed(2048) || GameCanvas.keyWasPressed(64) || GameCanvas.keyWasPressed(512) || GameCanvas.keyWasPressed(2048) || GameCanvas.keyWasPressed(256) || GameCanvas.keyWasPressed(512) || GameCanvas.keyWasPressed(2048) || GameCanvas.keyWasPressed(32)) {
                GameCanvas.resetKey(64);
                GameCanvas.resetKey(256);
                GameCanvas.resetKey(32);
                GameCanvas.resetKey(128);
                GameCanvas.resetKey(8192);
                GameCanvas.resetKey(512);
                GameCanvas.resetKey(2048);
                return;
            }
            if (GameCanvas.keyWasPressed(524288)) {
                this.gameCanvas.pauseGame();
                GameCanvas.resetKey(524288);
            }
            this.hero.processKeys();
            if (GameCanvas.gameMode == 1) {
                if (GameCanvas.keyWasPressed(131072)) {
                    this.gameCanvas.pauseGame();
                    this.setState(PAUSED);
                    GameCanvas.resetKey(131072);
                }
            } else if (GameCanvas.keyWasPressed(262144)) {
                this.gameCanvas.pauseGame();
                this.setState(PAUSED);
                GameCanvas.resetKey(262144);
            }
        }
    }

    public void paintLSK(Graphics g) {
        g.drawImage(this.imgPause, 220 - this.imgPause.getWidth() - 2, 176 - this.imgPause.getHeight() - 2, 0);
    }

    public void paintRSK(Graphics g) {
        g.drawImage(this.imgPause, 220 - this.imgPause.getWidth() - 2, 2, 0);
    }

    public void resetPanPixel() {
        for (Actor vehicle = (Vehicles)this.vehiclePool.getFirstUsed(); vehicle != null; vehicle = vehicle.getNextLinked()) {
            vehicle.panPixelsToMoveFP = 0;
        }
        this.hero.panPixelsToMoveFP = 0;
    }

    public void changeBgMode(int bgIndex) {
        this.bgEnvirnmentIndex = bgIndex;
        this.maxGlideHeight = this.bgEnvirnmentIndex == 2 ? 30 : 10;
    }

    public void setCurrentViewXY(int viewX, int viewY) {
        this.currentViewX = viewX;
        this.currentViewY = viewY;
    }

    public void setState(int state) {
        gameState = state;
        this.timeStateChanged = System.currentTimeMillis();
        GameCanvas.resetKeys();
    }

    public int getState() {
        return gameState;
    }

    public void pause() {
        if (gameState == PAUSED) {
            return;
        }
        this.statePriorToPause = gameState;
        this.setState(PAUSED);
        if (GameCanvas.isSound) {
            this.gameCanvas.soundUtils.stopSound((byte)2);
        }
        this.timeGamePause = System.currentTimeMillis();
    }

    public void resume() {
        if (gameState != PAUSED) {
            return;
        }
        this.setState(this.statePriorToPause);
        if (GameCanvas.isSound && gameState != LEVEL_FULL_IMAGE) {
            this.gameCanvas.soundUtils.playSound((byte)2, -1);
        }
        this.powerArray[0].timeElaps += System.currentTimeMillis() - this.timeGamePause;
        this.powerArray[1].timeElaps += System.currentTimeMillis() - this.timeGamePause;
        this.timeSinceGamePause = System.currentTimeMillis() - this.timeGamePause;
    }

    public void setNewVehiclesOnUsedList(Vehicles aThis) {
        this.releaseVehicle(aThis);
        this.totalFree = this.vehiclePool.getTotalFree();
        try {
            Vehicles v = (Vehicles)this.vehiclePool.getLastUsed();
            int xpos = v.getX();
            int rand = 0;
            if (this.countVehiclesForAmbulance < 25) {
                rand = Math.abs(this.random.nextInt()) % this.totalFree;
                v = this.getVehiclesFromPoolAt(rand);
                while (v.getActorID() == 0) {
                    this.releaseVehicle(v);
                    v = this.getVehiclesFromPool();
                }
            } else {
                rand = 0;
                for (Actor a2 = (Vehicles)this.vehiclePool.getFirstFree(); a2 != null; a2 = a2.getNextLinked()) {
                    ++rand;
                    if (a2.getActorID() == 0) break;
                }
                v = this.getVehiclesFromPoolAt(rand);
                this.countVehiclesForAmbulance = 0;
            }
            v.setX(xpos - v.getWidth() - this.differanceBetweenCar);
            v.speedFP = Constants.SPEED_VEHICLE_PIXEL_PER_MS_FP;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final Vehicles getVehiclesFromPool() {
        Vehicles v = (Vehicles)this.vehiclePool.getNextFree();
        v.isInUse = true;
        v.isCrossHero = false;
        return v;
    }

    public final Vehicles getVehiclesFromPoolAt(int index) {
        Vehicles v = (Vehicles)this.vehiclePool.getFreeAt(index);
        v.isInUse = true;
        v.isCrossHero = false;
        return v;
    }

    public final void releaseVehicle(Vehicles v) {
        v.deactivate();
        v.isInUse = false;
        this.vehiclePool.release(v);
    }

    public void free() {
        this.tiledLayer.free();
        this.hero.free();
        this.vehiclePool.free();
        this.tiledLayer = null;
        this.hero = null;
        this.vehiclePool = null;
        for (int i = 0; i < this.vehicals.length; ++i) {
            this.vehicals[i].free();
            this.vehicals[i] = null;
        }
        this.vehicals = null;
        this.cloud[0] = null;
        this.cloud[1] = null;
        this.cloud = null;
        this.cloudCoord1 = null;
        this.cloudCoord2 = null;
    }

    public void destroy() {
        this.free();
    }

    public void enable() {
    }

    public void disable() {
    }

    public void cycleMovingBuilding(long deltaMS) {
        --this.buildingX;
        if (this.buildingX < -220) {
            this.buildingX = 0;
        }
        this.clipX = 0;
        this.clipY = 0;
        this.clipW = Math.abs(this.buildingX);
        this.clipH = this.imgBuilding[this.bgEnvirnmentIndex].getHeight();
        this.cloudTicks = (deltaMS + this.cloudFluff) / 300L;
        this.cloudFluff += deltaMS - this.cloudTicks * 300L;
        if (this.cloudTicks > 0L) {
            if (this.cloudCoord1[0] < -this.cloud[this.bgEnvirnmentIndex][0].getWidth()) {
                this.cloudCoord1[0] = 220;
            }
            this.cloudCoord1[0] = (int)((long)this.cloudCoord1[0] - (long)this.cloudSpeed * this.cloudTicks);
            if (this.cloudCoord2[0] < -this.cloud[this.bgEnvirnmentIndex][1].getWidth()) {
                this.cloudCoord2[0] = 220;
            }
            this.cloudCoord2[0] = (int)((long)this.cloudCoord2[0] - (long)this.cloudSpeed * this.cloudTicks);
        }
    }

    public void drawMovingBuilding(Graphics g, int targetX, int targetY) {
        this.oldX = g.getClipX();
        this.oldY = g.getClipY();
        this.oldWidth = g.getClipWidth();
        this.oldHeight = g.getClipHeight();
        g.drawImage(this.imgBuilding[this.bgEnvirnmentIndex], targetX, targetY, 0);
        g.setClip(220 - Math.abs(targetX), targetY, this.clipW, this.clipH);
        g.drawImage(this.imgBuilding[this.bgEnvirnmentIndex], 220 - Math.abs(targetX), targetY, 0);
        g.setClip(this.oldX, this.oldY, this.oldWidth, this.oldHeight);
        g.drawImage(this.cloud[this.bgEnvirnmentIndex][0], this.cloudCoord1[0], this.cloudCoord1[1], 0);
        g.drawImage(this.cloud[this.bgEnvirnmentIndex][1], this.cloudCoord2[0], this.cloudCoord2[1], 0);
    }

    public void resetTransitionEffect(String newText, boolean isUseTextArea) {
        if (!this.isResetTransition) {
            this.transitionSpeed = 3;
            this.srcX = 0;
            this.srcWidth = this.offlineImage.getWidth();
            this.srcY = this.offlineImage.getHeight() / 2;
            this.srcHeight = 0;
            if (UIFont.stringWidth(newText, (byte)4) > this.offlineImage.getWidth() || isUseTextArea) {
                Vector vect = StringUtils.initRowString(newText, (byte)4, this.offlineImage.getWidth());
                Object[] wrappedText = new String[vect.size()];
                vect.copyInto(wrappedText);
                int y = (this.offlineImage.getHeight() - UIFont.getHeight(4) * wrappedText.length) / 2;
                this.offlineGraphics.setColor(2839166);
                this.offlineGraphics.fillRect(0, 0, 220, 176);
                for (int i = 0; i < wrappedText.length; ++i) {
                    UIFont.drawString(this.offlineGraphics, (String)wrappedText[i], (this.offlineImage.getWidth() - UIFont.stringWidth((String)wrappedText[i], (byte)4)) / 2, y, 4);
                    y += UIFont.getHeight(4);
                }
            } else {
                this.offlineGraphics.setColor(2839166);
                this.offlineGraphics.fillRect(0, 0, 220, 176);
                this.offlineGraphics.setColor(0xFF0000);
                this.offlineGraphics.fillRect(0, 0, this.offlineImage.getWidth(), 3);
                this.offlineGraphics.fillRect(0, this.offlineImage.getHeight() - 3, this.offlineImage.getWidth(), 3);
                UIFont.drawString(this.offlineGraphics, newText, (this.offlineImage.getWidth() - UIFont.stringWidth(newText, (byte)4)) / 2, (this.offlineImage.getHeight() - UIFont.getHeight(4)) / 2, 4);
            }
            this.isResetTransition = true;
        }
    }

    public void cycleTransitionEffect(long deltaMS, Image imgTransition, int animType) {
        if (this.srcX >= 0 && this.srcY >= 0 && this.srcX + this.srcWidth <= imgTransition.getWidth() && this.srcY + this.srcHeight <= imgTransition.getHeight()) {
            this.srcX = 0;
            this.srcWidth = imgTransition.getWidth();
            if (this.transitionSpeed < imgTransition.getHeight() / 2) {
                this.srcY -= this.transitionSpeed;
                this.srcHeight += 2 * this.transitionSpeed;
            }
            this.targetX = 110 - this.offlineImage.getWidth() / 2;
            this.targetY = 88 - this.srcHeight / 2;
        }
    }

    public void drawTransitionEffect(Graphics g, Image imgTransition) {
        this.oldX = g.getClipX();
        this.oldY = g.getClipY();
        this.oldWidth = g.getClipWidth();
        this.oldHeight = g.getClipHeight();
        g.setClip(this.targetX, this.targetY, this.srcWidth, this.srcHeight);
        g.drawImage(imgTransition, this.targetX - this.srcX, this.targetY - this.srcY, 0);
        g.setColor(0xFF0000);
        g.fillRect(this.targetX, this.targetY, this.srcWidth, 3);
        g.fillRect(this.targetX, this.targetY + this.srcHeight - 3, this.srcWidth, 3);
        g.setClip(this.oldX, this.oldY, this.oldWidth, this.oldHeight);
    }
}

