/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.locale;

import com.manthanstudio.locale.IndexedResourceBundle;
import java.io.IOException;
import java.io.InputStream;

public class Locale {
    private static final String L10N_ROOT_DIR = "/locale/l10n/";
    private static final String BASE_NAME_UI_RESOURCES = "UIResources";
    private static Locale locale;
    private String language = "en_US";
    private IndexedResourceBundle messageResourceBundle;

    public static Locale getInstance() {
        if (locale == null) {
            locale = new Locale();
        }
        return locale;
    }

    public void init() {
        try {
            this.messageResourceBundle = this.getResourceBundle(BASE_NAME_UI_RESOURCES);
        }
        catch (Exception e) {
            System.out.println("Exception while loading UIResources");
        }
    }

    public IndexedResourceBundle getResourceBundle(String baseName) throws Exception {
        IndexedResourceBundle resourceBundle = null;
        try {
            InputStream stream = this.getClass().getResourceAsStream(this.makeResourceBundleName(baseName, this.language));
            IndexedResourceBundle indexedResourceBundle = resourceBundle = stream != null ? IndexedResourceBundle.getBundleFromPropertyFile(this.language, stream, baseName) : null;
            if (resourceBundle != null) {
                return resourceBundle;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            resourceBundle = null;
        }
        return resourceBundle;
    }

    public String getMessage(int code) {
        return this.messageResourceBundle.getString(code);
    }

    private String makeResourceBundleName(String baseName, String locale) {
        return L10N_ROOT_DIR + baseName + "_" + locale + ".properties";
    }
}

