/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.main;

import com.twistfuture.app.App;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Recipe {
    private Image image;
    public Sprite sprite;
    private int x;
    private int y;
    private int id;
    private boolean collide;
    static final int LEFT_COLLISION = 0;
    static final int RIGHT_COLLISION = 1;
    private int collideSide;
    private int counter = 0;
    private boolean state = true;

    public Recipe(Image image, int x, int y, int id) {
        this.image = image;
        this.x = x;
        this.y = y;
        this.id = id;
        this.sprite = new Sprite(image, image.getWidth(), image.getHeight());
        this.sprite.setPosition(this.getX(), this.getY());
    }

    public void paint(Graphics g) {
        this.sprite.paint(g);
        this.sprite.setPosition(this.getX(), this.getY());
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getX() {
        return this.x;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.sprite.setImage(image, image.getWidth(), image.getHeight());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getY() {
        return this.y;
    }

    public void setCollide(boolean collide, int collideSide) {
        this.collide = collide;
        this.collideSide = collideSide;
    }

    public boolean getCollide() {
        return this.collide;
    }

    public int getCollisionSide() {
        return this.collideSide;
    }

    public void startAnimation(int side) {
        switch (side) {
            case 0: {
                if (this.state && this.counter++ >= 4) {
                    this.counter = 3;
                    this.sprite.setTransform(1);
                    this.sprite.setPosition(this.sprite.getX(), this.sprite.getY() + this.sprite.getHeight());
                    this.state = false;
                }
                if (this.state || this.counter-- > 0) break;
                this.counter = 1;
                this.sprite.setTransform(0);
                this.sprite.setPosition(this.sprite.getX(), this.sprite.getY() - this.sprite.getHeight());
                this.state = true;
                break;
            }
            case 1: {
                if (this.state && this.counter-- <= 0) {
                    this.counter = 1;
                    this.sprite.setTransform(1);
                    this.sprite.setPosition(this.sprite.getX(), this.sprite.getY() + this.sprite.getHeight());
                    this.state = false;
                }
                if (this.state || this.counter++ < 4) break;
                this.counter = 3;
                this.sprite.setTransform(0);
                this.sprite.setPosition(this.sprite.getX(), this.sprite.getY() - this.sprite.getHeight());
                this.state = true;
            }
        }
        this.setImage(App.createImage("anim/" + App.recipeName[this.getId()] + "/" + this.getCounter() + ".png"));
    }

    public int getCounter() {
        return this.counter;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }
}

