/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.Apps.TwistMidlet;
import com.twistfuture.Game.Level;
import com.twistfuture.Game.MainCanvas;
import com.twistfuture.Game.SaveRecord;
import com.twistfuture.app.GeneralFunction;
import com.twistfuture.general.MainMenu;
import com.twistfuture.utility.Button;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LevelCanvas
extends Canvas
implements Button.ButtonCallback,
TwistMidlet.Callback {
    private final int[] TOTEM_PRICE = new int[]{200, 1500, 3500};
    private final String[] CHARACTER_NAME = new String[]{"baba", "guddu", "chunnu"};
    private final Image bg;
    private final Image board;
    public static int currentLevel;
    private final int boardX;
    private final int boardY;
    private final Button play;
    private final Button home;
    private final Button left;
    private final Button right;
    private Image logo;
    private Image moneyImage;
    private int totalmoney;
    Level level;
    private Button buy;
    private Font font;
    private Image name;

    public LevelCanvas() {
        this.setFullScreenMode(true);
        this.bg = GeneralFunction.createImage("general/bg.png");
        this.logo = GeneralFunction.createImage("general/logo.png");
        this.board = GeneralFunction.createImage("level/moneyboard.png");
        this.name = GeneralFunction.createImage("level/" + this.CHARACTER_NAME[currentLevel] + ".png");
        this.boardX = (this.getWidth() - this.board.getWidth()) / 2;
        this.boardY = (this.getHeight() - this.board.getHeight()) / 2 + 60;
        this.level = new Level(currentLevel, this.boardX + 7, this.boardY);
        this.play = new Button(GeneralFunction.createImage("level/play.png"), 10, this.getHeight() - 60, 0, this);
        this.home = new Button(GeneralFunction.createImage("level/home.png"), 200, this.getHeight() - 60, 1, this);
        this.right = new Button(GeneralFunction.createImage("level/right.png"), 200, 120, 3, this);
        this.left = new Button(GeneralFunction.createImage("level/left.png"), 10, 120, 2, this);
        this.buy = new Button(this.board, this.boardX, this.boardY, 4, this);
        this.totalmoney = SaveRecord.getRecord(1);
        this.moneyImage = GeneralFunction.createImage("level/money.png");
        this.font = Font.getFont((int)32, (int)1, (int)8);
    }

    protected void showNotify() {
        TwistMidlet.mMidlet.registerForDown(this);
        TwistMidlet.mMidlet.registerForUP(this);
    }

    protected void paint(Graphics g) {
        g.drawImage(this.bg, 0, 0, 0);
        g.drawImage(this.name, (this.getWidth() - this.name.getWidth()) / 2, 95, 0);
        g.drawImage(this.logo, (this.getWidth() - this.logo.getWidth()) / 2, 10, 0);
        this.buy.paint(g);
        this.level.paint(g);
        this.play.paint(g);
        this.home.paint(g);
        this.left.paint(g);
        this.right.paint(g);
        g.setColor(0xFFFFFF);
        g.setFont(this.font);
        String str = "" + this.TOTEM_PRICE[currentLevel];
        if (this.level.isLockStatus()) {
            g.drawString(str, (240 - this.font.stringWidth(str)) / 2 - 20, this.boardY + 13, 0);
            g.drawImage(this.moneyImage, 115, this.boardY + 10, 0);
        } else {
            String str1 = "You have " + this.totalmoney;
            g.drawString(str1, (240 - this.font.stringWidth(str1)) / 2 - 10, this.boardY + 13, 0);
            g.drawImage(this.moneyImage, (240 + this.font.stringWidth(str1)) / 2, this.boardY + 10, 0);
        }
        TwistMidlet.mMidlet.paintAd(g);
    }

    protected void pointerPressed(int x, int y) {
        this.home.pointerPressed(x, y);
        this.play.pointerPressed(x, y);
        this.left.pointerPressed(x, y);
        this.right.pointerPressed(x, y);
        if (this.level.isLockStatus()) {
            this.buy.pointerPressed(x, y);
        }
        TwistMidlet.mMidlet.adClicked(x, y);
    }

    public void callRepaint(int xcordi, int ycordi, int width, int height) {
        this.repaint();
    }

    public void buttonClicked(int buttonId) {
        switch (buttonId) {
            case 0: {
                if (this.level.isLockStatus()) break;
                TwistMidlet.mDisplay.setCurrent((Displayable)new MainCanvas(currentLevel));
                break;
            }
            case 1: {
                TwistMidlet.mDisplay.setCurrent((Displayable)new MainMenu());
                break;
            }
            case 2: {
                if (currentLevel <= 0) break;
                this.name = GeneralFunction.createImage("level/" + this.CHARACTER_NAME[--currentLevel] + ".png");
                this.level = new Level(currentLevel, this.boardX + 7, this.boardY);
                this.repaint();
                break;
            }
            case 3: {
                if (currentLevel >= 2) break;
                this.name = GeneralFunction.createImage("level/" + this.CHARACTER_NAME[++currentLevel] + ".png");
                this.level = new Level(currentLevel, this.boardX + 7, this.boardY);
                this.repaint();
                break;
            }
            case 4: {
                int price = this.getprice();
                if (this.totalmoney <= price) break;
                this.totalmoney -= price;
                SaveRecord.setRecord(this.totalmoney);
                this.level.setLockStatus(false);
            }
        }
    }

    private int getprice() {
        return this.TOTEM_PRICE[currentLevel];
    }
}

