/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.Apps.TwistMidlet;
import com.twistfuture.Game.GameManager;
import com.twistfuture.Game.LevelCanvas;
import com.twistfuture.Game.MainCanvas;
import com.twistfuture.Game.SaveRecord;
import com.twistfuture.app.GeneralFunction;
import com.twistfuture.utility.Button;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScoreCanvas
extends Canvas
implements Button.ButtonCallback,
TwistMidlet.Callback {
    private final Image bg;
    private final Image gameOver;
    private final Image scoreboard;
    private final Button replay;
    private final Button home;
    private final int bestScore;
    Font f = Font.getFont((int)32, (int)1, (int)8);

    public ScoreCanvas() {
        this.setFullScreenMode(true);
        this.bg = GeneralFunction.createImage("general/bg.png");
        this.scoreboard = GeneralFunction.createImage("scorecanvas/scoreboard.png");
        this.gameOver = GeneralFunction.createImage("scorecanvas/gameover.png");
        this.replay = new Button(GeneralFunction.createImage("scorecanvas/replay.png"), 71, 250, 0, this);
        this.home = new Button(GeneralFunction.createImage("scorecanvas/home.png"), 71, 300, 1, this);
        SaveRecord.setRecord(GameManager.SCORE);
        this.bestScore = SaveRecord.getRecord(2);
    }

    protected void showNotify() {
        TwistMidlet.mMidlet.registerForDown(this);
        TwistMidlet.mMidlet.registerForUP(this);
    }

    protected void paint(Graphics g) {
        g.drawImage(this.bg, 0, 0, 0);
        g.drawImage(this.gameOver, (this.getWidth() - this.gameOver.getWidth()) / 2, 50, 0);
        g.drawImage(this.scoreboard, (this.getWidth() - this.scoreboard.getWidth()) / 2, 120, 0);
        g.setColor(0xFFFFFF);
        g.setFont(this.f);
        g.drawString("" + GameManager.SCORE, 60, 175, 0);
        g.drawString("" + this.bestScore, 160, 175, 0);
        this.home.paint(g);
        this.replay.paint(g);
        TwistMidlet.mMidlet.paintAd(g);
    }

    protected void pointerPressed(int x, int y) {
        this.home.pointerPressed(x, y);
        this.replay.pointerPressed(x, y);
        TwistMidlet.mMidlet.adClicked(x, y);
    }

    public void buttonClicked(int buttonId) {
        switch (buttonId) {
            case 0: {
                TwistMidlet.mDisplay.setCurrent((Displayable)new MainCanvas(LevelCanvas.currentLevel));
                break;
            }
            case 1: {
                TwistMidlet.mMidlet.startMainMenu();
            }
        }
    }

    public void callRepaint(int xcordi, int ycordi, int width, int height) {
        this.repaint();
    }
}

