/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Joint
implements Constraint {
    private Body a;
    private Body b;
    private FXVector a;
    private FXVector b;
    private boolean a;
    private int a;
    private FXMatrix a;
    private FXVector c;
    private FXVector d;
    private FXVector e;
    private int b = 0;
    private long a;
    private FXVector f;
    private static FXVector g = new FXVector();
    private static FXVector h = new FXVector();
    private UserData a = null;

    public Joint(Body body, Body body2, FXVector fXVector, FXVector fXVector2, boolean bl) {
        this.c = new FXVector();
        this.d = new FXVector();
        this.e = new FXVector();
        this.f = new FXVector();
        this.a = body;
        this.b = body2;
        this.a = fXVector;
        this.b = fXVector2;
        this.a = bl;
        if (this.a != null && this.b != null) {
            this.a = FXUtil.wrapAngleFX(this.a.a - this.b.a);
        }
    }

    private Joint(Joint joint, Body[] bodyArray) {
        this.c = new FXVector();
        this.d = new FXVector();
        this.e = new FXVector();
        this.f = new FXVector();
        if (bodyArray == null) {
            this.a = joint.a;
            this.b = joint.b;
        } else {
            this.a = bodyArray[joint.a.i];
            this.b = bodyArray[joint.b.i];
        }
        this.a = new FXVector(joint.a);
        this.b = new FXVector(joint.b);
        this.a = joint.a;
        this.a = joint.a;
        if (joint.a != null) {
            this.a = joint.a.copy();
        }
    }

    public Constraint copy(Body[] bodyArray) {
        return new Joint(this, bodyArray);
    }

    private Joint() {
        this.c = new FXVector();
        this.d = new FXVector();
        this.e = new FXVector();
        this.f = new FXVector();
    }

    public static Joint loadJoint(PhysicsFileReader object, Vector vector, UserData userData) {
        Joint joint = new Joint();
        new Joint().a = (Body)vector.elementAt(((PhysicsFileReader)object).next());
        joint.a = ((PhysicsFileReader)object).nextVector();
        joint.b = (Body)vector.elementAt(((PhysicsFileReader)object).next());
        joint.b = ((PhysicsFileReader)object).nextVector();
        joint.a = ((PhysicsFileReader)object).next() > 0;
        joint.a = FXUtil.wrapAngleFX(joint.a.a - joint.b.a);
        if (((PhysicsFileReader)object).getVersion() > 1792) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                joint.a = userData.createNewUserData((String)object, 4);
            }
        }
        return joint;
    }

    public void setCollisionLayer(int n2) {
        this.a.addCollisionLayer(n2);
        this.b.addCollisionLayer(n2);
    }

    public FXVector getPoint1() {
        return this.a.getAbsoluePoint(this.a);
    }

    public FXVector getPoint2() {
        return this.b.getAbsoluePoint(this.b);
    }

    public FXVector getRawPoint1() {
        return this.a;
    }

    public FXVector getRawPoint2() {
        return this.b;
    }

    public void setBody1(Body body) {
        this.a = body;
    }

    public Body getBody1() {
        return this.a;
    }

    public Body getBody2() {
        return this.b;
    }

    public boolean isFixed() {
        return this.a;
    }

    public void precalculate(long l2) {
        int n2 = (int)this.a.getInvMass2FX();
        int n3 = (int)this.b.getInvMass2FX();
        long l3 = this.a.getInvInertia2FX();
        long l4 = this.b.getInvInertia2FX();
        n2 = n2 + n3 >> 9;
        this.a.getRotationMatrix().mult(-this.a.yFX, this.a.xFX, this.c);
        this.b.getRotationMatrix().mult(this.b.yFX, -this.b.xFX, this.d);
        FXVector fXVector = this.c;
        FXVector fXVector2 = this.d;
        this.a.mCol1xFX = n2 + (int)(((long)fXVector.xFX * (long)fXVector.xFX >> 12) * l3 + ((long)fXVector2.xFX * (long)fXVector2.xFX >> 12) * l4 >> 21);
        this.a.mCol2xFX = this.a.mCol1yFX = (long)((int)(((long)fXVector.xFX * (long)fXVector.yFX >> 12) * l3 + ((long)fXVector2.xFX * (long)fXVector2.yFX >> 12) * l4 >> 21));
        this.a.mCol2yFX = n2 + (int)(((long)fXVector.yFX * (long)fXVector.yFX >> 12) * l3 + ((long)fXVector2.yFX * (long)fXVector2.yFX >> 12) * l4 >> 21);
        this.a.invert();
        this.a.getAbsoluePoint(this.a, g);
        this.b.getAbsoluePoint(this.b, h);
        this.e.assignDiff(h, g);
        this.e.multFX(l2);
        this.e.multFX(1024L);
        if (this.a) {
            this.a = l3 + l4;
            this.b = (int)(((long)FXUtil.angleDiffFX(this.a, FXUtil.wrapAngleFX(this.a.a - this.b.a)) * l2 >> 12) * 3072L >> 12);
        }
    }

    public boolean applyMomentum(long l2) {
        if (this.a && this.a != 0L) {
            int n2 = (int)(((long)(this.a.b - this.b.b) - (long)this.b << 12) / this.a);
            this.a.applyTorque(n2);
            this.b.applyTorque(-n2);
        }
        FXVector fXVector = h;
        fXVector.assignFX((int)((long)this.a.b.xFX - ((long)this.c.xFX * (long)this.a.b >> 24) - (long)this.b.b.xFX - ((long)this.d.xFX * (long)this.b.b >> 24)), (int)((long)this.a.b.yFX - ((long)this.c.yFX * (long)this.a.b >> 24) - (long)this.b.b.yFX - ((long)this.d.yFX * (long)this.b.b >> 24)));
        fXVector.subtract(this.e);
        fXVector.mult(-1);
        this.a.mult(fXVector, g);
        fXVector = g;
        this.a.applyMomentum(fXVector);
        this.a.applyTorque((int)(((long)fXVector.xFX * (long)this.c.xFX >> 12) + ((long)fXVector.yFX * (long)this.c.yFX >> 12)));
        this.b.applyTorque((int)(((long)fXVector.xFX * (long)this.d.xFX >> 12) + ((long)fXVector.yFX * (long)this.d.yFX >> 12)));
        fXVector.mult(-1);
        this.b.applyMomentum(fXVector);
        fXVector.mult(-1);
        this.f.xFX = fXVector.xFX;
        this.f.yFX = fXVector.yFX;
        return fXVector.fastLengthFX() < 16;
    }

    public void postStep() {
    }

    public int getImpulseFX() {
        return this.f.lengthFX();
    }

    public boolean concernsBody(Body body) {
        return this.a == body || this.b == body;
    }

    public boolean equals(Constraint constraint) {
        return constraint instanceof Joint && ((Joint)constraint).a.equals(this.a) && ((Joint)constraint).b.equals(this.b) && ((Joint)constraint).a.xFX == this.a.xFX && ((Joint)constraint).a.yFX == this.a.yFX && this.isFixed() == ((Joint)constraint).isFixed();
    }

    public void setFixPoint(FXVector fXVector) {
        if (this.a != null) {
            this.a = this.a.getRelativePoint(fXVector);
        }
        if (this.b != null) {
            this.b = this.b.getRelativePoint(fXVector);
        }
        if (this.a != null && this.b != null) {
            this.a = FXUtil.wrapAngleFX(this.a.rotation2FX() - this.b.rotation2FX());
        }
    }

    public UserData getUserData() {
        return this.a;
    }

    public void setUserData(UserData userData) {
        this.a = userData;
    }
}

