/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.game.objects;

import in.spicelabs.doodleCopter.common.Config;
import in.spicelabs.game.objects.AnimatableSprite;
import in.spicelabs.game.objects.AttackDirections;
import in.spicelabs.game.objects.AttackListener;
import in.spicelabs.game.objects.AttackableSprite;
import in.spicelabs.game.objects.ConsumableObstacle;
import in.spicelabs.game.objects.Controller;
import in.spicelabs.game.objects.Copter;
import in.spicelabs.game.objects.FireBall;
import in.spicelabs.game.objects.LevelGenerator;
import in.spicelabs.game.objects.Obstacles;
import in.spicelabs.game.objects.RemoveSpriteListener;
import in.spicelabs.game.objects.Sprite;
import in.spicelabs.game.objects.Tile;
import in.spicelabs.game.objects.WorldListener;
import in.spicelabs.game.objects.XYRect;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class World
extends AnimatableSprite
implements AttackListener,
AttackDirections,
RemoveSpriteListener {
    private static final int TILE_W = Controller.DIS_W / 20;
    private static final int DEFAULT_SPEED = Controller.DIS_W / 45;
    public static final int[][][] COIN_PATTERN;
    private static final int[] COLLECTABLES;
    private Random random = new Random();
    private WorldListener listener;
    private Copter copter;
    private int speed = DEFAULT_SPEED;
    private boolean shouldStop;
    protected Vector obstacles;
    private Vector sprites;
    private Vector ceiling;
    private Vector flooring;
    private int tileH = LevelGenerator.MIN_TILE_H;
    private boolean isUP;
    private boolean canAddCoins;
    private int obsTileH = LevelGenerator.INIT_FLY_AREA / 4;
    private Tile lastTileAdded;
    private int shieldCollected;
    private int obstacleSkipCount;

    static {
        int[][][] nArrayArray = new int[7][][];
        nArrayArray[0] = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1}};
        int[][] nArrayArray2 = new int[2][];
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArrayArray2[0] = nArray;
        int[] nArray2 = new int[8];
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArrayArray2[1] = nArray2;
        nArrayArray[1] = nArrayArray2;
        int[][] nArrayArray3 = new int[5][];
        nArrayArray3[0] = new int[]{1, 1, 1};
        int[] nArray3 = new int[4];
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArrayArray3[1] = nArray3;
        int[] nArray4 = new int[5];
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArrayArray3[2] = nArray4;
        int[] nArray5 = new int[4];
        nArray5[1] = 1;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArrayArray3[3] = nArray5;
        nArrayArray3[4] = new int[]{1, 1, 1};
        nArrayArray[2] = nArrayArray3;
        int[][] nArrayArray4 = new int[4][];
        int[] nArray6 = new int[6];
        nArray6[4] = 1;
        nArray6[5] = 1;
        nArrayArray4[0] = nArray6;
        nArrayArray4[1] = new int[]{1, 1, 1, 1, 1, 1};
        nArrayArray4[2] = new int[]{1, 1, 1, 1, 1, 1};
        int[] nArray7 = new int[6];
        nArray7[4] = 1;
        nArray7[5] = 1;
        nArrayArray4[3] = nArray7;
        nArrayArray[3] = nArrayArray4;
        int[][] nArrayArray5 = new int[5][];
        int[] nArray8 = new int[5];
        nArray8[4] = 1;
        nArrayArray5[0] = nArray8;
        int[] nArray9 = new int[6];
        nArray9[4] = 1;
        nArray9[5] = 1;
        nArrayArray5[1] = nArray9;
        nArrayArray5[2] = new int[]{1, 1, 1, 1, 1, 1, 1};
        int[] nArray10 = new int[6];
        nArray10[4] = 1;
        nArray10[5] = 1;
        nArrayArray5[3] = nArray10;
        int[] nArray11 = new int[5];
        nArray11[4] = 1;
        nArrayArray5[4] = nArray11;
        nArrayArray[4] = nArrayArray5;
        int[][] nArrayArray6 = new int[5][];
        int[] nArray12 = new int[5];
        nArray12[0] = 1;
        nArray12[1] = 1;
        nArray12[3] = 1;
        nArray12[4] = 1;
        nArrayArray6[0] = nArray12;
        int[] nArray13 = new int[6];
        nArray13[1] = 1;
        nArray13[2] = 1;
        nArray13[4] = 1;
        nArray13[5] = 1;
        nArrayArray6[1] = nArray13;
        int[] nArray14 = new int[7];
        nArray14[2] = 1;
        nArray14[3] = 1;
        nArray14[5] = 1;
        nArray14[6] = 1;
        nArrayArray6[2] = nArray14;
        int[] nArray15 = new int[6];
        nArray15[1] = 1;
        nArray15[2] = 1;
        nArray15[4] = 1;
        nArray15[5] = 1;
        nArrayArray6[3] = nArray15;
        int[] nArray16 = new int[5];
        nArray16[0] = 1;
        nArray16[1] = 1;
        nArray16[3] = 1;
        nArray16[4] = 1;
        nArrayArray6[4] = nArray16;
        nArrayArray[5] = nArrayArray6;
        int[][] nArrayArray7 = new int[5][];
        int[] nArray17 = new int[4];
        nArray17[1] = 1;
        nArray17[3] = 1;
        nArrayArray7[0] = nArray17;
        nArrayArray7[1] = new int[]{1, 1, 1, 1, 1};
        nArrayArray7[2] = new int[]{1, 1, 1, 1, 1};
        int[] nArray18 = new int[4];
        nArray18[1] = 1;
        nArray18[2] = 1;
        nArray18[3] = 1;
        nArrayArray7[3] = nArray18;
        int[] nArray19 = new int[3];
        nArray19[2] = 1;
        nArrayArray7[4] = nArray19;
        nArrayArray[6] = nArrayArray7;
        COIN_PATTERN = nArrayArray;
        COLLECTABLES = new int[]{3, 4};
    }

    public World(XYRect rect) {
        super(rect, null);
        this.sprites = new Vector();
        this.obstacles = new Vector();
        this.ceiling = new Vector(30);
        this.flooring = new Vector(30);
    }

    public void initEnvironment() {
        int tileSpace = Controller.DIS_H - LevelGenerator.getFlyArea();
        int m = (int)(0.08 * (double)tileSpace);
        int tl = this.random.nextInt(tileSpace - m);
        this.ceiling.addElement(new Tile(0, 0, TILE_W, tl, this));
        this.flooring.addElement(new Tile(0, Controller.DIS_H - (tileSpace - tl), TILE_W, tileSpace - tl, this));
        this.lastTileAdded = new Tile(this.copter.rect.x + LevelGenerator.getAndUpdateGap() + Controller.DIS_W, Controller.DIS_H - this.obsTileH >> 1, TILE_W, this.obsTileH, this);
        this.obstacles.addElement(this.lastTileAdded);
        this.updateboundary();
        this.canAddCoins = true;
    }

    private void addCollectables(int x, int y, int gap) {
        int toss = this.random.nextInt(COLLECTABLES.length);
        switch (COLLECTABLES[toss]) {
            case 3: {
                int ptrnIndex = this.random.nextInt(COIN_PATTERN.length);
                int h = COIN_PATTERN[ptrnIndex].length * Config.COIN[0].getHeight();
                this.insertObjects(x, y += LevelGenerator.getFlyArea() - h >> 1, COIN_PATTERN[ptrnIndex], 3);
                break;
            }
            case 4: {
                if (!LevelGenerator.canAddPower(4) || this.copter.isShielded()) break;
                LevelGenerator.stopCounter(4);
                this.obstacles.addElement(new ConsumableObstacle(x, y + this.random.nextInt(LevelGenerator.getFlyArea() - Config.SHIELD_FRAME[0].getHeight()), Config.SHIELD_FRAME, 4, true, this));
            }
        }
    }

    private void insertObjects(int x, int y, int[][] ptrn, int objType) {
        int i = 0;
        while (i < ptrn.length) {
            int j = 0;
            int x1 = x;
            while (j < ptrn[i].length) {
                if (ptrn[i][j] == 1) {
                    ConsumableObstacle cobs = new ConsumableObstacle(x1, y, Config.COIN, objType, true, this);
                    this.obstacles.addElement(cobs);
                }
                x1 += Config.COIN[0].getWidth();
                ++j;
            }
            y += Config.COIN[0].getHeight();
            ++i;
        }
    }

    private void updateboundary() {
        Sprite last = (Sprite)this.ceiling.lastElement();
        int tileSpace = Controller.DIS_H - LevelGenerator.getFlyArea();
        while (last.rect.x < Controller.DIS_W) {
            int addON = 0;
            if (this.isUP) {
                boolean bl = this.isUP = last.rect.height - this.tileH > this.tileH;
                if (!this.isUP) {
                    addON = this.random.nextInt(LevelGenerator.MAX_TILE_H / LevelGenerator.MIN_TILE_H) * LevelGenerator.MIN_TILE_H;
                    addON = this.random.nextInt(4) == 0 ? addON : 0;
                }
            } else {
                boolean bl = this.isUP = tileSpace - last.rect.height - this.tileH <= this.tileH;
                if (this.isUP) {
                    addON = this.random.nextInt(LevelGenerator.MAX_TILE_H / LevelGenerator.MIN_TILE_H) * LevelGenerator.MIN_TILE_H;
                    addON = this.random.nextInt(4) == 0 ? addON : 0;
                }
            }
            Tile ob = new Tile(last.rect.x + last.rect.width, 0, TILE_W, last.rect.height + (this.isUP ? -(this.tileH + addON) : this.tileH + addON), this);
            this.ceiling.addElement(ob);
            last = ob;
            this.flooring.addElement(new Tile(last.rect.x, Controller.DIS_H - (tileSpace - ob.rect.height), TILE_W, tileSpace - ob.rect.height, this));
            this.addObsacleTile(ob.rect.x, ob.rect.height);
        }
    }

    private void addObsacleTile(int x, int y) {
        if (this.canAddCoins && x - this.lastTileAdded.rect.x >= LevelGenerator.getGap() - COIN_PATTERN[0][0].length * Config.COIN[0].getHeight() >> 1) {
            this.addCollectables(x, y, LevelGenerator.getGap());
            this.canAddCoins = false;
        }
        if (x - this.lastTileAdded.rect.x >= LevelGenerator.getGap()) {
            LevelGenerator.getAndUpdateGap();
            int tmp = this.random.nextInt(LevelGenerator.getFlyArea() - this.obsTileH);
            if (tmp < this.obsTileH && LevelGenerator.getFlyArea() - tmp - this.obsTileH < this.obsTileH) {
                tmp = this.random.nextInt(2) == 0 ? this.obsTileH : LevelGenerator.getFlyArea() - 2 * this.obsTileH;
            }
            this.lastTileAdded = new Tile(x, y + tmp, TILE_W, this.obsTileH, this);
            this.obstacles.addElement(this.lastTileAdded);
            this.canAddCoins = true;
        }
    }

    protected void draw(Graphics g) {
        g.drawImage(Config.BG, this.rect.x, this.rect.y, 0);
        Enumeration e = this.obstacles.elements();
        while (e.hasMoreElements()) {
            Obstacles obs = (Obstacles)e.nextElement();
            obs.draw(g);
        }
        int i = 0;
        while (i < this.ceiling.size()) {
            Obstacles obs = (Obstacles)this.ceiling.elementAt(i);
            obs.draw(g);
            obs = (Obstacles)this.flooring.elementAt(i);
            obs.draw(g);
            ++i;
        }
        int j = 0;
        while (j < this.sprites.size()) {
            ((Sprite)this.sprites.elementAt(j)).draw(g);
            ++j;
        }
        super.draw(g);
    }

    protected void tick() {
        LevelGenerator.getInstance().tick();
        if (this.shouldStop && this.speed > 0) {
            --this.speed;
            if (this.speed < 0) {
                this.speed = 0;
            }
        }
        if (this.doesCopterCollide()) {
            this.copter.Explode();
        }
        this.updateScene();
        this.updateboundary();
        this.moveWithSpeed(this.speed);
        this.detectCollisionAmongAttacableSprites();
        int j = 0;
        while (j < this.sprites.size()) {
            ((Sprite)this.sprites.elementAt(j)).tick();
            ++j;
        }
        if (this.copter.hasFallen() || !this.copter.isAlive) {
            this.notifyGameOver();
        }
    }

    private boolean doesCopterCollide() {
        int i = 0;
        while (i < 10) {
            Tile c = (Tile)this.ceiling.elementAt(i);
            Tile f = (Tile)this.flooring.elementAt(i);
            if (!c.isDestroyed() && c.getCollisionRect().intersects(this.copter.getCollisionRect()) || !f.isDestroyed() && f.getCollisionRect().intersects(this.copter.getCollisionRect())) {
                if (this.copter.isShielded()) {
                    if (c.getCollisionRect().intersects(this.copter.getCollisionRect())) {
                        c.setDestroyed(true);
                    } else {
                        f.setDestroyed(true);
                    }
                    LevelGenerator.resetCounter(4);
                    this.copter.setShielded(false);
                    return false;
                }
                return true;
            }
            ++i;
        }
        Enumeration en = this.obstacles.elements();
        while (en.hasMoreElements()) {
            Obstacles obs = (Obstacles)en.nextElement();
            if (!obs.getCollisionRect().intersects(this.copter.getCollisionRect())) continue;
            if (obs instanceof ConsumableObstacle) {
                ConsumableObstacle cobs = (ConsumableObstacle)obs;
                if (!this.copter.canConsume() || cobs.isConsumed()) continue;
                switch (cobs.getType()) {
                    case 3: {
                        this.copter.incrementCoin();
                        break;
                    }
                    case 4: {
                        this.copter.setShielded(true);
                        ++this.shieldCollected;
                        break;
                    }
                    case 2: {
                        this.copter.incrementMissiles();
                    }
                }
                cobs.setConsumed(true);
                return false;
            }
            if (obs.isDestroyed()) {
                return false;
            }
            if (this.copter.isShielded()) {
                this.copter.setShielded(false);
                obs.setDestroyed(true);
                LevelGenerator.resetCounter(4);
                return false;
            }
            return true;
        }
        return false;
    }

    public void setShouldStop(boolean shouldStop) {
        this.shouldStop = shouldStop;
        this.speed = shouldStop ? 0 : DEFAULT_SPEED;
    }

    public int getShieldCollected() {
        return this.shieldCollected;
    }

    private void moveWithSpeed(int speed) {
        int i = 0;
        while (i < this.ceiling.size()) {
            Obstacles obs = (Obstacles)this.ceiling.elementAt(i);
            obs.moveWithSpeed(speed);
            obs.tick();
            obs = (Obstacles)this.flooring.elementAt(i);
            obs.moveWithSpeed(speed);
            obs.tick();
            ++i;
        }
        Enumeration e = this.obstacles.elements();
        while (e.hasMoreElements()) {
            Obstacles obs = (Obstacles)e.nextElement();
            obs.moveWithSpeed(speed);
            obs.tick();
        }
        this.moveAnimation(speed);
    }

    public int getObstacleSkipCount() {
        return this.obstacleSkipCount;
    }

    private void updateScene() {
    }

    public void setNinja(Copter sprite) {
        this.copter = sprite;
        this.sprites.addElement(sprite);
    }

    public void addSprite(Sprite sprite) {
        if (sprite != null && !this.sprites.contains(sprite)) {
            this.sprites.addElement(sprite);
        }
    }

    public int getSpeed() {
        return this.speed;
    }

    public void addListener(WorldListener listener) {
        if (listener != null) {
            this.listener = listener;
        }
    }

    private void detectCollisionAmongAttacableSprites() {
        int j = 0;
        while (j < this.sprites.size()) {
            Sprite missile = (Sprite)this.sprites.elementAt(j);
            if (missile instanceof FireBall) {
                int i = 0;
                while (i < this.sprites.size()) {
                    Sprite s = (Sprite)this.sprites.elementAt(i);
                    if (!s.equals(missile) && s instanceof AttackableSprite && s.intersectWith(((FireBall)missile).getCollisionRect()) && ((AttackableSprite)((Object)s)).beingAttacked(missile)) {
                        ((AttackableSprite)((Object)missile)).beingAttacked(s);
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public void attack(int x, int y, int inDirection, int weaponType, Sprite base) {
        FireBall fireBall = new FireBall(x, y, inDirection, weaponType, this);
        fireBall.setBase(base);
        this.sprites.addElement(fireBall);
    }

    public void removeSprite(Sprite sprite) {
        if (sprite != null) {
            if (this.flooring.contains(sprite)) {
                this.flooring.removeElement(sprite);
            } else if (this.ceiling.contains(sprite)) {
                this.ceiling.removeElement(sprite);
            } else if (this.obstacles.contains(sprite)) {
                ++this.obstacleSkipCount;
                this.obstacles.removeElement(sprite);
            } else if (this.sprites.contains(sprite)) {
                this.sprites.removeElement(sprite);
            }
        }
    }

    public void notifyGameOver() {
        if (this.listener != null) {
            this.listener.gameOver();
        }
    }
}

