/*
 * Decompiled with CFR 0.152.
 */
package com.spicelabs.eggtoss.screens;

import com.spicelabs.eggtoss.screens.MediaPlayer;
import com.spicelabs.eggtoss.screens.RMSData;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class MediaPlayerUtils
implements PlayerListener {
    private Hashtable hash = new Hashtable();
    private Vector vec = new Vector();
    private static MediaPlayerUtils utils;
    private Timer timer = new Timer();
    static /* synthetic */ Class class$0;

    public static MediaPlayerUtils getInstance() {
        if (utils == null) {
            utils = new MediaPlayerUtils();
        }
        return utils;
    }

    private MediaPlayerUtils() {
    }

    private MediaPlayer getMediaPlayer(String soundName, int count) {
        if (this.hash.containsKey(soundName)) {
            return (MediaPlayer)this.hash.get(soundName);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.spicelabs.eggtoss.screens.MediaPlayerUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream("/" + soundName);
        MediaPlayer player = null;
        try {
            player = new MediaPlayer(stream, soundName.endsWith("mid") ? "audio/midi" : "audio/mpeg");
            player.prefetch();
            player.addPlayerListener(utils);
            player.setLoopCount(count);
            player.realize();
            this.hash.put(soundName, player);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return player;
    }

    public void playMedia(String soundName, int count) {
        if (!RMSData.isSoundEnabled()) {
            return;
        }
        MediaPlayer player = this.getMediaPlayer(soundName, count);
        if (player.isPlaying()) {
            return;
        }
        if (this.vec.isEmpty()) {
            this.vec.addElement(soundName);
            this.playerUpdate(null, "endOfMedia", null);
        } else {
            this.vec.addElement(soundName);
        }
    }

    public void updateVolume() {
        Enumeration en = this.hash.keys();
        while (en.hasMoreElements()) {
            try {
                MediaPlayer player = (MediaPlayer)this.hash.get(en.nextElement());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stopMedia(String soundName) {
        MediaPlayer player = this.getMediaPlayer(soundName, 0);
        if (player.isPlaying()) {
            try {
                player.pause();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    public void releaseResources() {
        Enumeration enu = this.hash.keys();
        Vector<String> vec = new Vector<String>();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            vec.addElement(name);
        }
        int i = 0;
        while (i < vec.size()) {
            String name = (String)vec.elementAt(i);
            try {
                MediaPlayer player = (MediaPlayer)this.hash.get(name);
                player.removePlayerListener(utils);
                player.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("endOfMedia") && this.vec.size() > 0) {
            this.timer.schedule(new TimerTask(){

                public void run() {
                    if (MediaPlayerUtils.this.vec.size() > 0) {
                        String name = (String)MediaPlayerUtils.this.vec.elementAt(0);
                        MediaPlayer player1 = MediaPlayerUtils.this.getMediaPlayer(name, 0);
                        try {
                            player1.play();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        MediaPlayerUtils.this.vec.removeElementAt(0);
                    }
                }
            }, 0L);
        }
    }
}

