/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.linerunner.objects;

import in.spicelabs.linerunner.common.Config;
import in.spicelabs.linerunner.objects.Runner;
import in.spicelabs.linerunner.objects.Sprite;
import in.spicelabs.linerunner.objects.World;
import in.spicelabs.linerunner.objects.WorldListener;
import in.spicelabs.linerunner.objects.XYRect;
import in.spicelabs.linerunner.store.RMSData;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Controller
implements WorldListener {
    public static final int DIS_W = Config.SCREEN_WIDTH;
    public static final int DIS_H = Config.SCREEN_HEIGHT;
    public static double MIN_JUMP_FORCE;
    public static final double MAX_JUMP_FORCE;
    private static final int BEGIN_CYCLE_RATE = 45;
    private static final int SCORE_BONUS_FOR_ENEMY_DEFEAT = 1000;
    private static Controller controller;
    private Runner runner;
    private World world;
    private boolean isGameOver;
    private int cycleRate = 45;
    private int cycleCounter;
    private int score;
    private int duration;
    private boolean isPaused;
    private boolean isGameStarted;
    private StringBuffer strHighScore = new StringBuffer("H S: " + RMSData.getScore());
    private int gameOverType;
    private Vector note;
    Font font = Font.getFont((int)0, (int)0, (int)16);

    static {
        MAX_JUMP_FORCE = (double)DIS_H * 0.09;
    }

    private Controller() {
    }

    public void draw(Graphics g) {
        if (!this.isPaused && this.isGameStarted) {
            ++this.score;
            ++this.cycleCounter;
            this.duration += this.cycleRate;
            this.world.tick();
        }
        g.setFont(this.font);
        g.setColor(0);
        this.world.draw(g);
        int gap = g.getFont().getHeight() >> 1;
        g.drawString(this.strHighScore.toString(), gap, gap, 0);
        g.drawString("" + this.score, DIS_W - g.getFont().stringWidth("" + this.score) - gap, gap, 0);
        if (!this.isGameStarted) {
            g.setFont(Font.getFont((int)0, (int)0, (int)0));
            if (this.note == null) {
                this.note = this.wrap("To Jump: - Press KEY P(QWERTY Devices) or Touch right side of the screen.", (int)((double)DIS_W * 0.8), g);
                Vector wrap = this.wrap("To Slide: - Press KEY Q(QWERTY Devices) or Touch left side of the screen.", (int)((double)DIS_W * 0.8), g);
                Enumeration en = wrap.elements();
                while (en.hasMoreElements()) {
                    this.note.addElement(en.nextElement());
                }
            }
            int x = (int)((double)DIS_W * 0.1);
            int y = this.runner.rect.y - (int)((double)g.getFont().getHeight() * 0.6) * this.note.size() >> 1;
            int i = 0;
            while (i < this.note.size()) {
                String str = (String)this.note.elementAt(i);
                g.drawString(str, (Config.SCREEN_WIDTH - g.getFont().stringWidth(str)) / 2, y, 0);
                y += g.getFont().getHeight();
                ++i;
            }
        }
    }

    private Vector wrap(String text, int width, Graphics g) {
        Vector<String> result = new Vector<String>();
        if (text == null) {
            return result;
        }
        boolean hasMore = true;
        int current = 0;
        int lineBreak = -1;
        int nextSpace = -1;
        while (hasMore) {
            int linewidth;
            do {
                if ((lineBreak = nextSpace) == text.length() - 1) {
                    hasMore = false;
                    break;
                }
                nextSpace = text.indexOf(32, lineBreak + 1);
                if (nextSpace != -1) continue;
                nextSpace = text.length() - 1;
            } while ((linewidth = g.getFont().substringWidth(text, current, nextSpace - current)) <= width);
            String line = text.substring(current, lineBreak + 1);
            result.addElement(line);
            current = lineBreak + 1;
        }
        return result;
    }

    public static Controller getController() {
        if (controller == null) {
            controller = new Controller();
        }
        return controller;
    }

    public static float getWorldSpeed() {
        return Controller.controller.world.getSpeed();
    }

    public static int getDurationInSeconds() {
        return Controller.controller.duration / 1000;
    }

    public void startNewGame() {
        this.isGameOver = false;
        this.isPaused = false;
        this.isGameStarted = false;
        this.score = 0;
        this.duration = 0;
        this.cycleRate = 45;
        int x = DIS_W / 7;
        this.world = new World(new XYRect(0, 0, DIS_W, DIS_H));
        this.world.addListener(this);
        this.runner = new Runner(x, 0, Config.RUNNER_FRAMES, this.world);
        MIN_JUMP_FORCE = (int)Math.sqrt(2 * this.runner.mass * 2 * World.AIR_BLOCK_H);
        this.runner.setCanConsume(true);
        this.world.setRunner(this.runner);
        this.world.initEnvironment();
    }

    public void resumeGame() {
        this.runner.rect.y = 0;
        this.runner.beingAttackedCount = 0;
        this.isGameOver = false;
    }

    public void onTouch(int globalX) {
        if (globalX > DIS_W >> 1) {
            this.jump(0);
        } else {
            this.rollDown();
        }
    }

    public void setPaused(boolean isPaused) {
        this.isPaused = isPaused;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public int getScore() {
        return this.score;
    }

    public int getDuration() {
        return this.duration;
    }

    public void jump(int jumpRate) {
        if (!this.isGameOver) {
            if (!this.isGameStarted) {
                this.isGameStarted = true;
                return;
            }
            if (jumpRate < 150) {
                this.runner.jumpWithVelocity((int)MIN_JUMP_FORCE);
            } else {
                this.runner.velocityY = (int)(MAX_JUMP_FORCE - (MIN_JUMP_FORCE - (double)this.runner.velocityY));
            }
        }
    }

    public void cancelJump() {
        if (!this.isGameOver) {
            this.runner.cancelJump();
        }
    }

    public void rollDown() {
        if (!this.isGameOver) {
            if (!this.isGameStarted) {
                this.isGameStarted = true;
                return;
            }
            this.runner.rollDown();
        }
    }

    public boolean isGameOver() {
        return this.isGameOver;
    }

    public void gameOver(int type) {
        this.gameOverType = type;
        this.isGameOver = true;
    }

    public void taskAchieved(int taskType) {
        if (taskType == 1001) {
            this.score += 1000;
        }
    }

    public static int getNinjaAcceleration() {
        return Controller.controller.runner.getAcceleration();
    }

    public static boolean isOutOfWorld(Sprite sprite) {
        return !Controller.controller.world.intersectWith(sprite.rect);
    }

    public static int getCycleRate() {
        return Controller.controller.cycleRate;
    }

    public static void setCycleRate(int cycleRate) {
        Controller.controller.cycleRate = cycleRate;
    }

    public int getCoins() {
        return this.runner.getCoins();
    }

    public void setCoins(int coins) {
        this.runner.setCoins(coins);
    }

    public void setHighscore(long highscore) {
        this.strHighScore = new StringBuffer("H S: ");
        this.strHighScore.append(highscore);
    }

    public int getGameOverType() {
        return this.gameOverType;
    }
}

