/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.linerunner.objects;

public class XYRect {
    public int x;
    public int y;
    public int width;
    public int height;
    int overLappWidth;
    int overlappHeight;

    public XYRect(XYRect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public XYRect(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean intersects(XYRect xyRect) {
        int yb;
        int xr;
        int xl = Math.max(this.x, xyRect.x);
        if (xl >= (xr = Math.min(this.x + this.width, xyRect.x + xyRect.width))) {
            return false;
        }
        int yt = Math.max(this.y, xyRect.y);
        return yt < (yb = Math.min(this.y + this.height, xyRect.y + xyRect.height));
    }

    public void intersect(XYRect xyRect) {
        if (xyRect.x + this.width > this.x + this.width && xyRect.y + this.height > this.y + this.height) {
            this.width = this.overLappWidth = this.x + this.width - xyRect.x;
            this.height = this.overlappHeight = this.y + this.height - xyRect.y;
        } else {
            this.width = this.overLappWidth = xyRect.width;
            this.height = this.overlappHeight = this.height;
        }
    }

    public void overlap(XYRect xyRect) {
        int xl = Math.max(this.x, xyRect.x);
        int yt = Math.max(this.y, xyRect.y);
        int xr = Math.min(this.x + this.width, xyRect.x + xyRect.width);
        int yb = Math.min(this.y + this.height, xyRect.y + xyRect.height);
        this.x = xl;
        this.y = yt;
        this.width = xr - this.x;
        this.height = yb - this.y;
    }
}

