/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.linerunner.screen;

import in.spicelabs.linerunner.midlet.MainMidlet;
import in.spicelabs.linerunner.screen.HomeScreen;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HelpScreen
extends Canvas
implements CommandListener {
    protected int linePadding = 2;
    protected int margin = 2;
    protected int padding = 2;
    protected Font font = Font.getDefaultFont();
    protected int bgColor = 0xFFFFFF;
    protected int foreColor = 0;
    protected int foreSelectedColor = 0xFFFFFF;
    protected int backColor = 0xFFFFFF;
    protected int backSelectedColor = 255;
    protected int borderWidth = 3;
    protected int borderColor = 0;
    protected int borderSelectedColor = 0xFF0000;
    String[][] itemLines = null;
    Image[] images = null;
    int itemsCount = 0;
    int itemdragged = 0;
    public int selectedItem = 0;
    int[] itemsTop = null;
    int[] itemsHeight = null;
    int scrollTop = 0;
    final int SCROLL_STEP;
    Command backCommand;
    private int sY = 0;
    private int dragY = 0;
    int startXpoint;
    int startYpoint;

    public HelpScreen(String title, String[] items, Image[] imageElements) {
        this.SCROLL_STEP = 40;
        this.setTitle(title);
        this.setFullScreenMode(false);
        this.backCommand = new Command("Back", 2, 2);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        this.images = imageElements;
        this.itemLines = new String[items.length][];
        this.itemsTop = new int[this.itemLines.length + 1];
        this.itemsHeight = new int[this.itemLines.length];
        this.itemdragged = this.itemsCount = this.itemLines.length;
        int i = 0;
        while (i < this.itemLines.length) {
            Image imagePart = this.getImage(i);
            int w = this.getItemWidth() - (imagePart != null ? imagePart.getWidth() + this.padding : 0);
            this.itemLines[i] = HelpScreen.getTextRows(items[i], this.font, w);
            ++i;
        }
    }

    public int getItemWidth() {
        return this.getWidth() - 2 * this.borderWidth - 2 * this.padding - 2 * this.margin;
    }

    protected void keyPressed(int key) {
        int keyCode = this.getGameAction(key);
        if (this.itemLines.length > 0) {
            if (keyCode == 1) {
                if (this.itemsTop[this.selectedItem] < this.scrollTop) {
                    this.scrollTop -= 40;
                    this.repaint();
                } else if (this.selectedItem > 0) {
                    --this.selectedItem;
                    this.repaint();
                }
            } else if (keyCode == 6) {
                if (this.itemsTop[this.selectedItem] + this.itemsHeight[this.selectedItem] >= this.scrollTop + this.getHeight()) {
                    this.scrollTop += 40;
                    this.repaint();
                } else if (this.selectedItem < this.itemLines.length - 1) {
                    ++this.selectedItem;
                    this.repaint();
                }
            }
        }
    }

    Image getImage(int index) {
        return this.images != null && this.images.length > index ? this.images[index] : null;
    }

    protected void paint(Graphics g) {
        g.setColor(this.bgColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.translate(0, -this.scrollTop);
        int top = 0;
        g.setFont(this.font);
        int i = 0;
        while (i < this.itemLines.length) {
            int itemRows = this.itemLines[i].length;
            Image imagePart = this.getImage(i);
            int itemHeight = itemRows * this.font.getHeight() + this.linePadding * (itemRows - 1);
            this.itemsTop[i] = top;
            this.itemsHeight[i] = itemHeight;
            if (imagePart != null && imagePart.getHeight() > itemHeight) {
                itemHeight = imagePart.getHeight();
            }
            itemHeight += 2 * this.padding + 2 * this.borderWidth;
            g.translate(0, top);
            if (this.borderWidth > 0) {
                g.setColor(i == this.selectedItem ? this.borderColor : this.borderColor);
                g.fillRect(this.margin, this.margin, this.getWidth() - 2 * this.margin, itemHeight);
            }
            g.setColor(i == this.selectedItem ? 0 : 0);
            g.fillRect(this.margin + this.borderWidth, this.margin + this.borderWidth, this.getWidth() - 2 * this.margin - 2 * this.borderWidth, itemHeight - 2 * this.borderWidth);
            if (imagePart != null) {
                g.drawImage(imagePart, this.margin + this.borderWidth + this.padding, this.margin + this.borderWidth + this.padding, 20);
            }
            g.setColor(i == this.selectedItem ? this.foreSelectedColor : this.foreSelectedColor);
            int textLeft = this.margin + this.borderWidth + this.padding + (imagePart != null ? imagePart.getWidth() + this.padding : 0);
            int j = 0;
            while (j < itemRows && i < this.itemsCount) {
                g.drawString(this.itemLines[i][j], textLeft, this.margin + this.borderWidth + this.padding + j * (this.linePadding + this.font.getHeight()), 20);
                ++j;
            }
            g.translate(0, -top);
            top += itemHeight + 2 * this.margin;
            ++i;
        }
        g.translate(0, this.scrollTop);
    }

    static String[] getTextRows(String text, Font font, int width) {
        char SPACE_CHAR = ' ';
        String VOID_STRING = "";
        int prevIndex = 0;
        int currIndex = text.indexOf(SPACE_CHAR);
        Vector<String> rowsVector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        String currentRowText = VOID_STRING;
        while (prevIndex != -1) {
            int startCharIndex = prevIndex == 0 ? prevIndex : prevIndex + 1;
            String currentToken = currIndex != -1 ? text.substring(startCharIndex, currIndex) : text.substring(startCharIndex);
            prevIndex = currIndex;
            currIndex = text.indexOf(SPACE_CHAR, prevIndex + 1);
            if (currentToken.length() == 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(SPACE_CHAR);
            }
            stringBuffer.append(currentToken);
            if (font.stringWidth(stringBuffer.toString()) > width) {
                if (currentRowText.length() > 0) {
                    rowsVector.addElement(currentRowText);
                }
                stringBuffer.setLength(0);
                currentRowText = VOID_STRING;
                stringBuffer.append(currentToken);
                currentRowText = stringBuffer.toString();
                continue;
            }
            currentRowText = stringBuffer.toString();
        }
        if (currentRowText.length() > 0) {
            rowsVector.addElement(currentRowText);
        }
        Object[] rowsArray = new String[rowsVector.size()];
        rowsVector.copyInto(rowsArray);
        return rowsArray;
    }

    protected void pointerDragged(int x, int y) {
        if (y > this.sY && this.sY - this.dragY > 3) {
            if (this.itemsTop[this.selectedItem] < this.scrollTop) {
                this.scrollTop -= 40;
                this.repaint();
            } else if (this.selectedItem > 0) {
                --this.selectedItem;
                this.repaint();
            }
            this.dragY = this.sY;
        } else if (y < this.sY && this.dragY - this.sY > 3) {
            if (this.itemsTop[this.selectedItem] + this.itemsHeight[this.selectedItem] >= this.scrollTop + this.getHeight()) {
                this.scrollTop += 40;
                this.repaint();
            } else if (this.selectedItem < this.itemLines.length - 1) {
                ++this.selectedItem;
                this.repaint();
            }
            this.dragY = this.sY;
        }
        this.sY = y;
        this.repaint();
    }

    protected void pointerPressed(int x, int y) {
        this.sY = y;
        this.dragY = y;
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            MainMidlet.display.setCurrent((Displayable)new HomeScreen());
        }
    }
}

