/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.linerunner.objects;

import in.spicelabs.linerunner.objects.AttackListener;
import in.spicelabs.linerunner.objects.Controller;
import in.spicelabs.linerunner.objects.FallableSprite;
import in.spicelabs.linerunner.objects.World;
import in.spicelabs.linerunner.objects.XYRect;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Runner
extends FallableSprite {
    public static final int INITIAL_POWER = 50;
    public static final int SHIELD_BERAK_LIMIT = 10;
    public static final int INITIAL_LIFE = 50;
    protected boolean isJumping;
    protected int killType;
    protected boolean isAlive;
    protected int beingAttackedCount;
    protected int maxSurvivableAttack;
    protected boolean canAttack;
    protected Vector jumpTrajectory;
    int frameCount;
    int frequencyCount;
    int frequency;
    Image[][] frames;
    int powers = 50;
    private AttackListener attackListener;
    private boolean canConsume;
    private int coins;
    private boolean isShielded;
    private int shieldBreakCounter;
    private int shieldFrame;
    private int enemyDefeatCount;

    public Runner(int x, int y, Image[][] frames, World world) {
        super(new XYRect(x, y, frames[0][0].getWidth(), frames[0][0].getHeight()), world);
        this.frames = frames;
        this.mass = 3;
        this.isAlive = true;
        this.maxSurvivableAttack = 50;
    }

    public void setAttackListener(AttackListener attackListener) {
        this.attackListener = attackListener;
    }

    private Image[] getCurrentStateFrames() {
        Image[] frms;
        if (this.isInState(16)) {
            frms = this.frames[4];
        } else if (this.isInState(64)) {
            this.frequency = 3;
            frms = this.frames[4];
        } else if (this.isInState(32)) {
            this.frequency = 3;
            frms = this.frames[5];
        } else if (this.isInState(2)) {
            frms = this.frames[1];
        } else if (this.isInState(4)) {
            frms = this.frames[2];
        } else if (this.isInState(8)) {
            this.frequency = 2;
            frms = this.frames[3];
        } else {
            frms = this.frames[0];
        }
        this.frequency = 1;
        this.rect.width = frms[0].getWidth();
        this.rect.y = this.rect.y + this.rect.height - frms[0].getHeight();
        this.rect.height = frms[0].getHeight();
        return frms;
    }

    protected void draw(Graphics g) {
        Image[] frms = this.getCurrentStateFrames();
        this.rect.y += this.rect.height - frms[this.frameCount].getHeight() >> 1;
        this.rect.width = frms[this.frameCount].getWidth();
        this.rect.height = frms[this.frameCount].getHeight();
        g.drawImage(frms[this.frameCount], this.rect.x, this.rect.y, 0);
        super.draw(g);
    }

    protected void tick() {
        Image[] frms = this.getCurrentStateFrames();
        ++this.frameCount;
        this.frameCount %= frms.length;
        this.rect.x += this.velocityX;
        if (this.isInState(16) && this.frameCount == frms.length - 1) {
            this.addState(1);
        }
        if (this.isInState(2)) {
            this.isJumping = true;
            this.rect.y -= this.velocityY;
            this.velocityY -= this.mass * 2;
            if (this.velocityY <= 0) {
                this.addState(4);
            }
            return;
        }
        if (this.isInState(8) && this.frameCount == frms.length - 1) {
            this.addState(1);
        }
        super.tick();
        if (this.isJumping && this.rect.y + this.rect.height >= this.getLowerBound()) {
            this.isJumping = false;
        }
    }

    public int getEnemyDefeatCount() {
        return this.enemyDefeatCount;
    }

    public void inicrementEnemyDefeatCount() {
        ++this.enemyDefeatCount;
    }

    public boolean isLifeNeeded() {
        return this.beingAttackedCount > this.maxSurvivableAttack >> 1;
    }

    public int getShieldPowerPercentage() {
        return this.shieldBreakCounter * 100 / 10;
    }

    public int getCoins() {
        return this.coins;
    }

    public void setCoins(int coins) {
        this.coins = coins;
    }

    public void addState(int state) {
        super.addState(state);
        this.frameCount = 0;
    }

    public void setState(int state, boolean resetFrame) {
        super.addState(state);
        if (resetFrame) {
            this.frameCount = 0;
        }
    }

    public int getPowers() {
        return this.powers;
    }

    public void setCanConsume(boolean canConsume) {
        this.canConsume = canConsume;
    }

    public boolean hasFallen() {
        return this.rect.y + this.rect.height >= Controller.DIS_H;
    }

    public void jumpWithVelocity(int velocity) {
        if (!this.isJumping) {
            this.velocityY = velocity;
            this.addState(2);
        }
    }

    public void cancelJump() {
        if (this.isJumping && this.isInState(2)) {
            this.addState(4);
            this.velocityY = 0;
        }
    }

    public void rollDown() {
        if (this.isInState(1)) {
            if (this.isInState(2)) {
                this.cancelJump();
            }
            this.addState(8);
        }
    }

    protected int getAcceleration() {
        return 2 * this.mass;
    }

    public void setShieldBreakCounter(int shieldBreakCounter) {
        this.shieldBreakCounter = shieldBreakCounter;
        if (shieldBreakCounter <= 0) {
            this.world.resetShieldCounter();
            this.isShielded = false;
        } else {
            this.isShielded = true;
        }
    }

    public boolean isShielded() {
        return this.isShielded;
    }

    public XYRect[] getjumpTrajectory() {
        Object[] trajectory = new XYRect[this.jumpTrajectory.size()];
        this.jumpTrajectory.copyInto(trajectory);
        return trajectory;
    }
}

