/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.linerunner.screen;

import com.emobtech.googleanalyticsme.Event;
import com.emobtech.googleanalyticsme.Tracker;
import in.spicelabs.linerunner.common.Config;
import in.spicelabs.linerunner.midlet.MainMidlet;
import in.spicelabs.linerunner.objects.Controller;
import in.spicelabs.linerunner.objects.MediaPlayerUtils;
import in.spicelabs.linerunner.screen.GameOverScreen;
import in.spicelabs.linerunner.screen.HomeScreen;
import in.spicelabs.linerunner.store.RMSData;
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import vInAppAdEngine.VservAd;
import vInAppAdEngine.VservAdListener;
import vInAppAdEngine.VservManager;

public class GameScreen
extends GameCanvas
implements Runnable,
CommandListener,
VservAdListener {
    private Controller controller;
    private boolean isGameExited;
    public static GameScreen screen;
    private Command backCommand;
    Alert alert;
    private VservManager vservManager;
    private VservAd vservAd;
    Image imageAd;
    String textAd;
    Thread runner;

    protected GameScreen() {
        super(false);
        this.setFullScreenMode(true);
        this.controller = Controller.getController();
        this.controller.setHighscore(RMSData.getScore());
        ++Config.gameCount;
        this.controller.startNewGame();
        this.start();
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        this.initlize();
        System.out.println("cons called");
        Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-13");
        tracker.addToQueue(new Event("Game_Play", "Play_Started", "Game_Play", null));
    }

    private void initlize() {
        Hashtable<String, String> vservConfigTable = new Hashtable<String, String>();
        vservConfigTable.put("appId", "66e3c752");
        this.vservManager = new VservManager(Config.midlet, vservConfigTable);
        this.vservAd = new VservAd(this);
        this.vservAd.requestAd();
    }

    private void start() {
        this.runner = new Thread(this);
        this.runner.start();
    }

    public static GameScreen getinstance() {
        if (screen == null) {
            screen = new GameScreen();
        }
        return screen;
    }

    public void run() {
        while (!this.controller.isGameOver()) {
            if (this.isGameExited) break;
            this.repaint();
            try {
                Thread.sleep(Controller.getCycleRate());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.isGameExited) {
            return;
        }
        if ((long)this.controller.getScore() > RMSData.getScore()) {
            Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-13");
            tracker.addToQueue(new Event("Game_Play", "Play_End", "Game_Play", new Integer(this.controller.getScore())));
            this.runner = null;
            screen = null;
            MediaPlayerUtils.getInstance().stopMedia();
            MainMidlet.display.setCurrent((Displayable)new GameOverScreen(this.controller.getScore(), this.controller.getCoins(), this.controller.getGameOverType(), true));
        } else {
            this.runner = null;
            screen = null;
            MediaPlayerUtils.getInstance().stopMedia();
            MainMidlet.display.setCurrent((Displayable)new GameOverScreen(this.controller.getScore(), this.controller.getCoins(), this.controller.getGameOverType(), false));
        }
    }

    public void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.controller.draw(g);
        if (this.imageAd != null) {
            g.drawImage(this.imageAd, (Config.SCREEN_WIDTH - this.imageAd.getWidth()) / 2, 0, 0);
        }
        if (this.textAd != null) {
            g.drawString(this.textAd, (Config.SCREEN_WIDTH - g.getFont().stringWidth(this.textAd)) / 2, 0, 0);
        }
    }

    protected void pointerPressed(int x, int y) {
        this.controller.onTouch(x);
    }

    protected void keyPressed(int keyCode) {
        String key1 = this.getKeyName(keyCode);
        System.out.println("key" + key1);
        if (key1.equals("p")) {
            this.controller.jump(0);
        } else if (key1.equals("q")) {
            this.controller.rollDown();
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            this.showConfirmationYesOrNo(" ", "Are you sure you want to exit?");
            if (!this.controller.isGameOver()) {
                this.controller.setPaused(true);
            }
        }
    }

    protected void showConfirmationYesOrNo(String title, String text) {
        this.alert = new Alert(title, text, null, AlertType.CONFIRMATION);
        this.alert.addCommand(new Command("Yes", 4, 1));
        this.alert.addCommand(new Command("No", 3, 1));
        this.alert.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getLabel().equals("Yes")) {
                    GameScreen.this.isGameExited = true;
                    Tracker tracker = Tracker.getInstance(Config.midlet, "UA-48934997-13");
                    tracker.addToQueue(new Event("Game_Play", "Play_End", "Game_Play", new Integer(GameScreen.this.controller.getScore())));
                    MainMidlet.display.setCurrent((Displayable)new HomeScreen());
                    MediaPlayerUtils.getInstance().stopMedia();
                    GameScreen.this.runner = null;
                    screen = null;
                }
                if (c.getLabel().equals("No")) {
                    MainMidlet.display.setCurrent((Displayable)GameScreen.getinstance());
                    GameScreen.this.isGameExited = false;
                    if (!GameScreen.this.controller.isGameOver() && GameScreen.this.controller.isPaused()) {
                        GameScreen.this.controller.setPaused(false);
                    }
                    GameScreen.this.alert = null;
                }
            }
        });
        MainMidlet.display.setCurrent((Displayable)this.alert);
    }

    public void vservAdReceived(Object obj) {
        if (((VservAd)obj).getAdType().equals("image")) {
            this.imageAd = (Image)((VservAd)obj).getAd();
            System.out.println("image");
        } else if (((VservAd)obj).getAdType().equals("text")) {
            this.textAd = (String)((VservAd)obj).getAd();
            System.out.println("text");
        }
    }

    public void vservAdFailed(Object arg0) {
        System.out.println("not received");
    }

    protected void showNotify() {
        if (!this.controller.isGameOver()) {
            this.controller.setPaused(false);
        }
    }

    protected void hideNotify() {
        if (!this.controller.isGameOver()) {
            this.controller.setPaused(true);
        }
    }
}

