/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.hippojump.objects;

import in.spicelabs.hippojump.common.Config;
import in.spicelabs.hippojump.objects.Controller;
import in.spicelabs.hippojump.objects.FallableSprite;
import in.spicelabs.hippojump.objects.World;
import in.spicelabs.hippojump.objects.XYRect;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Hippo
extends FallableSprite {
    public static final int STATE_DIE = 64;
    private Image[] frames = this.getFramesForCurrentState();
    private int frameCount;
    protected int velocityX;

    public Hippo(int x, int y, World world) {
        super(new XYRect(x, y, Config.HIPPO[0][0].getWidth(), Config.HIPPO[0][0].getHeight()), world);
    }

    protected void draw(Graphics g) {
        g.drawImage(this.frames[this.frameCount], this.getAbsoluteX(), this.getAbsoluteY(), 0);
        super.draw(g);
    }

    private Image[] getFramesForCurrentState() {
        if (this.isInState(64)) {
            return Config.HIPPO[3];
        }
        if (this.isInState(4)) {
            return Config.HIPPO[0];
        }
        if (this.isInState(2)) {
            return Config.HIPPO[0];
        }
        return new Image[]{Config.HIPPO[0][0]};
    }

    protected void tick() {
        ++this.frameCount;
        this.frameCount %= this.frames.length;
        if (this.isInState(4) || this.isInState(2)) {
            this.move(this.velocityX);
        }
        if (this.isInState(2)) {
            if (this.rect.y - this.velocityY < World.hippo_upper_bound) {
                this.world.rollWorldWithSpeed(this.velocityY);
            } else {
                this.rect.y -= this.velocityY;
            }
            this.velocityY -= this.mass * 1;
            if (this.velocityY <= 0) {
                this.setState(4);
            }
        } else if (this.isInState(4)) {
            super.tick();
        }
        if (this.rect.y >= Controller.DIS_H) {
            this.world.notifyGameOver(0);
        }
    }

    public boolean isCaught() {
        return this.state == 1;
    }

    public boolean isFalling() {
        return this.state == 4;
    }

    public void throughTillHeight(int height) {
        if (this.isInState(64)) {
            return;
        }
        this.setState(2);
        this.velocityY = (int)Math.sqrt(2 * this.mass * 1 * height);
    }

    public void setState(int state) {
        super.setState(state);
        this.frames = this.getFramesForCurrentState();
        this.frameCount = 0;
    }

    private void move(int dx) {
        if (this.isInState(4) || this.isInState(2)) {
            int temp = this.rect.x + dx;
            this.rect.x = temp <= -this.rect.width ? this.world.rect.width - this.rect.width : (temp + this.rect.width >= this.world.rect.width + this.rect.width ? 0 : temp);
        }
    }
}

