/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.hippojump.objects;

import in.spicelabs.hippojump.common.Config;
import in.spicelabs.hippojump.objects.Controller;
import in.spicelabs.hippojump.objects.LevelGeneratorListener;
import java.util.Random;

public class LevelGenerator {
    private static Random random = new Random();
    private static LevelGenerator generator;
    private static final int APPEARANCE_PERIOD = 500;
    private static final int TOTAL_BRANCH_TYPES = 4;
    private int level;
    private int minSpeed;
    private int ticksCount;
    private int minGapBwtBranches;
    private int maxGapBwtBranches;
    private int maxCountMonster;
    private int maxCountBranchMoving;
    private int maxCountBranchSpring;
    private int maxCountBranchBreak;
    private int curCountMonster;
    private int curCountBranchMoving;
    private int curCountBranchSpring;
    private int curCountBranchBreak;
    private LevelGeneratorListener listener;

    private LevelGenerator() {
    }

    public static LevelGenerator getInstance() {
        if (generator == null) {
            generator = new LevelGenerator();
        }
        return generator;
    }

    public void setListener(LevelGeneratorListener listener) {
        this.listener = listener;
    }

    public void tick() {
        ++this.ticksCount;
        if (this.ticksCount % 500 == 0) {
            this.ticksCount = 0;
            ++this.level;
            this.updateFactors();
            this.notifyListener();
            this.curCountMonster = 0;
            this.curCountBranchSpring = 0;
            this.curCountBranchMoving = 0;
            this.curCountBranchBreak = 0;
        }
    }

    public static void reset() {
        LevelGenerator.generator.level = 1;
        generator.updateFactors();
    }

    private void updateFactors() {
        switch (this.level) {
            case 1: {
                LevelGenerator.generator.minGapBwtBranches = Config.BRANCH[0].getHeight() >> 2;
                LevelGenerator.generator.maxGapBwtBranches = Config.BRANCH[0].getHeight() >> 1;
                LevelGenerator.generator.minSpeed = Controller.DIS_W / 120;
                this.maxCountBranchMoving = 1;
                this.maxCountBranchSpring = 1;
                this.maxCountBranchBreak = 1;
                this.maxCountMonster = 0;
                break;
            }
            case 2: {
                this.maxCountBranchMoving = 2;
                this.maxCountBranchBreak = 3;
                this.maxCountBranchSpring = 2;
                break;
            }
            case 3: {
                this.maxCountMonster = 1;
                this.maxCountBranchMoving = 3;
                this.maxCountBranchBreak = 3;
                this.maxCountBranchSpring = 3;
                break;
            }
            case 4: {
                this.maxCountBranchBreak = 4;
                this.maxCountBranchMoving = 4;
                this.maxCountBranchSpring = 4;
                break;
            }
            case 5: {
                LevelGenerator.generator.maxGapBwtBranches = Config.BRANCH[0].getHeight();
                break;
            }
            case 6: {
                this.maxCountBranchBreak = 5;
                this.maxCountBranchMoving = 5;
                this.maxCountBranchSpring = 5;
                break;
            }
            case 7: {
                this.maxCountMonster = 2;
                this.maxCountBranchBreak = 6;
                this.maxCountBranchMoving = 6;
                this.maxCountBranchSpring = 6;
                break;
            }
            case 8: {
                LevelGenerator.generator.maxGapBwtBranches = 3 * (Config.BRANCH[0].getHeight() >> 1);
            }
        }
    }

    public static int getGap() {
        return LevelGenerator.generator.minGapBwtBranches + random.nextInt(LevelGenerator.generator.maxGapBwtBranches - LevelGenerator.generator.minGapBwtBranches);
    }

    public boolean canAddMonster() {
        if (this.canAddFeature(this.maxCountMonster, this.curCountMonster)) {
            ++this.curCountMonster;
            return true;
        }
        return false;
    }

    public boolean canAddFeature(int max, int cur) {
        if (500 - this.ticksCount > 1) {
            if (max - cur > 0) {
                return random.nextInt(4) == 0;
            }
            return false;
        }
        return 500 - this.ticksCount == 1 && max - cur > 0;
    }

    public static int getNestType() {
        int type = random.nextInt(4);
        switch (type) {
            case 1: {
                if (generator.canAddFeature(LevelGenerator.generator.maxCountBranchBreak, LevelGenerator.generator.curCountBranchBreak)) {
                    ++LevelGenerator.generator.curCountBranchBreak;
                    break;
                }
                type = 0;
                break;
            }
            case 2: {
                if (generator.canAddFeature(LevelGenerator.generator.maxCountBranchMoving, LevelGenerator.generator.curCountBranchMoving)) {
                    ++LevelGenerator.generator.curCountBranchMoving;
                    break;
                }
                type = 0;
                break;
            }
            case 3: {
                if (generator.canAddFeature(LevelGenerator.generator.maxCountBranchSpring, LevelGenerator.generator.curCountBranchSpring)) {
                    ++LevelGenerator.generator.curCountBranchSpring;
                    break;
                }
                type = 0;
            }
        }
        return type;
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.onLevelUp();
        }
    }

    public static int getSpeed() {
        return LevelGenerator.generator.minSpeed;
    }
}

