/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.hippojump.objects;

import in.spicelabs.hippojump.objects.Controller;
import in.spicelabs.hippojump.objects.FallableSprite;
import in.spicelabs.hippojump.objects.World;
import in.spicelabs.hippojump.objects.XYRect;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Obstacles
extends FallableSprite {
    public static final int WH = 30;
    protected int frameCount;
    private boolean isFalling;
    private boolean canFall = true;
    private boolean isWalkable;
    private boolean isDestroyed;
    private boolean isFriendly;
    private int type;
    Image[] frames;
    private int frequencyCount;
    int frequency = 1;

    public Obstacles(int x, int y, Image[] frames, int type, boolean isFriendly, World world) {
        super(new XYRect(x, y, frames[0].getWidth(), frames[0].getHeight()), world);
        this.isFriendly = isFriendly;
        this.type = type;
        this.frames = frames;
        this.mass = 2;
        this.isWalkable = true;
    }

    protected void draw(Graphics g) {
        g.drawImage(this.frames[this.frameCount], this.rect.x, this.rect.y, 0);
        super.draw(g);
    }

    public XYRect getCollisionRect() {
        if (this.isFriendly) {
            return this.rect;
        }
        int dx = this.rect.width / 10;
        int dy = this.rect.height / 5;
        return new XYRect(this.rect.x + dx, this.rect.y + dy, this.rect.width - 2 * dx, this.rect.height - dy);
    }

    protected void tick() {
        ++this.frequencyCount;
        if (this.frequencyCount % this.frequency == 0) {
            ++this.frameCount;
            this.frameCount %= this.frames.length;
            this.frequencyCount = 0;
        }
        if (this.canFall) {
            super.tick();
        }
        if (this.rect.y > -this.rect.height) {
            this.world.removeSprite(this);
        }
    }

    public void blastOff() {
        if (!this.isDestroyed) {
            this.isDestroyed = true;
        }
    }

    public void moveWithSpeed(int speed) {
        if (!this.isFalling) {
            this.rect.x -= speed;
        }
    }

    public boolean isFriendly() {
        return this.isFriendly;
    }

    public void setFriendly(boolean isFriendly) {
        this.isFriendly = isFriendly;
    }

    public boolean isWalkable() {
        return this.isWalkable;
    }

    public void setWalkable(boolean isWalkable) {
        this.isWalkable = isWalkable;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public void setDestroyed(boolean isDestroyed) {
        this.isDestroyed = isDestroyed;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isCanFall() {
        return this.canFall;
    }

    public void setCanFall(boolean canFall) {
        this.canFall = canFall;
    }

    public void startFall(int velocity) {
        this.velocityY = velocity;
        this.setState(2);
        this.isFalling = true;
    }

    protected int getLowerBound() {
        if (this.isFalling) {
            return Controller.DIS_H + this.rect.height;
        }
        return super.getLowerBound();
    }

    public boolean isFalling() {
        return this.isFalling;
    }
}

