/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.jpride.objects;

import in.spicelabs.jpride.objects.XYRect;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PowerSprite {
    private Image[] bitmap;
    protected XYRect rect;
    private int frameCount;
    private int color;

    public PowerSprite(Image[] bitmap, int x, int y) {
        this.bitmap = bitmap;
        this.rect = new XYRect(x, y, bitmap[0].getWidth(), bitmap[0].getHeight());
    }

    public PowerSprite(Image[] bitmap, int x, int y, int contectWidth, int color) {
        this.bitmap = bitmap;
        this.color = color;
        this.rect = new XYRect(x, y, bitmap[0].getWidth() + contectWidth, bitmap[0].getHeight());
    }

    protected void draw(Graphics g, String value) {
        g.drawImage(this.bitmap[this.frameCount], this.rect.x, this.rect.y, 0);
        ++this.frameCount;
        this.frameCount %= this.bitmap.length;
        Font font = g.getFont();
        g.setColor(0);
        g.drawString(value, this.rect.x + this.rect.width + 1, this.rect.y + (this.rect.height - g.getFont().getHeight() >> 1), 0);
        g.setFont(font);
    }

    protected void draw(Graphics g, int percent) {
        g.drawImage(this.bitmap[this.frameCount], this.rect.x, this.rect.y, 0);
        ++this.frameCount;
        this.frameCount %= this.bitmap.length;
        g.setColor(this.color);
        int temp = this.bitmap[0].getWidth() + 1;
        g.fillRect(this.rect.x + temp, this.rect.y + (this.rect.height >> 2), (this.rect.width - temp) * percent / 100, this.rect.height >> 1);
        g.drawRect(this.rect.x + temp, this.rect.y + (this.rect.height >> 2), this.rect.width - temp, this.rect.height >> 1);
    }

    public void setColor(int color) {
        this.color = color;
    }
}

