/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.subwaySketes.objects;

import in.spicelabs.subwaySketes.objects.AnimationCompleteListener;
import in.spicelabs.subwaySketes.objects.Sprite;
import in.spicelabs.subwaySketes.objects.XYRect;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnimationSprite
extends Sprite {
    private final Image[] frames;
    private AnimationCompleteListener listener;
    private int frameCount;
    private int animationCount;

    public AnimationSprite(Image[] frames, int x, int y) {
        super(new XYRect(x, y, frames[0].getWidth(), frames[0].getHeight()), null);
        this.frames = frames;
        this.animationCount = 1;
    }

    public void setAnimationListener(AnimationCompleteListener listener) {
        this.listener = listener;
    }

    public void setAnimationCount(int animationCount) {
        this.animationCount = animationCount;
    }

    protected void draw(Graphics g) {
        if (this.animationCount != 0) {
            g.drawImage(this.frames[this.frameCount], this.rect.x, this.rect.y, 0);
        }
    }

    protected void tick() {
        if (this.animationCount != 0) {
            ++this.frameCount;
            this.frameCount %= this.frames.length;
            if (this.frameCount == 0 && this.animationCount != -1) {
                --this.animationCount;
            }
        } else if (this.listener != null) {
            this.listener.onAnimationComplete(this);
        }
    }
}

