/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.subwaySketes.objects;

import in.spicelabs.subwaySketes.common.Config;
import in.spicelabs.subwaySketes.objects.Coins;
import in.spicelabs.subwaySketes.objects.Controller;
import in.spicelabs.subwaySketes.objects.FallableSprite;
import in.spicelabs.subwaySketes.objects.FireBall;
import in.spicelabs.subwaySketes.objects.Life;
import in.spicelabs.subwaySketes.objects.Obstacles;
import in.spicelabs.subwaySketes.objects.Shield;
import in.spicelabs.subwaySketes.objects.Shuriken;
import in.spicelabs.subwaySketes.objects.Spikes;
import in.spicelabs.subwaySketes.objects.Sprite;
import in.spicelabs.subwaySketes.objects.World;
import in.spicelabs.subwaySketes.objects.XYRect;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class Building
extends Sprite {
    private static final int SPIKE_OR_FIREBALL_COUNTER_MIN = 1;
    private static final int SPIKE_OR_FIREBALL_COUNTER_MAX = 5;
    protected Obstacles[] obstacles;
    private static Random random = new Random();
    static int spikeOrFireballCounter = 1 + random.nextInt(4);
    int TotalWidth;
    int imageWidth = Config.BMP_MID.getWidth();
    int imageHeight = Config.BMP_MID.getHeight();
    int diff;

    public Building(XYRect rect, World world) {
        super(rect, world);
        this.initObstacles();
    }

    public static void init() {
        spikeOrFireballCounter = 1 + random.nextInt(4);
    }

    private void initObstacles() {
        int shieldCount;
        int lifeCount;
        XYRect[] trajectory = this.world.getNinja().getjumpTrajectory();
        boolean canAddSpikesOrFireball = this.canAddSpikesOrFireball();
        if (canAddSpikesOrFireball) {
            this.rect.width = 3 * (Controller.DIS_W / 2);
        }
        int spikeOrFireballCount = canAddSpikesOrFireball ? 1 : 0;
        int obsCount = Controller.getDurationInSeconds() >= 20 && !canAddSpikesOrFireball ? random.nextInt(4) : 0;
        obsCount = this.rect.width > (obsCount + 7) * 30 ? obsCount : 0;
        int type = canAddSpikesOrFireball ? 0 : random.nextInt(3);
        int coinsCount = type != 0 ? trajectory.length : 10;
        int coinReqW = (type != 0 ? trajectory.length * Coins.getCoinWidth() : Coins.getCoinWidth() * coinsCount) + 2;
        coinsCount = this.rect.width > coinReqW ? (random.nextInt(4) == 0 ? coinsCount : 0) : 0;
        int n = lifeCount = this.world.shouldGiveLife() && !canAddSpikesOrFireball && this.world.getNinja().isLifeNeeded() ? 1 : 0;
        if (lifeCount > 0) {
            this.world.resetLifeCounter();
        }
        int n2 = shieldCount = this.world.shouldGiveShield() && !canAddSpikesOrFireball && !this.world.getNinja().isShielded() ? 1 : 0;
        if (shieldCount == 1) {
            this.world.stopShieldCounter();
        }
        this.obstacles = new Obstacles[spikeOrFireballCount + obsCount + coinsCount + lifeCount + shieldCount];
        int index = 0;
        while (index < obsCount) {
            try {
                this.obstacles[index] = new Obstacles(this.rect.x + random.nextInt(this.rect.width - (obsCount + 7) * 30), 0, Config.BOX, this.world);
                this.obstacles[index].setBase(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++index;
        }
        if (coinsCount > 0) {
            this.addCoins(index, random.nextInt(this.rect.width - coinReqW), trajectory, type);
            index += coinsCount;
        }
        if (lifeCount > 0) {
            this.obstacles[index] = new Life(this.rect.x + random.nextInt(this.rect.width - Life.getCoinWidth()), this.rect.y - Life.getLifeHeight() - random.nextInt(trajectory[trajectory.length >> 1].y), this.world);
            this.obstacles[index].setBase(this);
            ++index;
        }
        if (shieldCount > 0) {
            this.obstacles[index] = new Shield(this.rect.x + random.nextInt(this.rect.width - Shield.getShieldWidth()), this.rect.y - Shield.getShieldHeight() - random.nextInt(trajectory[trajectory.length >> 1].y), this.world);
            this.obstacles[index].setBase(this);
            ++index;
        }
        if (spikeOrFireballCount > 0) {
            int isSpike = random.nextInt(2);
            this.obstacles[index] = isSpike == 0 ? new Spikes(this.rect.x, this.rect.y, trajectory[trajectory.length - 1].x, this.world) : new FireBall(this.rect.x, this.rect.y, this.world);
            this.obstacles[index].rect.x = this.rect.x + (this.rect.width - trajectory[trajectory.length - 1].x >> 1);
            this.obstacles[index].setBase(this);
            ++index;
        }
    }

    private boolean canAddSpikesOrFireball() {
        if (spikeOrFireballCounter == 0) {
            spikeOrFireballCounter = 1 + random.nextInt(4);
            return true;
        }
        --spikeOrFireballCounter;
        return false;
    }

    private void addCoins(int offset, int initX, XYRect[] trajectory, int type) {
        int j = 0;
        while (j < trajectory.length) {
            try {
                this.obstacles[offset + j] = new Coins(initX + this.rect.x + j * Coins.getCoinWidth(), this.rect.y - ((type != 0 ? trajectory[j].y : 0) + Coins.getCoinWidth()), this.world);
                this.obstacles[offset + j].setBase(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++j;
        }
    }

    private void addPowers(int offset, int initX, XYRect[] trajectory, int type) {
        int k = 0;
        while (k < trajectory.length) {
            try {
                this.obstacles[offset + k] = new Shuriken(initX + this.rect.x + k * Shuriken.getShurikenWidth(), this.rect.y - ((type != 0 ? trajectory[k].y : 0) + Shuriken.getShurikenWidth()), this.world);
                this.obstacles[offset + k].setBase(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++k;
        }
    }

    protected void draw(Graphics g) {
        g.drawImage(Config.BMP_LEFT, this.rect.x, this.rect.y, 0);
        this.TotalWidth = this.rect.width - 2 * Config.BMP_RIGHT.getWidth();
        int c = this.TotalWidth / Config.BMP_MID.getWidth();
        if (this.TotalWidth % Config.BMP_MID.getWidth() != 0) {
            ++c;
        }
        int i = 0;
        while (i < c) {
            g.drawRegion(Config.BMP_MID, 0, 0, this.TotalWidth > this.imageWidth ? this.imageWidth : this.TotalWidth, this.imageHeight, 0, this.rect.x + Config.BMP_LEFT.getWidth() + this.imageWidth * i, this.rect.y, 0);
            this.TotalWidth -= this.imageWidth;
            ++i;
        }
        g.drawImage(Config.BMP_RIGHT, this.rect.x + this.rect.width - Config.BMP_RIGHT.getWidth(), this.rect.y, 0);
        i = 0;
        while (i < this.obstacles.length) {
            this.obstacles[i].draw(g);
            ++i;
        }
    }

    protected void tick() {
        this.moveWithSpeed(Controller.getWorldSpeed());
    }

    private void moveWithSpeed(int speed) {
        this.rect.x -= speed;
        int i = 0;
        while (i < this.obstacles.length) {
            this.obstacles[i].moveWithSpeed(speed);
            this.obstacles[i].tick();
            ++i;
        }
    }

    public boolean hasSpikesOrFireball() {
        int i = 0;
        while (i < this.obstacles.length) {
            if (this.obstacles[i] instanceof Spikes || this.obstacles[i] instanceof FireBall) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getSurfaceForSprite(FallableSprite sprite) {
        int i = 0;
        while (i < this.obstacles.length) {
            Obstacles ob = this.obstacles[i];
            if (!ob.isWalkable || sprite.equals(ob)) {
                ++i;
                continue;
            }
            if ((!sprite.isFalling || sprite.isFalling && sprite.rect.y < this.rect.y) && sprite.rect.x >= ob.rect.x && sprite.rect.x <= ob.rect.x + (ob.rect.width >> 1)) {
                return ob.rect.y;
            }
            ++i;
        }
        return super.getSurfaceForSprite(sprite);
    }
}

