/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.subwaySketes.objects;

import in.spicelabs.subwaySketes.objects.AnimatableSprite;
import in.spicelabs.subwaySketes.objects.Building;
import in.spicelabs.subwaySketes.objects.Controller;
import in.spicelabs.subwaySketes.objects.Sprite;
import in.spicelabs.subwaySketes.objects.World;
import in.spicelabs.subwaySketes.objects.XYRect;
import javax.microedition.lcdui.Graphics;

public abstract class FallableSprite
extends AnimatableSprite {
    public static final int G = 2;
    public static final int STATE_RUNING = 1;
    public static final int STATE_JUMP = 2;
    public static final int STATE_FALL = 4;
    public static final int STATE_ROLL = 8;
    public static final int STATE_FIRE = 16;
    public boolean isFalling = false;
    protected int velocity;
    protected int mass = 1;
    private int state = 1;
    protected Sprite base;
    int previousState;

    public FallableSprite(XYRect rect, World world) {
        super(rect, world);
    }

    protected void draw(Graphics g) {
        super.draw(g);
    }

    protected void tick() {
        int lb = this.getLowerBound();
        this.rect.y += this.velocity;
        this.velocity += this.mass * 2;
        if (this.rect.y + this.rect.height >= lb) {
            this.rect.y = lb - this.rect.height;
            this.velocity = 0;
            if (this.isInState(4)) {
                this.setState(1);
            }
        }
    }

    public boolean isOnTheBase() {
        int lb = this.getLowerBound();
        return this.rect.y + this.rect.height >= lb;
    }

    public void setBase(Sprite base) {
        this.base = base;
    }

    protected int getLowerBound() {
        if (this.base.rect.x <= this.rect.x + (this.rect.width >> 1) && this.rect.y + this.rect.height <= this.base.rect.y) {
            if (this.base instanceof Building) {
                return ((Building)this.base).getSurfaceForSprite(this);
            }
            return this.base.rect.y;
        }
        return Controller.DIS_H + this.rect.height;
    }

    public boolean isInState(int state) {
        return (this.state & state) == state;
    }

    public void setState(int state) {
        this.previousState = this.state;
        this.state |= state;
        switch (state) {
            case 4: {
                this.state &= 0xFFFFFFFD;
                break;
            }
            case 2: {
                this.state &= 0xFFFFFFFE;
                break;
            }
            case 1: {
                this.state &= 0xFFFFFFFB;
                this.state &= 0xFFFFFFF7;
                break;
            }
            case 8: {
                this.state &= 0xFFFFFFFE;
                this.state &= 0xFFFFFFFB;
            }
        }
    }
}

