/*
 * Decompiled with CFR 0.152.
 */
package in.spicelabs.subwaySketes.objects;

import in.spicelabs.subwaySketes.objects.AnimationSprite;
import in.spicelabs.subwaySketes.objects.Controller;
import in.spicelabs.subwaySketes.objects.FallableSprite;
import in.spicelabs.subwaySketes.objects.World;
import in.spicelabs.subwaySketes.objects.XYRect;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Obstacles
extends FallableSprite {
    public static final int WH = 30;
    protected boolean isFalling;
    protected Image[] frames;
    private int frameCount;
    protected boolean canFall = true;
    private boolean isDestroyed;
    protected boolean isWalkable;

    public Obstacles(int x, int y, Image[] frames, World world) {
        super(new XYRect(x, y, frames[0].getWidth(), frames[0].getHeight()), world);
        this.frames = frames;
        this.mass = 2;
        this.isWalkable = true;
    }

    public Obstacles(XYRect rect, World world) {
        super(rect, world);
    }

    protected void draw(Graphics g) {
        g.drawImage(this.frames[this.frameCount], this.rect.x, this.rect.y, 0);
    }

    protected void tick() {
        ++this.frameCount;
        this.frameCount %= this.frames.length;
        if (this.canFall) {
            super.tick();
        }
    }

    public void moveWithSpeed(int speed) {
        if (!this.isFalling) {
            this.rect.x -= speed;
        }
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public void setDestroyed(boolean isDestroyed) {
        this.isDestroyed = isDestroyed;
    }

    public void startFall(int velocity) {
        this.velocity = velocity;
        this.setState(2);
        this.isFalling = true;
    }

    protected int getLowerBound() {
        if (this.isFalling) {
            return Controller.DIS_H + this.rect.height;
        }
        return super.getLowerBound();
    }

    public void onAnimationComplete(AnimationSprite sprite) {
    }
}

