/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.impl.midp;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.VideoComponent;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.impl.LWUITImplementation;
import com.sun.lwuit.impl.midp.MMAPIPlayer;
import com.sun.lwuit.plaf.UIManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;
import javax.microedition.midlet.MIDlet;

public class GameCanvasImplementation
extends LWUITImplementation {
    public static boolean NOKIA = false;
    public boolean minimized;
    public MIDlet mid;
    public Object currentlyPlayingAudio;
    public static int[] portableKeyCodes;
    public static int[] portableKeyCodeValues;
    public int alpha = 255;
    public int[] rgbArr;
    public Canvas canvas;
    public static final AlertType[] TYPES;
    static javax.microedition.lcdui.Command CONFIRM_COMMAND;
    public long lastVibrate;
    static javax.microedition.lcdui.Command CANCEL_COMMAND;
    TextBox currentTextBox;
    Component currentTextComponent;
    public boolean flushGraphicsBug;
    static javax.microedition.lcdui.Display display;
    static int[] leftSK;
    static int[] rightSK;
    static int backSK;
    static int clearSK;
    static int backspaceSK;
    public static boolean drawNegativeOffsetsInRGB;
    static Hashtable configHashTable;
    static MIDlet vservMidlet;
    static boolean isEndInstanceRunning;

    protected Canvas createCanvas() {
        return new C();
    }

    public int getKeyboardType() {
        String keyboardType = System.getProperty("com.nokia.keyboard.type");
        if (keyboardType != null) {
            if ("None".equalsIgnoreCase(keyboardType)) {
                if (this.isTouchDevice()) {
                    return 3;
                }
                return 1;
            }
            if ("PhoneKeypad".equalsIgnoreCase(keyboardType)) {
                return 1;
            }
            if ("HalfKeyboard".equalsIgnoreCase(keyboardType)) {
                return 4;
            }
            if ("FullKeyboard".equalsIgnoreCase(keyboardType)) {
                return 2;
            }
            if ("LimitedKeyboard4x10".equalsIgnoreCase(keyboardType)) {
                return 2;
            }
            if ("LimitedKeyboard3x11".equalsIgnoreCase(keyboardType)) {
                return 2;
            }
        }
        return super.getKeyboardType();
    }

    public void init(Object m) {
        this.canvas = this.createCanvas();
        this.canvas.setTitle(null);
        this.canvas.setFullScreenMode(!Display.getInstance().isNativeCommands());
        String platform = System.getProperty("microedition.platform");
        if (platform != null && platform.toUpperCase().indexOf("NOKIA") >= 0) {
            this.flushGraphicsBug = false;
            NOKIA = true;
            Display.getInstance().setTransitionYield(1);
        } else {
            this.flushGraphicsBug = true;
            Display.getInstance().setTransitionYield(-1);
        }
        this.mid = (MIDlet)m;
        display = javax.microedition.lcdui.Display.getDisplay((MIDlet)this.mid);
        this.setSoftKeyCodes(this.mid);
    }

    private void setSoftKeyCodes(MIDlet m) {
        int game;
        this.setKnownSoftKeyCodes();
        try {
            game = this.getGameAction(backSK);
            if (game == 1 || game == 6 || game == 5 || game == 2 || game == 8) {
                backSK = -50000;
            }
        }
        catch (Exception ok) {
            // empty catch block
        }
        try {
            game = this.getGameAction(clearSK);
            if (game == 1 || game == 6 || game == 5 || game == 2 || game == 8) {
                clearSK = -50000;
            }
            if ((game = this.getGameAction(backspaceSK)) == 1 || game == 6 || game == 5 || game == 2 || game == 8) {
                backspaceSK = -50000;
            }
        }
        catch (Exception ok) {
            // empty catch block
        }
        String tmpSoftKey = m.getAppProperty("SoftKey-Right");
        if (tmpSoftKey != null && !"".equals(tmpSoftKey)) {
            GameCanvasImplementation.rightSK[0] = Integer.valueOf(tmpSoftKey);
        }
        if ((tmpSoftKey = m.getAppProperty("SoftKey-Right2")) != null && !"".equals(tmpSoftKey)) {
            rightSK = new int[]{rightSK[0], Integer.valueOf(tmpSoftKey)};
        }
        if ((tmpSoftKey = m.getAppProperty("SoftKey-Left")) != null && !"".equals(tmpSoftKey)) {
            GameCanvasImplementation.leftSK[0] = Integer.valueOf(tmpSoftKey);
        }
        if ((tmpSoftKey = m.getAppProperty("SoftKey-Back")) != null && !"".equals(tmpSoftKey)) {
            backSK = Integer.valueOf(tmpSoftKey);
        }
        if ((tmpSoftKey = m.getAppProperty("SoftKey-Clear")) != null && !"".equals(tmpSoftKey)) {
            clearSK = Integer.valueOf(tmpSoftKey);
        }
        if ((tmpSoftKey = m.getAppProperty("SoftKey-Backspace")) != null && !"".equals(tmpSoftKey)) {
            backspaceSK = Integer.valueOf(tmpSoftKey);
        }
        if ((tmpSoftKey = m.getAppProperty("isThirdSoftButtonSupported")) != null && "true".equals(tmpSoftKey.toLowerCase().trim())) {
            Display.getInstance().setThirdSoftButton(true);
        }
    }

    private void setKnownSoftKeyCodes() {
        try {
            Class.forName("com.siemens.mp.game.Light");
            GameCanvasImplementation.leftSK[0] = -1;
            GameCanvasImplementation.rightSK[0] = -4;
            clearSK = -12;
            backspaceSK = -12;
            return;
        }
        catch (ClassNotFoundException _ex) {
            try {
                Class.forName("com.motorola.phonebook.PhoneBookRecord");
                GameCanvasImplementation.leftSK[0] = -21;
                GameCanvasImplementation.rightSK[0] = -22;
                return;
            }
            catch (ClassNotFoundException _ex2) {
                try {
                    Class.forName("com.nokia.mid.ui.FullCanvas");
                    GameCanvasImplementation.leftSK[0] = -6;
                    GameCanvasImplementation.rightSK[0] = -7;
                    clearSK = -8;
                    backspaceSK = -8;
                    String p = System.getProperty("microedition.platform");
                    if (p != null && p.toUpperCase().indexOf("NOKIA") >= 0) {
                        backspaceSK = 8;
                    }
                    return;
                }
                catch (Throwable ex) {
                    try {
                        Class.forName("net.rim.device.api.system.Application");
                        GameCanvasImplementation.leftSK[0] = 113;
                        rightSK = new int[]{112, 111};
                        clearSK = 8;
                        backspaceSK = 8;
                        return;
                    }
                    catch (ClassNotFoundException ex2) {
                        try {
                            Class.forName("com.mot.iden.util.Base64");
                            clearSK = -5000;
                            backspaceSK = -5000;
                            GameCanvasImplementation.leftSK[0] = -20;
                            GameCanvasImplementation.rightSK[0] = -21;
                            this.setFireValue(-23);
                            return;
                        }
                        catch (Throwable ex3) {
                            try {
                                Class.forName("mmpp.media.MediaPlayer");
                                clearSK = -204;
                                backspaceSK = -204;
                            }
                            catch (ClassNotFoundException ex4) {
                                // empty catch block
                            }
                            try {
                                if (this.canvas.getKeyName(-6).toUpperCase().indexOf("SOFT") >= 0) {
                                    GameCanvasImplementation.leftSK[0] = -6;
                                    GameCanvasImplementation.rightSK[0] = -7;
                                    return;
                                }
                                if (this.canvas.getKeyName(21).toUpperCase().indexOf("SOFT") >= 0) {
                                    GameCanvasImplementation.leftSK[0] = 21;
                                    GameCanvasImplementation.rightSK[0] = 22;
                                    return;
                                }
                            }
                            catch (Exception ex5) {
                                // empty catch block
                            }
                            boolean leftInit = false;
                            boolean rightInit = false;
                            for (int i = -127; i < 127; ++i) {
                                if (leftInit && rightInit) {
                                    return;
                                }
                                try {
                                    if (this.canvas.getKeyName(i).toUpperCase().indexOf("SOFT") < 0) continue;
                                    if (this.canvas.getKeyName(i).indexOf("1") >= 0) {
                                        GameCanvasImplementation.leftSK[0] = i;
                                        leftInit = true;
                                    }
                                    if (this.canvas.getKeyName(i).indexOf("2") < 0) continue;
                                    GameCanvasImplementation.rightSK[0] = i;
                                    rightInit = true;
                                    continue;
                                }
                                catch (Exception ex6) {
                                    // empty catch block
                                }
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    void setFireValue(int key) {
        try {
            this.getKeyCode(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GameCanvasImplementation.portableKeyCodeValues[4] = key;
    }

    public void vibrate(int duration) {
        long now = System.currentTimeMillis();
        if (now > this.lastVibrate) {
            this.lastVibrate = now + (long)(duration * 3);
            display.vibrate(duration);
        }
    }

    public void flashBacklight(int duration) {
        display.flashBacklight(duration);
    }

    public int getDisplayWidth() {
        return this.canvas.getWidth();
    }

    public int getDisplayHeight() {
        return this.canvas.getHeight();
    }

    public void editString(Component cmp, int maxSize, int constraint, String text, int keyCode) {
        UIManager m = UIManager.getInstance();
        CONFIRM_COMMAND = new javax.microedition.lcdui.Command(m.localize("ok", "OK"), 4, 1);
        CANCEL_COMMAND = new javax.microedition.lcdui.Command(m.localize("cancel", "Cancel"), 3, 2);
        this.currentTextBox = new TextBox("", "", maxSize, 0);
        this.currentTextBox.setCommandListener((CommandListener)this.canvas);
        this.currentTextBox.addCommand(CONFIRM_COMMAND);
        this.currentTextBox.addCommand(CANCEL_COMMAND);
        this.currentTextComponent = cmp;
        this.currentTextBox.setMaxSize(maxSize);
        this.currentTextBox.setString(text);
        this.currentTextBox.setConstraints(constraint);
        display.setCurrent((Displayable)this.currentTextBox);
        ((C)this.canvas).setDone(false);
        Display.getInstance().invokeAndBlock((C)this.canvas);
    }

    public void saveTextEditingState() {
        if (this.currentTextBox != null) {
            String text = this.currentTextBox.getString();
            this.getCurrentForm().setVisible(true);
            Display.getInstance().onEditingComplete(this.currentTextComponent, text);
            this.currentTextBox = null;
            ((C)this.canvas).setDone(true);
        }
    }

    public void setFlashGraphicsBug(boolean flushGraphicsBug) {
        this.flushGraphicsBug = flushGraphicsBug;
    }

    protected final Canvas getCanvas() {
        return this.canvas;
    }

    public void flushGraphics(int x, int y, int width, int height) {
        Form current = this.getCurrentForm();
        if (!this.flushGraphicsBug || current != null && current.hasMedia()) {
            ((C)this.canvas).flushGraphics(x, y, width, height);
        } else {
            ((C)this.canvas).flushGraphics();
        }
    }

    public void flushGraphics() {
        ((C)this.canvas).flushGraphics();
    }

    public void getRGB(Object nativeImage, int[] arr, int offset, int x, int y, int width, int height) {
        ((Image)nativeImage).getRGB(arr, offset, width, x, y, width, height);
    }

    public Object createImage(int[] rgb, int width, int height) {
        return Image.createRGBImage((int[])rgb, (int)width, (int)height, (boolean)true);
    }

    public Object createImage(String path) throws IOException {
        return Image.createImage((String)path);
    }

    public Object createImage(InputStream i) throws IOException {
        return Image.createImage((InputStream)i);
    }

    public Object createMutableImage(int width, int height, int fillColor) {
        Image i = Image.createImage((int)width, (int)height);
        if (fillColor != -1) {
            javax.microedition.lcdui.Graphics g = i.getGraphics();
            g.setColor(fillColor);
            g.fillRect(0, 0, width, height);
            g.drawRect(0, 0, width - 1, height - 1);
        }
        return i;
    }

    public Object createImage(byte[] bytes, int offset, int len) {
        return Image.createImage((byte[])bytes, (int)offset, (int)len);
    }

    public int getImageWidth(Object i) {
        return ((Image)i).getWidth();
    }

    public int getImageHeight(Object i) {
        return ((Image)i).getHeight();
    }

    public Object scale(Object nativeImage, int width, int height) {
        Image image = (Image)nativeImage;
        int srcWidth = image.getWidth();
        int srcHeight = image.getHeight();
        if (srcWidth == width && srcHeight == height) {
            return image;
        }
        int[] currentArray = new int[srcWidth];
        int[] destinationArray = new int[width * height];
        this.scaleArray(image, srcWidth, srcHeight, height, width, currentArray, destinationArray);
        return this.createImage(destinationArray, width, height);
    }

    private void scaleArray(Image currentImage, int srcWidth, int srcHeight, int height, int width, int[] currentArray, int[] destinationArray) {
        int yRatio = (srcHeight << 16) / height;
        int xRatio = (srcWidth << 16) / width;
        int xPos = xRatio / 2;
        int yPos = yRatio / 2;
        for (int y = 0; y < height; ++y) {
            int srcY = yPos >> 16;
            this.getRGB(currentImage, currentArray, 0, 0, srcY, srcWidth, 1);
            for (int x = 0; x < width; ++x) {
                int srcX = xPos >> 16;
                int destPixel = x + y * width;
                if (destPixel >= 0 && destPixel < destinationArray.length && srcX < currentArray.length) {
                    destinationArray[destPixel] = currentArray[srcX];
                }
                xPos += xRatio;
            }
            yPos += yRatio;
            xPos = xRatio / 2;
        }
    }

    public void drawImageRotated(Object graphics, Object img, int x, int y, int degrees) {
        int t;
        Image i = (Image)img;
        switch (degrees % 360) {
            case 0: {
                this.drawImage(graphics, img, x, y);
                return;
            }
            case 90: {
                t = 5;
                break;
            }
            case 180: {
                t = 3;
                break;
            }
            case 270: {
                t = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported value for drawImageRotated: " + degrees);
            }
        }
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        nativeGraphics.drawRegion(i, 0, 0, i.getWidth(), i.getHeight(), t, x, y, 20);
    }

    public boolean isRotationDrawingSupported() {
        return true;
    }

    public int getSoftkeyCount() {
        return 2;
    }

    public int[] getSoftkeyCode(int index) {
        if (index == 0) {
            return leftSK;
        }
        if (index == 1) {
            return rightSK;
        }
        return null;
    }

    public int getClearKeyCode() {
        return clearSK;
    }

    public int getBackspaceKeyCode() {
        return backspaceSK;
    }

    public int getBackKeyCode() {
        return backSK;
    }

    public int getGameAction(int keyCode) {
        try {
            if (keyCode >= 48) {
                return 0;
            }
            if (portableKeyCodes != null) {
                for (int iter = 0; iter < portableKeyCodeValues.length; ++iter) {
                    if (portableKeyCodeValues[iter] != keyCode) continue;
                    return portableKeyCodes[iter];
                }
            }
            return this.canvas.getGameAction(keyCode);
        }
        catch (IllegalArgumentException err) {
            return 0;
        }
    }

    public int getKeyCode(int gameAction) {
        if (portableKeyCodes == null) {
            portableKeyCodes = new int[]{6, 2, 5, 1, 8};
            portableKeyCodeValues = new int[5];
            int currentValue = -500;
            int offset = 0;
            while (offset < portableKeyCodeValues.length) {
                --currentValue;
                try {
                    if (this.canvas.getGameAction(currentValue) != 0) {
                        continue;
                    }
                }
                catch (IllegalArgumentException ignor) {
                    // empty catch block
                }
                GameCanvasImplementation.portableKeyCodeValues[offset] = currentValue;
                ++offset;
            }
        }
        for (int iter = 0; iter < portableKeyCodes.length; ++iter) {
            if (portableKeyCodes[iter] != gameAction) continue;
            return portableKeyCodeValues[iter];
        }
        return 0;
    }

    public boolean isTouchDevice() {
        return this.canvas.hasPointerEvents();
    }

    public void setNativeFont(Object graphics, Object font) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        nativeGraphics.setFont(this.font(font));
    }

    public int getClipX(Object graphics) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        return nativeGraphics.getClipX();
    }

    public int getClipY(Object graphics) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        return nativeGraphics.getClipY();
    }

    public int getClipWidth(Object graphics) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        return nativeGraphics.getClipWidth();
    }

    public int getClipHeight(Object graphics) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        return nativeGraphics.getClipHeight();
    }

    public void setClip(Object graphics, int x, int y, int width, int height) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        nativeGraphics.setClip(x, y, width, height);
    }

    public void clipRect(Object graphics, int x, int y, int width, int height) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        nativeGraphics.clipRect(x, y, width, height);
    }

    public void drawLine(Object graphics, int x1, int y1, int x2, int y2) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        nativeGraphics.drawLine(x1, y1, x2, y2);
    }

    public void fillRect(Object graphics, int x, int y, int w, int h) {
        if (this.isAlphaGlobal()) {
            javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
            nativeGraphics.fillRect(x, y, w, h);
            nativeGraphics.drawRect(x, y, w - 1, h - 1);
            return;
        }
        if (this.alpha == 0) {
            return;
        }
        if (this.alpha == 255) {
            javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
            nativeGraphics.fillRect(x, y, w, h);
            nativeGraphics.drawRect(x, y, w - 1, h - 1);
        } else {
            int transparencyLevel = this.alpha << 24;
            int color = this.getColor(graphics) & 0xFFFFFF;
            color |= transparencyLevel;
            if (this.rgbArr == null || this.rgbArr.length < w) {
                this.rgbArr = new int[w];
            }
            for (int i = 0; i < w; ++i) {
                this.rgbArr[i] = color;
            }
            int rgbX = x;
            int rgbY = y;
            if (rgbX < 0 && rgbX + w > 0) {
                w = rgbX + w;
                rgbX = 0;
            }
            if (w < 0) {
                return;
            }
            int clipY = this.getClipY(graphics);
            int clipHeight = this.getClipHeight(graphics);
            int clipBottomY = clipHeight + clipY;
            for (int i = 0; i < h; ++i) {
                int currentY;
                if (rgbX < 0 || rgbY + i < 0 || (currentY = rgbY + i) < clipY || currentY > clipBottomY) continue;
                this.drawRGB(graphics, this.rgbArr, 0, rgbX, currentY, w, 1, true);
            }
        }
    }

    public void drawRect(Object graphics, int x, int y, int width, int height) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        nativeGraphics.drawRect(x, y, width, height);
    }

    public void drawRoundRect(Object graphics, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        nativeGraphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void fillRoundRect(Object graphics, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        nativeGraphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void fillArc(Object graphics, int x, int y, int width, int height, int startAngle, int arcAngle) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        nativeGraphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawArc(Object graphics, int x, int y, int width, int height, int startAngle, int arcAngle) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        nativeGraphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void setColor(Object graphics, int RGB) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        nativeGraphics.setColor(RGB);
    }

    public int getColor(Object graphics) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        return nativeGraphics.getColor();
    }

    public void setAlpha(Object graphics, int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha(Object graphics) {
        return this.alpha;
    }

    public void drawString(Object graphics, String str, int x, int y) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        nativeGraphics.drawString(str, x, y, 20);
    }

    public void drawImage(Object graphics, Object img, int x, int y) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        nativeGraphics.drawImage((Image)img, x, y, 20);
    }

    public void fillTriangle(Object graphics, int x1, int y1, int x2, int y2, int x3, int y3) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        nativeGraphics.fillTriangle(x1, y1, x2, y2, x3, y3);
    }

    public void drawRGB(Object graphics, int[] rgbData, int offset, int x, int y, int w, int h, boolean processAlpha) {
        javax.microedition.lcdui.Graphics nativeGraphics = (javax.microedition.lcdui.Graphics)graphics;
        int rgbX = x;
        int rgbY = y;
        if (rgbX >= 0 && rgbY >= 0) {
            nativeGraphics.drawRGB(rgbData, offset, w, rgbX, rgbY, w, h, processAlpha);
            return;
        }
        if (drawNegativeOffsetsInRGB) {
            try {
                nativeGraphics.drawRGB(rgbData, offset, w, rgbX, rgbY, w, h, processAlpha);
                return;
            }
            catch (RuntimeException e) {
                drawNegativeOffsetsInRGB = false;
            }
        }
        if (rgbX < 0 && rgbX + w > 0 && w < rgbData.length) {
            for (int i = 1; i <= rgbData.length / w; ++i) {
                offset = -rgbX + w * (i - 1);
                if (++rgbY < 0) continue;
                nativeGraphics.drawRGB(rgbData, offset, w + rgbX, 0, rgbY, w + rgbX, 1, processAlpha);
            }
        }
    }

    public Object getVideoControl(Object player) {
        VideoControl vidc = (VideoControl)((Player)player).getControl("VideoControl");
        vidc.initDisplayMode(1, (Object)this.canvas);
        return vidc;
    }

    public int numAlphaLevels() {
        return display.numAlphaLevels();
    }

    public int numColors() {
        return display.numColors();
    }

    public void playDialogSound(int type) {
        if (--type >= 0 && type < TYPES.length) {
            TYPES[type].playSound(display);
        }
    }

    public void confirmControlView() {
        if (display == null) {
            throw new IllegalStateException("First call Display.setDisplay(javax.microedition.lcdui.Display d) method");
        }
        if (display.getCurrent() != this.canvas || !this.canvas.isShown()) {
            this.setCurrent((Displayable)this.canvas);
        }
    }

    private void setCurrent(Displayable d) {
        if (display == null) {
            throw new IllegalStateException("First call Display.setDisplay(javax.microedition.lcdui.Display d) method");
        }
        if (!this.minimized) {
            if (d instanceof Canvas) {
                ((Canvas)d).setFullScreenMode(!Display.getInstance().isNativeCommands());
            }
            display.setCurrent(d);
        }
    }

    public Object getNativeGraphics() {
        return ((C)this.canvas).getGraphics();
    }

    public Object getNativeGraphics(Object image) {
        return ((Image)image).getGraphics();
    }

    public void translate(Object graphics, int x, int y) {
    }

    public int getTranslateX(Object graphics) {
        return 0;
    }

    public int getTranslateY(Object graphics) {
        return 0;
    }

    public int charsWidth(Object nativeFont, char[] ch, int offset, int length) {
        if (NOKIA) {
            return this.font(nativeFont).stringWidth(new String(ch, offset, length));
        }
        return this.font(nativeFont).charsWidth(ch, offset, length);
    }

    public int stringWidth(Object nativeFont, String str) {
        return this.font(nativeFont).stringWidth(str);
    }

    public int charWidth(Object nativeFont, char ch) {
        return this.font(nativeFont).charWidth(ch);
    }

    public int getHeight(Object nativeFont) {
        return this.font(nativeFont).getHeight();
    }

    public Object createFont(int face, int style, int size) {
        return Font.getFont((int)face, (int)style, (int)size);
    }

    public Object getDefaultFont() {
        return Font.getDefaultFont();
    }

    public int getFace(Object nativeFont) {
        return this.font(nativeFont).getFace();
    }

    public int getSize(Object nativeFont) {
        return this.font(nativeFont).getSize();
    }

    public int getStyle(Object nativeFont) {
        return this.font(nativeFont).getStyle();
    }

    private Font font(Object f) {
        if (f == null) {
            return (Font)this.getDefaultFont();
        }
        return (Font)f;
    }

    public VideoComponent createVideoPeer(String url) throws IOException {
        try {
            Player p = Manager.createPlayer((String)url);
            p.realize();
            return new MIDPVideoComponent(p);
        }
        catch (MediaException ex) {
            ex.printStackTrace();
            throw new IOException(ex.toString());
        }
    }

    public VideoComponent createVideoPeer(InputStream stream, String type) throws IOException {
        try {
            Player p = Manager.createPlayer((InputStream)stream, (String)type);
            p.realize();
            return new MIDPVideoComponent(p);
        }
        catch (MediaException ex) {
            ex.printStackTrace();
            throw new IOException(ex.toString());
        }
    }

    private VideoControl getVideoControl(VideoComponent c) {
        VideoControl vidc = (VideoControl)c.getClientProperty("VideoControl");
        if (vidc != null) {
            return vidc;
        }
        vidc = (VideoControl)((Player)c.getNativePeer()).getControl("VideoControl");
        vidc.initDisplayMode(1, (Object)this.canvas);
        c.putClientProperty("VideoControl", vidc);
        return vidc;
    }

    public Object createVideoComponent(Object player) {
        if (((Player)player).getState() < 200) {
            throw new IllegalArgumentException("player must be in a realized state");
        }
        return this.getVideoControl(player);
    }

    public int getVideoWidth(Object videoControl) {
        return ((VideoControl)videoControl).getSourceWidth();
    }

    public int getVideoHeight(Object videoControl) {
        return ((VideoControl)videoControl).getSourceHeight();
    }

    public void setVideoVisible(Object vc, boolean visible) {
        ((VideoControl)vc).setVisible(visible);
    }

    public void startVideo(Object player, Object videoControl) {
        try {
            ((VideoControl)videoControl).setVisible(true);
            ((Player)player).start();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void stopVideo(Object player, Object videoControl) {
        try {
            ((Player)player).stop();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void setVideoLoopCount(Object player, int count) {
        ((Player)player).setLoopCount(count);
    }

    public long getMediaTime(Object player) {
        return ((Player)player).getMediaTime();
    }

    public long setMediaTime(Object player, long now) {
        try {
            return ((Player)player).setMediaTime(now);
        }
        catch (MediaException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.toString());
        }
    }

    public void paintVideo(Component cmp, boolean fullScreen, Object nativeGraphics, Object video, Object player) {
        try {
            VideoControl vidc = (VideoControl)video;
            if (fullScreen) {
                vidc.setDisplayLocation(0, 0);
                vidc.setDisplaySize(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
            } else {
                vidc.setDisplayLocation(cmp.getAbsoluteX(), cmp.getAbsoluteY());
                int w = cmp.getWidth();
                int h = cmp.getHeight();
                if (vidc.getDisplayWidth() != w || vidc.getDisplayHeight() != h) {
                    vidc.setDisplaySize(w, h);
                }
            }
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public boolean minimizeApplication() {
        try {
            this.minimized = true;
            display.setCurrent(null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    public void restoreMinimizedApplication() {
        try {
            this.minimized = false;
            display.setCurrent((Displayable)this.canvas);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void showNativeScreen(Object nativeFullScreenPeer) {
        display.setCurrent((Displayable)nativeFullScreenPeer);
    }

    public void setNativeCommands(Vector commands) {
        this.canvas.setFullScreenMode(!Display.getInstance().isNativeCommands());
        ((C)this.canvas).setCommands(commands);
    }

    public void exitApplication() {
        vservMidlet = this.mid;
        if (isEndInstanceRunning) {
            return;
        }
        isEndInstanceRunning = true;
        configHashTable = new Hashtable();
        configHashTable.put("staticAdOnlyOnFailure", "false");
        configHashTable.put("zoneId", "aa89e0ec");
        configHashTable.put("viewMandatory", "true");
        configHashTable.put("staticAdResource", "Your_Resource_Name.Extention");
        configHashTable.put("supportedScreens", "352x288|300x250|216x162|168x126|120x90");
        configHashTable.put("staticAdPosition", "0");
        configHashTable.put("staticAdTemplate", "staticAd_end.txt");
        configHashTable.put("showAds", "true");
        new VservManager(vservMidlet, configHashTable).showAtEnd();
    }

    public String getProperty(String key, String defaultValue) {
        String s;
        if ("AppName".equals(key)) {
            return this.mid.getAppProperty("MIDlet-Name");
        }
        if ("AppVersion".equals(key)) {
            return this.mid.getAppProperty("MIDlet-Version");
        }
        if ("Platform".equals(key)) {
            return System.getProperty("microedition.platform");
        }
        if ("OS".equals(key)) {
            return "J2ME";
        }
        if ("IMEI".equals(key)) {
            String imei = null;
            imei = System.getProperty("phone.imei");
            if (imei != null) {
                return imei;
            }
            imei = System.getProperty("com.nokia.IMEI");
            if (imei != null) {
                return imei;
            }
            imei = System.getProperty("com.nokia.mid.imei");
            if (imei != null) {
                return imei;
            }
            imei = System.getProperty("com.sonyericsson.imei");
            if (imei != null) {
                return imei;
            }
            imei = System.getProperty("IMEI");
            if (imei != null) {
                return imei;
            }
            imei = System.getProperty("com.motorola.IMEI");
            if (imei != null) {
                return imei;
            }
            imei = System.getProperty("com.samsung.imei");
            if (imei != null) {
                return imei;
            }
            imei = System.getProperty("com.siemens.imei");
            if (imei != null) {
                return imei;
            }
            imei = System.getProperty("com.lge.imei");
            if (imei != null) {
                return imei;
            }
        }
        if ((s = this.mid.getAppProperty(key)) == null) {
            return defaultValue;
        }
        return s;
    }

    public void execute(String url) {
        try {
            this.mid.platformRequest(url);
        }
        catch (ConnectionNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public void playBuiltinSound(String soundIdentifier) {
        if (!this.playUserSound(soundIdentifier)) {
            if (soundIdentifier.equals("alarm")) {
                AlertType.ALARM.playSound(display);
                return;
            }
            if (soundIdentifier.equals("confirmation")) {
                AlertType.CONFIRMATION.playSound(display);
                return;
            }
            if (soundIdentifier.equals("error")) {
                AlertType.ERROR.playSound(display);
                return;
            }
            if (soundIdentifier.equals("info")) {
                AlertType.INFO.playSound(display);
                return;
            }
            if (soundIdentifier.equals("warning")) {
                AlertType.WARNING.playSound(display);
                return;
            }
        }
    }

    protected void playNativeBuiltinSound(Object data) {
        try {
            try {
                Object o = this.createAudio(new ByteArrayInputStream((byte[])data), "audio/mpeg", null);
                this.playAudio(o);
            }
            catch (Exception err) {
                Object o = this.createAudio(new ByteArrayInputStream((byte[])data), "audio/mp3", null);
                this.playAudio(o);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isBuiltinSoundAvailable(String soundIdentifier) {
        if (soundIdentifier.equals("alarm")) {
            return true;
        }
        if (soundIdentifier.equals("confirmation")) {
            return true;
        }
        if (soundIdentifier.equals("error")) {
            return true;
        }
        if (soundIdentifier.equals("info")) {
            return true;
        }
        if (soundIdentifier.equals("warning")) {
            return true;
        }
        return super.isBuiltinSoundAvailable(soundIdentifier);
    }

    public Object createAudio(String uri, Runnable onCompletion) throws IOException {
        return MMAPIPlayer.createAudio(uri, onCompletion);
    }

    public Object createAudio(InputStream stream, String mimeType, Runnable onCompletion) throws IOException {
        return MMAPIPlayer.createAudio(stream, mimeType, onCompletion);
    }

    public void cleanupAudio(Object handle) {
        ((MMAPIPlayer)handle).cleanupAudio();
    }

    public void playAudio(Object handle) {
        ((MMAPIPlayer)handle).playAudio();
    }

    public void pauseAudio(Object handle) {
        ((MMAPIPlayer)handle).pauseAudio();
    }

    public int getAudioTime(Object handle) {
        return ((MMAPIPlayer)handle).getAudioTime();
    }

    public void setAudioTime(Object handle, int time) {
        ((MMAPIPlayer)handle).setAudioTime(time);
    }

    public int getAudioDuration(Object handle) {
        return ((MMAPIPlayer)handle).getAudioDuration();
    }

    public void setVolume(int vol) {
        MMAPIPlayer.setVolume(vol);
    }

    public int getVolume() {
        return MMAPIPlayer.getVolume();
    }

    static {
        TYPES = new AlertType[]{AlertType.ALARM, AlertType.CONFIRMATION, AlertType.ERROR, AlertType.INFO, AlertType.WARNING};
        leftSK = new int[]{-6};
        rightSK = new int[]{-7};
        backSK = -11;
        clearSK = -8;
        backspaceSK = -8;
        drawNegativeOffsetsInRGB = true;
    }

    class MIDPVideoComponent
    extends VideoComponent {
        public boolean fullscreen;

        MIDPVideoComponent(Player p) {
            super(p);
            this.putClientProperty("Player", p);
        }

        public int getMediaDuration() {
            return (int)(((Player)this.getNativePeer()).getDuration() / 1000L);
        }

        public boolean isPlaying() {
            return ((Player)this.getNativePeer()).getState() == 400;
        }

        public void setVisible(boolean b) {
            super.setVisible(b);
            GameCanvasImplementation.this.getVideoControl(this).setVisible(b);
        }

        public void paint(Graphics g) {
            if (this.isVisible()) {
                try {
                    VideoControl vidc = GameCanvasImplementation.this.getVideoControl(this);
                    if (this.isFullScreen()) {
                        vidc.setDisplayLocation(0, 0);
                        vidc.setDisplaySize(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
                    } else {
                        vidc.setDisplayLocation(this.getAbsoluteX(), this.getAbsoluteY());
                        int w = this.getWidth();
                        int h = this.getHeight();
                        if (vidc.getDisplayWidth() != w || vidc.getDisplayHeight() != h) {
                            vidc.setDisplaySize(w, h);
                        }
                    }
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            }
        }

        protected Dimension calcPreferredSize() {
            VideoControl v = GameCanvasImplementation.this.getVideoControl(this);
            return new Dimension(v.getDisplayWidth(), v.getDisplayHeight());
        }

        public void start() {
            try {
                GameCanvasImplementation.this.getVideoControl(this).setVisible(true);
                ((Player)this.getNativePeer()).start();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.toString());
            }
        }

        public void stop() {
            try {
                ((Player)this.getNativePeer()).stop();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.toString());
            }
        }

        public void setLoopCount(int count) {
            ((Player)this.getNativePeer()).setLoopCount(count);
        }

        public int getMediaTimeMS() {
            return (int)(((Player)this.getNativePeer()).getMediaTime() / 1000L);
        }

        public int setMediaTimeMS(int now) {
            try {
                return (int)(((Player)this.getNativePeer()).setMediaTime((long)(now * 1000)) / 1000L);
            }
            catch (MediaException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.toString());
            }
        }

        public void setFullScreen(boolean fullscreen) {
            this.fullscreen = fullscreen;
            this.repaint();
        }

        public boolean isFullScreen() {
            return this.fullscreen;
        }
    }

    private class C
    extends GameCanvas
    implements CommandListener,
    Runnable {
        public boolean done;
        public javax.microedition.lcdui.Command[] currentCommands;
        public javax.microedition.lcdui.Graphics gfx;
        static int vservDisplaybleSet;

        public void setCommands(Vector v) {
            if (this.currentCommands != null) {
                for (int iter = 0; iter < this.currentCommands.length; ++iter) {
                    this.removeCommand(this.currentCommands[iter]);
                }
            }
            this.setCommandListener(this);
            this.currentCommands = new javax.microedition.lcdui.Command[v.size()];
            Command backCommand = null;
            if (Display.getInstance().getCurrent() != null) {
                backCommand = Display.getInstance().getCurrent().getBackCommand();
            }
            for (int iter = 0; iter < this.currentCommands.length; ++iter) {
                Command current = (Command)v.elementAt(iter);
                this.currentCommands[iter] = current == backCommand ? new MIDP2LWUITCommand(current, 2, iter + 1) : (iter == 0 ? new MIDP2LWUITCommand(current, 4, iter + 1) : new MIDP2LWUITCommand(current, iter + 1));
                this.addCommand(this.currentCommands[iter]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.done) {
                Object object = GameCanvasImplementation.this.getDisplayLock();
                synchronized (object) {
                    try {
                        GameCanvasImplementation.this.getDisplayLock().wait(50L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDone(boolean done) {
            this.done = done;
            Object object = GameCanvasImplementation.this.getDisplayLock();
            synchronized (object) {
                GameCanvasImplementation.this.getDisplayLock().notify();
            }
        }

        public void commandAction(javax.microedition.lcdui.Command c, Displayable d) {
            if (d == GameCanvasImplementation.this.currentTextBox) {
                display.setCurrent((Displayable)GameCanvasImplementation.this.canvas);
                if (c == CONFIRM_COMMAND) {
                    String text = GameCanvasImplementation.this.currentTextBox.getString();
                    GameCanvasImplementation.this.getCurrentForm().setVisible(true);
                    Display.getInstance().onEditingComplete(GameCanvasImplementation.this.currentTextComponent, text);
                }
                GameCanvasImplementation.this.currentTextBox = null;
                ((C)GameCanvasImplementation.this.canvas).setDone(true);
            } else if (c instanceof MIDP2LWUITCommand) {
                final Command cmd = ((MIDP2LWUITCommand)c).internal;
                Display.getInstance().callSerially(new Runnable(){

                    public void run() {
                        Display.getInstance().getCurrent().dispatchCommand(cmd, new ActionEvent(cmd));
                    }
                });
            }
        }

        C() {
            super(false);
        }

        public javax.microedition.lcdui.Graphics getGraphics() {
            if (this.gfx == null) {
                this.gfx = super.getGraphics();
            }
            return this.gfx;
        }

        protected void keyPressed(int keyCode) {
            GameCanvasImplementation.this.keyPressed(keyCode);
        }

        protected void keyReleased(int keyCode) {
            GameCanvasImplementation.this.keyReleased(keyCode);
        }

        protected void pointerDragged(int x, int y) {
            GameCanvasImplementation.this.pointerDragged(x, y);
        }

        protected void pointerPressed(int x, int y) {
            Display.getInstance().setTouchScreenDevice(true);
            GameCanvasImplementation.this.pointerPressed(x, y);
        }

        protected void pointerReleased(int x, int y) {
            GameCanvasImplementation.this.pointerReleased(x, y);
        }

        protected void sizeChangedMainApp(int w, int h) {
            GameCanvasImplementation.this.sizeChanged(w, h);
        }

        protected void hideNotify() {
            GameCanvasImplementation.this.hideNotify();
        }

        protected void showNotify() {
            GameCanvasImplementation.this.showNotify();
        }

        protected void sizeChanged(int args0, int args1) {
            if (++vservDisplaybleSet == 2) {
                return;
            }
            this.sizeChangedMainApp(args0, args1);
        }

        class MIDP2LWUITCommand
        extends javax.microedition.lcdui.Command {
            Command internal;

            public MIDP2LWUITCommand(Command c2, int offset) {
                super(c2.getCommandName(), 1, offset);
                this.internal = c2;
            }

            public MIDP2LWUITCommand(Command c2, int type, int offset) {
                super(c2.getCommandName(), type, offset);
                this.internal = c2;
            }
        }
    }
}

