/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.list.DefaultListCellRenderer;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Vector;

public class List
extends Component {
    public static final int FIXED_NONE = 0;
    public static final int FIXED_NONE_CYCLIC = 1;
    public static final int FIXED_NONE_ONE_ELEMENT_MARGIN_FROM_EDGE = 2;
    public static final int FIXED_NONE_BOUNDRY = 9;
    public static final int FIXED_LEAD = 10;
    public static final int FIXED_TRAIL = 11;
    public static final int FIXED_CENTER = 12;
    Style spinnerOverlay;
    public Object renderingPrototype;
    public int fixedSelection;
    public ListModel model;
    public ListCellRenderer renderer = new DefaultListCellRenderer();
    public int orientation = 0;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    static final int COMBO = 2;
    EventDispatcher dispatcher = new EventDispatcher();
    Object eventSource = this;
    public Dimension elemSize;
    public Dimension selectedElemSize;
    public boolean inputOnFocus = true;
    public boolean numericKeyActions = true;
    public boolean paintFocusBehindList = true;
    public int listSizeCalculationSampleCount = 5;
    public int minElementHeight = 0;
    public int itemGap = 2;
    public Listeners listener;
    public int animationPosition;
    public int fixedDraggedAnimationPosition;
    public int fixedDraggedPosition;
    public Motion fixedDraggedMotion;
    public int destination;
    public Motion listMotion;
    public static boolean defaultFireOnClick = true;
    public boolean fireOnClick = defaultFireOnClick;
    public boolean fireOnRelease;
    public int fixedDraggedSelection = 0;
    public boolean commandList;
    public static boolean defaultIgnoreFocusComponentWhenUnfocused = true;
    public boolean ignoreFocusComponentWhenUnfocused = defaultIgnoreFocusComponentWhenUnfocused;
    boolean disposeDialogOnSelection;
    public boolean mutableRendererBackgrounds;
    public boolean scrollToSelected = true;
    public Label hintLabel;

    public static boolean isDefaultIgnoreFocusComponentWhenUnfocused() {
        return defaultIgnoreFocusComponentWhenUnfocused;
    }

    public static void setDefaultIgnoreFocusComponentWhenUnfocused(boolean aDefaultIgnoreFocusComponentWhenUnfocused) {
        defaultIgnoreFocusComponentWhenUnfocused = aDefaultIgnoreFocusComponentWhenUnfocused;
    }

    public static boolean isDefaultFireOnClick() {
        return defaultFireOnClick;
    }

    public static void setDefaultFireOnClick(boolean aDefaultFireOnClick) {
        defaultFireOnClick = aDefaultFireOnClick;
    }

    public List(Vector items) {
        this(new DefaultListModel(items));
    }

    public List(Object[] items) {
        this(new DefaultListModel(items));
    }

    public List() {
        this(new DefaultListModel());
    }

    public List(ListModel model) {
        this.setUIID("List");
        this.setModel(model);
        LookAndFeel laf = UIManager.getInstance().getLookAndFeel();
        this.setSmoothScrolling(laf.isDefaultSmoothScrolling());
        this.fixedSelection = UIManager.getInstance().getThemeConstant("fixedSelectionInt", this.fixedSelection);
    }

    void initComponentImpl() {
        this.dataChanged(0, 0);
        this.bindListeners();
        super.initComponentImpl();
        int index = this.model.getSelectedIndex();
        if (index >= 0) {
            this.model.setSelectedIndex(index);
            this.selectElement(index);
        }
    }

    protected void laidOut() {
        int index;
        super.laidOut();
        if (this.isScrollable() && this.isInitialized() && this.scrollToSelected && (index = this.model.getSelectedIndex()) >= 0) {
            this.selectElement(index);
        }
    }

    void deinitializeImpl() {
        super.deinitializeImpl();
        if (this.listener != null) {
            this.model.removeDataChangedListener(this.listener);
            this.model.removeSelectionListener(this.listener);
            this.listener = null;
        }
    }

    protected void modelChanged(int status, int index) {
    }

    protected void listSelectionChanged(int oldSelected, int newSelected) {
    }

    public int getSideGap() {
        if (this.isScrollVisible() && this.orientation != 1) {
            return UIManager.getInstance().getLookAndFeel().getVerticalScrollWidth();
        }
        return 0;
    }

    public boolean isScrollableY() {
        return (this.getScrollDimension().getHeight() > this.getHeight() || this.isAlwaysTensile()) && this.getHeight() > 0 && this.fixedSelection < 9 && this.orientation != 1;
    }

    public boolean isScrollableX() {
        return this.getScrollDimension().getWidth() > this.getWidth() && this.fixedSelection < 9 && this.orientation == 1;
    }

    public int getMinElementHeight() {
        return this.minElementHeight;
    }

    public void setMinElementHeight(int minElementHeight) {
        this.minElementHeight = minElementHeight;
    }

    public int size() {
        return this.model.getSize();
    }

    private int getCurrentSelected() {
        if (this.fixedSelection > 9 && this.isDragActivated()) {
            return this.fixedDraggedSelection;
        }
        return this.model.getSelectedIndex();
    }

    public int getSelectedIndex() {
        return this.model.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.setSelectedIndex(index, true);
    }

    protected Rectangle getVisibleBounds() {
        Rectangle pos = new Rectangle();
        Dimension rendererSize = this.getElementSize(false, true);
        Style style = this.getStyle();
        int width = this.getWidth() - style.getPadding(this.isRTL(), 3) - style.getPadding(this.isRTL(), 1) - this.getSideGap();
        this.calculateComponentPosition(this.getCurrentSelected(), width, pos, rendererSize, this.getElementSize(true, true), true);
        pos.setX(pos.getX() + this.getX());
        pos.setY(pos.getY() + this.getY());
        return pos;
    }

    public void setSelectedIndex(int index, boolean scrollToSelection) {
        if (index < 0) {
            throw new IllegalArgumentException("Selection index is negative:" + index);
        }
        this.model.setSelectedIndex(index);
        if (scrollToSelection && this.isInitialized()) {
            this.selectElement(index);
        }
    }

    public Object getSelectedItem() {
        int idx = this.model.getSelectedIndex();
        if (idx < this.model.getSize() && idx > -1) {
            return this.model.getItemAt(idx);
        }
        return null;
    }

    public void setSelectedItem(Object item) {
        int size = this.model.getSize();
        for (int iter = 0; iter < size; ++iter) {
            Object current = this.model.getItemAt(iter);
            if (current != item && (current == null || !current.equals(item))) continue;
            this.model.setSelectedIndex(iter);
            break;
        }
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setShouldCalcPreferredSize(boolean shouldCalcPreferredSize) {
        super.setShouldCalcPreferredSize(shouldCalcPreferredSize);
        this.elemSize = null;
        this.selectedElemSize = null;
        if (shouldCalcPreferredSize) {
            Object val;
            ListCellRenderer r = this.getRenderer();
            if (this.renderingPrototype != null) {
                val = this.renderingPrototype;
            } else if (this.getModel().getSize() > 0) {
                val = this.getModel().getItemAt(0);
            } else {
                return;
            }
            Component c = r.getListCellRendererComponent(this, val, 0, false);
            c.setShouldCalcPreferredSize(shouldCalcPreferredSize);
            c = r.getListCellRendererComponent(this, val, 0, true);
            c.setShouldCalcPreferredSize(shouldCalcPreferredSize);
        }
    }

    void dataChanged(int status, int index) {
        this.setShouldCalcPreferredSize(true);
        if (this.getSelectedIndex() >= this.model.getSize()) {
            this.setSelectedIndex(Math.max(this.model.getSize() - 1, 0));
        }
        this.modelChanged(status, index);
        this.repaint();
    }

    private void bindListeners() {
        if (this.listener == null) {
            this.listener = new Listeners();
            this.model.addDataChangedListener(this.listener);
            this.model.addSelectionListener(this.listener);
        }
    }

    public void setModel(ListModel model) {
        if (this.model != null) {
            this.setShouldCalcPreferredSize(true);
            this.model.removeDataChangedListener(this.listener);
            this.model.removeSelectionListener(this.listener);
            this.model = model;
            this.listener = null;
            if (this.getScrollDimension().getHeight() < this.getScrollY() + this.getHeight()) {
                this.setScrollY(0);
            }
            if (this.getScrollDimension().getWidth() < this.getScrollX() + this.getWidth()) {
                this.setScrollX(0);
            }
        }
        this.model = model;
        if (this.isInitialized()) {
            this.bindListeners();
        }
        this.repaint();
    }

    public boolean isNumericKeyActions() {
        return this.numericKeyActions;
    }

    public void setNumericKeyActions(boolean numericKeyActions) {
        this.numericKeyActions = numericKeyActions;
    }

    public boolean isCommandList() {
        return this.commandList;
    }

    public void setCommandList(boolean commandList) {
        this.commandList = commandList;
    }

    public boolean isIgnoreFocusComponentWhenUnfocused() {
        return this.ignoreFocusComponentWhenUnfocused;
    }

    public void setIgnoreFocusComponentWhenUnfocused(boolean ignoreFocusComponentWhenUnfocused) {
        this.ignoreFocusComponentWhenUnfocused = ignoreFocusComponentWhenUnfocused;
    }

    public boolean isMutableRendererBackgrounds() {
        return this.mutableRendererBackgrounds;
    }

    public void setMutableRendererBackgrounds(boolean mutableRendererBackgrounds) {
        this.mutableRendererBackgrounds = mutableRendererBackgrounds;
    }

    public int getListSizeCalculationSampleCount() {
        return this.listSizeCalculationSampleCount;
    }

    public void setListSizeCalculationSampleCount(int listSizeCalculationSampleCount) {
        this.listSizeCalculationSampleCount = listSizeCalculationSampleCount;
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.setListCellRenderer(renderer);
    }

    public void setListCellRenderer(ListCellRenderer renderer) {
        if (this.renderer != null) {
            this.elemSize = null;
            this.selectedElemSize = null;
            this.setShouldCalcPreferredSize(true);
        }
        this.renderer = renderer;
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void refreshTheme() {
        this.fixedSelection = UIManager.getInstance().getThemeConstant("fixedSelectionInt", this.fixedSelection);
        this.itemGap = UIManager.getInstance().getThemeConstant("listItemGapInt", this.itemGap);
        ListCellRenderer r = this.getRenderer();
        if (this.renderingPrototype != null) {
            r.getListCellRendererComponent(this, this.renderingPrototype, 0, false).refreshTheme();
        } else if (this.getModel().getSize() > 0) {
            r.getListCellRendererComponent(this, this.getModel().getItemAt(0), 0, false).refreshTheme();
        } else {
            r.getListCellRendererComponent(this, "", 0, false).refreshTheme();
        }
        Component focus = r.getListFocusComponent(this);
        if (focus != null) {
            focus.refreshTheme();
        }
        super.refreshTheme();
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public void scrollRectToVisible(Rectangle rect) {
        if (this.fixedSelection < 9) {
            Rectangle toScroll = this.orientation != 1 ? new Rectangle(this.getScrollX(), rect.getY(), rect.getSize().getWidth(), rect.getSize().getHeight() + this.itemGap) : new Rectangle(rect.getX(), this.getScrollY(), rect.getSize().getWidth() + this.itemGap, rect.getSize().getHeight());
            super.scrollRectToVisible(toScroll, this);
        }
    }

    public void setHandlesInput(boolean b) {
        Form f = this.getComponentForm();
        if (f != null) {
            super.setHandlesInput(b || f.isSingleFocusMode());
        } else {
            super.setHandlesInput(b);
        }
    }

    void setHandlesInputParent(boolean b) {
        super.setHandlesInput(b);
    }

    protected void fireClicked() {
        boolean h = this.handlesInput();
        this.setHandlesInput(!h);
        if (h) {
            this.fireActionEvent();
        }
        this.repaint();
    }

    protected boolean isSelectableInteraction() {
        return true;
    }

    public void keyReleased(int keyCode) {
        int offset;
        int gameAction = Display.getInstance().getGameAction(keyCode);
        if (gameAction == 8) {
            boolean h = this.handlesInput();
            this.setHandlesInput(!h);
            if (h) {
                this.fireActionEvent();
            }
            this.repaint();
            return;
        }
        if (this.numericKeyActions && gameAction != 2 && gameAction != 5 && gameAction != 1 && gameAction != 6 && keyCode >= 49 && keyCode <= 57 && (offset = keyCode - 49) < this.getModel().getSize()) {
            this.setSelectedIndex(offset);
            this.fireActionEvent();
        }
    }

    public void keyPressed(int keyCode) {
        int keyBck;
        int keyFwd;
        if (!this.handlesInput()) {
            return;
        }
        int gameAction = Display.getInstance().getGameAction(keyCode);
        if (this.getOrientation() != 1) {
            keyFwd = 6;
            keyBck = 1;
            if (gameAction == 2 || gameAction == 5) {
                this.setHandlesInput(false);
            }
        } else {
            if (this.isRTL()) {
                keyFwd = 2;
                keyBck = 5;
            } else {
                keyFwd = 5;
                keyBck = 2;
            }
            if (gameAction == 6 || gameAction == 1) {
                this.setHandlesInput(false);
            }
        }
        int selectedIndex = this.model.getSelectedIndex();
        if (gameAction == keyBck) {
            if (--selectedIndex < 0) {
                if (this.fixedSelection != 0 && this.fixedSelection != 2) {
                    selectedIndex = this.size() - 1;
                } else {
                    selectedIndex = 0;
                    this.setHandlesInput(false);
                }
            }
        } else if (gameAction == keyFwd && ++selectedIndex >= this.size()) {
            if (this.fixedSelection != 0 && this.fixedSelection != 2) {
                selectedIndex = 0;
            } else {
                selectedIndex = this.size() - 1;
                this.setHandlesInput(false);
            }
        }
        if (selectedIndex != this.model.getSelectedIndex()) {
            int direction;
            this.model.setSelectedIndex(selectedIndex);
            int n = direction = gameAction == keyFwd ? 1 : -1;
            if (this.isRTL() && this.getOrientation() == 1) {
                direction = -direction;
            }
            this.updateAnimationPosition(direction);
            if (this.fixedSelection == 0 || this.fixedSelection == 1) {
                this.selectElement(selectedIndex);
            }
            if (this.fixedSelection == 2) {
                if (keyFwd == gameAction) {
                    this.selectElement(Math.min(selectedIndex + 1, this.getModel().getSize() - 1));
                } else {
                    this.selectElement(Math.max(selectedIndex - 1, 0));
                }
            }
        }
        this.repaint();
    }

    void selectElement(int selectedIndex) {
        Rectangle rect;
        Dimension size = this.getElementSize(false, true);
        if (this.getOrientation() != 1) {
            rect = new Rectangle(this.getX(), (size.getHeight() + this.itemGap) * selectedIndex, this.getElementSize(true, true));
        } else {
            int x = (size.getWidth() + this.itemGap) * selectedIndex;
            if (this.isRTL() && this.isScrollableX()) {
                x = this.getScrollDimension().getWidth() - x - (size.getWidth() + this.itemGap);
            }
            rect = new Rectangle(x, this.getY(), this.getElementSize(true, true));
        }
        if (this.hasScrollableParent(this.getParent())) {
            if (this.hasFocus()) {
                this.scrollRectToVisible(rect);
            }
        } else {
            this.scrollRectToVisible(rect);
        }
    }

    private boolean hasScrollableParent(Container c) {
        if (c == null) {
            return false;
        }
        if (c.isScrollable()) {
            return true;
        }
        return this.hasScrollableParent(c.getParent());
    }

    private void updateAnimationPosition(int direction) {
        if (this.animationPosition != 0) {
            this.animationPosition = 0;
            this.animate();
        }
        if (this.isSmoothScrolling()) {
            this.animationPosition = this.orientation != 1 ? (this.animationPosition += direction * this.getElementSize(false, true).getHeight()) : (this.animationPosition += direction * this.getElementSize(false, true).getWidth());
            this.destination = Math.abs(this.animationPosition);
            this.initListMotion();
        }
    }

    private void initListMotion() {
        Form p = this.getComponentForm();
        if (p != null) {
            p.registerAnimatedInternal(this);
        }
        this.listMotion = Motion.createSplineMotion(0, this.destination, this.getScrollAnimationSpeed());
        this.listMotion.start();
    }

    private void calculateComponentPosition(int index, int defaultWidth, Rectangle rect, Dimension rendererSize, Dimension selectedSize, boolean beforeSelected) {
        Style style = this.getStyle();
        int initialY = style.getPadding(false, 0);
        int initialX = style.getPadding(false, 1);
        boolean rtl = this.isRTL();
        if (rtl) {
            initialX += this.getSideGap();
        }
        int selection = this.getCurrentSelected();
        Dimension d = rect.getSize();
        if (this.orientation != 1) {
            int height = rendererSize.getHeight();
            int selectedDiff = selectedSize.getHeight() - height;
            rect.setX(initialX);
            d.setHeight(height);
            d.setWidth(defaultWidth);
            int y = 0;
            int listHeight = this.getHeight() - style.getPadding(false, 0) - style.getPadding(false, 2);
            int totalHeight = (height + this.itemGap) * this.getModel().getSize() + selectedDiff;
            switch (this.fixedSelection) {
                case 12: {
                    y = listHeight / 2 - (height + this.itemGap + selectedDiff) / 2 + (index - selection) * (height + this.itemGap);
                    if (!beforeSelected) {
                        y += selectedDiff;
                    }
                    y = this.recalcOffset(y, totalHeight, listHeight, height + this.itemGap);
                    break;
                }
                case 11: {
                    y = listHeight - (height + this.itemGap + selectedDiff);
                }
                case 10: {
                    y += (index - selection) * (height + this.itemGap);
                    if (index - selection > 0) {
                        y += selectedDiff;
                    }
                    y = this.recalcOffset(y, totalHeight, listHeight, height + this.itemGap);
                    break;
                }
                default: {
                    y = index * (height + this.itemGap);
                    if (beforeSelected) break;
                    y += selectedDiff;
                }
            }
            rect.setY(y + initialY);
            if (index == selection) {
                d.setHeight(d.getHeight() + selectedDiff);
            }
        } else {
            int width = rendererSize.getWidth();
            int selectedDiff = selectedSize.getWidth() - width;
            rect.setY(initialY);
            d.setHeight(this.getHeight() - style.getPadding(false, 0) - style.getPadding(false, 2));
            d.setWidth(width);
            int x = 0;
            int listWidth = this.getWidth() - style.getPadding(this.isRTL(), 3) - style.getPadding(this.isRTL(), 1);
            int totalWidth = (width + this.itemGap) * this.getModel().getSize() + selectedDiff;
            switch (this.fixedSelection) {
                case 12: {
                    x = listWidth / 2 - (width + this.itemGap + selectedDiff) / 2 + (index - selection) * (width + this.itemGap);
                    if (!beforeSelected) {
                        x += selectedDiff;
                    }
                    if (rtl) {
                        x = listWidth - x - width;
                    }
                    x = this.recalcOffset(x, totalWidth, listWidth, width + this.itemGap);
                    break;
                }
                case 11: {
                    x = listWidth - (width + this.itemGap + selectedDiff);
                }
                case 10: {
                    x += (index - selection) * (width + this.itemGap);
                    if (index - selection > 0) {
                        x += selectedDiff;
                    }
                    if (rtl) {
                        x = listWidth - x - width;
                    }
                    x = this.recalcOffset(x, totalWidth, listWidth, width + this.itemGap);
                    break;
                }
                default: {
                    x = index * (width + this.itemGap);
                    if (beforeSelected) break;
                    x += selectedDiff;
                }
            }
            int rectX = initialX + x;
            if (rtl && this.fixedSelection < 9) {
                rectX = initialX + totalWidth - (x - initialX) - (width + this.itemGap);
                if (index == this.getCurrentSelected()) {
                    rectX -= selectedDiff;
                }
                if (totalWidth < listWidth) {
                    rectX += listWidth - totalWidth;
                }
            }
            rect.setX(rectX);
            if (index == selection) {
                d.setWidth(d.getWidth() + selectedDiff);
            }
        }
    }

    private int recalcOffset(int offset, int totalSize, int viewSize, int componentSize) {
        if (offset + this.animationPosition % componentSize + this.fixedDraggedAnimationPosition % componentSize >= viewSize) {
            offset -= totalSize;
        } else if (offset + this.animationPosition % componentSize + this.fixedDraggedAnimationPosition % componentSize < 1 - componentSize) {
            offset += totalSize;
        }
        return offset;
    }

    public void paint(Graphics g) {
        int numOfcomponents;
        UIManager.getInstance().getLookAndFeel().drawList(g, this);
        Style style = this.getStyle();
        int width = this.getWidth() - style.getPadding(this.isRTL(), 3) - style.getPadding(this.isRTL(), 1) - this.getSideGap();
        if (this.isScrollableX()) {
            width = Math.max(width, this.getScrollDimension().getWidth() - style.getPadding(this.isRTL(), 3) - style.getPadding(this.isRTL(), 1) - this.getSideGap());
        }
        if ((numOfcomponents = this.model.getSize()) == 0) {
            this.paintHint(g);
            return;
        }
        int xTranslate = this.getX();
        int yTranslate = this.getY();
        g.translate(xTranslate, yTranslate);
        Rectangle pos = new Rectangle();
        Dimension rendererSize = this.getElementSize(false, true);
        if (this.fixedSelection > 9 && (this.animationPosition != 0 || this.isDragActivated())) {
            if (this.orientation != 1) {
                yTranslate += this.animationPosition + this.fixedDraggedAnimationPosition;
                g.translate(0, this.animationPosition + this.fixedDraggedAnimationPosition);
            } else {
                xTranslate += this.animationPosition + this.fixedDraggedAnimationPosition;
                g.translate(this.animationPosition + this.fixedDraggedAnimationPosition, 0);
            }
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        boolean shouldBreak = false;
        int startingPoint = 0;
        if (this.fixedSelection < 9) {
            int startX = clipX + this.getAbsoluteX();
            if (this.isRTL()) {
                startX += this.getWidth();
            }
            startingPoint = Math.max(0, this.pointerSelect(startX, clipY + this.getAbsoluteY()) - 1);
        }
        int startOffset = 0;
        int endOffset = numOfcomponents;
        if (this.mutableRendererBackgrounds) {
            for (int i = startingPoint; i < numOfcomponents; ++i) {
                if (i == this.getCurrentSelected() && this.animationPosition == 0 && this.fixedDraggedAnimationPosition == 0) {
                    if (!shouldBreak) {
                        startOffset = i;
                    }
                    endOffset = i;
                    shouldBreak = true;
                    continue;
                }
                this.calculateComponentPosition(i, width, pos, rendererSize, this.getElementSize(true, true), i <= this.getCurrentSelected());
                if (pos.intersects(clipX, clipY, clipWidth, clipHeight)) {
                    if (!shouldBreak) {
                        startOffset = i;
                    }
                    endOffset = i;
                    Dimension size = pos.getSize();
                    Component selectionCmp = this.renderer.getListCellRendererComponent(this, this.getModel().getItemAt(i), i, i == this.getCurrentSelected());
                    this.renderComponentBackground(g, selectionCmp, pos.getX(), pos.getY(), size.getWidth(), size.getHeight());
                    shouldBreak = true;
                    continue;
                }
                if (!shouldBreak || this.fixedSelection >= 9) {
                    continue;
                }
                break;
            }
        } else {
            Object valueAt0 = this.getModel().getItemAt(0);
            int selectedIndex = this.getSelectedIndex();
            Component selectionCmp = selectedIndex > -1 && selectedIndex < numOfcomponents ? this.renderer.getListCellRendererComponent(this, this.getModel().getItemAt(selectedIndex), 0, true) : this.renderer.getListCellRendererComponent(this, valueAt0, 0, true);
            Component unselectedCmp = this.renderer.getListCellRendererComponent(this, valueAt0, 0, false);
            for (int i = startingPoint; i < numOfcomponents; ++i) {
                if (i == this.getCurrentSelected() && this.animationPosition == 0) {
                    if (!shouldBreak) {
                        startOffset = i;
                    }
                    endOffset = i;
                    shouldBreak = true;
                    continue;
                }
                this.calculateComponentPosition(i, width, pos, rendererSize, this.getElementSize(true, true), i <= this.getCurrentSelected());
                if (pos.intersects(clipX, clipY, clipWidth, clipHeight)) {
                    Dimension size;
                    if (!shouldBreak) {
                        startOffset = i;
                    }
                    endOffset = i;
                    if (i == this.getCurrentSelected()) {
                        size = pos.getSize();
                        this.renderComponentBackground(g, selectionCmp, pos.getX(), pos.getY(), size.getWidth(), size.getHeight());
                    } else {
                        size = pos.getSize();
                        this.renderComponentBackground(g, unselectedCmp, pos.getX(), pos.getY(), size.getWidth(), size.getHeight());
                    }
                    shouldBreak = true;
                    continue;
                }
                if (!shouldBreak || this.fixedSelection >= 9) {
                    continue;
                }
                break;
            }
        }
        boolean shouldRendererSelectedEntry = this.renderer.getListFocusComponent(this) == null && this.fixedSelection < 9 || this.animationPosition == 0 && this.model.getSize() > 0;
        Rectangle selectedPos = new Rectangle();
        this.calculateComponentPosition(this.getCurrentSelected(), width, selectedPos, rendererSize, this.getElementSize(true, true), true);
        Dimension size = selectedPos.getSize();
        if (shouldRendererSelectedEntry) {
            Component selected = this.renderer.getListCellRendererComponent(this, this.model.getItemAt(this.getCurrentSelected()), this.getCurrentSelected(), true);
            this.renderComponentBackground(g, selected, selectedPos.getX(), selectedPos.getY(), size.getWidth(), size.getHeight());
        }
        if (this.paintFocusBehindList) {
            this.paintFocus(g, width, pos, rendererSize);
        }
        for (int i = startOffset; i <= endOffset; ++i) {
            if (i == this.getCurrentSelected() && this.animationPosition == 0) continue;
            this.calculateComponentPosition(i, width, pos, rendererSize, this.getElementSize(true, true), i <= this.getCurrentSelected());
            Object value = this.model.getItemAt(i);
            Component cmp = this.renderer.getListCellRendererComponent(this, value, i, false);
            cmp.setCellRenderer(true);
            Dimension sizeC = pos.getSize();
            this.renderComponent(g, cmp, pos.getX(), pos.getY(), sizeC.getWidth(), sizeC.getHeight());
        }
        if (shouldRendererSelectedEntry) {
            Component selected = this.renderer.getListCellRendererComponent(this, this.model.getItemAt(this.getCurrentSelected()), this.getCurrentSelected(), true);
            this.renderComponent(g, selected, selectedPos.getX(), selectedPos.getY(), size.getWidth(), size.getHeight());
        }
        if (!this.paintFocusBehindList) {
            this.paintFocus(g, width, pos, rendererSize);
        }
        g.translate(-xTranslate, -yTranslate);
        if (this.spinnerOverlay != null) {
            if (this.spinnerOverlay.getBorder() != null) {
                this.spinnerOverlay.getBorder().paintBorderBackground(g, this);
                this.spinnerOverlay.getBorder().paint(g, this);
            } else {
                this.spinnerOverlay.getBgPainter().paint(g, this.getBounds());
            }
        }
    }

    private void paintFocus(Graphics g, int width, Rectangle pos, Dimension rendererSize) {
        if (this.ignoreFocusComponentWhenUnfocused && !this.hasFocus()) {
            return;
        }
        if (!Display.getInstance().shouldRenderSelection(this)) {
            return;
        }
        this.calculateComponentPosition(this.getCurrentSelected(), width, pos, rendererSize, this.getElementSize(true, true), true);
        Dimension size = pos.getSize();
        Component cmp = this.renderer.getListFocusComponent(this);
        if (cmp != null) {
            cmp.setCellRenderer(true);
            int x = pos.getX();
            int y = pos.getY();
            if (this.orientation != 1) {
                y -= this.animationPosition + this.fixedDraggedAnimationPosition;
            } else {
                x -= this.animationPosition + this.fixedDraggedAnimationPosition;
            }
            this.renderComponentBackground(g, cmp, x, y, size.getWidth(), size.getHeight());
            this.renderComponent(g, cmp, x, y, size.getWidth(), size.getHeight());
        }
    }

    private void renderComponent(Graphics g, Component cmp, int x, int y, int width, int height) {
        Style s = cmp.getStyle();
        int left = s.getMargin(this.isRTL(), 1);
        int top = s.getMargin(false, 0);
        cmp.setWidth(width - left - s.getMargin(this.isRTL(), 3));
        cmp.setHeight(height - top - s.getMargin(false, 2));
        cmp.setX(x + left);
        cmp.setY(y + top);
        int oX = g.getClipX();
        int oY = g.getClipY();
        int oWidth = g.getClipWidth();
        int oHeight = g.getClipHeight();
        g.clipRect(cmp.getX(), cmp.getY(), cmp.getWidth(), cmp.getHeight());
        cmp.paint(g);
        Border b = s.getBorder();
        if (b != null && !b.isBackgroundPainter()) {
            cmp.paintBorder(g);
        }
        g.setClip(oX, oY, oWidth, oHeight);
    }

    private void renderComponentBackground(Graphics g, Component cmp, int x, int y, int width, int height) {
        Style s = cmp.getStyle();
        int left = s.getMargin(this.isRTL(), 1);
        int top = s.getMargin(false, 0);
        cmp.setWidth(width - left - s.getMargin(this.isRTL(), 3));
        cmp.setHeight(height - top - s.getMargin(false, 2));
        cmp.setX(x + left);
        cmp.setY(y + top);
        int cX = g.getClipX();
        int cY = g.getClipY();
        int cW = g.getClipWidth();
        int cH = g.getClipHeight();
        g.clipRect(cmp.getX(), cmp.getY(), cmp.getWidth(), cmp.getHeight());
        cmp.paintBackground(g);
        g.setClip(cX, cY, cW, cH);
    }

    public void addSelectionListener(SelectionListener l) {
        this.model.addSelectionListener(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.model.removeSelectionListener(l);
    }

    public void addActionListener(ActionListener l) {
        this.dispatcher.addListener(l);
    }

    public Vector getActionListeners() {
        return this.dispatcher.getListenerVector();
    }

    public void removeActionListener(ActionListener l) {
        this.dispatcher.removeListener(l);
    }

    protected void fireActionEvent() {
        if (this.isEnabled() && !Display.getInstance().hasDragOccured()) {
            Display d;
            Object i;
            if (this.disposeDialogOnSelection) {
                ((Dialog)this.getComponentForm()).dispose();
            }
            super.fireActionEvent();
            ActionEvent a2 = new ActionEvent(this.eventSource);
            this.dispatcher.fireActionEvent(a2);
            if (this.isCommandList() && !a2.isConsumed() && (i = this.getSelectedItem()) != null && i instanceof Command && ((Command)i).isEnabled()) {
                Form f;
                ((Command)i).actionPerformed(a2);
                if (!a2.isConsumed() && (f = this.getComponentForm()) != null) {
                    f.actionCommandImpl((Command)i);
                }
            }
            if ((d = Display.getInstance()).isBuiltinSoundsEnabled()) {
                d.playBuiltinSound("press");
            }
        }
    }

    public void setInputOnFocus(boolean inputOnFocus) {
        this.inputOnFocus = inputOnFocus;
    }

    public void setPaintFocusBehindList(boolean paintFocusBehindList) {
        this.paintFocusBehindList = paintFocusBehindList;
    }

    void focusGainedInternal() {
        super.focusGainedInternal();
        if (this.inputOnFocus) {
            this.setHandlesInput(true);
        }
    }

    void focusLostInternal() {
        super.focusLostInternal();
    }

    public int getItemGap() {
        return this.itemGap;
    }

    public void setItemGap(int itemGap) {
        this.itemGap = itemGap;
    }

    public void setRenderingPrototype(Object renderingPrototype) {
        this.renderingPrototype = renderingPrototype;
    }

    public Object getRenderingPrototype() {
        return this.renderingPrototype;
    }

    Dimension getElementSize(boolean selected, boolean addMargin) {
        if (selected) {
            if (this.selectedElemSize == null) {
                if (this.renderingPrototype == null && this.model.getSize() == 0) {
                    if (addMargin) {
                        return new Label("XXXXXX").getPreferredSizeWithMargin();
                    }
                    return new Label("XXXXXX").getPreferredSize();
                }
                this.selectedElemSize = this.calculateElementSize(true, addMargin);
            }
            return this.selectedElemSize;
        }
        if (this.elemSize == null) {
            if (this.renderingPrototype == null && this.model.getSize() == 0) {
                Label l = new Label("XXXXXX");
                if (addMargin) {
                    return l.getPreferredSizeWithMargin();
                }
                return l.getPreferredSize();
            }
            this.elemSize = this.calculateElementSize(false, addMargin);
        }
        return this.elemSize;
    }

    private Dimension calculateElementSize(boolean selected, boolean addMargin) {
        if (this.renderingPrototype != null) {
            Component unselected = this.renderer.getListCellRendererComponent(this, this.renderingPrototype, 0, selected);
            if (addMargin) {
                return unselected.getPreferredSizeWithMargin();
            }
            return unselected.getPreferredSize();
        }
        int width = 0;
        int height = 0;
        int elements = Math.min(this.listSizeCalculationSampleCount, this.model.getSize());
        int marginY = 0;
        int marginX = 0;
        for (int iter = 0; iter < elements; ++iter) {
            Component cmp = this.renderer.getListCellRendererComponent(this, this.model.getItemAt(iter), iter, selected);
            if (cmp instanceof Container) {
                cmp.setShouldCalcPreferredSize(true);
            }
            Dimension d = cmp.getPreferredSize();
            width = Math.max(width, d.getWidth());
            height = Math.max(height, d.getHeight());
            if (iter != 0) continue;
            Style s = cmp.getStyle();
            marginY = s.getMargin(0) + s.getMargin(2);
            marginX = s.getMargin(1) + s.getMargin(3);
        }
        return new Dimension(width + marginX, height + marginY);
    }

    protected void longPointerPress(int x, int y) {
        int s = this.pointerSelect(x, y);
        if (s > -1) {
            this.model.setSelectedIndex(s);
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.fixedSelection > 9 && this.isSmoothScrolling()) {
            this.fixedDraggedPosition = this.orientation != 1 ? y : x;
            if (this.isDragActivated()) {
                int selected = this.getCurrentSelected();
                this.model.setSelectedIndex(selected);
                this.fixedDraggedMotion = null;
                this.fixedDraggedAnimationPosition = 0;
            }
            this.fixedDraggedSelection = this.getModel().getSelectedIndex();
        }
        this.setDragActivated(false);
        int current = this.model.getSelectedIndex();
        int selection = this.pointerSelect(x, y);
        if (selection > -1 && this.fixedSelection < 9) {
            this.model.setSelectedIndex(selection);
        }
        this.fireOnRelease = current == selection;
        super.pointerPressed(x, y);
    }

    public void pointerHover(int[] x, int[] y) {
        int selection;
        this.clearDrag();
        if (!this.isDragActivated() && (selection = this.pointerSelect(x[0], y[0])) > -1) {
            this.model.setSelectedIndex(selection);
        }
        this.pointerDraggedImpl(x[0], y[0]);
    }

    public void pointerDragged(int x, int y) {
        this.pointerDraggedImpl(x, y);
    }

    private void pointerDraggedImpl(int x, int y) {
        if (this.isSmoothScrolling()) {
            if (this.fixedSelection < 9) {
                super.pointerDragged(x, y);
            } else {
                int s;
                int pos;
                boolean vertical;
                if (!this.isDragActivated()) {
                    this.setDragActivated(true);
                }
                Dimension size = this.getElementSize(false, true);
                boolean bl = vertical = this.orientation == 0;
                if (vertical) {
                    pos = y;
                    s = size.getHeight();
                } else {
                    pos = x;
                    s = size.getWidth();
                }
                this.fixedDraggedAnimationPosition -= this.fixedDraggedPosition - pos;
                this.fixedDraggedPosition = pos;
                if (this.fixedDraggedAnimationPosition <= -s) {
                    ++this.fixedDraggedSelection;
                    if (this.fixedDraggedSelection >= this.model.getSize()) {
                        this.fixedDraggedSelection = 0;
                    }
                } else if (this.fixedDraggedAnimationPosition >= s) {
                    --this.fixedDraggedSelection;
                    if (this.fixedDraggedSelection < 0) {
                        this.fixedDraggedSelection = this.model.getSize() - 1;
                    }
                }
                this.fixedDraggedAnimationPosition %= s;
            }
        } else {
            int sel = this.pointerSelect(x, y);
            if (sel > -1) {
                this.model.setSelectedIndex(sel);
            }
        }
    }

    public Rectangle getSelectedRect() {
        Style style = this.getStyle();
        Rectangle pos = new Rectangle();
        int width = this.getWidth() - style.getPadding(false, 3) - style.getPadding(false, 1) - this.getSideGap();
        Dimension rendererSize = this.getElementSize(false, true);
        this.calculateComponentPosition(this.getSelectedIndex(), width, pos, rendererSize, this.getElementSize(true, true), true);
        pos.setX(pos.getX() + this.getParent().getAbsoluteX());
        pos.setY(pos.getY() + this.getParent().getAbsoluteY());
        return pos;
    }

    private int pointerSelect(int x, int y) {
        int selectedIndex = -1;
        int numOfcomponents = this.getModel().getSize();
        Style style = this.getStyle();
        Dimension rendererSize = this.getElementSize(false, true);
        Dimension selectedSize = this.getElementSize(true, true);
        Rectangle pos = new Rectangle();
        int width = this.getWidth() - style.getPadding(false, 3) - style.getPadding(false, 1) - this.getSideGap();
        if (this.isScrollableX()) {
            width = Math.max(width, this.getScrollDimension().getWidth() - style.getPadding(false, 3) - style.getPadding(false, 1) - this.getSideGap());
        }
        y -= this.getAbsoluteY();
        x -= this.getAbsoluteX();
        if (this.fixedSelection < 9) {
            this.calculateComponentPosition(this.getSelectedIndex(), width, pos, rendererSize, this.getElementSize(true, true), true);
            if (this.orientation != 1) {
                if (y < pos.getY()) {
                    selectedIndex = y / (rendererSize.getHeight() + this.itemGap);
                } else {
                    int current = this.getSelectedIndex();
                    selectedIndex = y < pos.getY() + selectedSize.getHeight() ? current : current + 1 + (y - (pos.getY() + selectedSize.getHeight())) / (rendererSize.getHeight() + this.itemGap);
                }
            } else if (this.isRTL()) {
                if (x > pos.getX() + selectedSize.getWidth()) {
                    int delta = x - (pos.getX() + selectedSize.getWidth());
                    selectedIndex = this.getSelectedIndex() - 1 - (delta /= rendererSize.getWidth() + this.itemGap);
                } else if (x >= pos.getX()) {
                    selectedIndex = this.getSelectedIndex();
                } else {
                    int delta = pos.getX() - x;
                    selectedIndex = this.getSelectedIndex() + 1 + (delta /= rendererSize.getWidth() + this.itemGap);
                }
            } else if (x < pos.getX()) {
                selectedIndex = x / (rendererSize.getWidth() + this.itemGap);
            } else {
                int current = this.getSelectedIndex();
                selectedIndex = x < pos.getX() + selectedSize.getWidth() ? current : current + 1 + (x - (pos.getX() + selectedSize.getWidth())) / (rendererSize.getWidth() + this.itemGap);
            }
        } else {
            for (int i = 0; i < numOfcomponents; ++i) {
                this.calculateComponentPosition(i, width, pos, rendererSize, selectedSize, true);
                if (!pos.contains(x, y)) continue;
                selectedIndex = i;
                break;
            }
        }
        if (selectedIndex < 0 || selectedIndex >= this.size()) {
            return -1;
        }
        return selectedIndex;
    }

    public void setFireOnClick(boolean fireOnClick) {
        this.fireOnClick = fireOnClick;
    }

    public void pointerHoverReleased(int[] x, int[] y) {
        this.pointerReleasedImpl(x[0], y[0], true);
    }

    private void pointerReleasedImpl(int x, int y, boolean isHover) {
        if (this.isDragActivated()) {
            if (this.fixedSelection < 9) {
                super.pointerReleased(x, y);
            } else {
                boolean vertical = this.getOrientation() == 0;
                float speed = Display.getInstance().getDragSpeed(vertical);
                this.fixedDraggedMotion = vertical ? Motion.createFrictionMotion(-this.fixedDraggedAnimationPosition, this.getElementSize(false, true).getHeight() * this.getModel().getSize(), speed, 4.0E-4f) : Motion.createFrictionMotion(-this.fixedDraggedAnimationPosition, this.getElementSize(false, true).getWidth() * this.getModel().getSize(), speed, 4.0E-4f);
                this.fixedDraggedPosition = this.fixedDraggedAnimationPosition;
                Form p = this.getComponentForm();
                if (p != null) {
                    p.registerAnimatedInternal(this);
                }
                this.fixedDraggedMotion.start();
            }
            return;
        }
        if (!isHover && this.pointerSelect(x, y) > -1 && (this.fireOnClick && this.fixedSelection < 9 || this.fireOnRelease)) {
            Component tmp;
            Component selectionCmp = this.renderer.getListCellRendererComponent(this, this.getSelectedItem(), this.getSelectedIndex(), true);
            Style style = this.getStyle();
            int width = this.getWidth() - style.getPadding(this.isRTL(), 3) - style.getPadding(this.isRTL(), 1) - this.getSideGap();
            Rectangle pos = new Rectangle();
            Dimension rendererSize = this.getElementSize(false, true);
            this.calculateComponentPosition(this.getSelectedIndex(), width, pos, rendererSize, this.getElementSize(true, true), true);
            int absX = this.getAbsoluteX();
            int posX = pos.getX();
            int absY = this.getAbsoluteY();
            int posY = pos.getY();
            int newX = x - absX - posX;
            int newY = y - absY - posY;
            selectionCmp.setX(0);
            selectionCmp.setY(0);
            if (selectionCmp instanceof Container && (tmp = ((Container)selectionCmp).getComponentAt(newX, newY)) != null) {
                selectionCmp = tmp;
            }
            selectionCmp.pointerPressed(newX, newY);
            selectionCmp.pointerReleased(newX, newY);
            this.fireActionEvent();
        }
    }

    public void pointerReleased(int x, int y) {
        this.pointerReleasedImpl(x, y, false);
    }

    protected Dimension calcPreferredSize() {
        Label l;
        if (this.shouldShowHint() && (l = this.getHintLabelImpl()) != null) {
            Dimension d1 = UIManager.getInstance().getLookAndFeel().getListPreferredSize(this);
            Dimension d2 = l.getPreferredSize();
            return new Dimension(d1.getWidth() + d2.getWidth(), d1.getHeight() + d2.getHeight());
        }
        Dimension d = UIManager.getInstance().getLookAndFeel().getListPreferredSize(this);
        if (this.spinnerOverlay != null && this.spinnerOverlay.getBorder() != null) {
            d.setWidth(Math.max(this.spinnerOverlay.getBorder().getMinimumWidth(), d.getWidth()));
            d.setHeight(Math.max(this.spinnerOverlay.getBorder().getMinimumHeight(), d.getHeight()));
        }
        return d;
    }

    public void addItem(Object item) {
        this.model.addItem(item);
    }

    public int getFixedSelection() {
        return this.fixedSelection;
    }

    public void setFixedSelection(int fixedSelection) {
        this.fixedSelection = fixedSelection;
    }

    void deregisterAnimatedInternal() {
        if (this.animationPosition == 0) {
            super.deregisterAnimatedInternal();
        }
    }

    public boolean animate() {
        boolean parentFinished = super.animate();
        if (this.animationPosition != 0 && this.listMotion != null && !this.isDragActivated()) {
            this.animationPosition = this.animationPosition < 0 ? Math.min(this.listMotion.getValue() - this.destination, 0) : Math.max(this.destination - this.listMotion.getValue(), 0);
            if (this.animationPosition == 0) {
                this.listMotion = null;
                this.deregisterAnimatedInternal();
            }
            return true;
        }
        if (this.fixedDraggedMotion != null) {
            int val = -this.fixedDraggedMotion.getValue();
            this.fixedDraggedAnimationPosition -= this.fixedDraggedPosition - val;
            this.fixedDraggedPosition = val;
            Dimension size = this.getElementSize(false, true);
            int s = this.orientation == 0 ? size.getHeight() : size.getWidth();
            if (this.fixedDraggedAnimationPosition <= -s) {
                ++this.fixedDraggedSelection;
                if (this.fixedDraggedSelection >= this.model.getSize()) {
                    this.fixedDraggedSelection = 0;
                }
                this.fixedDraggedPosition = val;
            } else if (this.fixedDraggedAnimationPosition >= s) {
                --this.fixedDraggedSelection;
                if (this.fixedDraggedSelection < 0) {
                    this.fixedDraggedSelection = this.model.getSize() - 1;
                }
                this.fixedDraggedPosition = val;
            }
            this.fixedDraggedAnimationPosition %= s;
            if (this.fixedDraggedMotion.isFinished()) {
                this.deregisterAnimatedInternal();
                if (this.fixedDraggedAnimationPosition != 0) {
                    this.destination = this.fixedDraggedAnimationPosition < 0 ? -this.fixedDraggedAnimationPosition : this.fixedDraggedAnimationPosition;
                    this.animationPosition = this.fixedDraggedAnimationPosition;
                    this.initListMotion();
                    this.fixedDraggedAnimationPosition = 0;
                }
                this.setSelectedIndex(this.fixedDraggedSelection);
                this.setDragActivated(false);
                this.fixedDraggedMotion = null;
            }
            return true;
        }
        return parentFinished;
    }

    protected boolean isTactileTouch(int x, int y) {
        int selection;
        return this.isTactileTouch() && (selection = this.pointerSelect(x, y)) > -1;
    }

    public void setScrollToSelected(boolean scrollToSelected) {
        this.scrollToSelected = scrollToSelected;
    }

    protected int getGridPosY() {
        int gridSize = this.getElementSize(false, true).getHeight() + this.itemGap;
        int scroll = this.getScrollY();
        return this.calcGrid(scroll, gridSize);
    }

    private int calcGrid(int scroll, int gridSize) {
        int fraction = scroll % gridSize;
        if (Math.abs(fraction - gridSize) > 2) {
            if (fraction > gridSize / 2) {
                return scroll + gridSize - fraction;
            }
            return scroll - fraction;
        }
        return scroll;
    }

    protected int getGridPosX() {
        int gridSize = this.getElementSize(false, true).getWidth() + this.itemGap;
        int scroll = this.getScrollX();
        return this.calcGrid(scroll, gridSize);
    }

    protected String paramString() {
        String elemSizeStr = "element size = ";
        if (this.elemSize != null) {
            elemSizeStr = elemSizeStr + this.elemSize.toString();
        }
        return super.paramString() + ", " + elemSizeStr + ", itemGap = " + this.itemGap + ", orientation = " + this.orientation + ", selected index = " + this.getSelectedIndex() + ", size = " + this.size();
    }

    public void setHint(String hint) {
        super.setHint(hint, this.getHintIcon());
    }

    public String getHint() {
        return super.getHint();
    }

    public void setHintIcon(Image icon) {
        this.setHint(this.getHint(), icon);
    }

    public Image getHintIcon() {
        return super.getHintIcon();
    }

    public void setHint(String hint, Image icon) {
        super.setHint(hint, icon);
    }

    Label getHintLabelImpl() {
        return this.hintLabel;
    }

    void setHintLabelImpl(Label hintLabel) {
        this.hintLabel = hintLabel;
    }

    boolean shouldShowHint() {
        return this.getModel().getSize() == 0;
    }

    private class Listeners
    implements DataChangedListener,
    SelectionListener {
        private Listeners() {
        }

        public void dataChanged(int status, int index) {
            List.this.dataChanged(status, index);
        }

        public void selectionChanged(int oldSelected, int newSelected) {
            List.this.repaint();
            List.this.listSelectionChanged(oldSelected, newSelected);
        }
    }
}

