/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.html.CSSElement;
import com.sun.lwuit.html.CSSEngine;
import com.sun.lwuit.html.CSSParserCallback;
import com.sun.lwuit.html.DocumentInfo;
import com.sun.lwuit.html.HTMLComponent;
import com.sun.lwuit.html.HTMLElement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;

class CSSParser {
    public static String[] SUPPORTED_MEDIA_TYPES = new String[]{"all", "handheld"};
    public static CSSParser instance;
    public CSSParserCallback parserCallback;

    CSSParser() {
    }

    static CSSParser getInstance() {
        if (instance == null) {
            instance = new CSSParser();
        }
        return instance;
    }

    static void setCSSSupportedMediaTypes(String[] supportedMediaTypes) {
        SUPPORTED_MEDIA_TYPES = supportedMediaTypes;
    }

    static boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    private char handleCSSComment(ExtInputStreamReader r) throws IOException {
        char c = r.readCharFromReader();
        if (c == '*') {
            char lastC = '\u0000';
            while (c != '/' || lastC != '*') {
                lastC = c;
                c = r.readCharFromReader();
            }
            c = r.readCharFromReader();
            while ((byte)c != -1 && CSSParser.isWhiteSpace(c)) {
                c = r.readCharFromReader();
            }
        } else {
            r.unreadChar(c);
            return '/';
        }
        return c;
    }

    private String nextToken(ExtInputStreamReader r, boolean readNewline, boolean ignoreCommas, boolean ignoreColons, boolean ignoreWhiteSpaces) throws IOException {
        boolean newline = false;
        StringBuffer currentToken = new StringBuffer();
        char c = r.readCharFromReader();
        while ((byte)c != -1 && CSSParser.isWhiteSpace(c)) {
            boolean bl = newline = newline || c == '\n' || c == '\r' || c == ';' || c == ',' && !ignoreCommas || c == '>' || c == '+';
            if (!readNewline && newline) {
                return null;
            }
            c = r.readCharFromReader();
        }
        if (c == ';' && readNewline) {
            c = r.readCharFromReader();
            while ((byte)c != -1 && CSSParser.isWhiteSpace(c)) {
                newline = newline || c == '\n' || c == '\r' || c == ';' || c == ',' && !ignoreCommas || c == '>' || c == '+';
                c = r.readCharFromReader();
            }
        }
        char segment = '\u0000';
        while (!((byte)c == -1 || CSSParser.isWhiteSpace(c) && segment == '\u0000' && !ignoreWhiteSpaces || c == ';' || c == ':' && segment == '\u0000' && !ignoreColons || c == ',' && segment == '\u0000' && !ignoreCommas || (c == '>' || c == '+') && segment == '\u0000')) {
            if (segment == '\u0000' && c == '/') {
                c = this.handleCSSComment(r);
            }
            if ((c == '}' || c == '{' || c == '*') && segment == '\u0000') {
                newline = true;
                if (currentToken.length() == 0) {
                    if (!readNewline) {
                        r.unreadChar(c);
                        return null;
                    }
                    return "" + c;
                }
                r.unreadChar(c);
                break;
            }
            currentToken.append(c);
            if (c == '(') {
                segment = ')';
            } else if (segment == '\u0000' && (c == '\"' || c == '\'')) {
                segment = c;
            } else if (c == segment) {
                segment = '\u0000';
            }
            c = r.readCharFromReader();
        }
        if (c == ',' && !ignoreCommas || c == '>' || c == '+') {
            currentToken.append(c);
        }
        if (!readNewline && c == ';' && currentToken.length() != 0) {
            r.unreadChar(c);
        }
        if (currentToken.length() == 0) {
            return null;
        }
        return currentToken.toString();
    }

    private void copyAttributes(CSSElement element, Vector selectors, HTMLElement addTo) {
        if (selectors == null) {
            return;
        }
        Enumeration e = selectors.elements();
        while (e.hasMoreElements()) {
            CSSElement selector = (CSSElement)e.nextElement();
            addTo.addChild(selector);
            while (selector.getNumChildren() > 0) {
                selector = selector.getCSSChildAt(0);
            }
            element.copyAttributesTo(selector);
        }
    }

    private boolean isMediaTypeSupported(String media) {
        for (int i = 0; i < SUPPORTED_MEDIA_TYPES.length; ++i) {
            if (!media.equalsIgnoreCase(SUPPORTED_MEDIA_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    boolean mediaTypeMatches(String mediaTypes) {
        if (mediaTypes == null || mediaTypes.equals("")) {
            return true;
        }
        int comma = mediaTypes.indexOf(44);
        while (comma != -1) {
            if (this.isMediaTypeSupported(mediaTypes.substring(0, comma).trim())) {
                return true;
            }
            mediaTypes = mediaTypes.substring(comma + 1);
            comma = mediaTypes.indexOf(44);
        }
        return this.isMediaTypeSupported(mediaTypes.trim());
    }

    private String getImportURLByMediaType(String token) {
        String url = token;
        boolean mediaMatches = true;
        int space = token.indexOf(32);
        if (space != -1) {
            url = token.substring(0, space);
            token = token.substring(space + 1);
            mediaMatches = this.mediaTypeMatches(token);
        }
        if (mediaMatches) {
            if (url.startsWith("url(")) {
                url = CSSEngine.getCSSUrl(url);
            }
            return url;
        }
        return null;
    }

    private ExtInputStreamReader getMediaSegment(ExtInputStreamReader r, String encoding, HTMLComponent htmlC) throws IOException {
        String token = this.nextToken(r, true, true, true, true);
        char c = r.readCharFromReader();
        while ((byte)c != -1 && c != '{') {
            c = r.readCharFromReader();
        }
        StringBuffer segment = new StringBuffer();
        boolean match = this.mediaTypeMatches(token);
        int count = 1;
        while (count > 0 && (byte)(c = r.readCharFromReader()) != -1) {
            if (match) {
                segment.append(c);
            }
            if (c == '{') {
                ++count;
                continue;
            }
            if (c != '}') continue;
            --count;
        }
        if (match) {
            ExtInputStreamReader segmentReader = null;
            if (encoding != null) {
                try {
                    segmentReader = new ExtInputStreamReader(new InputStreamReader((InputStream)new ByteArrayInputStream(segment.toString().getBytes()), encoding));
                }
                catch (UnsupportedEncodingException uee) {
                    this.notifyError(9, "@media", null, encoding, "Encoding '" + encoding + "' failed for media segment. " + uee.getMessage());
                }
            }
            if (segmentReader == null) {
                segmentReader = new ExtInputStreamReader(new InputStreamReader(new ByteArrayInputStream(segment.toString().getBytes())));
            }
            return segmentReader;
        }
        return null;
    }

    CSSElement parseCSSSegment(Reader isr, InputStream is, HTMLComponent htmlC, String pageURL) throws IOException {
        CSSElement addTo = new CSSElement("style");
        ExtInputStreamReader r = new ExtInputStreamReader(isr);
        DocumentInfo docInfo = null;
        String encoding = htmlC.getDocumentInfo() != null ? htmlC.getDocumentInfo().getEncoding() : null;
        String token = this.nextToken(r, true, false, true, false);
        while (token.startsWith("@")) {
            if (token.equals("@import")) {
                token = this.nextToken(r, true, true, true, true);
                String url = this.getImportURLByMediaType(token);
                if (url != null) {
                    if (docInfo == null) {
                        DocumentInfo documentInfo = docInfo = pageURL == null ? htmlC.getDocumentInfo() : new DocumentInfo(pageURL);
                    }
                    if (docInfo != null) {
                        htmlC.getThreadQueue().addCSS(docInfo.convertURL(url), encoding);
                    } else if (DocumentInfo.isAbsoluteURL(url)) {
                        htmlC.getThreadQueue().addCSS(url, encoding);
                    } else {
                        this.notifyError(203, "@import", null, url, "Ignoring CSS file referred in an @import rule (" + url + "), since page was set by setBody/setHTML/setDOM so there's no way to access relative URLs");
                    }
                }
            } else if (token.equals("@media")) {
                ExtInputStreamReader mediaReader = this.getMediaSegment(r, encoding, htmlC);
                if (mediaReader != null) {
                    this.parseCSS(mediaReader, htmlC, addTo, null);
                }
            } else if (token.equals("@charset")) {
                token = CSSEngine.omitQuotesIfExist(this.nextToken(r, true, false, true, false));
                if (is != null) {
                    try {
                        ExtInputStreamReader encodedReader;
                        r = encodedReader = new ExtInputStreamReader(new InputStreamReader(is, token));
                        encoding = token;
                    }
                    catch (UnsupportedEncodingException uee) {
                        this.notifyError(9, "@charset", null, token, "External CSS encoding @charset " + token + " directive failed: " + uee.getMessage());
                    }
                }
            }
            token = this.nextToken(r, true, false, true, false);
        }
        return this.parseCSS(r, htmlC, addTo, token);
    }

    CSSElement parseCSS(InputStreamReader r, HTMLComponent htmlC) throws IOException {
        ExtInputStreamReader er = new ExtInputStreamReader(r);
        return this.parseCSS(er, htmlC, null, null);
    }

    /*
     * Unable to fully structure code
     */
    CSSElement parseCSS(ExtInputStreamReader r, HTMLComponent htmlC, CSSElement addTo, String firstToken) throws IOException {
        if (addTo == null) {
            addTo = new CSSElement("style");
        }
        parent = addTo;
        selectors = new Vector<CSSElement>();
        lastGroupedParent = null;
        selectorMode = true;
        grouping = false;
        childSelector = false;
        siblingSelector = false;
        token = "";
        block0: while (true) {
            if (firstToken != null) {
                token = firstToken;
                firstToken = null;
            } else {
                token = this.nextToken(r, true, false, selectorMode, false);
            }
            if (token == null || token.indexOf("</style") > -1) break;
            if ("{".equals(token)) {
                selectorMode = false;
                grouping = false;
                continue;
            }
            if ("}".equals(token)) {
                selectorMode = true;
                this.copyAttributes(parent, selectors, addTo);
                parent = addTo;
                selectors = new Vector<E>();
                lastGroupedParent = null;
                continue;
            }
            if (selectorMode) {
                if (",".equals(token)) {
                    grouping = true;
                    continue;
                }
                if (">".equals(token)) {
                    childSelector = true;
                    continue;
                }
                if ("+".equals(token)) {
                    siblingSelector = true;
                    continue;
                }
                if (token.startsWith(",")) {
                    token = token.substring(1);
                    grouping = true;
                } else if (token.startsWith(">")) {
                    token = token.substring(1);
                    childSelector = true;
                } else if (token.startsWith("+")) {
                    token = token.substring(1);
                    siblingSelector = true;
                }
                nextIsChildSelector = false;
                nextIsSiblingSelector = false;
                if (token.endsWith(">")) {
                    nextIsChildSelector = true;
                    token = token.substring(0, token.length() - 1);
                } else if (token.endsWith("+")) {
                    nextIsSiblingSelector = true;
                    token = token.substring(0, token.length() - 1);
                }
                if (grouping) {
                    if (token.endsWith(",")) {
                        token = token.substring(0, token.length() - 1);
                    } else {
                        grouping = false;
                    }
                    entry = new CSSElement(token);
                    selectors.addElement(entry);
                    lastGroupedParent = entry;
                } else {
                    if (token.endsWith(",")) {
                        grouping = true;
                        token = token.substring(0, token.length() - 1);
                    }
                    entry = new CSSElement(token);
                    entry.descendantSelector = childSelector == false;
                    entry.siblingSelector = siblingSelector;
                    if (lastGroupedParent == null) {
                        parent.addChild(entry);
                        parent = entry;
                    } else {
                        lastGroupedParent.addChild(entry);
                        lastGroupedParent = entry;
                    }
                }
                childSelector = nextIsChildSelector;
                siblingSelector = nextIsSiblingSelector;
                continue;
            }
            compoundToken = false;
            for (iter = 0; iter < CSSElement.CSS_SHORTHAND_ATTRIBUTE_LIST.length; ++iter) {
                if (!CSSElement.CSS_SHORTHAND_ATTRIBUTE_LIST[iter].equals(token)) continue;
                compoundToken = true;
                collattable = CSSElement.CSS_IS_SHORTHAND_ATTRIBUTE_COLLATABLE[iter];
                valsAdded = 0;
                token = this.nextToken(r, false, false, false, false);
                tokens = new String[4];
                while (token != null) {
                    if (collattable) {
                        if (valsAdded < tokens.length) {
                            tokens[valsAdded] = token;
                            ++valsAdded;
                        }
                    } else {
                        this.addShorthandAttribute(token, iter, parent);
                    }
                    token = this.nextToken(r, false, false, false, false);
                }
                if (!collattable || valsAdded <= 0) break;
                for (i = 0; i < CSSElement.CSS_COLLATABLE_ORDER[valsAdded - 1].length; ++i) {
                    for (j = 0; j < CSSElement.CSS_COLLATABLE_ORDER[valsAdded - 1][i].length; ++j) {
                        side = CSSElement.CSS_COLLATABLE_ORDER[valsAdded - 1][i][j];
                        this.addAttributeTo(parent, CSSElement.CSS_SHORTHAND_ATTRIBUTE_INDEX[iter][side], tokens[i], htmlC);
                    }
                }
                break;
            }
            if (compoundToken || (result = this.addAttributeTo(parent, token, this.nextToken(r, false, true, false, token.equalsIgnoreCase("-wap-access-key") != false || token.equalsIgnoreCase("font-family") != false || token.equalsIgnoreCase("quotes") != false || token.equalsIgnoreCase("border-spacing") != false || token.equalsIgnoreCase("content") != false || token.equalsIgnoreCase("counter-reset") != false || token.equalsIgnoreCase("counter-increment") != false), htmlC)) == -1) continue;
            while (true) {
                if (this.nextToken(r, false, false, false, false) != null) ** break;
                continue block0;
            }
            break;
        }
        return addTo;
    }

    private boolean addShorthandAttribute(String value, int shorthandAttr, CSSElement selector) {
        if (CSSElement.CSS_IS_SHORTHAND_ATTRIBUTE_COLLATABLE[shorthandAttr]) {
            return this.addCollatableAttribute(value, shorthandAttr, selector);
        }
        for (int i = 0; i < CSSElement.CSS_SHORTHAND_ATTRIBUTE_INDEX[shorthandAttr].length; ++i) {
            boolean success;
            int result;
            int attrIndex = CSSElement.CSS_SHORTHAND_ATTRIBUTE_INDEX[shorthandAttr][i];
            if (!(attrIndex >= 500 ? !selector.isAttributeAssigned(attrIndex) && (result = selector.addAttribute(attrIndex, value)) == -1 : (success = this.addShorthandAttribute(value, attrIndex, selector)))) continue;
            return true;
        }
        return false;
    }

    private boolean addCollatableAttribute(String value, int shorthandAttr, CSSElement selector) {
        int attrIndex = CSSElement.CSS_SHORTHAND_ATTRIBUTE_INDEX[shorthandAttr][0];
        int result = selector.addAttribute(attrIndex, value);
        if (result == -1) {
            for (int i = 1; i < CSSElement.CSS_SHORTHAND_ATTRIBUTE_INDEX[shorthandAttr].length; ++i) {
                attrIndex = CSSElement.CSS_SHORTHAND_ATTRIBUTE_INDEX[shorthandAttr][i];
                selector.addAttribute(attrIndex, value);
            }
            return true;
        }
        return false;
    }

    private int addAttributeTo(CSSElement selector, int attrId, String value, HTMLComponent htmlC) {
        int error = selector.addAttribute(attrId, value);
        this.reportAddAttributeError(error, selector, selector.getAttributeName(new Integer(attrId)), value, htmlC);
        return error;
    }

    private int addAttributeTo(CSSElement selector, String attributeName, String value, HTMLComponent htmlC) {
        int error = selector.setAttribute(attributeName, value);
        this.reportAddAttributeError(error, selector, attributeName, value, htmlC);
        return error;
    }

    private void reportAddAttributeError(int errorCode, CSSElement selector, String attributeName, String value, HTMLComponent htmlC) {
        if (errorCode != -1) {
            if (errorCode == 200) {
                this.notifyError(errorCode, selector.getTagName(), attributeName, value, "CSS Attribute '" + attributeName + "' (Appeared in selector '" + selector.getTagName() + "') is not supported in WCSS.");
            } else if (errorCode == 201) {
                this.notifyError(errorCode, selector.getTagName(), attributeName, value, "CSS Attribute '" + attributeName + "' (Appeared in selector '" + selector.getTagName() + "') has an invalid value (" + value + ")");
            }
        }
    }

    void notifyError(int errorId, String tag, String attribute, String value, String description) {
        boolean cont;
        if (this.parserCallback != null && !(cont = this.parserCallback.parsingError(errorId, tag, attribute, value, description))) {
            throw new IllegalArgumentException(description);
        }
    }

    public void setCSSParserCallback(CSSParserCallback parserCallback) {
        this.parserCallback = parserCallback;
    }

    class ExtInputStreamReader {
        char lastCharRead = (char)65535;
        Reader internalReader;

        ExtInputStreamReader(Reader isr) {
            this.internalReader = isr;
        }

        void unreadChar(char c) {
            this.lastCharRead = c;
        }

        char readCharFromReader() throws IOException {
            if (this.lastCharRead != '\uffff') {
                char c = this.lastCharRead;
                this.lastCharRead = (char)65535;
                return c;
            }
            return (char)this.internalReader.read();
        }
    }
}

