/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Button;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.html.HTMLComponent;
import com.sun.lwuit.html.HTMLLink;
import com.sun.lwuit.html.ImageMapData;
import java.util.Enumeration;

class HTMLImageMap
extends Button
implements ActionListener {
    ImageMapData mapData;
    HTMLComponent htmlC;

    HTMLImageMap(HTMLComponent htmlC) {
        this.htmlC = htmlC;
        this.setUIID("HTMLLink");
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.mapData != null) {
            int x = evt.getX();
            int y = evt.getY();
            if (this.mapData.areas != null && x != -1) {
                Enumeration e = this.mapData.areas.keys();
                while (e.hasMoreElements()) {
                    Rectangle rect = (Rectangle)e.nextElement();
                    if (!rect.contains(x - this.getAbsoluteX(), y - this.getAbsoluteY())) continue;
                    String link = (String)this.mapData.areas.get(rect);
                    if (link != null) {
                        HTMLLink.processLink(this.htmlC, link);
                    }
                    return;
                }
            }
            if (this.mapData.defaultLink != null) {
                HTMLLink.processLink(this.htmlC, this.mapData.defaultLink);
            }
        }
    }
}

