/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.impl.midp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class MMAPIPlayer
implements PlayerListener {
    public static int volume;
    public boolean deleted;
    public int lastTime;
    public Player p;
    public static Vector playing;
    public InputStream sourceStream;
    public Runnable onComplete;
    static /* synthetic */ Class class$com$sun$lwuit$impl$midp$MMAPIPlayer;

    private MMAPIPlayer(Player p) {
        this.p = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVolume() {
        if (volume > -1) {
            return volume;
        }
        Class clazz = class$com$sun$lwuit$impl$midp$MMAPIPlayer == null ? (class$com$sun$lwuit$impl$midp$MMAPIPlayer = MMAPIPlayer.class$("com.sun.lwuit.impl.midp.MMAPIPlayer")) : class$com$sun$lwuit$impl$midp$MMAPIPlayer;
        synchronized (clazz) {
            if (playing != null && playing.size() > 0) {
                MMAPIPlayer current = (MMAPIPlayer)playing.elementAt(0);
                VolumeControl volc = (VolumeControl)current.p.getControl("VolumeControl");
                if (volc != null) {
                    return volc.getLevel();
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVolume(int v) {
        volume = v;
        if (playing != null) {
            Class clazz = class$com$sun$lwuit$impl$midp$MMAPIPlayer == null ? (class$com$sun$lwuit$impl$midp$MMAPIPlayer = MMAPIPlayer.class$("com.sun.lwuit.impl.midp.MMAPIPlayer")) : class$com$sun$lwuit$impl$midp$MMAPIPlayer;
            synchronized (clazz) {
                for (int iter = 0; iter < playing.size(); ++iter) {
                    MMAPIPlayer current = (MMAPIPlayer)playing.elementAt(iter);
                    VolumeControl volc = (VolumeControl)current.p.getControl("VolumeControl");
                    if (volc == null) continue;
                    volc.setLevel(v);
                }
            }
        }
    }

    public static MMAPIPlayer createAudio(String uri, Runnable onCompletion) throws IOException {
        try {
            Player p = Manager.createPlayer((String)uri);
            p.realize();
            MMAPIPlayer m = new MMAPIPlayer(p);
            m.bindPlayerCleanupOnComplete(p, null, onCompletion);
            return m;
        }
        catch (MediaException ex) {
            ex.printStackTrace();
            throw new IOException(ex.toString());
        }
    }

    private void bindPlayerCleanupOnComplete(Player p, InputStream i, Runnable onComplete) {
        VolumeControl v;
        if (volume > -1 && (v = (VolumeControl)p.getControl("VolumeControl")) != null) {
            v.setLevel(volume);
        }
        this.sourceStream = i;
        this.onComplete = onComplete;
        p.addPlayerListener((PlayerListener)this);
    }

    public static MMAPIPlayer createAudio(InputStream stream, String mimeType, Runnable onCompletion) throws IOException {
        try {
            Player p = Manager.createPlayer((InputStream)stream, (String)mimeType);
            p.realize();
            MMAPIPlayer m = new MMAPIPlayer(p);
            m.bindPlayerCleanupOnComplete(p, stream, onCompletion);
            return m;
        }
        catch (MediaException ex) {
            if ("audio/mpeg".equals(mimeType)) {
                return MMAPIPlayer.createAudio(stream, "audio/mp3", onCompletion);
            }
            ex.printStackTrace();
            throw new IOException(ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAudio() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        try {
            Class clazz = class$com$sun$lwuit$impl$midp$MMAPIPlayer == null ? (class$com$sun$lwuit$impl$midp$MMAPIPlayer = MMAPIPlayer.class$("com.sun.lwuit.impl.midp.MMAPIPlayer")) : class$com$sun$lwuit$impl$midp$MMAPIPlayer;
            synchronized (clazz) {
                playing.removeElement(this);
            }
            try {
                this.p.stop();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.p.close();
            this.p = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playAudio() {
        if (this.deleted) {
            return;
        }
        try {
            if (playing == null) {
                playing = new Vector();
            }
            Class clazz = class$com$sun$lwuit$impl$midp$MMAPIPlayer == null ? (class$com$sun$lwuit$impl$midp$MMAPIPlayer = MMAPIPlayer.class$("com.sun.lwuit.impl.midp.MMAPIPlayer")) : class$com$sun$lwuit$impl$midp$MMAPIPlayer;
            synchronized (clazz) {
                playing.addElement(this);
            }
            this.p.start();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.toString());
        }
    }

    public void pauseAudio() {
        if (this.deleted) {
            return;
        }
        try {
            if (this.p != null) {
                this.p.stop();
            }
        }
        catch (MediaException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.toString());
        }
    }

    public int getAudioTime() {
        try {
            if (this.p == null || this.deleted) {
                return this.lastTime;
            }
            this.lastTime = (int)(this.p.getMediaTime() / 1000L);
            return this.lastTime;
        }
        catch (Throwable t) {
            return this.lastTime;
        }
    }

    public void setAudioTime(int time) {
        if (this.deleted) {
            return;
        }
        try {
            this.p.setMediaTime((long)(time * 1000));
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public int getAudioDuration() {
        if (this.p == null || this.deleted) {
            return 1000;
        }
        return (int)(this.p.getDuration() / 1000L);
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (this.deleted) {
            return;
        }
        if ("endOfMedia".equals(event) || "error".equals(event) || "recordError".equals(event)) {
            this.lastTime = (int)(this.p.getMediaTime() / 1000L);
            this.cleanupAudio();
            if (this.sourceStream != null) {
                try {
                    this.sourceStream.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (this.onComplete != null) {
                this.onComplete.run();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

