/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.util;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.events.StyleListener;
import com.sun.lwuit.plaf.Style;
import java.util.Vector;

public class EventDispatcher {
    public boolean blocking = false;
    public Vector listeners;
    public Object[] pending;
    public Object pendingEvent;
    public static boolean fireStyleEventsOnNonEDT = false;
    public final Runnable callback = new CallbackClass();

    public static void setFireStyleEventsOnNonEDT(boolean fire) {
        fireStyleEventsOnNonEDT = fire;
    }

    public synchronized void addListener(Object listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public Vector getListenerVector() {
        return this.listeners;
    }

    public synchronized void removeListener(Object listener) {
        if (this.listeners != null) {
            this.listeners.removeElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataChangeEvent(int index, int type) {
        DataChangedListener[] array;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            array = new DataChangedListener[this.listeners.size()];
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter] = (DataChangedListener)this.listeners.elementAt(iter);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireDataChangeSync(array, type, index);
        } else {
            this.pending = array;
            this.pendingEvent = new int[]{type, index};
            if (this.blocking) {
                Display.getInstance().callSeriallyAndWait(this.callback);
            } else {
                Display.getInstance().callSerially(new CallbackClass());
            }
            this.pending = null;
            this.pendingEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStyleChangeEvent(String property, Style source) {
        StyleListener[] array;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            array = new StyleListener[this.listeners.size()];
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter] = (StyleListener)this.listeners.elementAt(iter);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireStyleChangeSync(array, property, source);
        } else if (fireStyleEventsOnNonEDT) {
            this.pending = array;
            this.pendingEvent = new Object[]{property, source};
            Display.getInstance().callSerially(new CallbackClass());
            this.pending = null;
            this.pendingEvent = null;
        }
    }

    private void fireDataChangeSync(DataChangedListener[] array, int type, int index) {
        for (int iter = 0; iter < array.length; ++iter) {
            array[iter].dataChanged(type, index);
        }
    }

    private void fireStyleChangeSync(StyleListener[] array, String property, Style source) {
        for (int iter = 0; iter < array.length; ++iter) {
            array[iter].styleChanged(property, source);
        }
    }

    private void fireSelectionSync(SelectionListener[] array, int oldSelection, int newSelection) {
        for (int iter = 0; iter < array.length; ++iter) {
            array[iter].selectionChanged(oldSelection, newSelection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireActionEvent(ActionEvent ev) {
        ActionListener[] array;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            array = new ActionListener[this.listeners.size()];
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter] = (ActionListener)this.listeners.elementAt(iter);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireActionSync(array, ev);
        } else {
            this.pending = array;
            this.pendingEvent = ev;
            if (this.blocking) {
                Display.getInstance().callSeriallyAndWait(this.callback);
            } else {
                Display.getInstance().callSerially(new CallbackClass());
            }
            this.pending = null;
            this.pendingEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSelectionEvent(int oldSelection, int newSelection) {
        SelectionListener[] array;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            array = new SelectionListener[this.listeners.size()];
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter] = (SelectionListener)this.listeners.elementAt(iter);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireSelectionSync(array, oldSelection, newSelection);
        } else {
            this.pending = array;
            this.pendingEvent = new int[]{oldSelection, newSelection};
            if (this.blocking) {
                Display.getInstance().callSeriallyAndWait(this.callback);
            } else {
                Display.getInstance().callSerially(new CallbackClass());
            }
            this.pending = null;
            this.pendingEvent = null;
        }
    }

    private void fireActionSync(ActionListener[] array, ActionEvent ev) {
        for (int iter = 0; iter < array.length; ++iter) {
            if (ev.isConsumed()) continue;
            array[iter].actionPerformed(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFocus(Component c) {
        FocusListener[] array;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            array = new FocusListener[this.listeners.size()];
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter] = (FocusListener)this.listeners.elementAt(iter);
            }
        }
        if (Display.getInstance().isEdt()) {
            this.fireFocusSync(array, c);
        } else {
            this.pending = array;
            this.pendingEvent = c;
            if (this.blocking) {
                Display.getInstance().callSeriallyAndWait(this.callback);
            } else {
                Display.getInstance().callSerially(new CallbackClass());
            }
            this.pending = null;
            this.pendingEvent = null;
        }
    }

    private void fireFocusSync(FocusListener[] array, Component c) {
        if (c.hasFocus()) {
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter].focusGained(c);
            }
        } else {
            for (int iter = 0; iter < array.length; ++iter) {
                array[iter].focusLost(c);
            }
        }
    }

    public boolean hasListeners() {
        return this.listeners != null && this.listeners.size() > 0;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    static /* synthetic */ Object[] access$202(EventDispatcher x0, Object[] x1) {
        x0.pending = x1;
        return x1;
    }

    class CallbackClass
    implements Runnable {
        public Object[] iPending;
        public Object iPendingEvent;

        public CallbackClass() {
            if (!EventDispatcher.this.blocking) {
                this.iPendingEvent = EventDispatcher.this.pendingEvent;
                this.iPending = EventDispatcher.this.pending;
            }
        }

        public final void run() {
            if (!Display.getInstance().isEdt()) {
                throw new IllegalStateException("This method should not be invoked by external code!");
            }
            if (EventDispatcher.this.blocking) {
                this.iPendingEvent = EventDispatcher.this.pendingEvent;
                this.iPending = EventDispatcher.this.pending;
            }
            if (this.iPending instanceof ActionListener[]) {
                EventDispatcher.this.fireActionSync((ActionListener[])this.iPending, (ActionEvent)this.iPendingEvent);
                return;
            }
            if (this.iPending instanceof FocusListener[]) {
                EventDispatcher.this.fireFocusSync((FocusListener[])this.iPending, (Component)this.iPendingEvent);
                return;
            }
            if (this.iPending instanceof DataChangedListener[]) {
                EventDispatcher.this.fireDataChangeSync((DataChangedListener[])this.iPending, ((int[])this.iPendingEvent)[0], ((int[])this.iPendingEvent)[1]);
                return;
            }
            if (this.iPending instanceof SelectionListener[]) {
                EventDispatcher.this.fireSelectionSync((SelectionListener[])this.iPending, ((int[])this.iPendingEvent)[0], ((int[])this.iPendingEvent)[1]);
                return;
            }
            if (this.iPending instanceof StyleListener[]) {
                Object[] p = (Object[])this.iPendingEvent;
                EventDispatcher.this.fireStyleChangeSync((StyleListener[])this.iPending, (String)p[0], (Style)p[1]);
                EventDispatcher.this.pendingEvent = null;
                EventDispatcher.access$202(EventDispatcher.this, null);
                return;
            }
        }
    }
}

