/*
 * Decompiled with CFR 0.152.
 */
package vParser;

import vParser.JSONArray;
import vParser.JSONException;
import vParser.JSONObject;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JSONTokener {
    public int a;
    public String a = 0;

    public JSONTokener(String string) {
        this.a = string;
    }

    public void back() {
        if (this.a > 0) {
            --this.a;
        }
    }

    public char next() {
        JSONTokener jSONTokener = this;
        if (jSONTokener.a < jSONTokener.a.length()) {
            char c = this.a.charAt(this.a);
            ++this.a;
            return c;
        }
        return '\u0000';
    }

    private String a(int n) {
        int n2 = this.a;
        int n3 = n2 + n;
        if (n3 >= this.a.length()) {
            throw this.syntaxError("Substring bounds error");
        }
        this.a += n;
        return this.a.substring(n2, n3);
    }

    public char nextClean() {
        char c;
        block4: while (true) {
            if ((c = this.next()) == '/') {
                switch (this.next()) {
                    case '/': {
                        while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                        }
                        continue block4;
                    }
                    case '*': {
                        while (true) {
                            if ((c = this.next()) == '\u0000') {
                                throw this.syntaxError("Unclosed comment.");
                            }
                            if (c != '*') continue;
                            if (this.next() == '/') continue block4;
                            this.back();
                        }
                    }
                }
                this.back();
                return '/';
            }
            if (c == '#') {
                while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                }
                continue;
            }
            if (c == '\u0000' || c > ' ') break;
        }
        return c;
    }

    public Object nextValue() {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                char c2 = c;
                JSONTokener jSONTokener = this;
                StringBuffer stringBuffer = new StringBuffer();
                block26: while (true) {
                    char c3 = jSONTokener.next();
                    switch (c3) {
                        case '\u0000': 
                        case '\n': 
                        case '\r': {
                            throw jSONTokener.syntaxError("Unterminated string");
                        }
                        case '\\': {
                            c3 = jSONTokener.next();
                            switch (c3) {
                                case 'b': {
                                    stringBuffer.append('\b');
                                    continue block26;
                                }
                                case 't': {
                                    stringBuffer.append('\t');
                                    continue block26;
                                }
                                case 'n': {
                                    stringBuffer.append('\n');
                                    continue block26;
                                }
                                case 'f': {
                                    stringBuffer.append('\f');
                                    continue block26;
                                }
                                case 'r': {
                                    stringBuffer.append('\r');
                                    continue block26;
                                }
                                case 'u': {
                                    stringBuffer.append((char)Integer.parseInt(jSONTokener.a(4), 16));
                                    continue block26;
                                }
                                case 'x': {
                                    stringBuffer.append((char)Integer.parseInt(jSONTokener.a(2), 16));
                                    continue block26;
                                }
                            }
                            stringBuffer.append(c3);
                            continue block26;
                        }
                    }
                    if (c3 == c2) {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(c3);
                }
            }
            case '{': {
                this.back();
                return new JSONObject(this);
            }
            case '[': {
                this.back();
                return new JSONArray(this);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c4 = c;
        while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            stringBuffer.append(c);
            c = this.next();
        }
        this.back();
        String string = stringBuffer.toString().trim();
        if (string.equals("")) {
            throw this.syntaxError("Missing value.");
        }
        if (string.equals("null")) {
            return JSONObject.NULL;
        }
        if (c4 >= '0' && c4 <= '9' || c4 == '.' || c4 == '-' || c4 == '+') {
            if (c4 == '0') {
                if (string.length() > 2 && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                    try {
                        return new Integer(Integer.parseInt(string.substring(2), 16));
                    }
                    catch (Exception exception) {
                    }
                } else {
                    try {
                        return new Integer(Integer.parseInt(string, 8));
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                return Integer.valueOf(string);
            }
            catch (Exception exception) {
                try {
                    return new Long(Long.parseLong(string));
                }
                catch (Exception exception2) {}
            }
        }
        return string;
    }

    public JSONException syntaxError(String string) {
        return new JSONException(string + this.toString());
    }

    public String toString() {
        return " at character " + this.a + " of " + this.a;
    }
}

