/*
 * Decompiled with CFR 0.152.
 */
class BreakPlatform
extends GimmickObject {
    public static MFImage platformImage = null;
    public int[][] breakY;
    public int[][] breakVelY;
    public int breakCount;
    public boolean breakFlag = false;
    public int blockNumX;
    public int blockNumY;

    protected BreakPlatform(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (platformImage == null) {
            try {
                platformImage = MFImage.createImage("/gimmick/break_platform_" + StageManager.getCurrentZoneId() + ".png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (this.used && this.isStandingOver()) {
            return;
        }
        switch (n) {
            case 1: {
                playerObject.beStop(this.collisionRect.y0, 1, this);
                if (this.used) break;
                this.used = true;
                this.initialBreaking(platformImage);
                break;
            }
            case 4: {
                if (playerObject.getMoveDistance().y <= 0 || playerObject.getCollisionRect().y1 >= this.collisionRect.y1) break;
                playerObject.beStop(this.collisionRect.y0, 1, this);
                if (this.used) break;
                this.used = true;
                this.initialBreaking(platformImage);
            }
        }
    }

    public void logic() {
        if (this.used && this.isStandingOver()) {
            GameObject.player.cancelFootObject(this);
        }
    }

    public void doInitWhileInCamera() {
        this.used = false;
        this.breakFlag = false;
    }

    public void draw(MFGraphics mFGraphics) {
        if (this.breakFlag) {
            this.breakingDraw(mFGraphics, GameObject.camera);
        } else {
            this.drawInMap(mFGraphics, platformImage, 0, 0, MyAPI.zoomIn(platformImage.getHeight()), MyAPI.zoomIn(platformImage.getWidth()), this.iLeft == 0 ? 0 : 1, this.posX, this.posY, (this.iLeft == 0 ? 4 : 8) | 0x10);
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        if (this.iLeft == 0) {
            this.collisionRect.setRect(n, n2, 4096, 2048);
        } else {
            this.collisionRect.setRect(n - 4096, n2, 4096, 2048);
        }
    }

    public void initialBreaking(MFImage mFImage) {
        this.blockNumX = MyAPI.zoomIn(mFImage.getHeight() / 8);
        this.blockNumY = MyAPI.zoomIn(mFImage.getWidth() / 8);
        this.breakY = new int[this.blockNumX][this.blockNumY];
        this.breakVelY = new int[this.blockNumX][this.blockNumY];
        this.breakCount = 0;
        this.breakFlag = true;
    }

    public void breakingDraw(MFGraphics mFGraphics, Coordinate coordinate) {
        if (this.breakFlag) {
            int n;
            for (n = 0; n < this.breakCount; ++n) {
                int[] nArray = this.breakVelY[n % this.blockNumX];
                int n2 = n / this.blockNumX;
                nArray[n2] = nArray[n2] + GameObject.GRAVITY;
            }
            ++this.breakCount;
            if (this.breakCount > this.blockNumX * this.blockNumY) {
                this.breakCount = this.blockNumX * this.blockNumY;
            }
            for (n = 0; n < this.blockNumX * this.blockNumY; ++n) {
                int[] nArray = this.breakY[n % this.blockNumX];
                int n3 = n / this.blockNumX;
                nArray[n3] = nArray[n3] + this.breakVelY[n % this.blockNumX][n / this.blockNumX];
                this.drawInMap(mFGraphics, platformImage, n % this.blockNumX * 8, (this.blockNumY - 1 - n / this.blockNumX) * 8, 8, 8, this.iLeft == 0 ? 0 : 1, (this.iLeft == 0 ? 1 : -1) * (n % this.blockNumX) * 512 + this.posX, (this.blockNumY - 1 - n / this.blockNumX) * 512 + this.posY + this.breakY[n % this.blockNumX][n / this.blockNumX], (this.iLeft == 0 ? 4 : 8) | 0x10);
            }
        }
    }

    public boolean isStandingOver() {
        return this.breakCount >= this.blockNumX * (this.blockNumY - 1);
    }

    public void close() {
    }

    public static void releaseAllResource() {
        platformImage = null;
    }
}

