/*
 * Decompiled with CFR 0.152.
 */
class BreakWall
extends GimmickObject {
    public boolean breaking = false;
    public boolean breakOver = false;
    public int breakCount;
    public boolean positiveDirection;
    public int breakLimitLine;
    public int[][][] breakPosition = new int[2][4][3];
    public static MFImage image;

    protected BreakWall(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.breakPosition[i][j][0] = this.posX + i * 1024;
                this.breakPosition[i][j][1] = this.posY + j * 1024;
                this.breakPosition[i][j][2] = -GameObject.GRAVITY;
            }
        }
        this.breakLimitLine = this.posY + 4096 + 2048;
        if (image == null) {
            try {
                image = MFImage.createImage("/gimmick/breakWall_" + StageManager.getCurrentZoneId() + ".png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (playerObject.isAttackingEnemy()) {
            this.breaking = false;
            if (false) {
                this.breakCount = 0;
            }
            this.breaking = true;
            this.breakOver = false;
            if (n == 3) {
                this.positiveDirection = true;
            }
            if (n == 2) {
                this.positiveDirection = false;
            }
        } else if (!this.breaking) {
            playerObject.beStop(0, n, this);
        }
    }

    public void logic() {
        if (this.breaking && !this.breakOver) {
            int n;
            int n2 = 0;
            this.breakOver = true;
            int n3 = n = this.positiveDirection ? 0 : 1;
            block0: while (this.positiveDirection ? n < 2 : n >= 0) {
                for (int i = 3; i >= 0; --i) {
                    int[] nArray = this.breakPosition[n][i];
                    nArray[0] = nArray[0] + (this.positiveDirection ? 50 : -50);
                    int[] nArray2 = this.breakPosition[n][i];
                    nArray2[2] = nArray2[2] + GameObject.GRAVITY;
                    int[] nArray3 = this.breakPosition[n][i];
                    nArray3[1] = nArray3[1] + this.breakPosition[n][i][2];
                    if (this.breakPosition[n][i][1] < this.breakLimitLine) {
                        this.breakOver = false;
                    }
                    if (++n2 < this.breakCount) continue;
                    ++this.breakCount;
                    break block0;
                }
                n += this.positiveDirection ? 1 : -1;
            }
            if (this.breakCount < 8 && this.breakOver) {
                this.breakOver = false;
            }
        }
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawCollisionRect(mFGraphics);
        if (this.breakOver) {
            return;
        }
        if (this.breaking) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.drawInMap(mFGraphics, image, i * 16, j * 16, 16, 16, 0, this.breakPosition[i][j][0], this.breakPosition[i][j][1], 20);
                }
            }
        } else {
            this.drawInMap(mFGraphics, image, 20);
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n, n2, 2048, 4096);
    }

    public void close() {
        this.breakPosition = null;
    }

    public static void releaseAllResource() {
        image = null;
    }

    public void doInitWhileInCamera() {
        this.breaking = false;
        this.breakOver = false;
        this.breakCount = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.breakPosition[i][j][0] = this.posX + i * 1024;
                this.breakPosition[i][j][1] = this.posY + j * 1024;
                this.breakPosition[i][j][2] = -GameObject.GRAVITY;
            }
        }
    }
}

