/*
 * Decompiled with CFR 0.152.
 */
class CaperBlock
extends GimmickObject {
    public static MFImage blockImage;
    public HobinCal hobinCal;

    protected CaperBlock(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        this.posY -= 512;
        if (blockImage == null) {
            try {
                blockImage = MFImage.createImage("/gimmick/caper_block_" + StageManager.getCurrentZoneId() + ".png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.hobinCal = new HobinCal();
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, blockImage, this.posX + this.hobinCal.getPosOffsetX(), this.posY + this.hobinCal.getPosOffsetY(), 17);
        this.hobinCal.logic();
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (!this.hobinCal.isStop()) {
            return;
        }
        playerObject.beStop(this.collisionRect.x0, n, this);
        switch (n) {
            case 1: {
                if (playerObject != GameObject.player) break;
                GameObject.player.beSpring(1350, 1);
                this.hobinCal.startHobin(400, 90, 10);
                break;
            }
            case 4: {
                if (playerObject.getMoveDistance().y <= 0 || playerObject.getCollisionRect().y1 >= this.collisionRect.y1 || playerObject != GameObject.player) break;
                GameObject.player.beSpring(1350, 1);
                this.hobinCal.startHobin(400, 90, 10);
            }
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 1024, n2 + 192, 2048, 1024);
    }

    public void close() {
        this.hobinCal = null;
    }

    public static void releaseAllResource() {
        blockImage = null;
    }
}

