/*
 * Decompiled with CFR 0.152.
 */
public class CollisionBlock {
    public static final byte[] BLANK_COLLISION_INFO = new byte[8];
    public boolean FLIP_X;
    public boolean FLIP_Y;
    public byte[] collisionInfo = BLANK_COLLISION_INFO;
    public boolean attr;
    public int degree;
    public boolean extendsDegree;

    public void setProperty(byte[] byArray, boolean bl, boolean bl2, int n, boolean bl3) {
        this.collisionInfo = byArray;
        this.FLIP_X = bl;
        this.FLIP_Y = bl2;
        this.degree = n < 0 ? 256 + n : n;
        this.extendsDegree = this.degree == 255;
        this.attr = bl3;
    }

    public void setProperty(CollisionBlock collisionBlock) {
        this.setProperty(collisionBlock.collisionInfo, collisionBlock.FLIP_X, collisionBlock.FLIP_Y, collisionBlock.degree, collisionBlock.attr);
    }

    public int getCollisionY(int n) {
        while (n < 0) {
            n += 8;
        }
        n %= 8;
        if (this.FLIP_X) {
            n = 7 - n;
        }
        int n2 = (this.collisionInfo[n] & 0xF0) >> 4;
        int n3 = 0;
        if (n2 == 8) {
            n3 = 0;
            return n3;
        }
        if (n2 == 0) {
            n3 = -1;
            return n3;
        }
        if (n2 < 8) {
            n3 = n2;
        } else if (n2 > 8) {
            n3 = 15 - n2;
        }
        if (this.FLIP_Y) {
            n3 = 7 - n3;
        }
        return n3;
    }

    public int getCollisionX(int n) {
        while (n < 0) {
            n += 8;
        }
        n %= 8;
        if (this.FLIP_Y) {
            n = 7 - n;
        }
        int n2 = (this.collisionInfo[n] & 0xF) >> 0;
        int n3 = 0;
        if (n2 == 8) {
            n3 = 0;
            return n3;
        }
        if (n2 == 0) {
            n3 = -1;
            return n3;
        }
        if (n2 < 8) {
            n3 = n2;
        } else if (n2 > 8) {
            n3 = 15 - n2;
        }
        if (this.FLIP_X) {
            n3 = 7 - n3;
        }
        return n3;
    }

    public int getActualX(int n) {
        int n2;
        while (n < 0) {
            n += 8;
        }
        n %= 8;
        if (this.FLIP_Y) {
            n = 7 - n;
        }
        if ((n2 = (this.collisionInfo[n] & 0xF) >> 0) == 8 || n2 == 0) {
            return n2;
        }
        if (this.FLIP_X) {
            n2 = 7 - n2;
        }
        return n2;
    }

    public int getActualY(int n) {
        int n2;
        while (n < 0) {
            n += 8;
        }
        n %= 8;
        if (this.FLIP_X) {
            n = 7 - n;
        }
        if ((n2 = (this.collisionInfo[n] & 0xF0) >> 4) == 8 || n2 == 0) {
            return n2;
        }
        if (this.FLIP_Y) {
            n2 = 7 - n2;
        }
        return n2;
    }

    public int getDegree() {
        int n = this.degree * 360 / 256;
        if (n == 0) {
            return n;
        }
        if (this.FLIP_X) {
            n = 180 - n;
            n += 360;
            n %= 360;
        }
        if (this.FLIP_Y) {
            n = -n;
        }
        n += 360;
        return n %= 360;
    }

    public int getDegreeNearby(int n) {
        if (this.extendsDegree) {
            return n;
        }
        int n2 = this.getDegree();
        int n3 = Math.abs(n - n2);
        if (n3 > 180) {
            n3 = 360 - n3;
        }
        if (n3 > 90) {
            n2 += 180;
            n2 %= 360;
        }
        return n2;
    }

    public boolean getReverseX(int n, int n2) {
        int n3;
        boolean bl = false;
        while (n < 0) {
            n += 8;
        }
        n %= 8;
        if (this.FLIP_Y) {
            n = 7 - n;
        }
        if ((n3 = (this.collisionInfo[n] & 0xF) >> 0) > 8) {
            bl = !bl;
        } else if (n3 == 8 || n3 == 0) {
            boolean bl2 = true;
            for (int i = 0; i < 8; ++i) {
                n3 = (this.collisionInfo[(n + i) % 8] & 0xF) >> 0;
                if (n3 <= 0) continue;
                if (n3 > 8) {
                    bl = !bl;
                    bl2 = false;
                    break;
                }
                if (n3 >= 8) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                if (n2 > 45 && n2 < 135) {
                    return true;
                }
                if (n2 > 225 && n2 < 315) {
                    return false;
                }
            }
        }
        if (this.FLIP_X) {
            bl = !bl;
        }
        return bl;
    }

    public boolean getReverseY(int n, int n2) {
        int n3;
        boolean bl = false;
        while (n < 0) {
            n += 8;
        }
        n %= 8;
        if (this.FLIP_X) {
            n = 7 - n;
        }
        if ((n3 = (this.collisionInfo[n] & 0xF0) >> 4) > 8) {
            bl = !bl;
        } else if (n3 == 8) {
            boolean bl2 = true;
            for (int i = 0; i < 8; ++i) {
                n3 = (this.collisionInfo[(n + i) % 8] & 0xF0) >> 4;
                if (n3 < 0) continue;
                if (n3 > 8) {
                    bl = !bl;
                    bl2 = false;
                    break;
                }
                if (n3 >= 8) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                if (n2 > 135 && n2 < 225) {
                    return true;
                }
                if (n2 < 45 || n2 > 315) {
                    return false;
                }
            }
        }
        if (this.FLIP_Y) {
            bl = !bl;
        }
        return bl;
    }
}

