/*
 * Decompiled with CFR 0.152.
 */
public abstract class EnemyObject
extends GameObject {
    public int objId;
    protected int iLeft;
    protected int iTop;
    public int layer;
    protected boolean dead;
    protected AnimationDrawer drawer;
    protected boolean IsPlayBossBattleBGM;
    public static boolean magmaEnable = false;

    public static EnemyObject getNewInstance(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (GlobalResource.isEasyMode() && GameObject.stageModeState == 0) {
            switch (n) {
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 26: {
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        switch (n) {
            case 1: {
                return new Bee(n, n2, n3, n4, n5, n6, n7);
            }
            case 4: {
                return new Frog(n, n2, n3, n4, n5, n6, n7);
            }
            case 5: {
                return new RabbitFish(n, n2, n3, n4, n5, n6, n7);
            }
            case 6: {
                return new LadyBug(n, n2, n3, n4, n5, n6, n7);
            }
            case 7: {
                magmaEnable = true;
                return new Magma(n, n2, n3, n4, n5, n6, n7);
            }
            case 15: {
                return new Mole(n, n2, n3, n4, n5, n6, n7);
            }
            case 23: {
                return new Boss2(n, n2, n3, n4, n5, n6, n7);
            }
        }
        switch (n) {
            case 9: {
                return new Bat(n, n2, n3, n4, n5, n6, n7);
            }
            case 21: {
                return new ProBoss1(n, n2, n3, n4, n5, n6, n7);
            }
            case 22: {
                return new Boss1(n, n2, n3, n4, n5, n6, n7);
            }
            case 24: {
                return new Boss3(n, n2, n3, n4, n5, n6, n7);
            }
            case 26: {
                return new Boss5(n, n2, n3, n4, n5, n6, n7);
            }
            case 13: {
                return new Caterpillar(n, n2, n3, n4, n5, n6, n7);
            }
            case 10: {
                return new Clown(n, n2, n3, n4, n5, n6, n7);
            }
            case 2: {
                return new Crab(n, n2, n3, n4, n5, n6, n7);
            }
            case 8: {
                return new Lizard(n, n2, n3, n4, n5, n6, n7);
            }
            case 0: {
                return new Monkey(n, n2, n3, n4, n5, n6, n7);
            }
            case 3: {
                return new Motor(n, n2, n3, n4, n5, n6, n7);
            }
        }
        switch (n) {
            case 11: {
                return new Chameleon(n, n2, n3, n4, n5, n6, n7);
            }
            case 26: {
                return new Boss2(n, n2, n3, n4, n5, n6, n7);
            }
        }
        return null;
    }

    public static void releaseAllEnemyResource() {
        Bee.releaseAllResource();
        Frog.releaseAllResource();
        RabbitFish.releaseAllResource();
        LadyBug.releaseAllResource();
        Magma.releaseAllResource();
        Mole.releaseAllResource();
        BossBroken.releaseAllResource();
        Boss2.releaseAllResource();
        Boss2Spring.releaseAllResource();
        Motor.releaseAllResource();
        Monkey.releaseAllResource();
        Crab.releaseAllResource();
        Clown.releaseAllResource();
        Caterpillar.releaseAllResource();
        Bat.releaseAllResource();
        Boss1.releaseAllResource();
        Boss1Arm.releaseAllResource();
        Boss3.releaseAllResource();
        Boss3Pipe.releaseAllResource();
        Boss5.releaseAllResource();
        ProBoss1.releaseAllResource();
        Lizard.releaseAllResource();
        Chameleon.releaseAllResource();
    }

    protected EnemyObject(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.objId = n;
        this.posX = n2 << 6;
        this.posY = n3 << 6;
        this.iLeft = n4 << 6;
        this.iTop = n5 << 6;
        this.mWidth = n6 * 8 << 6;
        this.mHeight = n7 * 8 << 6;
        this.posX += this.iLeft * 8;
        this.posY += this.iTop * 8;
        this.layer = n6 < n7 ? (n6 == 0 ? 0 : 1) : (n7 == 0 ? 0 : 1);
        this.IsPlayBossBattleBGM = false;
        this.refreshCollisionRect(this.posX, this.posY);
    }

    public int getPaintLayer() {
        return 0;
    }

    public void draw(MFGraphics mFGraphics) {
        Coordinate coordinate = MapManager.getCamera();
        mFGraphics.setColor(65280);
        mFGraphics.drawRect(this.posX - coordinate.x, this.posY - coordinate.y, this.mWidth, this.mHeight);
        mFGraphics.drawRect(this.posX + 1 - coordinate.x, this.posY + 1 - coordinate.y, this.mWidth - 2, this.mHeight - 2);
        mFGraphics.setColor(0);
        mFGraphics.drawString("ID:" + this.objId + ";iLeft:" + this.iLeft + ";iTop:" + this.iTop, this.posX - coordinate.x - 1, this.posY - coordinate.y - 1, 36);
        mFGraphics.drawString("ID:" + this.objId + ";iLeft:" + this.iLeft + ";iTop:" + this.iTop, this.posX - coordinate.x + 1, this.posY - coordinate.y - 1, 36);
        mFGraphics.drawString("ID:" + this.objId + ";iLeft:" + this.iLeft + ";iTop:" + this.iTop, this.posX - coordinate.x, this.posY - coordinate.y - 1 - 1, 36);
        mFGraphics.drawString("ID:" + this.objId + ";iLeft:" + this.iLeft + ";iTop:" + this.iTop, this.posX - coordinate.x, this.posY - coordinate.y - 1 + 1, 36);
        mFGraphics.setColor(0xFFFF00);
        mFGraphics.drawString("ID:" + this.objId + ";iLeft:" + this.iLeft + ";iTop:" + this.iTop, this.posX - coordinate.x, this.posY - coordinate.y - 1, 36);
    }

    public static void enemyinit() {
        magmaEnable = false;
    }

    public static void enemyStaticLogic() {
        if (magmaEnable) {
            Magma.staticlogic();
        }
    }

    public void beAttack() {
        this.dead = true;
        Effect.showEffect(GameObject.destroyEffectAnimation, 0, this.posX >> 6, (this.posY >> 6) - 10, 0);
        SmallAnimal.addAnimal(this.posX, this.posY, this.getLayer());
        GameObject.player.getEnemyScore();
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (this.dead) {
            return;
        }
        if (playerObject == GameObject.player) {
            if (GameObject.player.isAttackingEnemy()) {
                GameObject.player.doAttackPose(this, n);
                this.beAttack();
                SoundSystem.getInstance().playSe(2, false);
            } else {
                GameObject.player.beHurt();
            }
        }
    }

    public int getLayer() {
        return this.layer;
    }

    public int checkPlayerInEnemyAlertRange(int n, int n2, int n3) {
        int n4;
        int n5 = (n - (GameObject.player.getCheckPositionX() >> 6)) * (n - (GameObject.player.getCheckPositionX() >> 6)) + (n2 - (GameObject.player.getCheckPositionY() >> 6)) * (n2 - (GameObject.player.getCheckPositionY() >> 6));
        if (n5 <= (n4 = (n3 >>= 6) * n3)) {
            return 0;
        }
        if (n5 > n4 && n5 <= n4 * 6) {
            return 1;
        }
        return 2;
    }

    public int checkPlayerInEnemyAlertRange(int n, int n2, int n3, int n4) {
        int n5 = Math.abs(n - (GameObject.player.getFootPositionX() >> 6));
        int n6 = Math.abs(n2 - (GameObject.player.getFootPositionY() >> 6));
        if (n5 <= n3 && n6 <= n4) {
            return 0;
        }
        if (n5 <= n3 * 2 && n6 <= n4 * 2) {
            return 1;
        }
        return 2;
    }

    public boolean checkPlayerInEnemyAlertRangeScale(int n, int n2, int n3, int n4) {
        int n5 = Math.abs(n - (GameObject.player.getFootPositionX() >> 6));
        int n6 = Math.abs(n2 - (GameObject.player.getFootPositionY() >> 6));
        if (n5 == 0) {
            return false;
        }
        int n7 = n6 * 100 / n5;
        return n7 >= n3 && n7 <= n4;
    }

    public int checkPlayerInEnemyAlertRange(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (n - (GameObject.player.getFootPositionX() >> 6)) * (n - (GameObject.player.getFootPositionX() >> 6)) + (n2 - (GameObject.player.getFootPositionY() >> 6)) * (n2 - (GameObject.player.getFootPositionY() >> 6));
        int n8 = n3 * n3;
        if (GameObject.player.getFootPositionX() >> 6 > n4 - (n6 >> 1) - 8 && GameObject.player.getFootPositionX() >> 6 < n5 + (n6 >> 1) + 8 && GameObject.player.getFootPositionY() >> 6 <= n2 + 11 && GameObject.player.getFootPositionY() >> 6 >= n2 - 44 && n7 <= n8) {
            return 0;
        }
        if (GameObject.player.getFootPositionX() >> 6 <= n4 - (n6 >> 1) - 8 && GameObject.player.getFootPositionX() >> 6 >= n4 - n6 * 2 || GameObject.player.getFootPositionX() >> 6 >= n5 + (n6 >> 1) + 8 && GameObject.player.getFootPositionX() >> 6 <= n4 + n6 * 2) {
            return 1;
        }
        return 2;
    }

    public int checkPlayerInEnemyAlertRange(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = Math.abs(n - (GameObject.player.getFootPositionX() >> 6));
        int n9 = Math.abs(n2 - (GameObject.player.getFootPositionY() >> 6));
        if (GameObject.player.getFootPositionX() >> 6 > n5 - (n7 >> 1) - 8 && GameObject.player.getFootPositionX() >> 6 < n6 + (n7 >> 1) + 8 && n8 <= n3 && n9 <= n4) {
            return 0;
        }
        if (n8 <= n3 * 2 && n9 <= n4 * 2) {
            return 1;
        }
        return 2;
    }

    public void close() {
        this.drawer = null;
    }
}

