/*
 * Decompiled with CFR 0.152.
 */
class Fountain
extends GimmickObject {
    public boolean touching = false;
    public static final int[][] POSITION_OFFSET = new int[][]{{0, 0}, {1024, -1024}, {7168, -3072}, {12288, -6144}, {18432, -5120}};
    public static AnimationDrawer[] drawer;

    protected Fountain(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (drawer == null) {
            drawer = new AnimationDrawer[5];
            for (int i = 0; i < 5; ++i) {
                Fountain.drawer[i] = new Animation("/animation/spring_0" + i).getDrawer(0, true, 0);
            }
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 12288 - 512, n2 + this.iTop * 512, 24576, this.mHeight);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        int n2;
        int n3;
        if (!this.touching && this.collisionRect.collisionChk(playerObject.getFootPositionX(), playerObject.getFootPositionY()) && (n3 = playerObject.getFootPositionY()) >= (n2 = this.getLineY(playerObject.getFootPositionX()))) {
            this.touching = true;
            GameObject.player.setOutOfControl(this);
            GameObject.player.setBodyPositionY(n2);
            GameObject.player.setAnimationId(30);
            GameObject.player.setCollisionState((byte)1);
            GameObject.player.setNoKey();
            GameObject.player.showWaterFlush = true;
        }
    }

    public void doWhileNoCollision() {
        if (this.touching) {
            this.touching = false;
            GameObject.player.outOfControl = false;
        }
    }

    public void logic() {
        if (this.touching && GameObject.player.outOfControl) {
            if (GameObject.player.getVelX() < 0) {
                GameObject.player.setVelX(GameObject.player.getVelX() + 300);
            } else {
                GameObject.player.setVelX(GameObject.player.getVelX() + 100);
            }
            GameObject.player.setVelY(0);
            int n = GameObject.player.getFootPositionX();
            int n2 = GameObject.player.getFootPositionY();
            GameObject.player.setAnimationId(30);
            GameObject.player.setNoKey();
            GameObject.player.showWaterFlush = true;
            GameObject.player.justLeaveLand = false;
            GameObject.player.moveOnObject(n + GameObject.player.getVelX(), this.getLineY(n + GameObject.player.getVelX()) + 768, true);
            if (GameObject.player.collisionState == 0) {
                this.touching = false;
                GameObject.player.outOfControl = false;
                GameObject.player.outOfControlObject = null;
            }
        }
    }

    public int getLineY(int n) {
        int n2 = n - this.posX;
        int n3 = (n2 >> 6) * (n2 >> 6) * 80 / 36864;
        n3 <<= 6;
        return n3 += this.collisionRect.y0;
    }

    public void draw(MFGraphics mFGraphics) {
        for (int i = 0; i < 5; ++i) {
            this.drawInMap(mFGraphics, drawer[i], POSITION_OFFSET[i][0] + this.collisionRect.x0 + 448, POSITION_OFFSET[i][1] + this.collisionRect.y1 + -384);
        }
        this.drawCollisionRect(mFGraphics);
    }

    public void close() {
        drawer = null;
    }

    public int getPaintLayer() {
        return 0;
    }
}

