/*
 * Decompiled with CFR 0.152.
 */
public class GimmickObject
extends GameObject {
    protected int objId;
    protected int iLeft;
    protected int iTop;
    protected boolean used;
    public static Animation doorAnimation = null;
    public static MFImage shipRingImage;
    public static MFImage platformImage;
    public static MFImage hookImage;
    public static boolean furikoEnable;
    public static boolean ironBallEnable;
    public static boolean torchFireEnable;
    public static boolean rollPlatformEnable;
    public static boolean steamEnable;
    public static boolean waterFallEnable;
    public static boolean waterSlipEnable;
    public static boolean rollHobinEnable;
    public static boolean damageEnable;
    public static final int WIND_VELOCITY;
    public static final int WIND_ACCELERATE;

    public static GameObject getNewInstance(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        GameObject gameObject = null;
        n2 <<= 6;
        n3 <<= 6;
        switch (n) {
            case 0: {
                gameObject = new Terminal(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                gameObject = new Hari(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 7: {
                gameObject = new Marker(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                gameObject = new Spring(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 21: {
                gameObject = new Platform(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 22: {
                gameObject = new FallingPlatform(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 24: {
                gameObject = new BreakPlatform(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 23: {
                gameObject = new CaperBed(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 25: {
                gameObject = new CaperBlock(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 100: {
                gameObject = new Accelerate(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 42: 
            case 44: 
            case 45: {
                gameObject = new Poal(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 76: {
                gameObject = new Furiko(n, n2, n3, n4, n5, n6, n7);
                furikoEnable = true;
                break;
            }
            case 77: {
                gameObject = new Shatter(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 78: {
                gameObject = new Neji(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 80: {
                gameObject = new Arm(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 110: {
                gameObject = new PipeIn(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 106: {
                gameObject = new PipeSet(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 111: {
                gameObject = new PipeOut(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 69: {
                gameObject = new Belt(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 116: {
                gameObject = new GraphicPatch(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 75: {
                gameObject = new RopeStart(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 117: {
                gameObject = new RopeEnd(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 118: {
                gameObject = new RopeTurn(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 105: {
                gameObject = new DamageArea(n, n2, n3, n4, n5, n6, n7);
                damageEnable = true;
                break;
            }
            case 102: {
                gameObject = ItemObject.getNewInstance(0, n2 >> 6, (n3 >> 6) - 8);
                break;
            }
            case 16: {
                gameObject = new Stone(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case 120: {
                gameObject = new TutorialPoint(n, n2, n3, n4, n5, n6, n7);
                break;
            }
            default: {
                switch (n) {
                    case 27: {
                        gameObject = new WaterFall(n, n2, n3, n4, n5, n6, n7);
                        waterFallEnable = true;
                        break;
                    }
                    case 40: {
                        gameObject = new Fountain(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 43: {
                        gameObject = new FallFlush(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 46: {
                        gameObject = new WaterSlip(n, n2, n3, n4, n5, n6, n7);
                        waterSlipEnable = true;
                        break;
                    }
                    case 87: {
                        gameObject = new TorchFire(n, n2, n3, n4, n5, n6, n7);
                        torchFireEnable = true;
                        break;
                    }
                    case 79: {
                        gameObject = new SteamBase(n, n2, n3, n4, n5, n6, n7);
                        steamEnable = true;
                        break;
                    }
                    case 82: {
                        gameObject = new IronBall(n, n2, n3, n4, n5, n6, n7);
                        ironBallEnable = true;
                        break;
                    }
                    case 73: {
                        gameObject = new RailFlipper(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 58: {
                        gameObject = new LightFont(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 48: {
                        gameObject = new HexHobin(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 49: {
                        gameObject = new BallHobin(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 50: {
                        gameObject = new RollHobin(n, n2, n3, n4, n5, n6, n7);
                        rollHobinEnable = true;
                        break;
                    }
                    case 53: {
                        gameObject = new CornerHobin(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 59: {
                        gameObject = new Balloon(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 60: {
                        gameObject = new ShipSystem(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 52: {
                        gameObject = new BarHorbinV(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 51: {
                        gameObject = new BarHorbinH(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 54: {
                        gameObject = new FlipH(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 56: {
                        gameObject = new FilpV(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 62: {
                        gameObject = new TeaCup(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 63: 
                    case 64: {
                        gameObject = new Door(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 67: {
                        gameObject = new RailIn(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 68: {
                        gameObject = new RailOut(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 74: {
                        gameObject = new FreeFallSystem(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 114: {
                        gameObject = new BreakWall(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 83: {
                        gameObject = new IronBar(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 107: {
                        gameObject = new Split(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 28: 
                    case 29: {
                        gameObject = new Bank(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 72: {
                        gameObject = new TransPoint(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 91: {
                        gameObject = new RollPlatform(n, n2, n3, n4, n5, n6, n7);
                        rollPlatformEnable = true;
                        break;
                    }
                    case 57: {
                        gameObject = new SpringPlatform(n, n2, n3, n4, n5, n6, n7);
                    }
                }
                switch (n) {
                    case 97: {
                        gameObject = new WindParts(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 108: {
                        gameObject = new UnseenSpring(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 88: {
                        gameObject = new UpArm(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 92: {
                        gameObject = new StoneBall(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 55: {
                        gameObject = new DekaPlatform(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 84: {
                        gameObject = new Subeyuka(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 61: {
                        gameObject = new HariIsland(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 81: {
                        gameObject = new SpringIsland(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 85: {
                        gameObject = new DownIsland(n, n2, n3, n4, n5, n6, n7);
                        break;
                    }
                    case 86: {
                        gameObject = new RollIsland(n, n2, n3, n4, n5, n6, n7);
                    }
                }
                if (gameObject != null) break;
                gameObject = new GimmickObject(n, n2, n3, n4, n5, n6, n7);
            }
        }
        if (gameObject != null) {
            gameObject.refreshCollisionRectWrap();
        }
        return gameObject;
    }

    public static void gimmickInit() {
        furikoEnable = false;
        ironBallEnable = false;
        torchFireEnable = false;
        rollPlatformEnable = false;
        steamEnable = false;
        waterFallEnable = false;
        waterSlipEnable = false;
        rollHobinEnable = false;
        damageEnable = false;
    }

    public static void gimmickStaticLogic() {
        if (furikoEnable) {
            Furiko.staticLogic();
        }
        if (damageEnable) {
            DamageArea.staticLogic();
        }
        MoveCalculator.staticLogic();
        if (waterFallEnable) {
            WaterFall.staticLogic();
        }
        if (waterSlipEnable) {
            WaterSlip.staticLogic();
        }
        if (torchFireEnable) {
            TorchFire.staticLogic();
        }
        if (steamEnable) {
            SteamBase.staticLogic();
        }
        if (ironBallEnable) {
            IronBall.staticLogic();
        }
        if (rollHobinEnable) {
            RollHobin.staticLogic();
        }
        if (rollPlatformEnable) {
            RollPlatform.staticLogic();
        }
    }

    public static void releaseGimmickResource() {
        doorAnimation = null;
        shipRingImage = null;
        platformImage = null;
        hookImage = null;
        Hari.releaseAllResource();
        Spring.releaseAllResource();
        Stone.releaseAllResource();
        Marker.releaseAllResource();
        BreakPlatform.releaseAllResource();
        CaperBed.releaseAllResource();
        CaperBlock.releaseAllResource();
        Accelerate.releaseAllResource();
        Poal.releaseAllResource();
        Furiko.releaseAllResource();
        Shatter.releaseAllResource();
        Neji.releaseAllResource();
        Arm.releaseAllResource();
        PipeIn.releaseAllResource();
        Terminal.releaseAllResource();
        Belt.releaseAllResource();
        DamageArea.releaseAllResource();
        GraphicPatch.releaseAllResource();
        TutorialPoint.releaseAllResource();
        WaterFall.releaseAllResource();
        TransPoint.releaseAllResource();
        Cage.releaseAllResource();
        FallFlush.releaseAllResource();
        WaterSlip.releaseAllResource();
        TorchFire.releaseAllResource();
        SteamBase.releaseAllResource();
        SteamPlatform.releaseAllResource();
        CageButton.releaseAllResource();
        IronBall.releaseAllResource();
        RailFlipper.releaseAllResource();
        LightFont.releaseAllResource();
        HexHobin.releaseAllResource();
        BallHobin.releaseAllResource();
        RollHobin.releaseAllResource();
        CornerHobin.releaseAllResource();
        BarHorbinV.releaseAllResource();
        BarHorbinH.releaseAllResource();
        Balloon.releaseAllResource();
        ShipSystem.releaseAllResource();
        Ship.releaseAllResource();
        ShipBase.releaseAllResource();
        FlipH.releaseAllResource();
        FilpV.releaseAllResource();
        TeaCup.releaseAllResource();
        Door.releaseAllResource();
        FreeFallSystem.releaseAllResource();
        FreeFallBar.releaseAllResource();
        FreeFallPlatform.releaseAllResource();
        BreakWall.releaseAllResource();
        SpringPlatform.releaseAllResource();
        DekaPlatform.releaseAllResource();
        Subeyuka.releaseAllResource();
        HariIsland.releaseAllResource();
        SpringIsland.releaseAllResource();
        WindParts.releaseAllResource();
        StoneBall.releaseAllResource();
        DownIsland.releaseAllResource();
        RollIsland.releaseAllResource();
    }

    protected GimmickObject(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.objId = n;
        this.posX = n2;
        this.posY = n3;
        this.iLeft = n4;
        this.iTop = n5;
        this.mWidth = n6 * 512;
        this.mHeight = n7 * 512;
        this.collisionRect.setRect(this.posX, this.posY, this.mWidth, this.mHeight);
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawCollisionRect(mFGraphics);
    }

    public void logic() {
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (playerObject != GameObject.player) {
            return;
        }
        switch (this.objId) {
            case 17: {
                if (this.collisionRect.collisionChk(GameObject.player.getCheckPositionX(), GameObject.player.getCheckPositionY())) {
                    if (this.used) break;
                    GameObject.player.setCollisionLayer(0);
                    this.used = true;
                    break;
                }
                this.used = false;
                break;
            }
            case 18: {
                if (this.collisionRect.collisionChk(GameObject.player.getCheckPositionX(), GameObject.player.getCheckPositionY())) {
                    if (this.used) break;
                    GameObject.player.setCollisionLayer(1);
                    this.used = true;
                    break;
                }
                this.used = false;
                break;
            }
            case 19: {
                if (GameObject.player.getVelX() <= 128 || GameObject.player.getVelY() <= 128 || GameObject.player.collisionState != 1 || GameObject.player.getFootPositionY() >= this.posY + 1536) break;
                GameObject.player.slipStart();
                break;
            }
            case 20: {
                GameObject.player.slipEnd();
                break;
            }
            case 36: {
                if (!GameObject.player.isOnGound() || !this.collisionRect.collisionChk(GameObject.player.getCheckPositionX(), GameObject.player.getCheckPositionY())) break;
                GameObject.player.setVelX(2000);
                break;
            }
            case 37: {
                if (!GameObject.player.isOnGound()) break;
                GameObject.player.setVelX(-2000);
                break;
            }
            case 38: {
                break;
            }
            case 65: {
                if (this.used || !GameObject.player.setRailLine(new Line(this.posX, this.posY, this.posX + this.iLeft, this.posY + this.iTop), this.posX, this.posY, this.iLeft, this.iTop, this)) break;
                this.used = true;
                break;
            }
            case 66: {
                if (!this.firstTouch) break;
                GameObject.player.setFall(this.posX - 256, this.posY, this.iLeft, this.iTop);
                break;
            }
            case 70: {
                if (this.used || !this.collisionRect.collisionChk(GameObject.player.getCheckPositionX(), GameObject.player.getCheckPositionY())) break;
                GameObject.player.changeVisible(this.iLeft == 0);
                this.used = true;
                break;
            }
            case 96: {
                GameObject.player.setAnimationId(4);
                break;
            }
            case 71: {
                GameObject.player.collisionState = 1;
                GameObject.player.setVelX(this.iLeft == 2 || this.iLeft == 4 ? -800 : 800);
                GameObject.player.setVelY(this.iLeft == 1 || this.iLeft == 2 ? -1400 : 1400);
                if (GameObject.player.moveDistanceX * GameObject.player.getVelX() < 0) {
                    GameObject.player.moveDistanceX = 0;
                }
                if (GameObject.player.moveDistanceY * GameObject.player.getVelY() >= 0) break;
                GameObject.player.moveDistanceY = 0;
                GameObject.player.setBodyPositionY(this.collisionRect.y0 + (this.collisionRect.getHeight() >> 1));
                break;
            }
            case 90: {
                if (!this.collisionRect.collisionChk(GameObject.player.getCheckPositionX(), GameObject.player.getCheckPositionY()) || GameObject.player.collisionState != 1) break;
                GameObject.player.collisionState = 1;
                if (GameObject.player.getVelY() > WIND_VELOCITY) {
                    GameObject.player.setVelY(GameObject.player.getVelY() + WIND_ACCELERATE);
                } else {
                    GameObject.player.setVelY(WIND_VELOCITY);
                }
                GameObject.player.setAnimationId(29);
                break;
            }
            case 26: {
                if (!this.firstTouch) break;
                GameObject.player.beUnseenPop();
                break;
            }
            case 34: {
                if (this.collisionRect.collisionChk(GameObject.player.getCheckPositionX(), GameObject.player.getCheckPositionY())) {
                    if (this.used) break;
                    GameObject.player.ductIn();
                    SoundSystem.getInstance().playSe(2);
                    this.used = true;
                    break;
                }
                this.used = false;
                break;
            }
            case 35: {
                if (this.collisionRect.collisionChk(GameObject.player.getCheckPositionX(), GameObject.player.getCheckPositionY())) {
                    if (this.used) break;
                    GameObject.player.ductOut();
                    this.used = true;
                    break;
                }
                this.used = false;
            }
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        switch (this.objId) {
            case 66: {
                this.collisionRect.setRect(n - 1024, n2, 1536, 64);
                break;
            }
            case 70: {
                this.collisionRect.setRect(n, n2, this.mWidth, this.mHeight);
                break;
            }
            case 73: {
                this.collisionRect.setRect(this.posX, this.posY - 512, 512, 512);
                break;
            }
            case 20: {
                this.collisionRect.setRect(n + (this.mWidth >> 1) - 640, n2, 1280, this.mHeight);
            }
        }
    }

    public void doWhileRail(PlayerObject playerObject, int n) {
        switch (this.objId) {
            case 65: {
                if (this.used || !GameObject.player.setRailLine(new Line(this.posX, this.posY, this.posX + this.iLeft, this.posY + (Math.abs(this.iTop) <= 1 ? 0 : this.iTop)), this.posX, this.posY, this.iLeft, this.iTop, this)) break;
                this.used = true;
                break;
            }
            case 70: {
                if (this.used || !this.collisionRect.collisionChk(GameObject.player.getCheckPositionX(), GameObject.player.getCheckPositionY())) break;
                GameObject.player.changeVisible(this.iLeft == 0);
                this.used = true;
                break;
            }
            case 66: {
                if (!this.firstTouch) break;
                GameObject.player.setFall(this.posX - 256, this.posY, this.iLeft, this.iTop);
                break;
            }
            case 73: {
                if (!this.firstTouch) break;
                GameObject.player.setRailFlip();
            }
        }
    }

    public void doWhileNoCollision() {
        switch (this.objId) {
            case 17: 
            case 18: 
            case 34: 
            case 35: 
            case 65: 
            case 70: {
                this.used = false;
            }
        }
    }

    public void close() {
    }

    static {
        platformImage = null;
        furikoEnable = false;
        ironBallEnable = false;
        torchFireEnable = false;
        rollPlatformEnable = false;
        steamEnable = false;
        waterFallEnable = false;
        waterSlipEnable = false;
        rollHobinEnable = false;
        damageEnable = false;
        WIND_VELOCITY = -300 - GameObject.GRAVITY;
        WIND_ACCELERATE = -GameObject.GRAVITY * 2;
    }
}

